#	nroff terminal driving tables make file
#	SCCS: (@(#)terms.mk	2.1	)

OL =
SL = /usr/src/cmd
RDIR = ${SL}/text/roff.d/terms.d
REL = current
TSID = -r`gsid terms ${REL}`
CSID = -r`gsid maketerms ${REL}`
MKSID = -r`gsid terms.mk ${REL}`
LIST = lp
ULTERM = $(OL)/usr/lib/term
TFILES = code.300 code.lp tab2631.c tab2631-c.c tab2631-e.c tab300.c \
	 tab300-12.c tab300s.c tab300s-12.c tab37.c tab382.c \
	 tab4000a.c tab450.c tab450-12.c tab832.c taba1.c tablp.c tabtn300.c \
	 tabX.c
PFILES = maketerms.c terms.hd
FILES = tab2631 tab2631-c tab2631-e tab300 tab300-12 tab300s \
	tab300s-12 tab37 tab382 tab4000a tab450 \
	tab450-12 tab832 taba1 tablp tabtn300 tabX

B03 =

maketerms compile all:  terms.hd
	${CC} -DPART1 ${B03} -o maketerms maketerms.c
	./maketerms
	${CC} -DPART2 ${B03} -o maketerms maketerms.c
	./maketerms
	${CC} -DPART3 ${B03} -o maketerms maketerms.c
	./maketerms

install:  maketerms
	cp ${FILES} ${ULTERM}
	cd ${ULTERM}; rm -f tab300S tab300S-12 tab4000A
	cd ${ULTERM}; ln tab300s tab300S; ln tab300s-12 tab300S-12; \
			ln tab4000a tab4000A
	cd ${ULTERM}; chmod 644 ${FILES}
	cd ${ULTERM}; chgrp bin ${FILES}; \
			chown bin ${FILES}

build:  bldmk bldt bldmt
	:
bldt:	;  get -p ${TSID} s.terms.src | ntar -d ${RDIR} -g
bldmt:	;  get -p ${CSID} s.maket.src | ntar -d ${RDIR} -g
bldmk: ; get -p ${MKSID} s.terms.mk > ${RDIR}/terms.mk

listing:
	pr terms.mk ${TFILES} ${PFILES} | ${LIST}
listmk: ;  pr terms.mk | ${LIST}
listt:	;  pr ${TFILES} | ${LIST}
listmt:	;  pr ${PFILES} | ${LIST}

edit:	mkedit tedit mtedit
	:
mkedit:	;  get -e s.terms.mk
tedit:	;  get -e -p s.terms.src | ntar -g
mtedit:	;  get -e -p s.maket.src | ntar -g

delta:	mkdelta tdelta mtdelta
	:
mkdelta:  ;  delta s.terms.mk
tdelta:   ;  ntar -p ${TFILES} > terms.src
	     delta s.terms.src
	     rm -f ${TFILES}
mtdelta:  ;  ntar -p ${PFILES} > maket.src
	     delta s.maket.src
	     rm -f ${PFILES}

clean:
	rm -f maketerms
clobber:  
	rm -f ${FILES}
delete:	clean clobber
	rm -f ${TFILES} ${PFILES}
