
#include <stdio.h>
#include "regs.h"
#include "trace.h"
#include "io.h"
#include "screen.h"

char prtview[5][81];
long total_cycles;

void
lights()
{
	char *status;
	register c1, c2;


	screenposition(1,1);
	clearline();
	printf("IBM 709x Simulator: %d mode\n", cpumode); 
#if 0
	printf("IBM 7090/94 Simulator     cycles: %10ld    total: %10ld\n",
		cycle_count, total_cycles + cycle_count);
#endif

  /*
   *   TRAP  SIMULATE ACCUMULATOR QUOTIENT READ/WRITE DIVIDE  IO   MACHINE
   *                   OVERFLOW   OVERFLOW   SELECT   CHECK  CHECK  CHECK
   * PROGRAM STOP  SSW bbbbbb  SL bbbb  CYCLE  RUN d+ooo  KEYS ooooooooooo
   * IC ooooo INSTR +oooo FLAG TAG o ADDR ooooo  EA ooooo SCNT   ooo
   * X1 ooooo  X2 ooooo  X3 ooooo  X4 ooooo  X5 ooooo  X6 ooooo  X7 ooooo
   * SR + oooooooooooo ENB oooooooooooo     IND     o
   * AC +ooooooooooooo      SI oooooooooooo
   * MQ + oooooooooooo	 ADDRESS STOP	ooooo
   *
   * A ..........   B ..........   C ..........   D ..........
   * OP +o UN oooR  OP +o UN oooW  OP +o UN ooo	OP +o UN ooo
   * AR	  oooooT  AR	 ooooo	 AR	ooooo	AR     ooooo
   * WR	  oooooE  WR	 ooooo	 WR	ooooo	WR     ooooo
   * LR	  oooooC  LR	 ooooo	 LR	ooooo	LR     ooooo
   * oooooooooooo   oooooooooooo	 oooooooooooo	oooooooooooo
   */

	printf("  %s  %s %s %s %s %s %s %s\n",
		trap?	"TRAP"          : "    ",
		simulate?"SIMULATE"     : "        ",
		acoflo? "ACCUMULATOR"   : "           ",
		mqoflo? "QUOTIENT"      : "        ",
		rwsel?	"READ/WRITE"    : "          ",
		divchk? "DIVIDE"        : "      ",
		iochk?	" IO  "         : "     ",
		machchk?"MACHINE"       : "       ");
	clearline();
	printf("                 %s %s %s %s %s %s\n",
		acoflo? " OVERFLOW  "   : "           ",
		mqoflo? "OVERFLOW"      : "        ",
		rwsel?	"  SELECT  "    : "          ",
		divchk? "CHECK "        : "      ",
		iochk?	"CHECK"         : "     ",
		machchk?" CHECK "       : "       ");
	clearline();
	if (!automatic)
		status = "MANUAL      ";
	else if (stop)
		status = "PROGRAM STOP";
	else if (run)
		status = "AUTOMATIC   ";
	else
		status = "READY       ";
	printf("%s  SSW %o%o%o%o%o%o  SL %o%o%o%o  %s  RUN %d+%03o  KEYS %c%02o%010lo \n",
		status,
		(ssw >> 5) & 1,
		(ssw >> 4) & 1,
		(ssw >> 3) & 1,
		(ssw >> 2) & 1,
		(ssw >> 1) & 1,
		ssw & 1,
		(sl >> 3) & 1,
		(sl >> 2) & 1,
		(sl >> 1) & 1,
		sl & 1,
		single_cycle? "CYCLE" : "     ",
		run, chan_in_op,
		(kyh & SIGN)? '-' : '+',
		((kyh & HMSK) << 2) | (short)(kyl >> 30),
		kyl & 07777777777);
	clearline();
	printf("IC %05o INSTR %c%04o %s TAG %o ADDR %05o  EA %05o SCNT  %03o\n",
	       ic, (op & 0100000)? '-' : '+', op & 03777,
	       flag? "FLAG" : "    ", tag, addr, y, shcnt);
	clearline();
	if (cpumode == 7094)

	   printf("X1 %05o  X2 %05o  X3 %05o  X4 %05o  X5 %05o  X6 %05o  X7 %05o \n",
		  xr[1], xr[2], xr[3], xr[4], xr[5], xr[6], xr[7]);
	else
	   printf("X1 %05o  X2 %05o  X4 %05o  \n",
		  xr[1], xr[2], xr[4]);
	printf("SR %c %02o%010lo     ENB 00%010lo     IND     %01o\n",
		(srh & SIGN)? '-' : '+',
		((srh & HMSK) << 2) | (short)(srl >> 30),
		srl & 07777777777,
		ctrap_enb, ctrap_ind);
	printf("AC %c%03o%010lo      SI %02o%010lo\n",
		(ach & SIGN)? '-' : '+',
		((ach & 037) << 2) | (short)(acl >> 30),
		acl & 07777777777,
		((sih & 017) << 2) | (short)(sil >> 30),
		sil & 07777777777);
	clearline();
	printf("MQ %c %02o%010lo",
		(mqh & SIGN)? '-' : '+',
		((mqh & HMSK) << 2) | (short)(mql >> 30),
		mql & 07777777777);

	if (addrstop)
		printf("     ADDRESS STOP   %05o\n", stopic);
	else
		printf("                         \n");

	clearline();
	screenposition (10,1);
	for (c1 = 0; c1 < NUMCHAN; c1 += 4) {
		printf("\n");
		for (c2 = c1; c2 < c1 + 4 && c2 < NUMCHAN; c2++) {
			int dev;
			char c;

			printf("%c ", c2 + 'A');
			for (dev = 10*c2 + 3; dev <= 10*c2 + 12; dev++) {
				if ((cun[c2] & 0100) == 0 &&
				    dev == (cun[c2] & 017) + 2 + 10*c2) {
					c = 'S';
				} else if (iofd[dev] == NULL) {
					c = '.';
				} else if (iopos[dev] == 0) {
					c = 'b';
				} else if (iorw[dev] < 2) {
					c = 'p';
				} else {
					c = 'o';
				}
				printf("%c", c);
			}
			printf("  ");
		}
		printf("\n");
		for (c2 = c1; c2 < c1 + 4 && c2 < NUMCHAN; c2++)
			printf("OP %o%c UN %03o%c ",
			       cop[c2] & 007,
			       (cop[c2] & 010)? 'N' : ' ',
			       cun[c2],
			       " RWBFM"[csel[c2]]);
		printf("\n");
		for (c2 = c1; c2 < c1 + 4 && c2 < NUMCHAN; c2++)
			printf("AR     %05o%c ", car[c2], ctrp[c2]? 'T' : ' ');
		printf("\n");
		for (c2 = c1; c2 < c1 + 4 && c2 < NUMCHAN; c2++)
			printf("WR     %05o%c ", cwr[c2], ceof[c2]? 'E' : ' ');
		printf("\n");
		for (c2 = c1; c2 < c1 + 4 && c2 < NUMCHAN; c2++)
			printf("LR     %05o%c ", clr[c2], cchk[c2]? 'C' : ' ');
		printf("\n");
		for (c2 = c1; c2 < c1 + 4 && c2 < NUMCHAN; c2++)
			printf("%02o%010lo  ",
				((cdrh[c2] & SIGN) >> 2) |
				((cdrh[c2] & HMSK) << 2) |
				(short)(cdrl[c2] >> 30),
				cdrl[c2] & 07777777777);
		printf("\n");
		clearline();
	}
	screenposition(17,1);
}

void
pview()
{
	register i;

	screenposition (17,1);
	printf("\n");
	clearline();
	for (i = 0; i < 5; i++)
	{
		clearline();
		printf("%s\n", prtview[i]);
	}
}

void
help()
{

 screenposition (17,1);
 printf("\n\
  h - help            r - reset       clear - clear         sw# - toggle SSW#\n\
  o - mount file      q - quit           sc - cycle   +,-,0-7,. - set keys   \n\
 lt - ld tape        lc - ld cards       lf - ld file     close - close file \n\
 em - enter MQ       ei - enter inst      a - auto            m - manual     \n\
 st - start/step     ds - disp storage   dn - disp next      sa - adrstop    \n\
");
 
}

void
trace()
{
	int i, j, tp;

	screenposition (17,1);
	printf("\n");
printf("Instruction trace:                                                 \n");
	tp = itrc_idx;
	for (i = 0; i < 4; i++) {
		printf("  ");
		for (j = 0; j < 8; j++) {
			if (j > 0) {
				printf(" ");
			}
			printf(" %c %05o",
				" ABCDEFGH"[itrc_buf[tp] >> 16],
				itrc_buf[tp] & 077777);
			tp++;
			if (tp == 32)
				tp = 0;
		}
		printf("\n");
	}
}

void
long_trace()
{
	int i, j, tp;

	screenposition (17,1);
	printf("\n");
printf("Instruction trace:                                                 \n");
	tp = itrc_idx;
	for (i = 0; i < 16; i++) {
		for (j = 0; j < 2; j++) {
			if (j > 0) {
				printf("        ");
			}
			printf(" %c %05o  %c %02o%010lo",
				" ABCDEFGH"[itrc_buf[tp] >> 16],
				itrc_buf[tp] & 077777,
				(itrc_h[tp] & SIGN)? '-' : '+',
				((itrc_h[tp] & HMSK) << 2) |
				 (short)(itrc_l[tp] >> 30),
				itrc_l[tp] & 07777777777);
			tp++;
			if (tp == 32)
				tp = 0;
		}
		printf("        \n");
	}
}
