/*	mmu.h	4.1	83/01/15	*/

/* 
 * Sun-1 Context register access.
 * Context number is in the high nibble
 * of shorts read and written to RCONTEXT
 * and WCONTEXT, respectively.
 */
#define	RCONTEXT 0xC00000
#define	WCONTEXT 0xE00000
#define	KCONTEXT 0		/* Kernel's context */
#define	NCONTEXT 16		/* Number of contexts */

#define	MAXOBMEM 0x200000	/* Maximum on-board memory address */
#define	MAXMBMEM 0x100000	/* Maximum Multibus memory address */

/*
 * Hardware segment and page registers and constants.
 */
#define	SEGBASE	0xC00000
#define	SEGSIZE	0x8000		/* 32K */
#define	NSEGMAP	64		/* # of segments per context */
#define	MAXKSEG 56		/* # of segments that we remap(up to 1c0000) */
#define	vtoseg(v) (union hseg *)(((int)(v)&0x1FFFF0)+SEGBASE)
#define	SEGZERO	0x0500		/* segment zero - all kernel access */
#define	SEGINV	0x0000		/* invalid segment - no access */
#define	SEG_KW	5		/* kernel RW protection */
#define	SEG_KR	3		/* kernel RO protection */

#define	PAGBASE	0xA00000
#define	PAGSIZE	0x800		/* 2K */
#define	NPAGSEG 16		/* # of pages per segment */
#define	NPAGMAP 1024		/* # of pages total */
#define	vtopag(v) ((union hpag *)(((int)(v)&0x1FFFF0)+PAGBASE))

#define	vtop(v)	((vtopag(v)->hpag_ent.hpag_ppag<<PGSHIFT)|((int)(v)&(NBPG-1)))
#define	ismbmem(v)	(vtopag(v)->hpag_ent.hpag_type == 2)
#define	ismbio(v)	(vtopag(v)->hpag_ent.hpag_type == 3)

#define	NPME	1024		/* number of hardware page map entries */
#define	NPMEG	(NPME/NPAGSEG)	/* # of pme groups (segment allocation) */
#define	PAGINV	0x1FFF		/* invalid page */

#define	vsegtopag(v)	((v)<<4)	/* virtual segment to virtual page */


#ifndef LOCORE
union hseg {
	struct hsegent {
		unsigned hseg_ctxt : 4;		/* context on read */
		unsigned hseg_prot : 4;		/* protection bits */
		unsigned           : 2;		/* unused */
		unsigned hseg_pmap : 6;		/* page map index */
	} hseg_ent;
	unsigned short hseg_all;
	char	hseg_size[SEGSIZE];
};

union hpag {
	struct hpagent {
		unsigned hpag_acc  : 1;		/* accessed */
		unsigned hpag_mod  : 1;		/* modified */
		unsigned hpag_type : 2;		/* memory type */
		unsigned hpag_ppag : 12;	/* physical page # */
	} hpag_ent;
	unsigned short hpag_all;
	char	hpag_size[PAGSIZE];
};

#ifdef KERNEL
extern union hseg hsegmap[];
extern union hpag hpagmap[];
#endif
#endif !LOCORE
