/*	param.h	4.1	82/12/01	*/

/*
 * Machine dependent constants for sun.
 */
#define	NBPG	2048		/* bytes/page */
#define	PGOFSET	(NBPG-1)	/* byte offset into page */
#define	PGSHIFT	11		/* LOG2(NBPG) */

#define	CLSIZE		1
#define	CLSIZELOG2	0

#define	SSIZE	1		/* initial stack size/NBPG */
#define	SINCR	1		/* increment of stack/NBPG */

#define	UPAGES	3		/* pages of u-area */

/*
 * Some macros for units conversion
 */
/* Core clicks (2048 bytes) to segments and vice versa */
#define	ctos(x)	(((x)+15)>>4)
#define	stoc(x)	((x)<<4)

/* Core clicks (2048 bytes) to disk blocks and vice versa */
#define	ctod(x)	((x)<<2)
#define	dtoc(x)	(((x)+3)>>2)
#define	dtob(x)	((x)<<9)

/* clicks to bytes */
#define	ctob(x)	((x)<<11)

/* bytes to clicks */
#define	btoc(x)	((((unsigned)(x)+2047)>>11))

/*
 * Macros to decode processor status word.
 */
#define	USERMODE(ps)	(((ps) & SR_SMODE) == 0)
#define	BASEPRI(ps)	(((ps) & SR_INTPRI) == 0)

#define	DELAY(n)	{ register int N = (n)>>1; while (--N > 0); }
