/*	winio.h	1.1	83/02/11	*/

/*	Copyright Sun Microsystems 1983.  All rights reserved */

/*
 * Sunwindow io definitions that are shared between the kernel and user.
 */


/* IOCTL call definitions: */
#define	WINLOCKOUT	_IOWR(g, 40, struct winLock)
		/* Copy in *winLock->rect (Window relative) that is used for cursor removal.
		Copy out *winLock->clippingID which is sequence number of exposed RectList.
		Lock screen for updates.  May block. Time limit used to avoid hangups. */
#define	WINUNLOCKOUT	_IO(g, 41)
		/* Unlock screen from updates */
#define	WINGETINPUT	_IOWR(g, 42, struct input)
		/* *input copied in and input.mouse.buttons and
		input.keyboard.down is encoded with
		state/transition bits.  The call waits until one of any
		specified states (button/key is up/down) exist or until one
		of any specified transition (button/key goes up/down) occurs.
		*input copied out when return. */
#define	WINSETMOUSE	_IOW(g, 43, struct mouse)
		/* Copy in *mouse.  Set mouse position relative to window. */
#define	WINSETPOINTER	_IOW(g, 44, struct pointer_c)
		/* Copy in *pointer_c.  Use pointer_c.shape[] or system provided
		pointer_c.type if not equal to USR_SHAPE. */
#define	WINGETPOINTER	_IOR(g, 45, struct pointer_c)
		/* Copy out *pointer_c.  pointer_c.shape[] holds image for system types too. */
#define	WINCREATE	_IOWR(g, 46, struct winNew)
		/* Copy in *winNew and set up the window generated on the open call.
		Copy out winNew cause holds winID of new window. */
#define	WINGETSIZE	_IOWR(g, 47, struct winSize)
		/* Copy in *winSize.winID and copy out *winSize.rect which is
		window's height and width relative to parent. */
#define	WINLOCKTREE	_IO(g, 48)
		/* Lock tree for updates.  Need not lock screen because 
		new clipping not computed until WINUNLOCKTREE.  Every ioctl
		call between this and WINUNLOCKTREE is blocked when non-
		locking Window tries to do something.
		Time limit used to avoid hangups. */
#define	WINGRABINPUT	_IO(g, 49)
		/* All actions directed to calling window. 
		Used during window management user interface actions.
		Time limit used to avoid hangups by window with lock. */
#define	WINRELEASEINPUT	_IO(g, 50)
		/* Opposite of WINGRABINPUT. */
#define	WINGETLINK	_IOWR(g, 51, struct winLink)
		/* Copy in *winLink.winID and *winLink.which and copy out
		the link in *winLink.winID. */
#define	WININSERT	_IOW(g, 52, WinID)
		/* Copy in *winID and insert it (and its subtree) 
		in the clipping tree (not done on open) of its parent.  */
#define	WINREMOVE	_IOW(g, 53, WinID)
		/* Copy in *winID and remove a window (and its subtree) from the clipping tree
		(done on close if not done explicitely)  */
#define	WINCHANGESIZE	_IOW(g, 54, struct winSize)
		/* Copy in *winSize.winID and *winSize.rect to get parent relative new rect */
#define	WINADJUSTSCREEN	_IOW(g, 55, struct screenInfo)
		/* Copy in *screenInfo to screen indicated by *screenInfo.screen.
		Use for changing neighbors position. */
#define	WINUNLOCKTREE	_IO(g, 59)
		/* Unlock tree from updates.  Causes new clipping to be generated
		and affected Windows to be notified with SIGWINCH.  */
#define	WINGETINPARMS	_IOR(g, 60, struct winInParms)
		/* Copy out *winInParms.mask. */
#define	WINSETINPARMS	_IOW(g, 61, struct winInParms)
		/* Copy in *winInParms.mask. */
#define	WINGETEXPOSEDRL	_IOWR(g, 62, struct winClip)
		/* Copy in *winClip.sizeInBytes and if enough room then copy out RectList
		that contains the clipping of the window. 
		If not enough bytes then sizeInBytes will be alterred to specify how many needed. */
#define	WINGETDAMAGEDRL	_IOWR(g, 63, struct winClip)
		/* Like WINGETEXPOSEDRL but used during fixup when receive SIGWINCH. */
#define	WINDONEDAMAGED	_IO(g, 64)
		/* Call after finished fixing up for WINGETDAMAGEDRL. 
		Call even if chose to ignore fixup list. */
#define	WINFINDINTERSECT	_IOWR(g, 65, struct winIntersect)
		/* Copy in winIntersect and determine which window is being pointed at, winID relative. */
#define	WINGETOUTMGR	_IOR(g, 66, int)
		/* Copy out int which is the pid of who is signalled for SIGWINCH. */
#define	WINSETOUTMGR	_IOW(g, 67, int)
		/* Copy in int which is the pid of who is signalled for SIGWINCH. */
#define	WINSETSAVEDRECT	_IOW(g, 68, struct winSize)
		/* Copy in winSize and set saved rect of winSize->winID to winSize->rect (parent relative). */
#define	WINTOGGLERECTS	_IOW(g, 69, WinID)
		/* Copy in winID and swap its current rect and saved rect.  Will cause repaint. */
#define	WINPRINT	_IOW(g, 70, WinID)
		/* Copy in winID and print the windows data structure on the console.  Used for debugging. */
#define	WINDESTROY	_IOW(g, 71, WinID)
		/* Copy in winID and destroy the window by killing its process and cleaning up tree. */
#define	WINSETLINK	_IOW(g, 72, struct winLink)
		/* Copy in *winLink.winID and *winLink.which and change 
		the link in *winLink.winID to be winLink.winIDSet. */

#define WINS	/* Used to differentiate between gfx and win world */

#define NWIN	32	/* Number of window will support-total for each screen */
#define NSCR	1	/* Number of screens will support */

/* Barrow some signals until get own */
#include <signal.h>
#define	SIGWINCH	28	/* Note: Get officially registered. */
	/* Windows in this process changed size or clipping.  Get damaged rl and fix up each window.
	Check to see if window size changed, if you care, by comparing your cached
	window size with current window size.*/

typedef	int WinID;	/* Kernel internal identifier of window */

struct winLock {
	int clippingID;		/* clipping ID that must match current held */
	Rect rect;		/* window coordinates of area that may write */
};

#define CLIPPING_UNDEFINED	0	/* Means that clipping has not been set yet */

struct winClip {
	int sizeInBytes;
	int clippingID;
	coord screenOffsetX;	/* Screen relative (used when paint) */
	coord screenOffsetY;	/* Screen relative (used when paint) */
	char *block;	/* Block of bytes into which the RectList will be copied. */
			/* The RectList is self relative. */
};

struct winInParms {	/* User setable input options */
	unsigned mask;	/* TBD about input mask */
};

struct winIntersect {
	WinID winID;
	coord x, y;
};

#define	RESIZE		1
#define	DAMAGED_RL	2
	
struct winNew {
	WinID winID;
	WinID parent;
	WinID olderSib;
	WinID youngerSib;
	Rect rect;
};
struct winSize {
	WinID winID;
	Rect rect;		/* Rect is parent relative */
};
struct winLink {
	WinID winID;
	short which;
	WinID winIDSet;
};
#define	ENCLOSING_LINK		0
#define	PARENT_LINK		0
#define	COVERED_LINK		1
#define	OLDERSIB_LINK		1
#define	COVERING_LINK		2
#define	YOUNGERSIB_LINK		2
#define	BOTTOM_KID_LINK		3
#define	OLDESTCHILD_LINK	3
#define	TOP_KID_LINK		4
#define	YOUNGESTCHILD_LINK	4
#define	NULL_LINK		1024

struct keyboard{
	short down;	/* 1 is went down and 0 is went up on return &
			what class of state/transition will except on call. */
	char c;		/* Character invoked */
};

struct mouse{
	short x, y, buttons;
};

struct input {
	struct mouse mouse;
	struct keyboard keyboard;
};

/*
 * Button names -- Bred, Bgreen, Bblue or Bleft, Bmiddle, Bright or B1, B2, B3
 * Brange is a pseudo button set when the mouse leaves the window
 */
#define	M_TRACKALLMOUSE	0x10000
#define	Bred	4
#define	Bgreen	2
#define	Bblue	1
#define	Bleft	4
#define	Bmiddle	2
#define	Bright	1
#define	B1	4
#define	B2	2
#define	B3	1
#define	Brange	8
/*
 * state/transition bits used in WINGETINPUT
 */
#define	DOWN1	B1
#define	DOWN2	B2
#define	DOWN3	B3
#define	OUT	Brange
#define	UP1	(DOWN1<<4)
#define	UP2	(DOWN2<<4)
#define	UP3	(DOWN3<<4)
#define	IN	(OUT<<4)
#define	TDOWN1	(DOWN1<<8)
#define	TDOWN2	(DOWN2<<8)
#define	TDOWN3	(DOWN3<<8)
#define	TOUT	(OUT<<8)
#define	TUP1	(UP1<<8)
#define	TUP2	(UP2<<8)
#define	TUP3	(UP3<<8)
#define	TIN	(IN<<8)

#define NCURSOR	16		/* # of shorts in pointer shape	*/
#define DEFAULT_SHAPE	0	/* text arrow pointer shape	*/
#define USR_SHAPE	1	/* user supplied pointer shape	*/
#define BLANK_SHAPE	2	/* blank pointer shape	*/
#define WAIT_SHAPE	3	/* universal "wait because processing" pointer shape	*/
struct pointer_c {
	short type;		/* Index of system shape to use as pointer_c */
	coord xHot, yHot;	/* Hot spot on user shape. */
	short shape[NCURSOR];	/* User shape to use as pointer_c */
};

/* BEGIN CLEAN */

/*
 * Screen creation, inquiry and deletion.
 *
 * A screen is a piece of a viewsurface holding a tree of
 * windows.  For now, think of just one screen per surface.
 * Screens are named with small integers, e.g. 0 is the b/w display,
 * 1 is the color display.
 *
 * To make use of the window system you should first make a ``root''
 * window which covers the viewsurface and then make this the
 * root window for the screen with the call:
 *	ioctl(win, WINNEWSCREEN, &screenInfo);
 * This call also specifies the relationship of this screen to
 * other screens by naming the screens which are above/left/etc
 * of this screen.  This will allow the mouse to be moved from screen
 * to screen (someday).
 *
 * The call
 *	ioctl(win, WINGETSCREEN, &screenInfo);
 * returns information about a specified screen.
 *
 * The call
 *	ioctl(win, WINAXESCREEN, &screenInfo);
 * destroys the screen specified in screenInfo and does other
 * appropriately horrible things.  This is permitted only to
 * if win is the root window of the screen.
 */
#define	WINNEWSCREEN	_IOWR(g, 57, struct screenInfo)
#define	WINGETSCREEN	_IOWR(g, 56, struct screenInfo)
#define	WINAXESCREEN	_IO(g, 58)

typedef	int Screen;

#define	NORTH		0
#define	EAST		1
#define	SOUTH		2
#define	WEST		3

#define	NEIGHBORS 	4

struct screenInfo {
	Screen	screen;		/* screen identifier */
	int	*device;	/* device virtual address XXX */
	WinID	rootWin;	/* window id for root window */
	Rect	rect;		/* location in world coordinates */
	int	type;		/* screen type */
	Screen	neighbors[NEIGHBORS];
				/* adjacent screen, or -1 */
};
