/*	xyreg.h	1.6	83/06/27	*/

/*
 * Xylogics 440/450 declarations
 */

/*
 * I/O space registers - byte accesses only because of 450
 */
struct xydevice {		/* I/O space registers (at EE40) */
	u_char	xy_iopbrel[2];	/* 1,0 - IOPB relocation */
	u_char	xy_iopboff[2];	/* 3,2 - IOPB offset */
	u_char	xy_resupd;	/* 5 - reset/update */
	u_char	xy_csr;		/* 4 - controller status register */
};

/*
 * xy_csr bits
 */
#define	XY_GO		0x80	/* w - start operation */
#define XY_BUSY		0x80	/* r - operation in progress */
#define XY_ERROR	0x40	/* r - error occurred / w450 - clear error */
#define	XY_DBLERR	0x20	/* r - double error */
#define	XY_INTR		0x10	/* r - interrupting / w450 - clear interrupt */
#define	XY_ADDR24	0x08	/* r450 - addressing mode */
#define	XY_ATTN		0x04	/* w450 - attention request */
#define	XY_ACK		0x02	/* r450 - attention acknowledge */
#define	XY_DREADY	0x01	/* r - drive ready */

/*
 * IOPB - in real memory so we can use bit fields
 */
struct xyiopb {
	/* Byte 1 */
	u_char		   : 1;
	u_char	xy_intrall : 1;	/* interrupt on all iopbs (450) */
	u_char	xy_intrerr : 1;	/* interrupt on error */
	u_char	xy_reserve : 1;	/* reserve dual port drive (450) */
	u_char	xy_recal   : 1;	/* recalibrate on seek errors (450) */
	u_char	xy_enabext : 1;	/* enable extensions (450) */
	u_char	xy_eccmode : 2;	/* ECC actions */
	/* Byte 0 */
	u_char	xy_autoup  : 1;	/* auto update of IOPB */
	u_char	xy_reloc   : 1;	/* use relocation */
	u_char	xy_chain   : 1;	/* command chaining */
	u_char	xy_ie      : 1;	/* interrupt enable */
	u_char	xy_cmd     : 4;	/* command */
	/* Byte 3 */
	u_char	xy_errno;	/* error number */
	/* Byte 2 */	
	u_char	xy_iserr   : 1;	/* error indicator */
	u_char		   : 2;
	u_char	xy_ctype   : 3;	/* controller type */
	u_char		   : 1;
	u_char	xy_complete: 1;	/* completion code valid (450) */
	/* Byte 5 */
	u_char	xy_drive   : 2;	/* drive type */
	u_char		   : 4;
	u_char	xy_unit    : 2;	/* unit number */
	/* Byte 4 */
	u_char	xy_bytebus : 1;	/* use byte transfers */
	u_char	xy_intrlv  : 4;	/* interleave - 1 (450) */
	u_char	xy_throttle: 3;	/* throttle control */
	u_char	xy_sector;	/* 7: sector number */
	u_char	xy_head;	/* 6: head number */
	u_short	xy_cylinder;	/* 9,8: cylinder number */
	u_short	xy_nsect;	/* b,a: sector count */
#define	xy_status	xy_nsect	/* low byte is status */
	u_short	xy_bufoff;	/* d,c: buffer offset */
	u_short	xy_bufrel;	/* f,e: buffer offset */
	u_char		   : 8;	/* 11: reserved */
	u_char	xy_bhead;	/* 10: base head (450) */
	u_short	xy_nxtoff;	/* 13,12: next iopb offset */
	u_short	xy_eccpatt;	/* 15,14: ECC pattern */
	u_short	xy_eccaddr;	/* 17,16: ECC address */
};

/* commands */
#define	XY_NOP		0
#define	XY_WRITE	1
#define	XY_READ		2
#define	XY_SLIP		4
#define	XY_SEEK		5
#define	XY_RESET	6
#define	XY_FORMAT	7
#define	XY_READALL	8
#define	XY_STATUS	9
#define	XY_WRITEALL	10
#define	XY_INIT		11
#define	XY_TEST		12

/* controller types */
#define	XYC_440		0
#define	XYC_450		1
#define	XYC_472		2

/* xy_status bits */
#define	XY_ONCYL	0x80		/* true if zero */
#define	XY_READY	0x40		/* true if zero */
#define	XY_WRPOT	0x20
#define	XY_RSVRD	0x10
#define	XY_SKERR	0x08
#define	XY_FAULT	0x04

/* xy_throttle value */
#define XY_THROTTLE        4	/* 32 words/transfer */

#define	NXYDRIVE	4	/* 4 possible drive types */

/*
 * Layout for Read and Write of header, data, and ECC
 */
struct xyrec {
	u_short	xyr_cyl;	/* 1,0: cyl #, byte swapped */
	u_char	xyr_sector;	/* 3: sector number */
	/* Byte 2 */
	u_char	xyr_drive  : 2;	/* drive type */
	u_char		   : 1;	
	u_char	xyr_head   : 5;	/* head number */
	char	xyr_data[512];	/* data */
	u_long	xyr_ecc;	/* ECC value */
};
