;		LIFE.CMD
;	      ===============
;
; Command file to compile, assemble and build the LIFE demonstration program.
; 
;
.testfile life1.rtl
.if <filerr> ne 1 .goto notok
.;
.notok:
;
; Cannot find LIFE demo source files; please make sure you have set the default
; device:directory to that containing the LIFE demo files.
;
.exit
.;
.ok:
;
;	Compile the demo source files
;
rtl life2,life2,life2=life1,life2/ti:life2
.if <exstat> ne 1 .exit
rtl life3,life3,life3=life1,life3/ti:life3
.if <exstat> ne 1 .exit
rtl life3d,life3d,life3d=life1,life3d/ti:life3d
.if <exstat> ne 1 .exit
rtl life4,life4,life4=life1,life4/ti:life4
.if <exstat> ne 1 .exit
;
;	Verify the demo files
;
rlv ,life/ss:y=life2,life3,life3d,life4,rtlxrf
.if <exstat> ne 1 .exit
;
;	Assemble the demo files
;
mac life2
.if <exstat> ne 1 .exit
mac life3
.if <exstat> ne 1 .exit
mac life3d
.if <exstat> ne 1 .exit
mac life4
.if <exstat> ne 1 .exit
;
; Taskbuild
;
.;
.open life.lnk
.enable data
LIFE,LIFE/-SP=LIFE2,LIFE3,LIFE3D,LIFE4
@demetc
/
asg=ti:1:2
.disable data
.close
.;
.;
tkb @life.lnk
.if <exstat> ne 1 .exit
;
;
;	Demo program built successfully
;
;	This demo can now be run on a VT220-compatible vdu.
;
