/* block.c - (c) 2014 by Johnny Billquist */

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>

#include "block.h"

unsigned char buf[BFSZ];

void wrlen(FILE *f, int l, int m)
{
  int i,v;
  for (i=0; i<m; i++) {
    putc(l & 255, f);
    l = l >> 8;
  }
}

void writeblk(FILE *f, int l, int m)
{
  int i;
  wrlen(f, l, m);
  for (i=0; i<l; i++) {
    putc(buf[i], f);
  }
  if ((m == 4) && (l > 0)) wrlen(f,l,m);
}


int rdlen(FILE *f, int m)
{
  int i,x,l;
  l = 0;
  for (i=0; i<m; i++) {
    x = getc(f);
    if (x < 0) return -1;
    x <<= (8*i);
    l += x;
  }
  return l;
}

int readblk(FILE *f, int m)
{
  int l,i,z;

  l = rdlen(f, m);
  for (i=0; i<l; i++) {
    z = getc(f);
    if (z < 0) return -1;
    buf[i] = z;
  }
  if ((m == 4) && (l > 0)) i = rdlen(f,m);
  return l;
}

int detect(FILE *f)
{
  unsigned int x[4];
  int i,z;
  int m=-1;
  int m4l, m2l;

  fprintf(stderr, "Autodetecting type\n");
  for (i=0; i<4; i++) {
    z = getc(f);
    if (z < 0) {
      fprintf(stderr, "Failed to detect type\n");
      return -1;
    }
    x[i] = (unsigned int) z;
  }
  m2l = x[0] + (x[1] << 8);
  m4l = m2l + (x[2] << 16) + (x[3] << 24);
  if (m2l == m4l) {
    fseek(f, m4l + 4, SEEK_SET);
    for (i=0; i<4; i++) {
      z = getc(f);
      if (z != x[i]) {
	fprintf(stderr, "Failed to detect type\n");
	return -1;
      }
    }
    m = 4;
  } else if (m2l < 8192) m = 2;
  fseek(f, 0, SEEK_SET);
  if (m>0) fprintf(stderr,"Type of file is %d\n", m);
  return m;
}
