/* tpx.c - (c) 2914 by Johnny Billquist */

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/mtio.h>
#include <sys/ioctl.h>

#include "block.h"

main(argc,argv)
int argc;
char **argv;
{
  FILE *ifp;
  unsigned char *file = NULL;
  unsigned char *cmd;
  int mode = 0;
  int bc, bl, c, p, done, obl, b;

  fprintf(stderr, "tape check program\n");

  cmd = *argv++;

  while (--argc) {
    if (*argv[0] == '-') {
      if (argv[0][1] == '4') mode = 4;
      if (argv[0][1] == '2') mode = 2;
      argv++;
    }
    else if (!file) {
      file = *argv++;
    }
    else {
      fprintf(stderr,"usage: %s [opts] <infile>\n", cmd);
      exit(1);
    }
  }

  if ((ifp = fopen(file, "r")) == NULL) {
    fprintf(stderr,"Input file error.\n");
    exit(1);
  }

  done = 0;
  obl = -1;
  bc = 0;
  if (mode == 0) mode = detect(ifp);
  if (mode < 2) {
    fprintf(stderr, "Unknown mode for file\n");
    exit(1);
  }
  while (!done) {
    bl = readblk(ifp, mode);
    printf("Block %d. Length = %d\n", bc, bl);
    if (bl <= 0 && obl <= 0)
      done = -1;
    obl = bl;
    bc++;
  }
  printf("eof\n");
  fclose(ifp);
}
