
/* PDP-11 Assembler for the VAX Pass 0 */

#include "vars1.h"

#include <pdp11/names.h>

char fpass2[] = ASPASS2;
char globfl[] = "-\0";
char outfl[] = "-o";
char outfile[] = "a.out";

char *argv2[] = {
    fpass2,
    globfl,
    outfl,
    outfile,
    a_tmp1,
    a_tmp2,
    a_tmp3,
    NULL };

void go(void) {
    FILE *fd;
    
    assem();
    if (fclose(pof) == EOF)
	wrterr("can't close %s", a_tmp1);
    if (fclose(fbfil) == EOF)
	wrterr("can't close %s", a_tmp2);
    if (errflg)
	aexit(1);
    if ((fd = fcreat(a_tmp3)) == NULL)
	wrterr("can't create %s", a_tmp3);
    setbuf(fd, iobuf2);
    if (symend != (char *) usymtab)
	if (fwrite((char *) usymtab, symend - (char *) usymtab, 1, fd) != 1)
	    wrterr("can't write on %s", a_tmp3);
    if (fclose(fd) == EOF)
	wrterr("can't close %s", a_tmp3);
    execv(fpass2, argv2);
    fprintf(stderr, "%s?\n", fpass2);
}

void aexit(int i) {
    unlink(a_tmp1);
    unlink(a_tmp2);
    unlink(a_tmp3);
    exit(3);
}

FILE *fcreat(char *name) {
    struct stat statb;
    int fd;
    
    while (stat(name, &statb) >= 0 || (fd = creat(name,0444)) < 0)
	if (name[9]++ == 'z') {
	    fprintf(stderr, "%s?\n", name);
	    exit(3);
	}
    return (fdopen(fd, "w"));
}

void wrterr(char *s, char *n) {
    fprintf(stderr, "as: error on temp file: ");
    fprintf(stderr, s, n);
    fprintf(stderr, "\n");
    aexit(1);
}
