/* PDP-11 Assembler for the VAX Pass 0 */

#include "vars1.h"

#define PASS1		/* Cause names to be inserted */
#include "symbols.code"	/* Insert symbol table */

#define SYMSIZE (sizeof(symtab)/sizeof(struct symbol))

int main(int argc, char **argv) {
    void (*oldsig)();
    int chr;
    extern int end;

    oldsig = signal(SIGINT, SIG_IGN);
    if (((int) oldsig & 01) == 0)
	signal(SIGINT, aexit);
    argv++;
    argc--;
    while (argv[0][0] == '-' && argc > 0) {
	chr = argv[0][1];
	if (chr == 'u' || chr == '\0')
	    globfl[1] = 'g';
	else if (chr == 'o') {
	    argv2[3] = *++argv;
	    argc--;
	} else {
	    fprintf(stderr, "as: %s bad flag\n", *argv);
	    break;
	}
	argv++;
	argc--;
    }
    nargs = argc;
    curarg = argv - 1;
#ifdef notdef	/* -tih */
    symend = endcore = (char *) &end;
    usymtab = (struct symbol *)endcore;
#else
    symend = (char *) &end;
    usymtab = (struct symbol *) symend;
    endcore = sbrk(0);
#endif
    pof = fcreat(a_tmp1);
    setbuf(pof, iobuf1);
    fbfil = fcreat(a_tmp2);
    setbuf(fbfil, iobuf2);
    setup();
    fclose(stdin);
    go();
    return (0);
}

void setup(void) {
    struct symbol *sptr, **hptr;
    
    for (sptr = symtab; sptr < &symtab[SYMSIZE]; sptr++) {
	hptr = findsym(hashsym(sptr->s_name), sptr->s_name);
	*hptr = sptr;
    }
}
