/* cc11.c - main */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <signal.h>

#include <pdp11/names.h>

/*----------------------------------------------------------------------
 * cc11 -- replacement for (and translated directly from) cc11.sh
 *----------------------------------------------------------------------
 */

char	DIR[]		= CCDIRSPEC,
	CPP[]		= CCCPPSPEC,
	C0[]		= CCC0SPEC,
	C1[]		= CCC1SPEC,
	C2[]		= CCC2SPEC,
	AS[]		= CCASSPEC,
	ASDEFS[]	= CCASDEFS,
	LD[]		= CCLDSPEC,
	CRT[]		= CCCRTSPEC,
	*crtptr = CRT,
	LIBS[]		= CCLIBSSPEC,
	*libptr = LIBS,
	STANDLIB[]	= CCSTANDLIB,
	STANDCRT[]	= CCSTANDCRT;

int cflag = 1, Eflag = 0, Sflag = 0, Oflag = 0, vflag = 0, Lflag = 0;
int Aflag = 1, errors = 0;
char ldflags[256], Iflags[256], libs[512];
char cfiles[512], sfiles[512], ofiles[512];
char *ofile, *usymbol, *entry = "start", *Pflag = "", *dot, *file, *space;
char tmp[7][20], y[160], z[160];
char pobuf[160], *cppo, sysbuf[512], *cco, *asi;
int PID = -1;

struct sig {
    int snum;
    char *sname;
} sigs[] = {
    { SIGHUP, 	"Hangup" },
    { SIGINT,	"Interrupt" },
    { SIGQUIT,	"Quit" },
    { SIGILL,	"Illegal Instruction" },
    { SIGFPE,	"Floating Point Exception" },
    { SIGBUS,	"Bus Error" },
    { SIGSEGV,	"Segmentation Violation" },
    { SIGSYS,	"Bad System Call" },
    { SIGPIPE,	"Broken Pipe" },
    { SIGALRM,	"Alarm Clock" },
    { SIGTERM,	"Terminate" },
    { SIGURG,	"Urgent Condition" },
    { SIGXCPU,	"Exceeded CPU Limit" },
    { SIGXFSZ,	"Exceeded File Size Limit" },
    { NULL,		NULL}
};

void doremove(int);
int main(int, char **);
void assemble(char *);

void doremove(int s) {
    int i;
    if (s > 0)
	signal(s,SIG_IGN);
    for (i = 0; i < 7; i++)
	unlink(tmp[i]);
    if (s > 0) {
	if (PID > 0)
	    kill(PID,SIGTERM);
	for (i = 0; (sigs[i].snum > 0) && (sigs[i].snum < s); i++);
	fprintf(stderr,"cc11: received signal %d (%s)\n",s,sigs[i].sname);
    }
    exit(s != 0);
}


int main(int argc, char **argv) {
    char **a;
    int i, pid;

    pid = getpid();
    usymbol = "";
    ofile = "a.out";
    *cfiles = *sfiles = *ofiles = '\0';
    *libs = *Iflags = *ldflags = '\0';
    for (a = &argv[1]; *a != NULL; a++) {
	if (**a == '-') {
	    switch ((*a)[1]) {
	    case 'o':
		if (*++a == NULL) {
		    fprintf(stderr,"-o what?\n");
		    exit(1);
		}
		ofile = *a;
		break;
	    case 'u':
		if (*++a == NULL) {
		    fprintf(stderr,"-u what?\n");
		    exit(1);
		}
		usymbol = *a;
		break;
	    case 'e':
		if (*++a == NULL) {
		    fprintf(stderr,"-e what?\n");
		    exit(1);
		}
		entry = *a;
		break;
	    case 'P':
		Pflag = "-P";
		cflag = 0;
		break;
	    case 'E':
		Eflag++;
		cflag = 0;
		break;
	    case 'S':
		Sflag++;
		cflag = 0;
		break;
	    case 'O':
		Oflag++;
		break;
	    case 'c':
		cflag = 0;
		break;
	    case 'v':
		vflag++;
		break;
	    case 'L':
		Lflag++;
		break;
	    case 'A':
		Aflag = 0;
		break;
	    case 'd':
	    case 'r':
	    case 's':
	    case 'x':
	    case 'X':
		strcat(ldflags," ");
		strcat(ldflags,*a);
		break;
	    case 'i':
	    case 'n':
		fprintf(stderr,"warning: can't share text on LSI-11\n");
		break;
	    case 'D':
	    case 'I':
	    case 'U':
		strcat(Iflags," ");
		strcat(Iflags,*a);
		break;
	    case 'l':
		strcat(libs," ");
		strcat(libs,*a);
		break;
	    default:
		fprintf(stderr,"-%c option ignored.\n",(*a)[1]);
	    }
	}
	else {
	    if ( (dot = rindex(*a,'.')) == NULL) { /* object file */
		strcat(ofiles," ");
		strcat(ofiles,*a);
		continue;
	    }
	    switch (dot[1]) {
	    case 'c':
		strcat(cfiles," ");
		strcat(cfiles,*a);
		break;
	    case 's':
		strcat(sfiles," ");
		strcat(sfiles,*a);
		break;
	    case 'a':
		strcat(libs," ");
		strcat(libs,*a);
		break;
	    default:
		strcat(ofiles," ");
		strcat(ofiles,*a);
	    }
	}
    }
    strcat(Iflags," -I");
    strcat(Iflags,DIR);
    strcat(Iflags,"/include");
    strcat(Iflags," -I");
    strcat(Iflags,DIR);
    strcat(Iflags,"/src/sys/h");
    for (i = 0; i < 7; i++) {
	sprintf(tmp[i],"/tmp/ctm%da%d",i,pid);
	unlink(tmp[i]);
    }

    for (i = 0; sigs[i].snum > 0; i++)
	signal(sigs[i].snum,doremove);

    for (file = cfiles; file != NULL && *file!='\0'; file=index(file,' ')) {
	file++;
	space = index(file,' '); /* deal with 1 file name at a time */
	if (space)
	    *space = '\0';
	dot = rindex(file,'.');	/* should check for error */
	*dot = '\0'; strcpy(y,file); *dot = '.'; /* name up to '.' */
	strcpy(z,file);		/* name including '.' & suffix */
	if (space)		/* restore blank if we took it out */
	    *space = ' ';
	printf("%s:\n",z);	/* left from early days... */
	if (Eflag)
	    cppo = "-";
	else if (*Pflag) {
	    sprintf(pobuf,"%s.i",y);
	    cppo = pobuf;
	}
	else
	    cppo = tmp[3];
	if (vflag)
	    fprintf(stderr,"[preprocessor] %s %s %s %s\n",z,cppo,Iflags,Pflag);
	sprintf(sysbuf,"%s %s %s %s %s -DXinu",CPP,z,cppo,Iflags,Pflag);
	if (system(sysbuf)) {
	    errors = 1;
	    continue;
	}
	if (*Pflag || Eflag)
	    continue;
	if (vflag)
	    fprintf(stderr,"[pass1] %s %s %s\n",cppo,tmp[0],tmp[1]);
	sprintf(sysbuf,"%s %s %s %s",C0,cppo,tmp[0],tmp[1]);
	if (system(sysbuf)) {
	    errors = 1;
	    continue;
	}
	if (Sflag) {
	    sprintf(pobuf,"%s.s",y);
	    asi = pobuf;
	    if (Oflag)
		cco = tmp[4];
	    else
		cco = pobuf;
	}
	else {
	    if (Oflag)
		cco = tmp[4];
	    else
		cco = tmp[2];
	    asi = tmp[2];
	}
	if (vflag)
	    fprintf(stderr,"[pass2] %s %s %s\n",tmp[0],tmp[1],cco);
	sprintf(sysbuf,"%s %s %s %s",C1,tmp[0],tmp[1],cco);
	if (system(sysbuf)) {
	    errors = 1;
	    continue;
	}
	if (Oflag) {
	    if (vflag)
		fprintf(stderr,"[optimizer] %s %s\n",cco,asi);
	    sprintf(sysbuf,"%s %s %s",C2,cco,asi);
	    if (system(sysbuf)) {
		errors = 1;
		continue;
	    }
	}
	if (Aflag) {
	    sprintf(sysbuf,"cp %s %s;%s/bin/cvt11 %s > %s",
		    asi,tmp[6],DIR,tmp[6],asi);
	    if (vflag)
		fprintf(stderr,"[convert ps] %s\n", sysbuf);
	    if (system(sysbuf)) {
		fprintf(stderr, "ps undeclared\n");
		errors = 1;
		continue;
	    }
	}
	if (Sflag)
	    continue;
	assemble(asi);
    }
    if (*sfiles != '\0')
	for (file = sfiles; file != NULL && *file!='\0'; file=index(file,' ')) {
	    file++;
	    space = index(file,' '); /* deal with 1 file name at a time */
	    if (space)
		*space = '\0';
	    dot = rindex(file,'.'); /* should check for error */
	    *dot = '\0'; strcpy(y,file); *dot = '.'; /* name up to '.' */
	    strcpy(z,file);	/* name including '.' & suffix */
	    if (space)		/* restore blank if we took it out */
		*space = ' ';
	    printf("%s:\n",z);	/* left from early days... */
	    assemble(z);
	}

    if (Lflag) {
	libptr = STANDLIB;
	crtptr = STANDCRT;
    }
    if ( (errors == 0) && (cflag) ) {
	if (vflag)
	    fprintf(stderr,"[loader] -e %s -o %s %s %s%s %s %s %s %s\n",
		    entry,ofile,crtptr,*usymbol?"-u ":"",usymbol,
		    ldflags,ofiles,libs,libptr);
	sprintf(sysbuf,"%s -X -e %s -o %s %s %s%s %s %s %s %s",
		LD,entry,ofile,crtptr,*usymbol?"-u ":"",usymbol,
		ldflags,ofiles,libs,libptr);
	if (system(sysbuf))
	    errors = 1;
    }
    doremove( (errors != 0) ? -1 : 0);
    return(0);
}

char asbuf[160], *aso;

void assemble(char *asi) {
    sprintf(asbuf,"%s.o",y);
    aso = asbuf;
    if (vflag)
	fprintf(stderr,"[assembler] -u -o %s %s\n",aso,asi);
    sprintf(sysbuf,"%s -u -o %s %s %s",AS,aso,ASDEFS,asi);
    if (system(sysbuf)) {
	errors = 1;
	return;
    }
    if (Sflag == 0) {
	strcat(ofiles," ");
	strcat(ofiles,aso);
    }
}

