/* startup.s - start, _disable, _enable */ /* standalone version */

DISABLE	=	340			/ PS to disable interrupts
ENABLE	=	0			/ PS to enable interrupts
EXCPPC	=	4			/ exception vector address for
EXCPPS	=	6			/ "memory out of range" errors
MAXADDR	= 0157776			/ maximum valid memory address
reset   = 0000005			/ LSI 11 opcodes not recognized
mfps	= 0106700 ^ tst			/ by the assembler
mtps	= 0106400 ^ tst

/*----------------------------------------------------------------------
/*  Stand-alone startup header -- branches to main program after
/*            getting the stack pointer in place for C run-time
/*  Features: sizes memory and starts SP at highest address.
/*            preserves interrupt vectors in case they have
/*            been set statically.
/*            leaves interrupts disabled when program starts
/*            (call enable/disable to enable or disable them
/*            while running)
/*            Will halt if user program returns; type P to run again
/*----------------------------------------------------------------------
	.globl	start, _restart, _main, _disable, _enable

/*----------------------------------------------------------------------
/*  absolute location 0  -- fixed interrupt and exception vectors
/*----------------------------------------------------------------------

.	=	000^.
	jmp	start
.	=	004^.			/ bus error (e.g., malfunction)
	20001;	0
.	=	010^.			/ illegal/reserved instruction
	20002;	0
.	=	014^.			/ BPT instruction and T bit
	20003;	0
.	=	020^.			/ Input/Output trap
	20004;	0
.	=	024^.			/ Power	fail
	20005;	0
.	=	030^.			/ EMT instruction, emulator trap
	20006;	0
.	=	034^.			/ TRAP instruction
	20007;	0
.	=	040^.
	20007;	0
.	=	044^.
	20007;	0
.	=	050^.
	20007;	0
.	=	054^.
	20007;	0
.	=	060^.			/ Console terminal, input
	20007;	0			/  (usually, device 0)
.	=	064^.			/ Console terminal, output
	20007;	0			/  (usually, device 0)
.	=	070^.
	20007;	0
.	=	074^.
	20010;	0
.	=	100^.			/ BEVENT (real-time clock)
	20007;	0
.	=	104^.
	20007;	0
.	=	110^.
	20007;	0
.	=	114^.
	20007;	0
.	=	120^.
	20007;	0
.	=	124^.			/ DRV11-B
	20007;	0
.	=	130^.
	20007;	0
.	=	134^.
	20007;	0
.	=	140^.
	20007;	0
.	=	144^.
	20007;	0
.	=	150^.
	20007;	0
.	=	154^.
	20007;	0
.	=	160^.			/ RLV11	DMA interface
	20007;	0
.	=	164^.
	20007;	0
.	=	170^.
	20007;	0
.	=	174^.
	20007;	0
.	=	200^.			/ LAV11, LPV11 line printers
	20007;	0
.	=	204^.
	20007;	0
.	=	210^.
	20007;	0
.	=	214^.
	20007;	0
.	=	220^.			/ RKV11	disk
	20007;	0
.	=	224^.
	20007;	0
.	=	230^.
	20007;	0
.	=	234^.
	20007;	0
.	=	240^.
	20007;	0
.	=	244^.			/ Floating point error
	20007;	0
.	=	250^.			/ Memory management (11/23)
	20007;	0
.	=	254^.
	20007;	0
.	=	260^.
	20007;	0
.	=	264^.			/ RXV11, RXV21 floppy disks
	20007;	0
.	=	270^.
	20007;	0
.	=	274^.
	20007;	0
.	=	300^.			/ Start	of floating vectors
	20007;	0
.	=	304^.
	20007;	0
.	=	310^.
	20007;	0
.	=	314^.
	20007;	0
.	=	320^.
	20007;	0
.	=	324^.
	20007;	0
.	=	330^.
	20007;	0
.	=	334^.
	20007;	0
.	=	340^.
	20007;	0
.	=	344^.
	20007;	0
.	=	350^.
	20007;	0
.	=	354^.
	20007;	0
.	=	360^.
	20007;	0
.	=	364^.
	20007;	0
.	=	370^.
	20007;	0
.	=	374^.
	20007;	0
.	=	400^.
	20007;	0
.	=	404^.
	20007;	0
.	=	410^.
	20007;	0
.	=	414^.
	20007;	0
.	=	420^.
	20007;	0
.	=	424^.
	20007;	0
.	=	430^.
	20007;	0
.	=	434^.
	20007;	0
.	=	440^.
	20007;	0
.	=	444^.
	20007;	0
.	=	450^.
	20007;	0
.	=	454^.
	20007;	0
.	=	460^.
	20007;	0
.	=	464^.
	20007;	0
.	=	470^.
	20007;	0
.	=	474^.
	20007;	0
.	=	500^.
	20007;	0
.	=	504^.
	20007;	0
.	=	510^.
	20007;	0
.	=	514^.
	20007;	0
.	=	520^.
	20007;	0
.	=	524^.
	20007;	0
.	=	530^.
	20007;	0
.	=	534^.
	20007;	0
.	=	540^.
	20007;	0
.	=	544^.
	20007;	0
.	=	550^.
	20007;	0
.	=	554^.
	20007;	0
.	=	560^.
	20007;	0
.	=	564^.
	20007;	0
.	=	570^.
	20007;	0
.	=	574^.
	20007;	0
.	=	600^.
	20007;	0
.	=	604^.
	20007;	0
.	=	610^.
	20007;	0
.	=	614^.
	20007;	0
.	=	620^.
	20007;	0
.	=	624^.
	20007;	0
.	=	630^.
	20007;	0
.	=	634^.
	20007;	0
.	=	640^.
	20007;	0
.	=	644^.
	20007;	0
.	=	650^.
	20007;	0
.	=	654^.
	20007;	0
.	=	660^.
	20007;	0
.	=	664^.
	20007;	0
.	=	670^.
	20007;	0
.	=	674^.
	20007;	0
.	=	700^.
	20007;	0
.	=	704^.
	20007;	0
.	=	710^.
	20007;	0
.	=	714^.
	20007;	0
.	=	720^.
	20007;	0
.	=	724^.
	20007;	0
.	=	730^.
	20007;	0
.	=	734^.
	20007;	0
.	=	740^.
	20007;	0
.	=	744^.
	20007;	0
.	=	750^.
	20007;	0
.	=	754^.
	20007;	0
.	=	760^.
	20007;	0
.	=	764^.
	20007;	0
.	=	770^.
	20007;	0
.	=	774^.
	20007;	0
	
.	=	1000^.
	
_restart:
start:
	mtps	$DISABLE		/ Disable interrupts
	reset				/ Clear the bus
	mov	$kernstk,sp		/ set up temporary stack pointer
	mov	*$EXCPPC,r3		/ save old contents of
	mov	*$EXCPPS,r4		/  exception vector
	mov	$siztrap,*$EXCPPC	/ set up vector to catch memory
	mov	$DISABLE,*$EXCPPS	/ exceptions; disable interrupts
	mov	$MAXADDR,r0		/ set r0 to highest possible loc
sizloop:
	mov	(r0),(r0)		/ reference what r0 points to
	mov	r4,*$EXCPPS		/ no fault, so memory exists
	mov	r3,*$EXCPPC		/ restore exception vectors
	mov	r0,sp			/ set stack pointer
	clr	(sp)			/ clear argv
	clr	-(sp)			/ clear argc
	jsr	pc,_main		/ start main program
	halt				/ halt if program returns
	jbr	start			/ rerun if user types P

siztrap:
	add	$4,sp			/ pop interrupted PC and PS
	sub	$8.,r0			/ move to next lower address
	jbr	sizloop			/ try again

_disable:
	mtps	$DISABLE		/ externally callable routine to
	rts	pc			/   disable interrupts

_enable:
	mtps	$ENABLE			/ externally callable routine to
	rts	pc			/   enable interrupts

	.data
.	=	.+6			/ temporary stack space for trap
kernstk:				/  while sizing memory
.	=	.+2
