	.TITLE	KERCON
	.VERSION 1
	.SBTTL	Header
/ ++
/
/	KERCON	X1B
/
/	(c) 1990, 1991 by Johnny Billquist
/
/	Kermit for pdp8.
/	The CONNECT code.
/
/	Id	Programmer
/	BQT	Johnny Billquist
/
/	Ver	Date		By	Comments
/	X1A	90/02/07 21:00	BQT	Copied from KERMIT.
/	X1B	91/05/15 06:40	BQT	Changed escape function. Now beeps
/					when unknown character is given.
/
/ --
	.SBTTL	Setup
	.INCLUDE	SYS:COMMON
	.EXTERNAL	TGET,PUT
	.ZTERNAL	GETL,PUTL
	.EXTERNAL	MAIN,FP,CHKEOL,CLRCC
	.EXTERNAL	FIL
/
/ .FP macro is NOT the same as .FILEPARSE
/ .FP calls FILEPARSE and FETCH...
/
	.MACRO	.FP	DEVADR,FILNAM
	JMS	FP
	DEVADR
	FILNAM
	.ENDM
	.SBTTL	Zero page

	.XSECT	XREG
X0,	0

	.ZSECT	ZCON
	FIELD	XREG
TMP,	0
/
LOGFLG,	0
	.SBTTL	The CONNECT routine.
/
	.RSECT	RCON
	FIELD	XREG
/
	.ENTRY	CONNEC
/
CONNEC,	JMS	CHKEOL
	.PRINT	CONTXT		/CONNECT. Print out text.
	TAD	ESC
	CIA
	TAD	(100)
	CIF	PUT
	JMS	PUT
	.PRINT	CON2
CLOOP,	CIF	TGET
	JMS I	GETL		/Anything from modem?
	JMP	2$		/No.
	DCA	TMP		/Yes. Save char.
	TAD	TMP		/Get char.
	CIF	PUT
	JMS	PUT		/Output on tty.
	TAD	LOGFLG		/Check if logging enabeled.
	SZA CLA
	JMS	LOG		/It is. Log.
2$:	CIF	TGET
	JMS	TGET		/Anything on tty.
	JMP	CLOOP		/No. Repeat.
	DCA	TMP		/Save it.
	TAD	TMP		/Check if escape character.
	AND	(177)
	TAD	ESC
	SNA CLA
	JMP	CHKESC		/It was escape char. See if escape...
	TAD	TMP		/No escape. Get char.
OKC,	CIF	PUT
	JMS I	PUTL		/Output it.
	JMP	CLOOP		/Repeat.
/
UPC,	0			/Make character uppercase.
	AND	(177)
	TAD	(-140)
	SMA
	TAD	(-40)
	TAD	(140)
	JMP I	UPC
/
GESC,	TAD	ESC
	CIA
	JMP	OKC
/
	.SBTTL	Error routines.
/
LOERR,	.PRINT	LOET
	JMP	MAIN
/
LCERR,	.PRINT	LCET
	JMP	MAIN
/
CLRLOG,	0			/Stop logging.
	CLA			/Are we logging?
	TAD	LOGFLG
	SNA CLA
	JMP I	CLRLOG		/No. Return.
	DCA	LOGFLG		/Yes. Clear flag.
	TAD	(232		/Output EOF.
	.OCHAR	LFIB,LCERR
	.CLOSE	LFIB,LCERR	/And close file.
	.PRINT	LOISOF		/Tell action.
	JMP I	CLRLOG		/Return.
/
	PAGE
	.SBTTL	CONNECT escape.
/
CHKESC,	CIF	TGET
	JMS	TGET		/Get 2:nd char.
	JMP	CHKESC		/Wait for it to come.
	JMS	UPC		/Make into uppercase.
	TAD	(-"C)		/Close connection?
	SNA
	JMP	EXIT$
	TAD	("C-"?)		/Help?
	SNA
	JMP	OPTL$
	TAD	("?-"Q)		/Quit logging.
	SNA
	JMP	QLOG$
	TAD	("Q-"R)		/Resume logging.
	SNA
	JMP	DOLOG$
	TAD	("R)
	TAD	ESC
	SNA CLA
	JMP	GESC
	TAD	(7)		/We didn't understand this. Output a bell.
	CIF	PUT
	JMS	PUT
	JMP	CLOOP		/And get next char...
/
EXIT$:	.PRINT	EXICON		/Escaping... Tell 'em.
	JMS	CLRLOG		/Close LOG if open.
	JMS	CLRCC		/Clear ^C.
	NOP
	JMP	MAIN		/New command.
/
OPTL$:	.PRINT	OPTLT		/Print list of commands.
	JMP	CHKESC		/And repeat.
/
QLOG$:	TAD	LOGFLG		/Quit logging.
	SNA CLA			/Check if we ARE logging.
	JMP	NOLOG$		/We are not.
	JMS	CLRLOG		/We are. Close LOG.
	JMP	CLOOP
/
NOLOG$:	.PRINT	NOLOOP		/Not logging. Tell him.
	JMP	CLOOP
/
DOLOG$:	TAD	LOGFLG		/Start logging...
	SZA CLA			/Are we already logging?
	JMP	ISLOG$		/Yes, say so.
	TAD	LOGFIL		/Is no logfile specified?
	SNA CLA
	JMP	NOLOF$		/Say so.
	.FP	LDEVH!1,LOGFIL	/Otherwise parse filename.
	DCA	LFIB+DEVNUM	/Save device number and address.
	TAD I	X0
	DCA	LFIB+DEVADR
	.OOPEN	LFIB,FIL,LOERR	/Open file
	.PRINT	LOGGIN		/Say we have started.
	CLA CMA			/Set flag.
	DCA	LOGFLG
	JMP	CLOOP

NOLOF$:	.PRINT	NOLOFI		/Print no logfile text.
	JMP	CLOOP

ISLOG$:	.PRINT	LOISOP		/Print logfile already activated.
	JMP	CLOOP
/
	.GLOBAL	ESC
/
ESC,	-^"]
/
	.SBTTL	LOG subfunctions.
/
LOG,	0			/Logging on file...
	CLA
	TAD	TMP		/Get char.
	.OCHAR	LFIB,LERR	/Output it on log.
	JMP I	LOG		/Return.
/
LERR,	JMS	LOGERR		/Error while logging...
	JMP I	LOG		/                                                                                                  Return.
/
LOGERR,	0			/Logging error...
	.PRINT	LOGFUL		/Tell we have log error.
	.CLOSE	LFIB,LCERR	/Clsoe log.
	DCA	LOGFLG		/Clear flag.
	JMP I	LOGERR
/
	PAGE
	.SBTTL	Text data

	.DSECT	TXCON
	.RADIX	10

LOGFUL,	TEXT	<13><10>"[Logfile full. Logging stopped.]"<13><10>
LOET,	TEXT	<13><10>"Error opening logfile!"<13>
LCET,	TEXT	<13><10>"Error closing logfile!"<13>
LOGGIN,	TEXT	<13><10>"[KERMIT has started logging you session.]"<13><10>
LOISOF,	TEXT	<13><10>"[KERMIT has closed your logfile.]"<13><10>
NOLOOP,	TEXT	<13><10>"[You have not started logging yet.]"<13><10>
NOLOFI,	TEXT	<13><10>"[You have not specified a logging file.]"<13><10>
LOISOP,	TEXT	<13><10>"[You are already logging session.]"<13><10>

CONTXT,	TEXT	<10>"[Connecting. Press C-"
CON2,	TEXT	" C to close connection (return to pdp8).]"<13><10>
EXICON,	TEXT	<13><10>"[Back to pdp8]"<13>
	.DISABLE FILL
OPTLT,	TEXT	<13><10>"[Options available:"<13><10>
	TEXT	" C  Close connection (return to pdp8)."<13><10>
	TEXT	" R  Start logging."<13><10>
	TEXT	" Q  Quit logging."<13><10>
	TEXT	" ?  This text."<13><10>
	TEXT	"(Pressing the escape character a second time, will send it.)]"<13><10><0>
	.ENABLE FILL
	.SBTTL	Data

	.DSECT	DACON
	FIELD	XREG
	.RADIX	8

LFIB,	.FIB	,,FILBUF	/FIB for all file operations.
/
	.GLOBAL	LOGFIL
/
LOGFIL,	TEXT	"DSK:KERMIT.LOG"<0>
	.SBTTL	BUFFERS
/
	.DSECT	BUFF
/
FILBUF,	ZBLOCK	400			/File buffer.
/
	.RSECT	HANDL
	FIELD	0
LDEVH,	ZBLOCK	400			/Area for device handler.
/
	.END
