	.TITLE	KERPKT
	.VERSION 1
	.SBTTL	Header
/ ++
/
/	KERPKT	X1G
/
/	(c) 1990, 1991 by Johnny Billquist
/
/	Kermit for pdp8.
/	The low level packet routines.
/
/	Id	Programmer
/	BQT	Johnny Billquist
/
/	Ver	Date		By	Comments
/	X1A	90/02/09 12:30	BQT	Copied from KERMIT.
/	X1B	90/05/07 02:00	BQT	Moved code into field 3.
/	X1C	90/06/05 02:00	BQT	Started coding recieve functions.
/	X1D	90/07/17 03:00	BQT	First working version!
/	X1E	90/07/28 03:00	BQT	Added .FIXFIL on filenames.
/	X1F	91/03/14 02:35	BQT	Removed obsolete .RESET call.
/	X1G	91/05/08 17:35	BQT	Split from KERSND.
/
/ --
	.SBTTL	Setup
	.INCLUDE	SYS:COMMON
/
	.EXTERNAL	FLUSH
	.ZTERNAL	GETP,PUTP,FLUSHP
	.EXTERNAL	SETTMR,CHKTMR,CLRCC,RET
	.ZTERNAL	DEFPAR,LOCPAR,REMPAR
/
	.MACRO	.MSG	ADDR
	.IF BL	ADDR	<DCA	.+3>
	.EXTERNAL	$MSG
	JMS	$MSG
	.IF BL	ADDR	<
	.FLD
	0>
	.IF NB	ADDR	<
	EDF	ADDR
	ADDR>
	.ENDM
/
MAXL=0
TIME=1
NPAD=2
PADC=3
EOL=4
QCTL=5
QBIN=6
CHKT=7
REPT=10
CAPAS=11
MARK=12
SEQ=13
/
	.SBTTL	Zero page

	.XSECT	PXREG
	FIELD	3
SRCP,	0
DSTP,	0

	.ZSECT	PZREG
	FIELD	PXREG
/
TRIES,	0
	.GLOBAL	MAXTRY
MAXTRY,	4
/
/ Packet types...
/
ACK="Y
NAK="N
ERR="E
/
	.SBTTL	Packet code.
/
	.RSECT	PKT
	FIELD	PXREG
/
	.SBTTL	Send packet.
/
/ SPKT call format:
/
/ TAD	(TYPE	/Type of packet to send.
/ JMS	SPKT
/ <addr>	/Address of data for packet to send.
/ <bool>	/0 for immediate return. Non-0: Wait for ACK.
/
	.ENTRY	SPKT
SPKT,	0
	DCA	TYP$		/Save packet type.
	CMA			/Get address of data.
	TAD I	SPKT
	ISZ	SPKT
	DCA	SRCP		/Save address.
	TAD I	SPKT		/Get post-action flag.
	ISZ	SPKT
	DCA	ANSP$
	TAD	(SPBUF-1)	/Get destination address for data.
	DCA	DSTP
	DCA	LC$

	TAD	REMPAR+MARK	/Get start marker.
	DCA I	DSTP
	DCA I	DSTP		/Skip length byte.
	TAD	LOCPAR+SEQ	/Get sequence number.
	AND	(77)
	JMS	CHAR		/char(seq)
	DCA I	DSTP		/Save sequence number.
	TAD	LOCPAR+SEQ
	MQL
	CLA
	ISZ	LOCPAR+SEQ	/Bump sequence number.
	NOP
	TAD	TYP$		/Packet type.
	DCA I	DSTP

COPY$:	TAD I	SRCP		/Copy data until NUL.
	SNA
	JMP	ECOPY$
	DCA I	DSTP
	ISZ	LC$
	JMP	COPY$

ECOPY$:	DCA I	DSTP		/Set mark for end of send buffer.
	TAD	DSTP		/Get pointer. (Checksum pointer.)
	DCA	CKPTR$
	TAD	REMPAR+EOL	/The comes end of line char.
	DCA I	DSTP
	DCA                                                                                                                                                                                                                                                                                                                                                                                      I	DSTP		/EOB marker.
	TAD	LC$		/Get length of data.
	TAD	(3)		/Add 3 for type, seq and checksum byte.
	JMS	CHAR		/char(length)
	DCA	SPBUF+1		/Save length.
	JMS	CKSUM;SPBUF+1	/Calculate checksum.
	JMS	CHAR		/char(cksum)
	DCA I	CKPTR$		/Save checksum.

RSND$:	TAD	MAXTRY		/Setup try limit.
	CIA
	DCA	TRIES

SEND$:	TAD	(SPBUF-1)	/Setup pointer to packet buffer.
	DCA	SRCP

	CIF	0		/Clear input buffer.
	JMS I	FLUSHP

SLOOP$:	TAD I	SRCP		/Send packet.
	SNA
	JMP	ESEND$
	CIF	0
	JMS I	PUTP
	JMP	SLOOP$

ESEND$:	IAC			/Set sequence diff #.
	DCA	SDIFF

	TAD	ANSP$		/Shall we wait for answer?
	SZA CLA
	JMP	RLOOP$		/Yes. Jump to recieve code.
ACK$:	CLA			/Done. Reset sequence # diff to 0 (Normal).
	DCA	SDIFF
	TAD	(GPBUF+3)	/AC points at recieve buffer...
	JMP I	SPKT		/Return.

RLOOP$:	JMS	RPKT;SATAB$	/Yes. Recieve packet.
	JMP	NAK$		/Timeout error.
	JMP	SEQ$		/Sequence error.
	JMS	SERR;UNKPAK	/Unknown packet.

SEQ$:	TAD	REMPAR+SEQ	/Sequence error. Is sequence number same as
	CMA			/last but one?
	TAD	LOCPAR+SEQ
	SNA CLA
	JMP	NAK$		/Yes. Treat as NAK.
	JMS	SERR;SEQERR	/No. BIG ERROR!

NAK$:	ISZ	TRIES		/Here on NAK, timeout. Bump tries.
	JMP	SEND$		/Repeat send.
	JMS	SERR;TOMANY	/Error. Too many tries.

TYP$:	0			/Tmp save for type.
ANSP$:	0			/Flag for post-action.
LC$:	0			/Count of data.
CKPTR$:	0			/Pointer to chekcum address.

SATAB$:	.TABLE	SAEND$		/Table where to jump on different answers.
	ACK;ACK$		/On ACK, jump to ACK$
	NAK;NAK$		/NAK: jump to NAK$
SAEND$:
/
	.ENTRY	RESEND
RESEND:	0
	TAD	RESEND
	DCA	SPKT
	JMP	RSND$
/
	PAGE
	.SBTTL	Recieve packet.
/
/ Calling sequence:
/
/ JMS	RPKT
/ <addr>	/Pointer to table for types, and appropriate addresses.
/ <timeout return>
/ <sequence error>
/ <unknown type>
/
	.ENTRY	RPKT
RPKT,	0
	CLA
	TAD I	RPKT		/Get table address.
	ISZ	RPKT
	DCA	TABLE$

	TAD	REMPAR+TIME	/Setup timeout.
	SNA
	TAD	LOCPAR+TIME
	CIF	SETTMR
	JMS	SETTMR

L1$:	JMS	GETCHR		/Get character.
	JMP I	RPKT		/We have timeout!
	CIA			/Check if start of packet.
	TAD	LOCPAR+MARK
	SZA CLA
	JMP	L1$		/Was not. Repeat.

GMLOP$:	TAD	(GPBUF-1)	/So it was. Set up pointer.
	DCA	DSTP
	TAD	LOCPAR+MARK	/Save mark character.
	DCA I	DSTP
	TAD	(-96.)		/Set up max length.
	DCA	LC$
	TAD	REMPAR+TIME	/Reset time. We don't want a timeout
	SNA			/when the packet finally is coming.
	TAD	LOCPAR+TIME
	CIF	SETTMR
	JMS	SETTMR

GLOP$:	JMS	GETCHR		/Get a character.
	JMP I	RPKT		/Timeout!
	DCA	CHR$		/Save char.
	TAD	CHR$		/Check if a new start of packet.
	CIA
	TAD	LOCPAR+MARK
	SNA CLA
	JMP	GMLOP$		/It was. Previous was false alarm, I suppose.
	TAD	CHR$		/Was not. End of packet?
	CIA
	TAD	LOCPAR+EOL
	SNA CLA
	JMP	EGLOP$		/It was. GOTO next part.
	TAD	CHR$		/Was nothing special.
	DCA I	DSTP		/Save character.
	ISZ	LC$		/Bump count.
	JMP	GLOP$		/Repeat.
	JMP	L1$		/Ooops. Buffer filled up. False alarm, again.

EGLOP$:	TAD	DSTP		/Ok, we have packet. We point at checksum.
	DCA	CKPTR$		/Save checksum pointer.
	TAD I	CKPTR$		/Get checksum.
	JMS	UNCHAR
	DCA	CKSUM$
	DCA I	CKPTR$		/Clear checksum in buffer.
	JMS	CKSUM;GPBUF+1	/Calculate checksum of buffer.
	CIA			/Compare with recieved checksum.
	TAD	CKSUM$
	SZA CLA
	JMP	L1$		/Bad checksum. Assume this was no packet.

	ISZ	RPKT		/Ok, we cannot get any timeouts. Error is
				/now bad sequence.
	TAD	(GPBUF+1)	/Get pointer into buffert.
	DCA	SRCP		/Save it.
	TAD I	SRCP		/Get sequence number.
	JMS	UNCHAR
	DCA	REMPAR+SEQ	/Save it.
	TAD I	SRCP		/Get packet type.
	DCA	TYPE$

	TAD	LOCPAR+SEQ	/Compare our sequence number with recieved.
	CIA
	TAD	REMPAR+SEQ
	TAD	SDIFF		/SDIFF is 0 if recieving, and 1 if sending.
	AND	(77)
	SZA CLA			/AC=0 means sequence number was as expected.
	JMP I	RPKT		/Error! Bad sequence number.

	ISZ	RPKT		/Ok. Next error is bad type.
	TAD	TYPE$		/Get type.
	TAD	(-ERR)		/Check if error packet.
	SZA CLA
	JMP	L2$		/Was not.

	JMS	RERR;GPBUF+4	/It was. Give error msg.

L2$:	TAD	TYPE$		/Everything nice so far. Get type.
	.TRNSLT			/Try to understand it.
TABLE$:	0
	SKP CLA			/We didn't understand, skip next line.
	DCA	RPKT		/Save resulting handler address as return.
	TAD	(GPBUF+3)	/AC points at start of data - 1.
	JMP I	RPKT		/Return.

LC$:	0			/Loop counter.
CHR$:	0			/Saved character.
CKPTR$:	0			/Pointer to checksum.
CKSUM$:	0			/Checksum.
TYPE$:	0			/Packet type.
/
SDIFF,	0			/Sequence difference.
				/If we are recieving data, RPKT will recieve
				/packets with same sequence number.
				/When we are sending data, RPKT will get
				/ACK/NAK on just sent data, but our seq.
				/number will have bumped.
/
	PAGE
	.SBTTL	Subroutines for RPKT
/
GETCHR,	0
1$:	CIF	CHKTMR
	JMS	CHKTMR
	JMP I	GETCHR
	CIF	CLRCC
	JMS	CLRCC
	JMP	ABORT$
	CIF	0
	JMS I	GETP
	JMP	1$
	ISZ	GETCHR
	JMP I	GETCHR
/
ABORT$:	JMS	SERR;CCABO
/
	.SBTTL	CHAR, UNCHAR and CTL routines.
/
	.ENTRY	CHAR,UNCHAR,CTL
/
CHAR,	0
	TAD	(32.)
	JMP I	CHAR
/
UNCHAR,	0
	TAD	(-32.)
	JMP I	UNCHAR
/
CTL,	0
	TAD	(64.)
	AND	(127.)
	JMP I	CTL
/
	.SBTTL	Error routines.
/
RERR,	0
	CLA CLL CMA RAL		/Get pointer to string.
	TAD I	RERR		/Add a LF at head, and CR at end.
	DCA	SRCP
	TAD	(12)
	DCA I	SRCP
L$:	TAD I	SRCP
	SZA CLA
	JMP	L$
	CMA
	TAD	SRCP
	DCA	SRCP
	TAD	(15)
	DCA I	SRCP
	DCA I	SRCP
	TAD I	RERR
	.MSG			/Print string.
	JMP	RET		/Return to main.
/
	.ENTRY	SERR
SERR,	0
	CLA			/Get pointer to string.
	TAD I	SERR
	DCA	PKT$
	TAD	(ERR)		/Send string to remote.
	JMS	SPKT
PKT$:	0
	0
	CIF	FLUSH		/Flush TTY input.
	JMS	FLUSH
	.MSG	LF
	TAD	PKT$		/Output string on tty.
	.MSG
	.MSG	CR
	JMP	RET		/Return.
/
	.SBTTL	Checksum calculator.
/
CKSUM,	0
	CLA CMA			/Get address of buffer.
	TAD I	CKSUM
	ISZ	CKSUM		/Bump return.
	DCA	SRCP		/Save address pointer.
	DCA	CK$		/Clear checksum.
L$:	TAD I	SRCP		/Get char.
	SNA			/End of buffer?
	JMP	E$		/Yes.
	TAD	CK$		/No. Add checksum to char.
	DCA	CK$		/Save new checksum.
	JMP	L$		/Repeat.

E$:	TAD	CK$		/Get checksum.
	BSW			/High part.
	AND	(3)		/Mask away unwanted bits.
	TAD	CK$		/Add to checksum.
	AND	(77)		/Mask away unwanted bits.
	JMP I	CKSUM		/Return.

CK$:	0
/
	.DSECT	PDREG
	FIELD	PXREG
/
SPBUF,	ZBLOCK	100.
GPBUF,	ZBLOCK	100.
/
CCABO,	TEXT	"^C (Aborting...)"
SEQERR,	TEXT	"Sequence error. Aborting."
TOMANY,	TEXT	"Too many retries. Aborting."
UNKPAK,	TEXT	"Unknown packet. Aborting."
LF,	12;0
CR,	15;0
/
	.END
