	.TITLE	KERSET
	.VERSION 1
	.SBTTL	Header
/ ++
/
/	KERSET X1D
/
/	(c) 1990, 1991 by Johnny Billquist
/
/	Kermit for pdp8.
/	The SET and SHOW subfunction.
/
/	Id	Programmer
/	BQT	Johnny Billquist
/
/	Ver	Date		By	Comments
/	X1A	90/02/07 20:00	BQT	Copied from KERMIT.
/	X1B	91/05/08 05:25	BQT	Added autodetect for clock.
/	X1C	91/05/26 22:30	BQT	Added some more keywords to
/					SET PARAMETER function.
/	X1D	91/06/01 03:00	BQT	Added PARITY commands.
/
/ --
	.SBTTL	Setup
	.INCLUDE	SYS:COMMON
/
	.EXTERNAL	TGET,PUT,FLUSH
	.EXTERNAL	GETM,PUTM,FLUSHM
	.EXTERNAL	R1,R2,T1,T2,T3,T4,T5
	.EXTERNAL	PUTO2
	.EXTERNAL	CLKTYP
	.EXTERNAL	CLKON,CLKOFF
	.EXTERNAL	MAIN,ADDEXT,GETCMD,CHKEOL
	.EXTERNAL	KERVER,LOGFIL
/
/ .FP macro is NOT the same as .FILEPARSE
/ .FP calls FILEPARSE and FETCH...
/
	.MACRO	.GETCMD	CMDADR,LEN
	JMS	GETCMD
	CMDADR
	LEN
	.ENDM
	.SBTTL	Zero page

	.XSECT	XREG
X0,	0

	.ZSECT	ZSET
	FIELD	XREG
TMP,	0
/
	.GLOBAL	GETL,PUTL,FLUSHL,LOCAL
/
GETL,	GETM
PUTL,	PUTM
FLUSHL,	FLUSHM
LOCAL,	0		/Flag which tells if we a local or not.
/
NOFLG,	0
/
IDEV,	310
ODEV,	320
/
	.SBTTL	SET main code.
/
	.RSECT	RSET
	FIELD	XREG
/
	.ENTRY	SET
/
SET,	DCA	NOFLG		/Set command. Save no-flag.
	.GETCMD	CMDBUF,7	/Get command.
	TAD	CMDBUF		/Get 1:st char.
	SNA CLA			/Nothing in buffer?
	JMP	SETW$		/Nope. Read a new command.
	.PARSE	CMDBUF,SETTAB	/Why, yes... What do you want?
	JMP	SETE$		/Ugh! Garbage in, garbage out.
	DCA	TMP		/Well, okeydokey. Now we know too...
	JMS I	TMP		/So we'll go around and do it.
	JMP	MAIN		/New command, please.

SETE$:	.PRINT	UNKSET		/The UGH!
	JMP	MAIN		/Please behave better next time.

SETW$:	.PRINT	SETWHT		/What?
	JMP	MAIN
/
	.SBTTL	SET NO subfunction.
/
CSETNO,	0			/Set NO <something>.
	TAD	NOFLG		/Check if already NO.
	SZA
	JMP	SETNN$		/Already!
	CMA			/Set NO flag.
	JMP	SET		/Return.

SETNN$:	.PRINT	NONO		/Nono.
	JMP	MAIN
/
	.SBTTL	SHOW main code.
/
	.ENTRY	SHOW
/
SHOW,	.GETCMD	CMDBUF,7	/Get command.
	TAD	CMDBUF		/Check if buffer is empty.
	SNA CLA
	JMP	SHOWW$		/So it was. Get new command for me.
	.PARSE	CMDBUF,SHOTAB	/Well, you want something, lets see what. 
	JMP	SHOWE$		/Nah! Can't understand ya.
	DCA	TMP		/Okey, lets do it!
	JMS I	TMP
	JMP	MAIN		/Next.

SHOWE$:	.PRINT	UNKSHO		/UGH!
	JMP	MAIN		/Better up!

SHOWW$:	.PRINT	SHOWHT		/What?
	JMP	MAIN
/
	.SBTTL	SHOW ALL subfunction.
/
CSHOAL,	0			/Show all function.
	JMS	CHKEOL
	TAD	(SHOTAB+1)	/Get table of show functions.
	DCA	X0		/Save in index reg.
1$:	TAD I	X0		/Get pointer to cmd.
	SNA CLA			/End of table?
	JMP	MAIN		/Yes. Get new command.
	TAD I	X0		/No. Get pointer to routine.
	DCA	TMP		/Save pointer.
	JMS I	TMP		/Do routine.
	JMP	1$		/Repeat.
/
	.SBTTL	SHOW VERSION subfunction.
/
CSHOVE,	0			/Show version.
	JMS	CHKEOL
	.PRINT	KERVER		/Output version.
	JMP I	CSHOVE		/Return.
/
	PAGE
	.SBTTL	LOGFILE subfunction.
/
CSETLO,	0			/Set LOG...
	TAD	NOFLG		/Check NO flag.
	SZA CLA
	JMP	CNOLOG		/We had a NO! Set NO logfile.
	.GETCMD	LOGFIL,17	/Get filename.
	JMS	CHKEOL
	TAD	LOGFIL		/Check if file specified.
	SNA CLA
	JMP	NL$		/No logfile specified.
	JMS	ADDEXT;LOGFIL;LOGEXT
	JMP I	CSETLO		/Return.

NL$:	.PRINT	NOLOG		/No log file.
	JMP	MAIN

CNOLOG,	JMS	CHKEOL
	DCA	LOGFIL
	JMP I	CSETLO		/Return.
/
CSHOLO,	0			/Show log.
	JMS	CHKEOL
	TAD	LOGFIL		/Any logfile specified?
	SNA CLA
	JMP	NOLOG$		/No.
	.PRINT	LGF		/Yes. Tell so.
	.PRINT	LOGFIL		/Tell currently selected filename.
	.PRINT	LGF2		/End of tell.
	JMP I	CSHOLO		/Return.

NOLOG$:	.PRINT	NOLOG
	JMP I	CSHOLO
	.SBTTL	CLOCK subfunction
/
CSETCL,	0
	TAD	NOFLG
	SZA CLA
	JMP	1$
	.GETCMD	CMDBUF,7	/Get argument.
	TAD	CMDBUF		/Check for empty arg.
	SNA CLA
	JMP	NOCMD$		/It was.
	.PARSE	CMDBUF,CLKTAB	/Was not. Parse argument.
	JMP	CLKER$		/Bad argument.
1$:	DCA	TMP		/Good argument. Save clock type.
	JMS	CHKEOL		/Check for no more on line...
	CIF	CLKOFF		/Turn off old clock.
	JMS	CLKOFF
	TAD	TMP		/Get new clock type.
	SPA			/Check if negative.
	JMS	CLDET		/If so. Do an autodetect.
	CDF	CLKTYP		/Save new clock type.
	DCA I	(CLKTYP)
	CDF	.
	CIF	CLKON		/Turn new clock on.
	JMS	CLKON
	JMP I	CSETCL		/Return.

NOCMD$:	.PRINT	NOCLK
	JMP	MAIN

CLKER$:	.PRINT	BADCLK
	JMP	MAIN
/
CLDET,	0			/Clock autodetect function.
	CLA
	6133			/This is hopefully a skip on DK8-EC, and
	JMP	NOEC$		/not harmful on others.
	TAD	(DK8EC		/If it skipped, we found clock type.
	JMP I	CLDET
NOEC$:	6131			/This is hopefully a skip on DK8-EP.
	JMP	NOEP$
	TAD	(DK8EP		/It was a DK8-EP.
	JMP I	CLDET
NOEP$:	6137			/This is a skip on DKC8-AA...
	SKP
	TAD	(DKC8A
	JMP I	CLDET
/
	PAGE
/
CSHOCL,	0
	JMS	CHKEOL		/Check for no more.
	CDF	CLKTYP		/Get clock type.
	TAD I	(CLKTYP
	CDF	.
	.TRNSLT	CL2TAB		/Translate to appropriate string pointer.
	JMP	NOCLK$		/No match...
	DCA	TMP		/Save pointer.
	.PRINT	CLKT1		/Print part 1 of text.
	TAD	TMP
	.PRINT			/Print clock type.
	.PRINT	CLKT2		/Print part 2.
	JMP I	CSHOCL		/Return.

NOCLK$:	.PRINT	NOCLK		/Print no clock...
	JMP I	CSHOCL		/Return.
/
	PAGE
	.SBTTL	DEVICE subfunction.
/
CSETDE,	0			/Set device...
	.GETCMD	CMDBUF,7	/Get commnd.
	TAD	CMDBUF		/Check if anything specified.
	SNA CLA
	JMP	IN$		/Nothing. Illegal number error.
	.CVTOB	CMDBUF		/Convert octal to binary.
	AND	(77)		/Mask away high digits.
	CLL RTL;RAL		/Move into device field.
	DCA	IDEV		/Save as input device.
	.GETCMD	CMDBUF,7	/Get command.
	JMS	CHKEOL
	TAD	CMDBUF		/Check if anything.
	SNA CLA
	JMP	1$		/Nothing. Handle special.
	.CVTOB	CMDBUF		/Something. Convert to binary.
	AND	(77)		/Mask high.
	CLL RTL;RAL		/Move into device field.
	JMP	2$		/Continue.
1$:	TAD	IDEV		/Special. Get input device.
	TAD	(10)		/Bump.
	AND	(770)		/Mask.

2$:	DCA	ODEV		/Save as output device.
	TAD	IDEV		/Get input device.
	TAD	(-30)		/Check if console.
	SZA CLA
	JMP	3$		/Not.
	CLA CMA			/It is. Remove links to special device.
	DCA	LOCAL
	TAD	(FLUSH)
	DCA	FLUSHL
	TAD	(TGET)
	DCA	GETL
	TAD	(PUT)
	JMP	9$		/Continue.
3$:	CLA			/Not console. Add link to special device.
	DCA	LOCAL
	TAD	(FLUSHM)
	DCA	FLUSHL
	TAD	(GETM)
	DCA	GETL
	TAD	(PUTM)

9$:	DCA	PUTL
	JMS	DOSETD

	JMP I	CSETDE		/Return.

IN$:	.PRINT	TINUM
	JMP	MAIN
/
CSHODE,	0			/Show device routine.
	JMS	CHKEOL
	.PRINT	SHDV1		/Start print.
	TAD	IDEV		/Get input device.
	CLL RTR;RAR		/Move to low part.
	CIF	PUTO2		/Call output for 2 octal digits.
	JMS	PUTO2
	TAD	(",)		/Output comma.
	CIF	0
	JMS	PUT
	TAD	ODEV		/Get output device.
	CLL RTR;RAR		/Move to low part.
	CIF	PUTO2		/Output as 2 octal digits.
	JMS	PUTO2
	.PRINT	SHDV2		/End of print.
	JMP I	CSHODE		/Return.
/
	PAGE
/
DOSETD,	0
	CDF	R1
	TAD I	(R1		/Get first receive IOT.
	CDF	.
	TAD	(-KIE)		/Check if console.
	SNA CLA
	JMP	10$		/It was console. We do not disable INT.
	CDF	R1
	TAD	R1		/It was not console. Disable INT from this.
	CDF	.
	DCA	.+1
	HLT			/Done

10$:	TAD	(RCVTAB-1)	/Get pointer to table of receive IOTs.
	DCA	X0		/Save in index reg.
4$:	TAD I	X0		/Get ptr to IOT field.
	SPA			/End of table?
	JMP	5$		/Yes.
	TAD	(CDF
	DCA	C1$		/No. Save field change.
	TAD I	X0		/Get address.
	DCA	TMP		/Save as pointer.
C1$:	HLT			/Change field.
	TAD I	TMP		/Get IOT.
	AND	(7007)		/Mask away device.
	TAD	IDEV		/Get new device.
	DCA I	TMP		/Save IOT.
	CDF	.FLD		/Change field.
	JMP	4$		/Repeat.

5$:	CLA			/Get pointer to transmit IOT table.
	TAD	(SNDTAB-1)
	DCA	X0		/Save in index reg.
6$:	TAD I	X0		/Get pointer to IOT field.
	SPA			/End of table?
	JMP	7$		/Yes.
	TAD	(CDF
	DCA	C2$		/No. Save change field.
	TAD I	X0		/Get pointer.
	DCA	TMP		/Save pointer.
C2$:	HLT			/Change field.
	TAD I	TMP		/Get IOT.
	AND	(7007)		/Mask away old device.
	TAD	ODEV		/Get new device.
	DCA I	TMP		/Save IOT.
	CDF	.FLD		/Change field.
	JMP	6$		/Repeat.

7$:	CLA
	CDF	R1
	TAD	R1		/Get 1:st recevice.
	CDF	.
	DCA	.+2		/Save for execute.
	IAC			/Set AC for enable INT.
	HLT			/Do it.
	JMP I	DOSETD
/
	.SBTTL	ESCAPE subfunction.
/
	.EXTERNAL	ESC
/
CSHOES,	0			/Show ESCape...
	.PRINT	TESC1		/Print text part 1.
	TAD	ESC		/Get escape character.
	CIA			/Make into printable char.
	JMS	PCH
	.PRINT	TESC3		/Output text part 3.
	JMP I	CSHOES		/Return.
/
CSETES,	0			/Set escape..
	CLA			/Get NO flag.
	TAD	NOFLG
	SZA CLA			/NO ESCape?
	JMP	NOESC$		/Yup...
	.GETCMD	CMDBUF,7	/No. Get code for escape char.
	TAD	CMDBUF		/Get buffer.
	SNA CLA			/Anything?
	JMP	UNESC$		/Nope.
	JMS	CHKEOL		/Yes. Check for end of command.
	.CVTOB	CMDBUF		/All ok. Convert number to binary.
	AND	(77)		/Mask away high bits.
	CIA			/Get two's complement.
	DCA	ESC		/Save char.
	JMP I	CSETES		/Return.

NOESC$:	.PRINT	NOESC		/If NO ESC was commanded...
	JMP	MAIN

UNESC$:	.PRINT	UNESC		/If no ESC argument was given.
	JMP	MAIN
/
PUTC,	0			/Output a specified char.
	TAD I	PUTC		/Get char.
	ISZ	PUTC		/Bump return.
	CIF	PUT		/Output it.
	JMS	PUT
	JMP I	PUTC		/and return.
/
PUTC2,	0			/Output a digit.
	AND	(7)		/Mask away crap.
	TAD	(60)		/Asciify.
	CIF	PUT		/Output.
	JMS	PUT
	JMP I	PUTC2		/and return.
/
	PAGE
	.SBTTL	PARAMETER subfunctions.
/
	.EXTERNAL	LOCPAR,REMPAR,DEFPAR
/
CSHOPA,	0
	.GETCMD	CMDBUF,7	/Get next arg.
	TAD	CMDBUF
	SNA CLA
	JMP	1$		/If empty, we already know what we want.
	.PARSE	CMDBUF,SHOP1	/Parse it.
	JMP	ERR$		/Funny stuff.
	SKP			/Found out.

1$:	TAD	(PARTAB		/If unknown.
	DCA	TMP		/Save table pointer.
	JMS	CHKEOL		/Check for end of command.
	TAD I	TMP		/Get 1:st entry in table.
	ISZ	TMP		/Bump pointer.
	.PRINT			/Print what AC points at.
	TAD I	TMP		/Get 2:nd entry in table.
	DCA	TMP		/Save this pointer.
/
/Print texts and values.
/
	.PRINT	P1		/MAXL
	JMS	GETP
	JMS	PO3

	.PRINT	P2		/TIME
	JMS	GETP
	JMS	PO3

	.PRINT	P3		/NPAD
	JMS	GETP
	JMS	PO3

	.PRINT	P4		/PADC
	JMS	GETP
	JMS	PCH

	.PRINT	P5		/EOL
	JMS	GETP
	JMS	PCH

	.PRINT	P6		/QCTL
	JMS	GETP
	JMS	PCH

	.PRINT	P7		/QBIN
	JMS	GETP
	JMS	PCH

	.PRINT	P8		/CHKT
	JMS	GETP
	JMS	PUTC2

	.PRINT	P9		/REPT
	JMS	GETP
	JMS	PCH

	.PRINT	P10		/CAPAS
	JMS	GETP
	CIF	PUTO2
	JMS	PUTO2

	.PRINT	P11		/MARK
	JMS	GETP
	JMS	PCH

	.PRINT	PEND
	JMP I	CSHOPA

ERR$:	.PRINT	SHPARE
	JMP	MAIN
/
	PAGE
/
GETP,	0			/Get next argument.
	CDF	LOCPAR		/Change to correct field.
	TAD I	TMP		/Get arg.
	ISZ	TMP		/Bump pointer.
	CDF	.		/Change field back.
	JMP I	GETP		/Return.
/
PCH,	0			/Output a specific char.
	DCA	TMP$		/Save char.
	TAD	TMP$		/Get char.
	TAD	(-40)		/Check if control char.
	SMA
	JMP	1$		/Normal char.
	CLA
	JMS	PUTC;"C		/Control char...
	JMS	PUTC;"-
	TAD	TMP$		/Get back char.
	TAD	(40)
1$:	TAD	(40)		/Normalize char.
	CIF	PUT		/Output char.
	JMS	PUT
	JMS	PUTC;" 		/And output in octal.
	JMS	PUTC;"(
	TAD	TMP$
	JMS	PO3
	JMS	PUTC;")
	JMP I	PCH

TMP$:
/
PO3,	0			/Output 3 octal digits.
	DCA	TMP$		/Save number.
	TAD	TMP$		/Get digit #3.
	RTR;RTR;RTR
	JMS	PUTC2		/Output it.
	TAD	TMP$		/Get digit #2.
	RTR;RAR
	JMS	PUTC2		/Output it.
	TAD	TMP$		/Get digit #1.
	JMS	PUTC2		/Output it.
	JMP I	PO3		/Return.

TMP$:
/
CSETLP,	0			/Set parametes.
	JMS	SETPAR;LOCPAR
/
CSETDP,	0			/Set default parameters.
	JMS	SETPAR;DEFPAR
/
SETPAR,	0
	TAD	NOFLG		/Check for no NO flag.
	SZA CLA
	JMP	SETNOP		/There was one...
	.GETCMD	CMDBUF,7	/Get what he exactly wants...
	TAD	CMDBUF		/Anything specified?
	SNA CLA
	JMP	NOPAR		/Nothing!
SETP2,	.PARSE	CMDBUF,ARGTAB	/Get action.
	JMP	UNKPAR		/Unknown option.
	TAD I	SETPAR		/Add option # to start of table.
	DCA	SETPAR		/Save pointer into table.
	.GETCMD	CMDBUF,7	/Get value.
	JMS	CHKEOL		/Check for end of line.
	TAD	CMDBUF		/Check if anything specified.
	SNA
	JMP	NOPARG		/No value specified...
	TAD	(-60)
	SPA
	JMP	1$
	TAD	(-10
	SMA CLA
	JMP	1$
	.CVTOB	CMDBUF		/Convert value to binary.
	JMP	2$
1$:	CLA
	TAD	CMDBUF
2$:	CDF	DEFPAR
	DCA I	SETPAR		/Save value.
	CDF	.
	JMP	MAIN
/
SETNOP,	.PRINT	TSETNP
	JMP	MAIN
/
NOPAR,	.PRINT	TNOPAR
	JMP	MAIN
/
UNKPAR,	.PRINT	TUNKPA
	JMP	MAIN
/
NOPARG,	.PRINT	TNOARG
	JMP	MAIN
/
	PAGE
	.SBTTL	MODE sunfuctions
/
	.EXTERNAL	BINMOD
/
CSHOMO,	0
	JMS	CHKEOL		/ Check for end of line.
	.PRINT	M1		/Everythink is OK. Print 1:st text.
	CDF	BINMOD
	TAD I	(BINMOD)	/Get mode.
	CDF	.
	.TRNSLT	M2TAB		/Translate into text pointer.
	NOP			/This one should never occur.
	.PRINT			/Output mode text.
	.PRINT	M2		/Output 2:nd text.
	JMP I	CSHOMO		/Return.
/
CSETMO,	0
	.GETCMD	CMDBUF,7	/Get mode.
	TAD	CMDBUF		/Get 1:st char.
	SNA CLA			/Anything specified?
	JMP	NOMOD		/No.
	JMS	CHKEOL		/Yes. Check for end of line.
	.PARSE	CMDBUF,MODTAB	/All is ok. Parse argument.
	JMP	UNKMOD		/Bad argument.
	CLL RAR			/Good argument. Move it into link.
	TAD	NOFLG		/Get NO flag.
	SZA CLA			/Skip if not NO.
	CML			/Was NO. Complement function.
	RAL			/Get function.
	CDF	BINMOD		/Change to correct field.
	DCA I	(BINMOD)	/Save mode.
	CDF	.		/Restore field.
	JMP I	CSETMO		/Return.
/
NOMOD,	.PRINT	TNOMOD		/No argument was given.
	JMP	MAIN
/
UNKMOD,	.PRINT	TUNKMO		/Unknown argument was given.
	JMP	MAIN
/
	.SBTTL	Parity sunfuctions
/
	.EXTERNAL	PARITY,BINMSK
/
CSHOPR,	0
	JMS	CHKEOL		/ Check for end of line.
	.PRINT	TPAR		/Everythink is OK. Print 1:st text.
	CDF	PARITY
	TAD I	(PARITY)	/Get mode.
	CDF	.
	.TRNSLT	P2TAB		/Translate into text pointer.
	NOP			/This one should never occur.
	.PRINT			/Output mode text.
	.PRINT	M2		/Output 2:nd text.
	JMP I	CSHOPR		/Return.
/
CSETPR,	0
	.GETCMD	CMDBUF,7	/Get mode.
	TAD	CMDBUF		/Get 1:st char.
	SNA CLA			/Anything specified?
	JMP	NOPR		/No.
	JMS	CHKEOL		/Yes. Check for end of line.
	.PARSE	CMDBUF,PRTAB	/All is ok. Parse argument.
	JMP	UNKPR		/Bad argument.
	DCA	PAR$		/Good argument. Save it.
	TAD	NOFLG		/Check NO flag.
	SNA CLA
	TAD	PAR$		/No NO flag. Get argument.
	CDF	PARITY		/Save argument.
	DCA I	(PARITY)
	TAD I	(PARITY)	/Do we have no parity?
	SNA CLA
	TAD	(200)		/Yes. Use all bits as data.
	TAD	(177)		/No. Use 7 low bits only.
	DCA I	(BINMSK)	/Save binary mask.
	CDF	.
	JMP I	CSETPR		/Return.
PAR$:	0
/
NOPR,	.PRINT	TPARNO		/No argument was given.
	JMP	MAIN
/
UNKPR,	.PRINT	TPARUN		/Unknown argument was given.
	JMP	MAIN
/
	PAGE
	.SBTTL	Text data
/
	.DSEC                                                                                                                                                                  T	TXSET
	.RADIX	10

LGF,	TEXT	<10>'Your logfile is "'
LGF2,	TEXT	'".'<13>
NOLOG,	TEXT	<10>"No logfile specified."<13>

UNKSET,	TEXT	<10>"Unknown SET option."<13>
UNKSHO,	TEXT	<10>"Unknown SHOW opti                                                                                                                                                                                   on."<13>
SETWHT,	TEXT	<10>"SET what?"<13>
SHOWHT,	TEXT	<10>"SHOW what?"<13>
NONO,	TEXT	<10>"NONO - That's a contradiction!"<13>
NOCLK,	TEXT	<10>"No clock specified."<13>
BADCLK,	TEXT	<10>"Bad clock specified."<13>
CLKT1,	TEXT	<10>"Selected clock type is: "
CLKT2,	TEXT	"."<13>

TINUM,	TEXT	<10>"Illegal number."<13>
SHDV1,	TEXT	<10>"Your selected devices are ("
SHDV2,	TEXT	")."<13>

TESC1,	TEXT	<10>"Your escape character is "
TESC3,	TEXT	"."<13>

NOESC,	TEXT	<10>"You must have an escape character!"<13>
UNESC,	TEXT	<10>"You must give an escape character!"<13>

SHPARE,	TEXT	<10>"Unknown SHOW PARAMETERS argument."<13>
P1,	TEXT	<10>"MAX packet length: "
P2,	TEXT	"            Timeout: "
P3,	TEXT	<13><10>"# of padding chars: "
P4,	TEXT	"           Padding char: "
P5,	TEXT	<13><10>"End of line char: "
P6,	TEXT	<13><10>"Control quote char: "
P7,	TEXT	<13><10>"8-bit quote char: "
P8,	TEXT	<13><10>"Checksum type: "
P9,	TEXT	"                  Repeat character: "
P10,	TEXT	<13><10>"Capacity mask: "
P11,	TEXT	"                 Mark character: "
PEND,	TEXT	<13><10>
TSETNP,	TEXT	<10>"Sorry, but you can't negate this option."<13>
TNOPAR,	TEXT	<10>"You must specify which parameter you want to modify."<13>
TUNKPA,	TEXT	<10>"Unknown parameter."<13>
TNOARG,	TEXT	<10>"No arguemnt was given."<13>

M1,	TEXT	<10>"Transfer mode is "
M2,	TEXT	"."<13>
TNOMOD,	TEXT	<10>"What mode of transfer did you want???"<13>
TUNKMO,	TEXT	<10>"Can only do ASCII or BINARY mode."<13>
TPAR,	TEXT	<10>"Parity is "
TPARUN,	TEXT	<10>"Can't do that parity."<13>
TPARNO,	TEXT	<10>"You must specify which parity you want."<13>
/
	.SBTTL	Data
/
	.DSECT	DASET
	FIELD	XREG
	.RADIX	8

CMDBUF,	ZBLOCK	10		/Buffer to hold specific command.
/
SETTAB,	SETNO;CSETNO		/Set command table.
	SETLOG;CSETLO
	SETDEV;CSETDE
	SETCLK;CSETCL
	SETESC;CSETES
	SETLOC;CSETLP
	SETDEF;CSETDP
	SETMOD;CSETMO
	SETPR;CSETPR
	0

SHOTAB,	SHOALL;CSHOAL		/Show command table.
	SHOVER;CSHOVE
	SETCLK;CSHOCL
	SETDEV;CSHODE
	SETLOG;CSHOLO
	SETESC;CSHOES
	SHOPAR;CSHOPA
	SETMOD;CSHOMO
	SETPR;CSHOPR
	0

CLKTAB,	NONE;0
	TAUTO;-1
	TCLK\DK8EA;DK8EA
	TCLK\DK8EC;DK8EC
	TCLK\DK8EP;DK8EP
	TCLK\DKC8A;DKC8A
	0

SHOP1,	SLOC;PARTAB
	SREM;PARTAB+2
	SDEF;PARTAB+4
	0

	.EXTERNAL	MAXL,TIME,NPAD,PADC,EOL,QCTL,QBIN,CHKT,REPT,CAPAS

ARGTAB,	SMAXL;MAXL
	STIME;TIME
	SNPAD;NPAD
	SPADC;PADC
	SEOL;EOL
	SEOL2;EOL
	SQCTL;QCTL
	SQCTL2;QCTL
	SQBIN;QBIN
	SQBIN2;QBIN
	SCHKT;CHKT
	SREPT;REPT
	SCAPAS;CAPAS
	0

MODTAB,	MASCII;0
	MBINAR;1
	0
/
SNDTAB,	EDF	T1;T1		/Transmit IOT locations table.
	EDF	T2;T2
	EDF	T3;T3
	EDF	T4;T4
	EDF	T5;T5
	-1
RCVTAB,	EDF	R1;R1		/Receive IOT locations table.
	EDF	R2;R2
	-1

PARTAB,	TLOC;LOCPAR
	TREM;REMPAR
	TDEF;DEFPAR

CL2TAB,	.TABLE	CL2LEN
	0;NONE
	DK8EA;TCLK\DK8EA
	DK8EC;TCLK\DK8EC
	DK8EP;TCLK\DK8EP
	DKC8A;TCLK\DKC8A
CL2LEN=.

M2TAB,	.TABLE	M2LEN
	0;MASCII
	1;MBINAR
M2LEN=.

PRTAB,	PARNON;0
	PARMAR;200
	PARSPC;400
	0

P2TAB,	.TABLE	END$
	0;PARNON
	200;PARMAR
	400;PARSPC
END$:
/
SETNO,	TEXT	"NO"
SETLOG,	TEXT	"LOGfile"
SETDEV,	TEXT	"DEVice"
SETCLK,	TEXT	"CLock"
SETESC,	TEXT	"ESCape-character"
SETLOC,	TEXT	"LOCal"
SETDEF,	TEXT	"DEFault"
SETMOD,	TEXT	"MOde"
SETPR,	TEXT	"Parity"

SMAXL,	TEXT	"MAX-length"
STIME,	TEXT	"TImeout"
SNPAD,	TEXT	"NUMber-of-pad-characters"
SPADC,	TEXT	"PAD-character"
SEOL,	TEXT	"END-of-line-character"
SEOL2,	TEXT	"EOL"
SQCTL,	TEXT	"COntrol-quote-character"
SQCTL2,	TEXT	"CQuote"
SQBIN,	TEXT	"BINary-quote-character"
SQBIN2,	TEXT	"BQuote"
SCHKT,	TEXT	"CHeck-type"
SREPT,	TEXT	"REPeat-character"
SCAPAS,	TEXT	"CAPacity-mask"

NONE,		TEXT	"NONE"
TCLK\DK8EA,	TEXT	"DK8-EA"
TCLK\DK8EC,	TEXT	"DK8-EC"
TCLK\DK8EP,	TEXT	"DK8-EP"
TCLK\DKC8A,	TEXT	"DKC8-AA"
TAUTO,		TEXT	"AUTodetect"

MASCII,	TEXT	"Ascii"
MBINAR,	TEXT	"Binary"

PARNON,	TEXT	"None"
PARMAR,	TEXT	"Mark"
PARSPC,	TEXT	"Space"

SHOALL,	TEXT	"ALL"
SHOVER,	TEXT	"VERsion"
SHOPAR,	TEXT	"PARAmeters"

SLOC,	TEXT	"LOcal"
SREM,	TEXT	"REmote"
SDEF,	TEXT	"DEfault"

LOGEXT,	TEXT	".LOG"

	.RADIX	10
TLOC,	TEXT	<10>"Local parameters:"<13><10>
TREM,	TEXT	<10>"Remote parameters:"<13><10>
TDEF,	TEXT	<10>"Default parameters:"<13><10>
/
	.END
