	.TITLE	KERSND
	.VERSION 2
	.SBTTL	Header
/ ++
/
/	KERSND	X2A
/
/	(c) 1990, 1991 by Johnny Billquist
/
/	Kermit for pdp8.
/	The SEND/RECIEVE part.
/
/	Id	Programmer
/	BQT	Johnny Billquist
/
/	Ver	Date		By	Comments
/	X1A	90/02/09 12:30	BQT	Copied from KERMIT.
/	X1B	90/05/07 02:00	BQT	Moved code into field 3.
/	X1C	90/06/05 02:00	BQT	Started coding recieve functions.
/	X1D	90/07/17 03:00	BQT	First working version!
/	X1E	90/07/28 03:00	BQT	Added .FIXFIL on filenames.
/	X1F	91/03/14 02:35	BQT	Removed obsolete .RESET call.
/	X1G	91/05/09 00:20	BQT	Removed packet specific code.
/	X2A	91/05/09 01:15	BQT	Total rewrite of code.
/
/ --
	.SBTTL	Setup
	.INCLUDE	SYS:COMMON
/
	.ZTERNAL	GETL,PUTL,FLUSHL
	.EXTERNAL	SETTMR,CHKTMR
	.EXTERNAL	MAIN,GETCMD,CHKEOL,CLRCC
	.EXTERNAL	LOCAL
	.EXTERNAL	SPKT,RESEND,RPKT,SERR,CHAR,UNCHAR,CTL,MAXTRY
/
/ .FP macro is NOT the same as .FILEPARSE
/ .FP calls FILEPARSE and FETCH...
/
	.MACRO	.FP	DEVADR,FILNAM
	.IF BL	FILNAM	<
	DCA	.+3>
	JMS	FP
	DEVADR
	.IF NB	FILNAM	<FILNAM>
	.IF BL	FILNAM	<0>
	.ENDM

	.MACRO	.GETCMD	CMDBUF,LEN
	CIF	GETCMD
	JMS	GETCMD
	CMDBUF
	LEN
	.ENDM

	.MACRO	.CHKEOL
	CIF	CHKEOL
	JMS	CHKEOL
	.ENDM

	.MACRO	.MSG	ADDR
	.IF BL	ADDR	<DCA	.+3>
	JMS	$MSG
	.IF BL	ADDR	<
	.FLD
	0>
	.IF NB	ADDR	<
	EDF	ADDR
	ADDR>
	.ENDM

	.SBTTL	Zero page

	.XSECT	SXREG
	FIELD	3
SRCP,	0
DSTP,	0

	.ZSECT	SZREG
	FIELD	SXREG
/
LC,	0
TRIES,	0
CHR,	0
SDAT,	0
/
	.GLOBAL	Q8BIT,REPTC
Q8BIT,	0
REPTC,	0
/
	.GLOBAL	MODE
MODE,	0
/
	.GLOBAL	BINMOD
BINMOD,	0
/
	.GLOBAL	GETP,PUTP,FLUSHP
GETP,	0
PUTP,	0
FLUSHP,	0
/
CAPTIM=32.
CAPSER=16.
CAPATT=8.
/
	.GLOBAL	DEFPAR,LOCPAR,REMPAR
DEFPAR,
MAXL==.-DEFPAR
	80.
TIME==.-DEFPAR
	0
NPAD==.-DEFPAR
	0
PADC==.-DEFPAR
	0
EOL==.-DEFPAR
	^"M
QCTL==.-DEFPAR
	"#
QBIN==.-DEFPAR
	"N
CHKT==.-DEFPAR
	"1
REPT==.-DEFPAR
	" 
CAPAS==.-DEFPAR
	0
MARK==.-DEFPAR
	^"A
SEQ==.-DEFPAR
	0
	0
	0
	0
/
LOCPAR,	94.
	5.
	0
	0
	^"M
	"#
	"&
	"1
	" 
	CAPTIM+CAPATT	/32=Timeout, 16=Server, 8=File attributes
	^"A
	0
	0
	0
	0
	0
/
REMPAR,	ZBLOCK	16.
/
/
/ Packet types...
/
DATA="D
ACK="Y
NAK="N
SINIT="S
INIT="I
BREAK="B
FILE="F
EOF="Z
ERR="E
RINIT="R
CMD="C
GENE="G
TXT="X
ATTR="A
/
	.SBTTL	Entries for the SEND module.
/
	.FSECT	SRCODE
	FIELD	1
/
	.ENTRY	BYE
BYE,	JMS	SRINIT		/Init.
	CDF CIF	BYE2		/Jump to proper.
	JMP	BYE2
/
	.ENTRY	SEND
SEND,	JMS	SRINIT		/Init.
	CDF CIF	SEND2		/Jump to proper.
	JMP	SEND2
/
	.ENTRY	FGET
FGET,	JMS	SRINIT		/Init.
	CDF CIF	GET2		/Jump to proper.
	JMP	GET2
/
	.ENTRY	RECIEV
RECIEV,	JMS	SRINIT		/Init.
	CDF CIF	RECIE2		/Jump to proper.
	JMP	RECIE2
/
SRINIT,	0			/Init routine.
	CLA			/Set up links to I/O routines.
	TAD	GETL
	CDF	GETP
	DCA I	(GETP)
	CDF	.
	TAD	PUTL
	CDF	PUTP
	DCA I	(PUTP)
	CDF	.
	TAD	FLUSHL
	CDF	FLUSHP
	DCA I	(FLUSHP)
	CDF	.
	JMP I	SRINIT		/Return.
/
	.SBTTL	Common code.
/
	.RSECT	SRMAIN
	FIELD	SXREG
/
	.ENTRY	RET
RET,	NOP			/Return to main. The server will
	CDF CIF	MAIN		/catch this call later.
	JMP	MAIN		/Jump to main.
/
	.SBTTL	SEND file.
/
SEND2,	.GETCMD	SRCFIL,77	/Get source files.
	.GETCMD	DSTFIL,77	/Get destination files.
	.CHKEOL			/Check that end of line is reached.

	TAD	SRCFIL		/Check if null argument.
	SNA CLA
	JMP	NOFIL$		/So it was. Give error.

	TAD	(SRCFIL)	/Was not. Initiate pointer.
	DCA	SP$

	TAD	(DSTFIL)	/Also initiate destination file pointer.
	DCA	DP$

	JMS	SDEFDV		/Setup default device.

	JMS	SINI		/Initiate send.

SLOOP$:	TAD I	SP$		/Check filespec.
	SNA CLA			/No more files?
	JMP	S.END$		/Yup. We are done.
	TAD	SP$		/Get one filespec. to send.
	.GETSTR	,SOURCE,17,<",>
	DCA	SP$		/Save pointer to next file.
	TAD	DP$		/Get one destination file name.
	.GETSTR	,DEST,17,<",>
	DCA	DP$		/Save pointer to next file.
	JMS	SFIL		/Send file.
	JMP	SLOOP$		/Repeat.

S.END$:	TAD	(BREAK)		/End reached. Break connection.
	JMS	SPKT;EMPTY;-1	/Send break and wait for ack.
	JMP	RET		/We are done.
/
NOFIL$:	.PRINT	NOFIL		/No files specified. Tell him so.
	JMP	RET		/And return.
/
SP$:	0
DP$:	0
/
	.SBTTL	RECIEVE file.
/
RECIE2,	.GETCMD	DSTFIL,77	/Get filenames to place stuff in.
	.CHKEOL			/Check for physical eol.

	JMS	SDEFDV		/Setup default device.

	JMS	INIREM		/Initiate remote parameters.
	JMS	INIVAR

	JMS	RPKT;TAB$	/Get 1:st packet from remote.
	JMP	TIME$		/Timeout...
	JMP	SEQE$		/Sequence error.

	JMS	SERR;UNKPAK	/Unknown packet. Send error.

TIME$:	.PRINT	NOFILR		/Timeout. Say we got no file.
	JMP	RET		/And return.

SEQE$:	JMS	SERR;SEQERR	/Sequence error. Tell so.

TAB$:	.TABLE	TEND$		/Table of actions on his packet.
	SINIT;RFILES		/Get init, jump to RFILES.
TEND$:
/
	PAGE
	.SBTTL	BYE.
/
BYE2,	.CHKEOL			/Check if physical eol.

	JMS	INIREM		/Ok. Setup remotes parameters.
	JMS	INIVAR		/Mak our initialization.
	TAD	(GENE)		/We will send a generic message.
	JMS	SPKT;BYEMSG;1	/Send a bye message and wait for ack.
	.PRINT	BYEDON		/Tell user we did it!
	JMP	RET		/And return.
/
BYEMSG,	TEXT	"F"
/
	.SBTTL	GET files.
/
GET2,	.GETCMD	SRCFIL,77	/Get remote files to send.
	.GETCMD	DSTFIL,77	/Get local filenames to recieve to.
	.CHKEOL			/Check for physical eol.

	TAD	SRCFIL		/Check if no files was specified.
	SNA CLA
	JMP	NOFIL$		/No files. Error!

	JMS	SDEFDV		/Setup default local device.

	JMS	INIREM		/Init remote parameters.
	JMS	INIVAR

	TAD	(RINIT)		/Send a "Send Init" packet.
	JMS	SPKT;SRCFIL;0	/Along with what files we want.
	JMS	INIVAR

	JMS	GETPKT;TAB$	/Get answer packet.
	.PRINT	GFAIL		/No answer. Error!
	JMP	RET		/And return.

NOFIL$:	.PRINT	NOFIL		/No files specified.
	JMP	RET

TAB$:	.TABLE	TEND$
	SINIT;RFILES		/If we got init, start recieving files.
TEND$:
/
	PAGE
	.SBTTL	Init routines.
/
SINI,	0			/Send initiate.
	JMS	INIREM		/Start by init remote parameters.
	JMS	INIVAR
	JMS	MAKINI		/Make my init packet.
	TAD	(SINIT)		/Send it.
	JMS	SPKT;BUF;1	/and wait for answer.
	JMS	REMINI		/Setup remotes real parameters.
	JMP I	SINI		/Return.
/
INIREM,	0			/Init remote to default parameters.
	CLA
	TAD	(DEFPAR-1)	/Copy defpar block...
	DCA	SRCP
	TAD	(REMPAR-1)	/to rempar.
	DCA	DSTP
	TAD	(-20)
	DCA	LC
1$:	TAD I	SRCP
	DCA I	DSTP
	ISZ	LC
	JMP	1$
	CIF	0		/Clear remote input buffer.
	JMS I	FLUSHP
	JMP I	INIREM		/And return.
/
INIVAR,	0			/Init general variables.
	CLA
	DCA	LOCPAR+SEQ	/Clear sequence number.
	JMP I	INIVAR
/
MAKINI,	0			/Make my init packet.
	TAD	(BUF-1)		/Setup pointer.
	DCA	DSTP
	TAD	LOCPAR+MAXL	/Put in all info in packet.
	JMS	CHAR
	DCA I	DSTP
	TAD	LOCPAR+TIME
	JMS	CHAR
	DCA I	DSTP
	TAD	LOCPAR+NPAD
	JMS	CHAR
	DCA I	DSTP
	TAD	LOCPAR+PADC
	JMS	CTL
	DCA I	DSTP
	TAD	LOCPAR+EOL
	JMS	CHAR
	DCA I	DSTP
	TAD	LOCPAR+QCTL
	DCA I	DSTP
	TAD	REMPAR+QBIN
	TAD	(-"N)		/8:th bit prefixing depends on what remote
	SNA			/wants...
	JMP	NO$
	TAD	("N-"Y)
	SNA
	JMP	YES$
	JMP	Q$
NO$:	TAD	("N)
	JMP	Q$
YES$:	TAD	LOCPAR+QBIN
Q$:	DCA I	DSTP
	TAD	LOCPAR+CHKT
	DCA I	DSTP
	TAD	LOCPAR+REPT
	DCA I	DSTP
	TAD	LOCPAR+CAPAS
	JMS	CHAR
	DCA I	DSTP
	DCA I	DSTP
	JMP I	MAKINI		/Return.
/
	PAGE
/
REMINI,	0			/Setup remotes parameters for real.
	DCA	SRCP
	JMS	GC$
	JMS	UNCHAR
	SZA
	DCA	REMPAR+MAXL
	JMS	GC$
	JMS	UNCHAR
	SZA
	DCA	REMPAR+TIME
	JMS	GC$
	JMS	UNCHAR
	SZA
	DCA	REMPAR+NPAD
	JMS	GC$
	JMS	CTL
	DCA	REMPAR+PADC
	JMS	GC$
	JMS	UNCHAR
	SZA
	DCA	REMPAR+EOL
	JMS	GC$
	JMS	SPACE$
	DCA	REMPAR+QCTL
	JMS	GC$
	JMS	SPACE$
	DCA	REMPAR+QBIN
	JMS	GC$
	JMS	SPACE$
	DCA	REMPAR+CHKT
	JMS	GC$
	JMS	SPACE$
	DCA	REMPAR+REPT
	JMS	GC$
	JMS	UNCHAR
	SZA
	DCA	REMPAR+CAPAS

EREM$:	TAD	REMPAR+QBIN	/Now find oput what the 8-bit quote is.
	TAD	(-"N)		/Did remote say no?
	SNA CLA
	JMP	NO$		/Yes. Use no 8-bit prefix.
	TAD	LOCPAR+QBIN	/Did we say no?
	TAD	(-"N)
	SNA
	JMP	NO$		/Yes. Use no 8-bit prefix.
	TAD	("N-"Y)		/Did we say yes?
	SZA CLA
	JMP	REMQ$		/Yes. Use remote request.
	TAD	LOCPAR+QBIN	/No. Use our.
	JMP	GQ$
REMQ$:	TAD	REMPAR+QBIN	/Get remote request.
	TAD	(-"Y)		/Did he also say yes?
	SNA
	JMP	NO$		/Yes. We cannot decide what. Use none.
	TAD	("Y)		/Use remote.
	JMP	GQ$
NO$:
GQ$:	DCA	Q8BIT
	JMP I	REMINI		/And return.
/
GC$:	0
	CLA
	TAD I	SRCP		/Get a parameter.
	SNA			/End of buffer?
	JMP	EREM$		/Yes. End remote setup.
	JMP I	GC$		/No. Return.
/
SPACE$:	0
	TAD	(-" )		/Check if char is space...
	SZA
	ISZ	SPACE$		/No. Bump return.
	TAD	(" )		/Restore char.
	JMP I	SPACE$		/Return.
/
SDEFDV,	0			/Set default device.
	CLA
	TAD	DSK		/Copy from DSK to DEV.
	DCA	DEV
	TAD	DSK+1
	DCA	DEV+1
	JMP I	SDEFDV		/And return.
/
	PAGE
	.SBTTL	Send file subroutines.
/
SFIL,	0
	TAD	SOURCE		/Check if sourc is NUL.
	SNA CLA
	JMP	NOFIL$		/So they are. End...

	.FP	DEVH+1,SOURCE	/Setup next file.
	DCA	FIB+DEVNUM	/Save info into FIB.
	TAD I	SRCP
	DCA	FIB+DEVADR

	DCA	FCNT$		/Clear filecounter.
LOOP$:	ISZ	FCNT$		/Bump filecounter.
	TAD	FCNT$		/Get filecounter.
	.LOOKUP	FIB,FIL,OPERR$	/Open next file.
	JMS	SFIL2		/Send this file.
	JMP	LOOP$		/And repeat.

NOFIL$:	.MSG	NOFIL		/He must have given an empty filename...
	JMP I	SFIL		/Return.

OPERR$:	SPA CLA			/Error opening file.
	JMP	FATAL$		/Error was fatal.
	CMA CLL RAL		/Not fatal.
	TAD	FCNT$		/Check if it was the first file.
	SNA CLA
	JMP I	SFIL		/Was not. Everything is ok.
	.MSG	FNF		/First file not found.
	JMP I	SFIL		/Return.

FATAL$:	JMS	SERR;OPFAT	/Fatal error. Abort.
/
FCNT$:	0
/
	PAGE
/
SFIL2,	0
	JMS	UNPACK		/Unpack filename.
	TAD	DEST		/Check if a destination file was given.
	SNA CLA
	JMP	USEMY$		/Was not. Use my own.
	TAD	(DEST)		/It was. Use that name instead.
	JMP	L1$
USEMY$:	TAD	(BUF)		/My file...
L1$:	DCA	L2$		/Save pointer to filename.
	TAD	(FILE)
	JMS	SPKT		/Send packet
L2$:	0
	1			/And wait for answer.

	.MSG	TSFIL1		/Tell what we are doing.
	.MSG	BUF		/(that is sending file <file>).

	TAD	REMPAR+CAPAS	/Check if he can take attributes...
	AND	(CAPATT)
	SNA CLA
	JMP	SDATA$		/Ha cannot.

	TAD	FIB+FILDAT	/Hey! He can! Lets give him a date.
	.BDATD	BUF+2
	CLA
	DCA	BUF+8.
	.MSG	FDAT		/Also tell user the date.
	TAD	(BUF+2)
	.MSG
	TAD	("#)		/Make a complete packet of it.
	DCA	BUF
	TAD	(46)
	DCA	BUF+1
	TAD	(ATTR)		/It's an attribute packet.
	JMS	SPKT;BUF;1	/Send it and wait for answer.
	CLA

SDATA$:	.MSG	TSFIL2		/Time to send data. Finish info line...
	TAD	(BUF-1)		/Where to place data to send.
	DCA	DSTP
	TAD	REMPAR+MAXL	/Get max length.
	CIA
	DCA	LC		/Save as counter.
	JMP	LOOP

IR,	JMP I	SFIL2

	PAGE

LOOP,	.ICHAR	FIB,IERR$	/Get one char from file.
	DCA	CHR		/Save character.
	TAD	BINMOD		/Are we in binary?
	SZA CLA
	JMP	L3$		/Yes. Don't touch data.
	TAD	CHR		/No. Clear high bit.
	AND	(177)
	DCA	CHR
	TAD	CHR
	TAD	(-32)		/Check if eof...
	SNA CLA
	JMP	EOF$		/It was. Abort.
L3$:	TAD	CHR		/Get character.
	JMS	BINCHK		/Check what, if any prefixing to do.
	JMP	NRML		/No prfix.
	JMP	CTRL		/Control prefix.
	JMP	QBIT		/8-bit prefix.
	JMP	QCBIT		/8-bit control prefix.

EOF$:	TAD	LC		/Check if anything in buffer...
	TAD	REMPAR+MAXL
	SNA CLA
	JMP	EOF2$		/Nothing.
	DCA I	DSTP		/Something. Set end of buffer.
	TAD	(DATA)		/Send data.
	JMS	SPKT;BUF;1
EOF2$:	CLA
	TAD	(EOF)		/When EOF is reached, send eof packet.
	JMS	SPKT;EMPTY;1	/and wait for answer.
	.CLOSE	FIB,CERR$	/Close input file.
	CLA
	JMP	IR		/The return.

IERR$:	SMA CLA			/If we have error on input, check if
	JMP	EOF$		/serious. If not, assume eof.
	JMS	SERR;SFILE	/Serious. Tell so.

CERR$:	JMS	SERR;CLIERR
/
	PAGE
/
QCBIT,	JMS	FILL$;3		/8-bit control quote... Needs 3 chars.
	TAD	Q8BIT		/Get prefix char.
	DCA I	DSTP		/Output it.
	TAD	CHR		/Get char.
	AND	(177)		/Mask high bit.
	DCA	CHR		/Save char.
	JMP	LC$		/Go on in control prefix code.

QBIT:	JMS	FILL$;2		/8-bit prefix needs 2 chars.
	TAD	Q8BIT		/Get prefix char.
	DCA I	DSTP		/Output it.
	TAD	CHR		/Get char.
	AND	(177)		/Mask high bit.
	DCA I	DSTP		/Output it.
	JMP	LOOP		/Next char.

CTRL:	JMS	FILL$;2		/Control char need 2 chars.
LC$:	TAD	REMPAR+QCTL	/Get prefix char.
	DCA I	DSTP		/Output it.
	TAD	CHR		/Get char.
	TAD	(-40)		/Make printable if control...
	SPA
	TAD	(100)
	TAD	(40)
	DCA I	DSTP		/Save character.
	JMP	LOOP		/Next char.

NRML:	JMS	FILL$;1		/Normal char. Needs 1 char.
	TAD	CHR		/Get char.
	DCA I	DSTP		/Output it.
	JMP	LOOP		/Next char.

FILL$:	0			/FILL$ checks for available space, and
	TAD I	FILL$		/makes space if none is available.
	TAD	LC		/Bump LC by # of chars.
	DCA	LC		/Save LC.
	TAD	LC		/Check if it became positive = Overflow.
	SMA SZA CLA
	JMP	LF$
	ISZ	FILL$		/No overflow. Bump return and return.
	JMP I	FILL$
LF$:	DCA I	DSTP		/Overflow. Set end mark.
	TAD	(DATA)		/This is a data packet.
	JMS	SPKT;BUF;1	/Send packet. Wait for answer.
	CLA
	TAD	(BUF-1)		/Reset pointer and counter.
	DCA	DSTP
	TAD	REMPAR+MAXL
	CIA
	DCA	LC
	JMP	FILL$+1		/And make space.
/
BINCHK,	0			/Check what kind of prefix to use.
	DCA	C$		/Save character.
	TAD	C$		/Get char.
	TAD	(-200)		/Check if high bit is set.
	SPA CLA
	JMP	NRML$		/High bit not set, normal char.
	TAD	Q8BIT		/High bit set. Get prefix char.
	SNA CLA			/No prefix char?
	JMP	NRML$		/Nope. We must use normal.
	ISZ	BINCHK		/8-bit. Bump return two steps.
	ISZ	BINCHK
NRML$:	TAD	C$		/Get char.
	AND	(177)		/Mask away high bit.
	JMS	CHK2		/Check if control or special char.
	ISZ	BINCHK		/It was. Bump return.
	JMP I	BINCHK		/Return.
/
C$:	0
/
CHK2,	0			/Check if control char, or special char.
	CIA			/Save -char.
	DCA	C$
	TAD	C$
	TAD	(40)		/Compare with space.
	SMA SZA CLA
	JMP I	CHK2		/It was a control char.
	TAD	C$		/Was not.
	TAD	Q8BIT		/Was it 8-bit quote?
	SNA CLA
	JMP I	CHK2		/Yup.
	TAD	C$
	TAD	REMPAR+QCTL	/control prefix?
	SNA CLA
	JMP I	CHK2		/Yup.
	TAD	C$
	TAD	REPTC		/Repeat character?
	SNA CLA
	JMP I	CHK2		/Yup.
	ISZ	CHK2		/Nothing special. Bump return.
	JMP I	CHK2		/And return.
/
C$:	0
/
	PAGE
	.SBTTL	Recieve motor.
/
RFILES,	JMS	REMINI		/Setup remote parameters.
	JMS	MAKINI		/Make my parameters.
	TAD	(ACK)		/Send my parameters.
	JMS	SPKT;BUF;0
	CLA
	TAD	(DSTFIL)	/Setup destination filepointer.
	DCA	DP$
	JMS	GETPKT;GINI$	/Get next packet.
	JMS	SERR;EGFH	/Error!

GINI$:	.TABLE	END$		/Table of actions on second packet.
	FILE;RFIL
END$:

RFIL:	IAC			/Recieve filename packet.
	DCA	GF$		/Save pointer to filename.
	TAD	DP$		/Get local filename.
	.GETSTR	,DEST,17,<",>
	DCA	DP$

	TAD	DEST		/Check if any local file was specified.
	SZA CLA
	JMP	USEMY$		/Yes. Local filename was specified.
	TAD	GF$		/Nope. Use remote filename.
	SKP			/Skip next.
USEMY$:	TAD	(DEST)		/Use local filename.
	DCA	GF$		/Save pointer to filename.
	.MSG	TRFIL1		/Tell some stuff.
	TAD	GF$		/Tell filename.
	.MSG
	TAD	GF$		/Get filename pointer.
	.FP	DEVH+1		/Parse filename.
	DCA	FIB+DEVNUM	/Save FIB info.
	TAD I	SRCP
	DCA	FIB+DEVADR

	CDF	10		/Save OS8 DATEWD
	TAD I	(7666)
	CDF	.
	DCA	SDAT

NXTA:	TAD	(ACK)		/Ack last packet.
	JMS	SPKT;EMPTY;0

	JMS	GETPKT;TAB$	/Get next packet.
	JMS	SERR;RCVERR	/Error!

GF$:	0
DP$:	0
/
TAB$:	.TABLE	TEND$		/Actions on next packet.
	ATTR;FATTR		/Attribute packet.
	DATA;FDATA1		/Data packet.
	EOF;FEOF		/EOF packet.
TEND$:
/
	PAGE
/
FATTR,	DCA	SRCP		/Attribute packet.
	TAD I	SRCP		/Get 1:st char.
	TAD	(-"#)		/We only understand date packet.
	SZA CLA
	JMP	NXTA		/Not date. Get next packet.
	ISZ	SRCP		/Was date. Skip length.
	JMS	GD2$		/Get year.
	TAD	(-70.)
	SMA
	JMP	L1$
	JMS	GD2$		/Year was 4 digits, get next two.
	TAD	(-70.)
L1$:	AND	(7)		/Mask year.
	DCA	YR$		/Save year.
	JMS	GD2$		/Get month.
	DCA	MN$
	JMS	GD2$		/And date.
	DCA	DA$
	TAD	MN$		/Get month.
	CLL RTL;RTL;RAL		/Move up to get space for date.
	TAD	DA$		/Add date.
	CLL RTL;RAL		/move up to get space for year.
	TAD	YR$		/Add year.
	CDF	10
	DCA I	(7666)		/Set date.
	CDF	.
	.MSG	FDAT		/Tell some info.
	TAD	SRCP		/Get pointer to start of date text.
	TAD	(-6)
	.MSG			/Print date.
	JMS	NXTA
/
YR$:	0
MN$:	0
DA$:	0
/
GD2$:	0			/Get two digits.
	TAD I	SRCP		/Get first digit.
	TAD	(-60)		/Make into binary.
	CLL RAL			/*2
	DCA	DA$		/Save temporary.
	TAD	DA$		/Get it again.
	RTL			/*4 (total *8)
	TAD	DA$		/Add the *2 item, giving *10.
	TAD I	SRCP		/Add low digit.
	TAD	(-60)		/Make binary of low digit.
	JMP I	GD2$		/Return.
/
	PAGE
/
FDATA1,	DCA	SRCP		/Save pointer to data.
	.MSG	TRFIL2		/Print end of info.
	.OOPEN	FIB,FIL,OPERR$	/Create file.
	CLA
	TAD	SDAT		/Restore date.
	CDF	10
	DCA I	(7666)
	CDF	.
	SKP			/Skip next line.
FDATA:	DCA	SRCP		/Save pointer to data.
LOOP$:	JMS	GC$		/Get char.
	SNA			/End of buffer?
	JMP	EOD$		/Yup.
	DCA	CHR		/Save character.
	TAD	BINMOD		/Are we in binary mode?
	SZA CLA
	JMP	L$		/Yes.
	TAD	CHR		/No. Set high bit.
	AND	(177)
	TAD	(200)
	SKP
L$:	TAD	CHR
	.OCHAR	FIB,OUERR$	/Save character.
	CLA
	JMP	LOOP$		/Repeat.

/
GC$:	0			/Get one character.
	CLA
	TAD I	SRCP
	SNA			/NUL needs no special treatment. It is eod.
	JMP I	GC$
	DCA	CHR		/Save character.
	TAD	CHR		/Check if control quote...
	CIA
	TAD	REMPAR+QCTL
	SNA CLA
	JMP	CTL$		/It was.
	TAD	CHR		/Check if 8-bit quote.
	CIA
	TAD	Q8BIT
	SNA CLA
	JMP	Q8$		/It was.
	TAD	CHR		/Nothing. Normal character.
	JMP I	GC$		/Return.

CTL$:	TAD I	SRCP		/Control quote. Get next char.
	DCA	CHR		/Save char.
	TAD	CHR		/Check if alphanumeric...
	AND	(177)
	TAD	(-100)
	SPA CLA
	JMP	L1$		/Was not.
	TAD	CHR		/It was. Make into control char.
	TAD	(-100)
	SKP			/And skip next word.
L1$:	TAD	CHR		/Special character...
	JMP I	GC$		/Done. Return.

Q8$:	TAD I	SRCP		/8-bit quote... Get next char.
	AND	(177)		/Mask away possible high bit.
	DCA	CHR		/Save char.
	TAD	CHR		/Check if control quote...
	CIA
	TAD	REMPAR+QCTL
	SZA CLA
	JMP	L2$		/Was not.
	TAD I	SRCP		/So it was. Get next char.
	AND	(177)		/Mask away high bit.
	TAD	(-100)		/Make into proper character...
	SPA
	TAD	(100)
	SKP			/And skip next word.
L2$:	TAD	CHR		/Normal 8-bit char.
	TAD	(200)		/Set high bit.
	JMP I	GC$		/And return.
/
EOD$:	TAD	(ACK)		/End of data... Send ack for packet.
	JMS	SPKT;EMPTY;0
	JMS	GETPKT;TAB$	/Get new packet.
	JMS	SERR;RCVERR	/Error!
/
OPERR$:	JMS	SERR;OOPERR	/Error opening file.
OUERR$:	JMS	SERR;OUTERR	/Error while writing to file.
/
TAB$:	.TABLE	ETAB$		/Actions on new packet.
	DATA;FDATA		/Data.
	EOF;FEOF		/Eof.
ETAB$:
/
	PAGE
/
FEOF,	CLA			/EOF... Are we recieving binary files?
	TAD	BINMOD
	SZA CLA
	JMP	L1$		/Yes.
	TAD	(232)		/No. Output ^Z to file...
	.OCHAR	FIB,OUERR$
L1$:	.CLOSE	FIB,OCERR$	/Close file.
	CLA
	TAD	(ACK)		/Ack packet.
	JMS	SPKT;EMPTY;0
	JMS	GETPKT;TAB$	/Get next packet.
	JMS	SERR;REOT	/Error!
/
OUERR$:	JMS	SERR;OUTERR	/Error while writing to file.
OCERR$:	JMS	SERR;CLOERR	/Error on close.
/
TAB$:	.TABLE	ETAB$		/Actions on packet recieved.
	FILE;RFIL		/New file...
	BREAK;REND$		/EOT.
ETAB$:
/
REND$:	CLA			/End of reception. Send ack.
	TAD	(ACK)
	JMS	SPKT;EMPTY;0
	JMP	RET
/
	.SBTTL	Subroutine to get packet.
/
GETPKT,	0			/Get packet.
	CLA
	TAD I	GETPKT		/Get address of table.
	ISZ	GETPKT		/Bump return.
	DCA	TAB$		/Save table address.

	TAD	MAXTRY		/Get max tries.
	CIA			/Save as try counter.
	DCA	TRIES

	SKP			/Skip resend first time.
LOOP$:	JMS	RESEND		/Resend our packet.
	JMS	RPKT		/Recieve packet.
TAB$:	0			/Table address.
	JMP	TIME$		/Timeout...
	JMP	SEQ$		/Sequence error.
	.PRINT	TYPERR
	JMP I	GETPKT		/Type error. Return.

SEQ$:	TAD	LOCPAR+SEQ	/Sequence error. Was sequence number same
	CIA			/as last but one?
	TAD	REMPAR+SEQ
	IAC
	AND	(77)
	SNA CLA
	JMP	TIM2$
	.PRINT	SEQ2RR
	JMP I	GETPKT		/No. BAD error!
				/Yes. Act as if timeout.
TIM2$:	.PRINT	SEQ2RR
TIME$:	ISZ	TRIES		/Timeout. Bump tries.
	JMP	LOOP$		/And repeat.
	.PRINT	TIMERR
	JMP I	GETPKT		/Max try exceeded. Abort.
/
	PAGE
	.SBTTL	Subroutines for filename handling.
/
UNPACK,	0			/Unpack filename from sixbit.
	CLA
	TAD	(FIB+FILNAM-1)	/Get pointer to filename.
	DCA	SRCP		/Save it.
	TAD	(BUF-1)		/Get destination pointer.
	DCA	DSTP		/Save it.
	TAD	(-4)		/Loop c ounter.
	DCA	LC
LOO                                                                                                                                                                                                                                                                                                                                                                           P$:	CLA
	TAD I	SRCP		/Get character
	DCA	CHR		/Save it.
	TAD	CHR		/Get it.
	BSW			/Get high part.
	JMS	STORE$		/Save it.
	TAD	CHR		/Get char.
	JMS	STORE$		/Save low part.
	CLA CLL IAC RAL		/Check if we have looped three times.
	TAD	LC
	SZA CLA
	JMP	L1$		/We have not...
	TAD	(".)		/We have. Add a period to result.
	DCA I	DSTP
L1$:	ISZ	LC		/Bump counter.
	JMP	LOOP$		/Repeat.
	DCA I	DSTP		/Set end mark.
	JMP I	UNPACK		/Return.
/
STORE$:	0			/Save sizbit char.
	AND	(77)		/Mask.
	SNA			/NUL?
	JMP I	STORE$		/Yes. Return.
	TAD	(-40)		/Make into prinatble...
	SNA			/Space?
	JMP I	STORE$		/Yes. Return.
	SPA			/Alphanumeric?
	TAD	(100)		/Yes.
	TAD	(40)		/Restore char.
	DCA I	DSTP		/Save it.
	JMP I	STORE$		/Return.
/
	PAGE
	.SBTTL	FILE PARSER
/
FP,	0
	CLA
	TAD I	FP		/Get device address.
	ISZ	FP
	DCA	DA$
	TAD I	FP		/Get filename pointer.
	ISZ	FP
	.FPARSE	,DEV		/Parse filename into DEV.
	.FIXFIL	FIL		/Replace * with ??
	CALUSR	13		/Reset.
	.FETCH	DEV,DA$,FERR$	/Fetch device driver.
	DCA	SRCP		/Save pointer to result.
	TAD I	SRCP		/Get result.
	JMP I	FP		/Return.
/
DA$:	0
/
FERR$:	JMS	SERR;TFERR
/
	.SBTTL	Message printer.
/
	.ENTRY	$MSG
$MSG,	0
	CLA
	TAD I	$MSG
	ISZ	$MSG
	DCA	SF$
	TAD I	$MSG
	ISZ	$MSG
	DCA	SA$
	CDF	LOCAL
	TAD	LOCAL
	CDF	.
	SZA CLA
	JMP I	$MSG
	CIF	$PRINT
	JMS	$PRINT
SA$:	0
SF$:	0
	JMP I	$MSG
/
	.SBTTL	DATA
	.DSECT	SRDATA
	FIELD	SXREG

SRCFIL,	ZBLOCK	100
DSTFIL,	ZBLOCK	100
SOURCE,	ZBLOCK	20
DEST,	ZBLOCK	20
BUF,	ZBLOCK	100.

DSK,	DEVICE	DSK
DEV,	DEVICE	XXXX
FIL,	FILENA	XXXXXX.XX

FIB,	.FIB

EMPTY,	TEXT	""
UNKPAK,	TEXT	"Unknown packet recieved. Aborting."
SEQERR,	TEXT	"Bad sequence number recieved. Aborting."
OPFAT,	TEXT	"Fatal error when opening file. Aborting."
SFILE,	TEXT	"Fatal error sending file. Aborting."
TFERR,	TEXT	"Error fetching device driver. Aborting."
EGFH,	TEXT	"Error recieving file header. Aborting."
TYPERR,	TEXT	<12>"Type error!"<15>
SEQ2RR,	TEXT	<12>"Sequence error!"<15>
TIMERR,	TEXT	<12>"Timeout error!"<15>
RCVERR,	TEXT	"Error recieving packet. Aborting."
OOPERR,	TEXT	"Error opening output file. Aborting."
OUTERR,	TEXT	"Error writing to output file. Aborting."
CLOERR,	TEXT	"Error closing output file. Aborting."
CLIERR,	TEXT	"Error closing input file. Aborting."
REOT,	TEXT	"Error while at end of transmission."
/
	.SBTTL	TEXT
	.DSECT	SRTEXT
/
BYEDON,	TEXT	<12>"Remote server succefully shut down."<15>
NOFIL,	TEXT	<12>"No file specified."<15>
NOFILR,	TEXT	<12>"No file was recieved."<15>
FNF,	TEXT	<12>"File not found."<15>
TSFIL1,	TEXT	<12>"Sending file "
FDAT,	TEXT	" created "
TRFIL2,
TSFIL2,	TEXT	"."<15>
TRFIL1,	TEXT	<12>"Recieving file "
GFAIL,	TEXT	<12>"GET failed."<15>
/
	.RSECT	HANDL
	FIELD	0
DEVH,	ZBLOCK	400
/
	.END
 