/*
 *	PDP-8 register definitions for PDP-8 emulator.
 *
 *	Author:
 *		Bill Haygood
 *		41832 Ernest Road
 *		Loon Lake, WA 99148-9607
 *		Internet: billh@comtch.iea.com
 *		Voice/AnsMach/FAX \
 *			or	   509-233-2555
 *		  Cellular/Pager  /
 *
 *	Copyright 1992, 1993 by the author with all rights reserved.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define	BYTE	char
#define UBYTE	unsigned char
#define	WORD	short
#define	UWORD	unsigned short
#define	INT	int
#define	UINT	unsigned int
#define	LONG	long
#define	ULONG	unsigned long
#define REG	register
#define DOUBLE	double
#define FLOAT	float
#define	VOID	void
#define STATIC	static

#define	SEEK_SET	0
#define	SEEK_CUR	1
#define	SEEK_END	2

#define	TRUE	1
#define	FALSE	0

#define	CLKCNT	1000

#define	BIT0	04000
#define	BIT1	02000
#define	BIT2	01000
#define	BIT3	0400
#define	BIT4	0200
#define	BIT5	0100
#define	BIT6	040
#define	BIT7	020
#define	BIT8	010
#define	BIT9	04
#define	BIT10	02
#define	BIT11	01

#define	FIELDS	8L			/* Number of 4096 word fields	*/

/*
 *	pdp8 registers.
 */
extern	UINT	DF ;			/* Data Field register		*/
extern	UINT	IB ;			/* Inst Buffer			*/
extern	UINT	IF ;			/* Inst Field register		*/
extern	UINT	PC ;			/* PC register			*/
extern	UINT	INST ;			/* Instruction fetched from mem */
extern	UINT	AC ;			/* Accumulator			*/
extern	UINT	MQ ;			/* Multiplier-Quotient		*/
extern	UINT	SR ;			/* Switch register		*/
extern	UBYTE	EAE ;			/* EAE presence/mode flag	*/
extern	UBYTE	GTF ;			/* EAE Greater Than flag	*/
extern	UINT	SC ;			/* EAE Step Counter		*/
extern	UBYTE	int_ena ;		/* Interrupt Enable Flip-Flop	*/
extern	UBYTE	int_inh ;		/* Interrupt Inhibit Flop-Flop	*/
extern	ULONG	io_flags ;		/* Interrupt request line	*/
extern	UINT	UB ;			/* User Buffer			*/
extern	UINT	UF ;			/* User Flag			*/
extern	UINT	SF ;			/* Save Field			*/

/*
 *	Base register pointing to pdp8 memory.
 */
extern	UWORD *base ;

/*
 *	Processor flag bits.
 */
#define userFLAG	1

/*
 *	FPP-8/A Floating Point Processor
 */
#define fppFLAG		(1 << 1)
#define	LEAV		0		/* Run in interleaved mode	*/
#define	LOCK		1		/* Run in lockout mode		*/
#define	DP		2		/* Double precision data mode	*/
#define	FP		3		/* Floating point data mode	*/
#define	EP		6		/* Extended precision data mode	*/
#define	FPP	fpp_data		/* FPP-8/A in/out flag		*/
extern	LONG	fpptotal ;		/* FPP-8/A inst execution count	*/
extern	UBYTE	fpptrace ;		/* FPP instruction trace flag	*/
extern	UBYTE	fpp_mode ;		/* Run mode			*/
extern	UBYTE	fpp_data ;		/* Data mode			*/
extern	UBYTE	fpp_run ;		/* Pause: run = halt = TRUE	*/
extern	UBYTE	fpp_pause ;		/* Set by FPHLT (6554)		*/
extern	UINT	fpp_aptp ;		/* FPP APT pointer		*/
extern	UINT	fpp_command ;		/* FPP command register		*/
extern	UINT	fpp_stat ;		/* FPP status register		*/
extern	UWORD	fpp_ac [6] ;		/* FPP FAC in pdp8 format	*/
extern	UINT	fpp_pc ;		/* FPP program counter		*/
extern	UINT	fpp_x0 ;		/* FPP index register location	*/
extern	UINT	fpp_br ;		/* FPP base register		*/
extern	UINT	fpp_opadd ;		/* FPP operand address		*/

/*
 *	100 Hz clock (DK8E-C, PDP8-A, VT/78, VT/278)
 */
#define clockFLAG	(1 << 2)
extern	UBYTE	clocktype ;		/* 1=DK8-EA, 2=DK8-EC		*/
extern	LONG	tickspersec ;		/* Real time clock ticks/second	*/

/*
 *	Console VDU
 */
#define coninFLAG	(1 << 3)
#define conoutFLAG	(1 << 4)
extern	UBYTE	coninchar, conoutchar ;

/*
 *	Auxilliary VDU
 */
#define auxinFLAG	(1 << 5)
#define auxoutFLAG	(1 << 6)
extern	UBYTE	aux_vdu ;
extern	UBYTE	auxinchar, auxoutchar ;

/*
 *	PT8-E Reader/Punch
 */
extern	FILE	*pt8reader ;
#define pt8rdrFLAG	(1 << 7)
extern	UBYTE	pt8rdrbuffer ;
extern	FILE	*pt8punch ;
#define pt8punFLAG	(1 << 8)
extern	UBYTE	pt8punbuffer ;

/*
 *	LP8-E Line Printer
 */
#define lp8doneFLAG	(1 << 9)
/* #define lp8errorFLAG */
extern	UBYTE	printCHAR ;
extern	FILE	*lp8printer ;

/*
 *	RK8-E Disk System Registers
 */
#define rk8FLAG		(1 << 10)
#define RK8BUFSIZ	(32 * 384)
extern	BYTE	*rk8file [4] ;
extern	UINT	rk8command ;
extern	UINT	rk8curaddr ;
extern	UINT	rk8block ;
extern	UINT	rk8status  ;
extern	UBYTE	traceflag ;
extern	UBYTE	breakflag ;
extern	UBYTE	tabulate, profile ;
extern	UBYTE	checkvdus ;
extern	INT	clkcntr ;
extern	LONG	curtime, ticks, ticktime ;
extern	UWORD	addrmask, instmask ;
extern	UWORD	breakaddr, breakinst ;
extern	FILE	*tabfile, *histofile ;
extern	ULONG	*tab, *histo ;
extern	UBYTE	total ;
extern	DOUBLE	pdptotal ;
extern	INT	trace ;
extern	ULONG	exec ;
extern	INT	diag ;
extern struct
{
    FILE *drive ;
    UBYTE *buff ;
    INT cyl ;
    INT maxcyl ;
    UBYTE dirty ;
} rk8 [4] ;
extern	INT	rk8unit ;
extern	INT	rk8words ;
extern	INT	rk8count ;
extern	UBYTE	rk8lock ;
extern	UBYTE	rk8write ;

/*
 *	Miscellaneous variables used by the emulator.
 */
extern	BYTE	chrsout [200], pdp8exec [100] ;
extern	UBYTE	run ;
extern	UBYTE	delay ;			/* Delay after ION		*/
extern	ULONG	int_mask ;		/* Interrupt request mask	*/
extern	UBYTE	incrPC ;		/* Used by disassem & pdp8.c	*/
extern	UINT	lastPC ;		/* Used in tracing		*/
extern	UINT	dateword ;		/* Used to store OS/8 dateword	*/
extern	union
	{
	    DOUBLE d ;
	    FLOAT f [2] ;
	    ULONG l [2] ;
	    UWORD w [4] ;
	    UBYTE b [8] ;
	} order ;

/*
 *	Various output files.
 */
extern	FILE	*pdp8conout ;		/* pdp8 console output file	*/
extern	FILE	*pdp8auxout ;		/* pdp8 aux console output file	*/
extern	FILE	*tracefile ;		/* pdp8 inst trace output file	*/
extern	FILE	*disassemfile ;		/* pdp8 disassembly output file	*/
/*
 *	pdp8 memory
 */
extern	FILE	*pdp8file ;		/* pdp8 memory storage file	*/
extern	UWORD	mem32k [8L * 4096] ;
