/*
 *	EMUL-8: a pdp8e emulator.
 *
 *	Author:
 *		Bill Haygood
 *		41832 Ernest Road
 *		Loon Lake, WA 99148-9607
 *		Internet: billh@comtch.iea.com
 *		Voice/AnsMach/FAX \
 *			or	   509-233-2555
 *		  Cellular/Pager  /
 *
 *	Copyright 1992, 1993, 1994 by the author with all rights reserved.
 *
 *	Definitions module.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <math.h>

#define	BYTE	char
#define	UBYTE	unsigned char
#define	INT	int
#define	UINT	unsigned int
#define	UWORD	unsigned short
#define	LONG	long
#define	ULONG	unsigned long
#define	FLOAT	float
#define	DOUBLE	double
#define	REG	register
#define	VOID	void
#define STATIC	static

#define	TRUE	1
#define	FALSE	0

#define	CLKCNT	1000

#define	BIT0	04000
#define	BIT1	02000
#define	BIT2	01000
#define	BIT3	0400
#define	BIT4	0200
#define	BIT5	0100
#define	BIT6	040
#define	BIT7	020
#define	BIT8	010
#define	BIT9	04
#define	BIT10	02
#define	BIT11	01

#define	FIELDS	8L			/* Number of 4096 word fields	*/
/*
 *	Processor flag bits.
 */
#define userFLAG	1
/*
 *	FPP-8/A Floating Point Processor
 */
#define fppFLAG		(1 << 1)
#define	LEAV		0		/* Run in interleaved mode	*/
#define	LOCK		1		/* Run in lockout mode		*/
#define	DP		2		/* Double precision data mode	*/
#define	FP		3		/* Floating point data mode	*/
#define	EP		6		/* Extended precision data mode	*/
#define	FPP	fpp_data		/* FPP-8/A in/out flag		*/
/*
 *	100 Hz clock (DK8E-C, PDP8-A, VT/78, VT/278)
 */
#define clockFLAG	(1 << 2)
#define	DK8EA	1			/* Clock definitions		*/
#define	DK8EC	2
#define	DK8EP	3
#define	PDP8A	4
#define	VT78	5
#define	VT278	6
/*
 *	Console VDU
 */
#define coninFLAG	(1 << 3)
#define conoutFLAG	(1 << 4)
/*
 *	Auxilliary VDU
 */
#define auxinFLAG	(1 << 5)
#define auxoutFLAG	(1 << 6)
/*
 *	PT8-E Reader/Punch
 */
#define	MAXTAPES	16
#define pt8rdrFLAG	(1 << 7)
#define pt8punFLAG	(1 << 8)
/*
 *	LP8-E Line Printer
 */
#define lp8doneFLAG	(1 << 9)
#define	lp8errorFLAG	(1 << 10)
/*
 *	RK8-E Disk System Registers
 */
#define rk8FLAG		(1 << 11)
#define RK8BUFSIZ	(32 * 384)
/*
 *	RX50 Disk System Registers
 */
#define rx50FLAG	(1 << 12)
/* -------------------------------------------------------------------- */
