/*
 *	EMUL-8: a pdp8e emulator.
 *
 *	Author:
 *		Bill Haygood
 *		41832 Ernest Road
 *		Loon Lake, WA 99148-9607
 *		Internet: billh@comtch.iea.com
 *		Voice/AnsMach/FAX \
 *			or	   509-233-2555
 *		  Cellular/Pager  /
 *
 *	Copyright 1992, 1993, 1994 by the author with all rights reserved.
 *
 *	Text module.
 */
#include "pdp8.h"
#include "pdp8regs.h"

#define UNDEF "Undefined EAE Mode B inst"

BYTE	*mritxt [] =
{
    "AND", "TAD", "ISZ", "DCA", "JMS", "JMP"
} ;
/* -------------------------------------------------------------------- */

BYTE	*iottxt [] =
{
/* 6000 */ "SKON", "ION",  "IOF",  "SRQ",  "GTF",  "RTF",  "SGT",  "CAF",
/* 6010 */ "RPE",  "RSF",  "",     "RRB",  "RFC",  "",  "RRB RFC","RDRCLS",
/* 6020 */ "PCE",  "PSF",  "PCF",  "",     "PPC",  "",     "PLS", "PUNCLS",
/* 6030 */ "KCF",  "KSF",  "KCC",  "",     "KRS",  "KIE",  "KRB",  "",
/* 6040 */ "TFL",  "TSF",  "TCF",  "",     "TPC",  "TSK",  "TLS",  "",
/* 6050 */ "DPLA", "DPGO", "DPSM", "DPMB", "DPMD", "",    "DPCL", "DPBELL",
/* 6060 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6070 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6100 */ "DPI",  "SMP",  "SPL",  "EPI",  "CMP",  "SMPCMP", "CEP", "SPO",
/* 6110 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6120 */ "",     "",     "",     "",     "",     "",     "",     "",
#if 0	/*DK8-EP mnemonics	*/
/* 6130 */ "CLZE", "CLSK", "CLOE", "CLAB", "CLEN", "CLSA", "CLBA", "CLCA",
#else
/* 6130 */ "",     "CLEI", "CLDI", "CLSK", "",     "CLIE", "CLCF", "CLSK",
#endif
/* 6140 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6150 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6160 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6170 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6200 */ "",     "CDF 0", "CIF 0", "CIF CDF 0", "CINT", "",  "",  "",
/* 6210 */ "",     "CDF 1", "CIF 1", "CIF CDF 1", "RDF",  "",  "",  "",
/* 6220 */ "",     "CDF 2", "CIF 2", "CIF CDF 2", "RIF",  "",  "",  "",
/* 6230 */ "",     "CDF 3", "CIF 3", "CIF CDF 3", "RIB",  "",  "",  "",
/* 6240 */ "",     "CDF 4", "CIF 4", "CIF CDF 4", "RMF",  "",  "",  "",
/* 6250 */ "",     "CDF 5", "CIF 5", "CIF CDF 5", "SINT", "",  "",  "",
/* 6260 */ "",     "CDF 6", "CIF 6", "CIF CDF 6", "CUF",  "",  "",  "",
/* 6270 */ "",     "CDF 7", "CIF 7", "CIF CDF 7", "SUF",  "",  "",  "",
/* 6300 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6310 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6320 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6330 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6340 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6350 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6360 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6370 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6400 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6410 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6420 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6430 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6440 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6450 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6460 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6470 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6500 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6510 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6520 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6530 */ "ADCL", "ADLM", "ADST", "ADRB", "ADSK", "ADSE", "ADLE", "ADRS",
/* 6540 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6550 */ "",     "FPINT","FPICL","FPCOM","FPHLT","FPST", "FPRST","FPIST",
/* 6560 */ "",     "",     "",     "",     "",     "",     "",     "FPEP",
/* 6570 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6600 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6610 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6620 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6630 */ "",     "RCSF", "RCRA", "",     "RCRB", "RCNO", "RCRC", "RCNI",
/* 6640 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6650 */ "PLCE","PLSF","PLCF","PLPU","PLLR","PLPD","PLCF PLLR","PLSE",
/* 6660 */ "",    "PSKF","PCLF","PSKE","PSTB","PSIE","PCLF PSTB","PCIE",
/* 6670 */ "",     "RCSD", "RCSE", "",     "RCRD", "RCSI", "RCTF", "",
/* 6700 */ "",     "LWCR", "CWCR", "LCAR", "CCAR", "LCMR", "LFGR", "LDBR",
/* 6710 */ "",     "RWCR", "CLT",  "RCAR", "RMSR", "RCMR", "RFSR", "RDBR",
/* 6720 */ "",     "SKEF", "SKCB", "SKJD", "SKTR", "CLF", "maint","maint",
/* 6730 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6740 */ "",     "DSKP", "DCLR", "DLAG", "DLCA", "DRST", "DLDC", "DMAN",
/* 6750 */ "",     "",     "",     "",     "",     "",     "",     "",
/* 6760 */ "",     "DTRA", "DTCA", "",     "DTXA", "",     "DTLA", "",
						/* Read STAT REG A 6772	*/
						/* Load STAT REG B 6774	*/
/* 6770 */ "",     "DTSF", "DTRB", "",     "DTLB", "",      "",     ""
} ;
/* -------------------------------------------------------------------- */

BYTE	*oprtxt1 [] =
{
/* 7000 */ "NOP", "IAC", "BSW", "IAC BSW",
	   "RAL", "IAC RAL", "RTL", "IAC RTL",
/* 7010 */ "RAR", "IAC RAR", "RTR", "IAC RTR",
	   "Reserved", "Reserved", "Reserved", "Reserved",
/* 7020 */ "CML", "CML IAC", "CML BSW", "CML IAC BSW",
	   "CML RAL", "CML IAC RAL", "CML RTL", "CML IAC RTL",
/* 7030 */ "CML RAR", "CML IAC RAR", "CML RTR", "CML IAC RTR",
	   "Reserved", "Reserved", "Reserved", "Reserved",
/* 7040 */ "CMA", "CMA IAC", "CMA BSW", "CMA IAC BSW",
	   "CMA RAL", "CMA IAC RAL", "CMA RTL", "CMA IAC RTL",
/* 7050 */ "CMA RAR", "CMA IAC RAR", "CMA RTR", "CMA IAC RTR",
	   "Reserved", "Reserved", "Reserved", "Reserved",
/* 7060 */ "CMA CML", "CMA CML IAC", "CMA CML BSW", "CMA CML IAC BSW",
	   "CMA CML RAL", "CMA CML IAC RAL",
			"CMA CML RTL", "CMA CML IAC RTL",
/* 7070 */ "CMA CML RAR", "CMA CML IAC RAR",
			"CMA CML RTR", "CMA CML IAC RTR",
	   "Reserved", "Reserved", "Reserved", "Reserved",
/* 7100 */ "CLL", "CLL IAC", "CLL BSW", "CLL IAC BSW",
	   "CLL RAL", "CLL IAC RAL", "CLL RTL", "CLL IAC RTL",
/* 7110 */ "CLL RAR", "CLL IAC RAR", "CLL RTR", "CLL IAC RTR",
	   "Reserved", "Reserved", "Reserved", "Reserved",
/* 7120 */ "CLL CML", "CML CML IAC", "CLL CML BSW", "CLL CML IAC BSW",
	   "CLL CML RAL", "CLL CML IAC RAL",
			"CLL CML RTL", "CLL CML IAC RTL",
/* 7130 */ "CLL CML RAR", "CLL CML IAC RAR",
			"CLL CML RTR", "CLL CML IAC RTR",
	   "Reserved", "Reserved", "Reserved", "Reserved",
/* 7140 */ "CLL CMA", "CLL CMA IAC", "CLL CMA BSW", "CLL CMA IAC BSW",
	   "CLL CMA RAL", "CLL CMA IAC RAL",
			"CLL CMA RTL", "CLL CMA IAC RTL",
/* 7150 */ "CLL CMA RAR", "CLL CMA IAC RAR",
			"CLL CMA RTR", "CLL CMA IAC RTR",
	   "Reserved", "Reserved", "Reserved", "Reserved",
/* 7160 */ "CLL CMA CML", "CLL CMA CML IAC",
			"CLL CMA CML BSW", "CLL CMA CML IAC BSW",
	   "CLL CMA CML RAL", "CLL CMA CML IAC RAL",
			"CLL CMA CML RTL", "CLL CMA CML IAC RTL",
/* 7170 */ "CLL CMA CML RAR", "CLL CMA CML IAC RAR",
			"CLL CMA CML RTR", "CLL CMA CML IAC RTR",
	   "Reserved", "Reserved", "Reserved", "Reserved",
/* 7200 */ "CLA", "CLA IAC", "CLA BSW", "CLA IAC BSW",
	   "CLA RAL", "CLA IAC RAL", "CLA RTL", "CLA IAC RTL",
/* 7210 */ "CLA RAR", "CLA IAC RAR", "CLA RTR", "CLA IAC RTR",
	   "Reserved", "Reserved", "Reserved", "Reserved",
/* 7220 */ "CLA CML", "CLA CML IAC", "CLA CML BSW", "CLA CML IAC BSW",
	   "CLA CML RAL", "CLA CML IAC RAL",
			"CLA CML RTL", "CLA CML IAC RTL",
/* 7230 */ "CLA CML RAR", "CLA CML IAC RAR",
			"CLA CML RTR", "CLA CML IAC RTR",
	   "Reserved", "Reserved", "Reserved", "Reserved",
/* 7240 */ "CLA CMA", "CLA CMA IAC", "CLA CMA BSW", "CLA CMA IAC BSW",
	   "CLA CMA RAL", "CLA CMA IAC RAL",
			"CLA CMA RTL", "CLA CMA IAC RTL",
/* 7250 */ "CLA CMA RAR", "CLA CMA IAC RAR",
			"CLA CMA RTR", "CLA CMA IAC RTR",
	   "Reserved", "Reserved", "Reserved", "Reserved",
/* 7260 */ "CLA CMA CML", "CLA CMA CML IAC",
			"CLA CMA CML BSW", "CLA CMA CML IAC BSW",
	   "CLA CMA CML RAL", "CLA CMA CML IAC RAL",
			"CLA CMA CML RTL", "CLA CMA CML IAC RTL",
/* 7270 */ "CLA CMA CML RAR", "CLA CMA CML IAC RAR",
			"CLA CMA CML RTR", "CLA CMA CML IAC RTR",
	   "Reserved", "Reserved", "Reserved", "Reserved",
/* 7300 */ "CLA CLL", "CLA CLL IAC", "CLA CLL BSW", "CLA CLL IAC BSW",
	   "CLA CLL RAL", "CLA CLL IAC RAL",
			"CLA CLL RTL", "CLA CLL IAC RTL",
/* 7310 */ "CLA CLL RAR", "CLA CLL IAC RAR",
			"CLA CLL RTR", "CLA CLL IAC RTR",
	   "Reserved", "Reserved", "Reserved", "Reserved",
/* 7320 */ "CLA CLL CML", "CLA CLL CML IAC",
			"CLA CLL CML BSW", "CLA CLL CML IAC BSW",
	   "CLA CLL CML RAL", "CLA CLL CML IAC RAL",
			"CLA CLL CML RTL", "CLA CLL CML IAC RTL",
/* 7330 */ "CLA CLL CML RAR", "CLA CLL CML IAC RAR",
			"CLA CLL CML RTR", "CLA CLL CML IAC RTR",
	   "Reserved", "Reserved", "Reserved", "Reserved",
/* 7340 */ "CLA CLL CMA", "CLA CLL CMA IAC",
			"CLA CLL CMA BSW", "CLA CLL CMA IAC BSW",
	   "CLA CLL CMA RAL", "CLA CLL CMA IAC RAL",
			"CLA CLL CMA RTL", "CLA CLL CMA IAC RTL",
/* 7350 */ "CLA CLL CMA RAR", "CLA CLL CMA IAC RAR",
			"CLA CLL CMA RTR", "CLA CLL CMA IAC RTR",
	   "Reserved", "Reserved", "Reserved", "Reserved",
/* 7360 */ "CLA CLL CMA CML", "CLA CLL CMA CML IAC",
			"CLA CLL CMA CML BSW", "CLA CLL CMA CML IAC BSW",
	   "CLA CLL CMA CML RAL", "CLA CLL CMA CML IAC RAL",
			"CLA CLL CMA CML RTL", "CLA CLL CMA CML IAC RTL",
/* 7370 */ "CLA CLL CMA CML RAR", "CLA CLL CMA CML IAC RAR",
			"CLA CLL CMA CML RTR", "CLA CLL CMA CML IAC RTR",
	   "Reserved", "Reserved", "Reserved", "Reserved"
} ;
/* -------------------------------------------------------------------- */

BYTE	*oprtxt2 [] =
{
/* 7400 */ "NOP", "HLT", "OSR", "OSR HLT",
	   "SKP", "SKP HLT", "SKP OSR", "SKP OSR HLT",
/* 7420 */ "SNL", "SNL HLT", "SNL OSR", "SNL OSR HLT",
	   "SZL", "SZL HLT", "SZL OSR", "SZL OSR HLT",
/* 7440 */ "SZA", "SZA HLT", "SZA OSR", "SZA OSR HLT",
	   "SNA", "SNA HLT", "SNA OSR", "SNA OSR HLT",
/* 7460 */ "SZA SNL", "SZA SNL HLT", "SZA SNL OSR", "SZA SNL OSR HLT",
	   "SNA SZL", "SNA SZL HLT", "SNA SZL OSR", "SNA SZL OSR HLT",
/* 7500 */ "SMA", "SMA HLT", "SMA OSR", "SMA OSR HLT",
	   "SPA", "SPA HLT", "SPA OSR", "SPA OSR HLT",
/* 7520 */ "SMA SNL", "SMA SNL HLT", "SMA SNL OSR", "SMA SNL OSR HLT",
	   "SPA SZL", "SPA SZL HLT", "SPA SZL OSR", "SPA SZL OSR HLT",
/* 7540 */ "SMA SZA", "SMA SZA HLT", "SMA SZA OSR", "SMA SZA OSR HLT",
	   "SPA SNA", "SPA SNA HLT", "SPA SNA OSR", "SPA SNA OSR HLT",
/* 7560 */ "SMA SZA SNL", "SMA SZA SNL HLT",
			"SMA SZA SNL OSR", "SMA SZA SNL OSR HLT",
	   "SPA SNA SZL", "SPA SNA SZL HLT",
			"SPA SNA SZL OSR", "SPA SNA SZL OSR HLT",
/* 7600 */ "CLA", "CLA HLT", "CLA OSR", "CLA OSR HLT",
	   "SKP CLA", "SKP CLA HLT", "SKP CLA OSR", "SKP CLA OSR HLT",
/* 7620 */ "SNL CLA", "SNL CLA HLT", "SNL CLA OSR", "SNL CLA OSR HLT",
	   "SZL CLA", "SZL CLA HLT", "SZL CLA OSR", "SZA CLA OSR HLT",
/* 7640 */ "SZA CLA", "SZA CLA HLT", "SZA CLA OSR", "SZA CLA OSR HLT",
	   "SNA CLA", "SNA CLA HLT", "SNA CLA OSR", "SNA CLA OSR HLT",
/* 7660 */ "SZA SNL CLA", "SZA SNL CLA HLT",
			"SZA SNL CLA OSR", "SZA SNL CLA OSR HLT",
	   "SNA SZL CLA", "SNA SZL CLA HLT",
			"SNA SZL CLA OSR", "SNA SZL CLA OSR HLT",
/* 7700 */ "SMA CLA", "SMA CLA HLT", "SMA CLA OSR", "SMA CLA OSR HLT",
	   "SPA CLA", "SPA CLA HLT", "SPA CLA OSR", "SPA CLA OSR HLT",
/* 7720 */ "SMA SNL CLA", "SMA SNL CLA HLT",
			"SMA SNL CLA OSR", "SMA SNL CLA OSR HLT",
	   "SPA SZL CLA", "SPA SZL CLA HLT",
			"SPA SZL CLA OSR", "SPA SZL CLA OSR HLT",
/* 7740 */ "SMA SZA CLA", "SMA SZA CLA HLT",
			"SMA SZA CLA OSR", "SMA SZA CLA OSR HLT",
	   "SPA SNA CLA", "SPA SNA CLA HLT",
			"SPA SNA CLA OSR", "SPA SNA CLA OSR HLT",
/* 7760 */ "SMA SZA SNL CLA", "SMA SZA SNL CLA HLT",
			"SMA SZA SNL CLA OSR", "SMA SZA SNL CLA OSR HLT",
	   "SPA SNA SZL CLA", "SPA SNA SZL CLA HLT",
			"SPA SNA SZL CLA OSR", "SPA SNA SZL CLA OSR HLT"
} ;
/* -------------------------------------------------------------------- */

BYTE *eaetxta [] =
{
/* 7401 */ "NOP", "SCL", "MUY", "DVI", "NMI", "SHL", "ASR", "LSR",
/* 7421 */ "MQL", "MQL SCL", "MQL MUY", "MQL DVI",
	   "SWAB", "MQL SHL", "MQL ASR", "MQL LSR",
/* 7441 */ "SCA", "SCA SCL", "SCA MUY", "SWBA",
	    "SCA NMI", "SCA SHL", "SCA ASR", "SCA LSR",
/* 7461 */ "MQL SCA", "MQL SCA SCL", "MQL SCA MUY", "MQL SWBA",
	   "MQL SCA NMI", "MQL SCA SHL", "MQL SCA ASR", "MQL SCA LSR",
/* 7501 */ "MQA", "MQA SCL", "MQA MUY", "MQA DVI",
	   "MQA NMI", "MQA SHL", "MQA ASR", "MQA LSR",
/* 7521 */ "SWP", "SWP SCL", "SWP MUY", "SWP DVI",
	   "SWP NMI", "SWP SHL", "SWP ASR", "SWP LSR",
/* 7541 */ "MQA SCA", "MQA SCA SCL", "MQA SCA MUY", "MQA SWBA",
	   "MQA SCA NMI", "MQA SCA SHL", "MQA SCA ASR", "MQA SCA LSR",
/* 7561 */ "SWP SCA", "SWP SCA SCL", "SWP SCA MUY", "SWP SWBA",
	   "SWP SCA NMI", "SWP SCA SHL", "SWP SCA ASR", "MQA MQA SCA LSR",
/* 7601 */ "CLA", "CLA SCA", "CLA MUY", "CLA DVI",
	   "CLA NMI", "CLA SHL", "CLA ASR", "CLA LSR",
/* 7621 */ "CAM", "CAM SCL", "CAM MUY", "CAM DVI",
	   "CAM NMI", "CAM SHL", "CAM ASR", "CAM LSR",
/* 7641 */ "CLA SCA", "CLA SCA SCL", "CLA SCA MUY", "CLA SWBA",
	   "CLA SCA NMI", "CLA SCA SHL", "CLA SCA ASR", "CLA SCA LSR",
/* 7661 */ "CAM SCA", "CAM SCA SCL",
			"CAM SCA MUY", "CAM SWBA",
	   "CAM SCA NMI", "CAM SCA SHL",
			"CAM SCA ASR", "CAM SCA LSR",
/* 7701 */ "CLA MQA", "CLA MQA SCL", "CLA MQA MUY", "CLA MQA DVI",
	   "CLA MQA NMI", "CLA MQA SHL", "CLA MQA ASR", "CLA MQA LSR",
/* 7721 */ "CLA SWP", "CLA SWP SCL", "CLA SWP MUY", "CLA SWP DVI",
	   "CLA SWP NMI", "CLA SWP SHL", "CLA SWP ASR", "CLA SWP LSR",
/* 7741 */ "CLA MQA SCA", "CLA MQA SCA SCL",
			"CLA MQA SCA MUY", "CLA MQA SWBA",
	   "CLA MQA SCA NMI", "CLA MQA SCA SHL",
			"CLA MQA SCA ASR", "CLA MQA SCA LSR",
/* 7761 */ "CLA SWP SCA", "CLA SWP SCA SCL",
			"CLA SWP SCA MUY", "CLA SWP SCA DVI",
	   "CLA SWP SWAB", "CLA SWP SCA SHL",
			"CLA SWP SCA ASR", "CLA SWP SCA LSR"
} ;
/* -------------------------------------------------------------------- */

BYTE *eaetxtb [] =
{
/* 7401 */ "NOP", "SCL", "MUY", "DVI", "NMI", "SHL", "ASR", "LSR",
/* 7421 */ "MQL", "MQL SCL", "MQL MUY", "MQL DVI",
	   "SWAB", "MQL SHL", "MQL ASR", "MQL LSR",
/* 7441 */ "SCA", "DAD", "DST", "SWBA", "DPSZ", UNDEF, UNDEF, "SAM",
/* 7461 */ "MQL SCA", "MQL DAD", "MQL DST", "MQL SWBA",
	   "MQL DPSZ", UNDEF, UNDEF, "MQL SAM",
/* 7501 */ "MQA", "MQA ACS", "MQA MUY", "MQA DVI",
	   "MQA NMI", "MQA SHL", "MQA ASR", "MQA LSR",
/* 7521 */ "SWP", "SWP ACS", "SWP MUY", "SWP DVI",
	   "SWP NMI", "SWP SHL", "SWP ASR", "SWP LSR",
/* 7541 */ "MQA SCA", "MQA DAD", "MQA DST", "MQA SWBA",
			"MQA DPSZ", UNDEF, UNDEF, "MQA SAM",
/* 7561 */ "SWP SCA", "SWP DAD", "SWP DST", "SWP SWBA",
	   "SWP DPSZ", "DPIC", "DCM", "SWP SAM",
/* 7601 */ "CLA", "CLA SCA", "CLA MUY", "CLA DVI",
	   "CLA NMI", "CLA SHL", "CLA ASR", "CLA LSR",
/* 7621 */ "CAM", "CAM SCL", "CAM MUY", "CAM DVI",
	   "CAM NMI", "CAM SHL", "CAM ASR", "CAM LSR",
/* 7641 */ "CLA SCA", "CLA DAD", "CLA DST", "CLA SWBA",
	   "CLA DPSZ", UNDEF, UNDEF, "CLA SAM",
/* 7661 */ "CAM SCA", "DLD", "DDZ", "CAM SWBA",
	   "CAM DPSZ", "CAM DPIC", "DLD", "CAM SAM",
/* 7701 */ "CLA MQA", "CLA MQA SCL", "CLA MQA MUY", "CLA MQA DVI",
	   "CLA MQA NMI", "CLA MQA SHL", "CLA MQA ASR", "CLA MQA LSR",
/* 7721 */ "CLA SWP", "CLA SWP SCL", "CLA SWP MUY", "CLA SWP DVI",
	   "CLA SWP NMI", "CLA SWP SHL", "CLA SWP ASR", "CLA SWP LSR",
/* 7741 */ "CLA MQA SCA", "CLA MQA DAD", "CLA MQA DST", "CLA MQA SWBA",
	   "CLA MQA DPSZ", "CLA DPIC", "CLA DCM", "CLA MQA SAM",
/* 7761 */ "CLA SWP SCA", "CLA SWP DAD", "CLA SWP DST", "CLA SWP SWBA",
	   "CLA SWP DPSZ", "CLA SWP DPIC", "CLA SWP DCM", "CLA SWP SAM"
} ;
/* -------------------------------------------------------------------- */
