#include "c42pdf.h"

/*the following lines come from the Linux getopt.h*/

#include "getopt.h"
#include "getopt.c"
#include "getopt1.c"



int optionhandler(int argc, char **argv, options * o)
{
int opt;
int option_index = 0;
int i,j;
char buffer[256];

/*default settings*/
o->listfile = NULL; o->pdffile = NULL;
o->caption = false; o->stretch = STRETCH_TRUE; o->flip = true; 
o->fixedpapersize = true; o->bottom = -1; o->final_scale = 1.0;
o->paperheight = a4.height; o->paperwidth = a4.width;
o->crop[0]=o->crop[1]=o->crop[2]=o->crop[3]=0.0; o->repetitions=1; o->runs=0; 
strcpy(o->commandstring,"c42pdf 0.08 args: ");

//    while ((opt = getopt_long(argc, argv, "ao:b:r:s:hc:n:l:p:")) != -1)
      while (1) 
      {
	int this_option_optind = optind ? optind : 1;
        int option_index = 0; 

	static struct option long_options[]= {
	  {"nostretch", 0, 0, 0}, 
	  {"lockstretch", 0, 0, 0}, 
          {"noflip", 0, 0, 0},
	  {0,0,0,0}
        };
	

	
	opt = getopt_long (argc, argv, "ao:b:r:s:hc:n:l:p:", long_options, &option_index); 
 
	if (opt == -1) 
	  break;

	if (opt!='o' && opt!='l' && opt!=0 && opt!='h')
        {      
	  
        char a[5]=" -  "; a[2]=opt;  
	        strcat(o->commandstring,a); 
	  
		  strcat(o->commandstring,optarg);
        }
        
        switch (opt) {
	    case 0:
		    if (!strcmp ("nostretch", long_options[option_index].name)) {
		         o->stretch = STRETCH_FALSE; 
	                 strcat(o->commandstring," --nostretch"); 
			}			 
	            if (!strcmp ("lockstretch", long_options[option_index].name)) {
		         o->stretch = STRETCH_LOCK; 
	                 strcat(o->commandstring," --lockstretch"); 
			}			 
		       
	            if (!strcmp ("noflip", long_options[option_index].name)) {
		         o->flip = false; 
			 strcat(o->commandstring," --noflip");
			}
		break;         
		
		
	    case 'o':
		if ((o->pdffile = fopen(optarg, WRITEMODE)) == NULL) {
		    fprintf(stderr, 
		        "Error: cannot open output file %s.\n", optarg);
		    exit(1);
		}
		break;
            case 'p':
             
	        if (!strcmp(optarg,"B5"))
                        {o->paperheight = b5.height; o->paperwidth = b5.width; break;}
                if (!strcmp(optarg,"l"))
                        {o->paperheight = letter.height; o->paperwidth = letter.width; break;}
                if (!strcmp(optarg,"o"))
                        {o->fixedpapersize = false; break;}
                o->paperwidth = 0; o->paperheight = 0;
                for (i=0; (buffer[i]=optarg[i])!=0 && optarg[i]!='x'; i++);
                buffer[i]=0; o->paperwidth = atof(buffer);
                j=0;
                for (i++; (buffer[j++]=optarg[i])!=0; i++)
                o->paperheight = atof(buffer);
                if (o->paperheight <= 0 || o->paperwidth <=0) {
                        fprintf(stderr, "Error: paper format (width: %f, height %f) invalid", o->paperwidth, o->paperheight);
                    exit(1); }
                if (o->paperheight < o->paperwidth) {
                        fprintf(stderr, "Error: paper width must be less or equal to paper height (landscape orientation is automatic)"); exit(1);
                        }
		break;
            case 'c':
                j=0; for (i=0;(buffer[j++]=optarg[i])!=0 && optarg[i]!='x';i++);
                buffer[j]=0; o->crop[0] = atof(buffer);
                j=0; for (i++;(buffer[j++]=optarg[i])!=0 && optarg[i]!='x';i++);
                buffer[j]=0; o->crop[1] = atof(buffer);
                j=0; for (i++;(buffer[j++]=optarg[i])!=0 && optarg[i]!='x';i++);
                buffer[j]=0; o->crop[2] = atof(buffer);
                j=0; for (i++;(buffer[j++]=optarg[i])!=0 && optarg[i]!='x';i++);
                buffer[j]=0; o->crop[3] = atof(buffer);
                if (o->crop[0] <0 || o->crop[1] <0 || o->crop[2] <0 || o->crop[3]<0) {
                        fprintf(stderr, "Error: crop values must be >= 0");
                    exit(1); }
		break;
	    case 's':
		if ((o->final_scale = atof(optarg)) == 0.0) {
		    fprintf(stderr, 
		        "Error: scale must not be 0.0\n", optarg);
		    exit(1);
		}
		break;
            case 'l':
                if ((o->listfile = fopen(optarg, READMODE)) == NULL) {
		    fprintf(stderr, 
                        "Error: cannot open list file\n", optarg);
		    exit(1);
		}
		break;
            case 'r':
                if ((o->repetitions = atoi(optarg)) < 1) {
		    fprintf(stderr, 
                        "Error: repetitions must not be less than 1\n", optarg);
		    exit(1);
		}
		break;
            case 'b':
                if ((o->bottom = atoi(optarg)) < 0) {
		    fprintf(stderr, 
                        "Error: bottom must not be less than 0\n", optarg);
                    if (o->bottom > o->paperheight) fprintf(stderr, "Error: Bottom higher than page height");
		    exit(1);
		}
		break;
            case 'h':
                {
                    helpme();
                    exit(1);
		}
		break;

	}
      }
    if (optind == argc && o->listfile == NULL) {
	fprintf(stderr, "Error: no image files given.\n");
	usage();
    }

    
    if (o->pdffile == NULL && o->listfile == NULL) {  /*use default output *.pdf when no outfile is specified*/
        strcpy(o->pdfname,argv[optind]);
        for (i=0; o->pdfname[i]!='.' && i<256; i++);
        o->pdfname[i+1]='p'; o->pdfname[i+2]='d'; o->pdfname[i+3]='f'; o->pdfname[i+4]=0;
        if ((o->pdffile = fopen(o->pdfname, WRITEMODE)) == NULL) {
		    fprintf(stderr, 
                        "Error: cannot open output file %s.\n", o->pdfname);
                     usage(); exit(1);}     
    }

    if (o->pdffile == NULL) {  /*use default output *.pdf when no outfile is specified*/
        for (i=0; o->pdfname[i]!='.' && i<256; i++);
        o->pdfname[i+1]='p'; o->pdfname[i+2]='d'; o->pdfname[i+3]='f'; o->pdfname[i+4]=0;
        if ((o->pdffile = fopen(o->pdfname, WRITEMODE)) == NULL) {
		    fprintf(stderr, 
                        "Error: cannot open output file %s.\n", o->pdfname);
                     usage(); exit(1);}     
     }
    
    return optind;
}













