/*HB 1999-05-27: Improved I/O buffering*/

#include "c42pdf.h"

/*this 256-byte lookup table is needed for FILLORDER_LSB2MSB in TIFFTAG_FILLORDER*/

char lookup_table[256]={0,128,64,192,32,160,96,224,16,144,80,208,48,176,112,240,8,136,72,200,40,168,104,232,24,152,88,216,56,184,120,248,4,132,68,196,36,164,100,228,20,148,84,212,52,180,116,244,12,140,76,204,44,172,108,236,28,156,92,220,60,188,124,252,2,130,66,194,34,162,98,226,18,146,82,210,50,178,114,242,10,138,74,202,42,170,106,234,26,154,90,218,58,186,122,250,6,134,70,198,38,166,102,230,22,150,86,214,54,182,118,246,14,142,78,206,46,174,110,238,30,158,94,222,62,190,126,254,1,129,65,193,33,161,97,225,17,145,81,209,49,177,113,241,9,137,73,201,41,169,105,233,25,153,89,217,57,185,121,249,5,133,69,197,37,165,101,229,21,149,85,213,53,181,117,245,13,141,77,205,45,173,109,237,29,157,93,221,61,189,125,253,3,131,67,195,35,163,99,227,19,147,83,211,51,179,115,243,11,139,75,203,43,171,107,235,27,155,91,219,59,187,123,251,7,135,71,199,39,167,103,231,23,151,87,215,55,183,119,247,15,143,79,207,47,175,111,239,31,159,95,223,63,191,127,255};


/*these functions are slightly adapted versions of original functions contained in PDFlib*/

#define BUFFERLENGTH 4096

void
C4_put_image(PDF *p, TIFF *t, options *o)
{
    PDF_data_source	src;

    id			image_id, length_id, colormap_id = 0;
    long		length;
    long                curpos;
    char                buffer[BUFFERLENGTH];
     
    pdf_end_contents_section(p);

	p->start_contents_pos = ftell(p->fp);
	    
    image_id = pdf_begin_obj(p, NEW_ID);	/* Image object */
    pdf_add_res_xobject(p, image_id);

    length_id		= pdf_alloc_id(p);

    pdf_begin_dict(p); 		

    (void) fputs("/Type /XObject\n", p->fp);
    (void) fputs("/Subtype /Image\n", p->fp);
    (void) fprintf(p->fp,"/Name /I0\n", t->pagecount);
    (void) fprintf(p->fp,"/Filter /CCITTFaxDecode /Width %d\n", t->imagewidth);
    (void) fprintf(p->fp,"/Height %d\n", t->imageheight);
    (void) fprintf(p->fp,"/BitsPerComponent 1\n");

    (void) fprintf(p->fp,"/ColorSpace /DeviceGray\n");
    (void) fprintf(p->fp,"/DecodeParms << /K -1 /Columns %d>>", t->imagewidth);
 
    (void) fprintf(p->fp,"/Length %ld 0 R\n", length_id);
    pdf_end_dict(p);

    pdf_begin_stream(p);
    p->start_contents_pos = ftell(p->fp);

    /* here we process the actual image data */
    fseek(t->tiffile,t->thispagedatastart,SEEK_SET); 
    curpos=ftell(t->tiffile);

    if (t->compressionfillorder == FILLORDER_MSB2LSB)/*baseline TIFF*/
            while (curpos<t->thispagedataend)
                {
		  while (curpos<t->thispagedataend - BUFFERLENGTH) {
		    fread(buffer, BUFFERLENGTH, 1, t->tiffile);
		    fwrite(buffer, BUFFERLENGTH, 1, p->fp);
                    curpos += BUFFERLENGTH; 
		  }


                putc(getc(t->tiffile),p->fp);
                curpos ++;
                }
    if (t->compressionfillorder == FILLORDER_LSB2MSB)/*reverse fillorder TIFF*/
            while (curpos<t->thispagedataend)
                {
                putc(lookup_table[getc(t->tiffile)],p->fp);
                curpos ++;
                }

    length = ftell(p->fp) - p->start_contents_pos;

    pdf_end_stream(p);
    pdf_end_obj(p);

    pdf_begin_obj(p, length_id);		/* Length object */
    (void) fprintf(p->fp,"%ld\n", length);
    pdf_end_obj(p);

}

void C4_execute_image(PDF *p, TIFF *t, options *o)
{
    PDF_matrix m;
    float endwidth, endheight;

	p->res.procset	|= ImageB;

    pdf_end_text(p);
    pdf_begin_contents_section(p);


    		endwidth = p->width * o->final_scale;
    		endheight = p->height * o->final_scale;

	#ifdef DEBUG
	printf ("iw %d ih %d flip %d ew %f eh %f pw %f ph %f ppw %f pph %f\n", t->imagewidth, t->imageheight, flippit(p,t,o), endwidth, endheight, p->width, p->height, o->paperwidth, o->paperheight);
        #endif



    if (o->stretch == STRETCH_LOCK) {
        float sourceheight; 
        float sourcewidth; 
        float verticalskew; 
	float horizontalskew;
	float skewfactor; 
	
        sourcewidth = flippit(p,t,o) ? 
		t->imageheight * t->yresolution * resolutionfactor(t): 
		t->imagewidth * t->xresolution * resolutionfactor(t); 
        sourceheight = flippit(p,t,o) ? 
		t->imagewidth * t->xresolution * resolutionfactor(t): 
		t->imageheight * t->yresolution * resolutionfactor(t); 
     
        verticalskew = (sourcewidth / p->width); 
	horizontalskew = (sourceheight / p->height); 
	
	skewfactor = (verticalskew > horizontalskew) ? verticalskew :  
		horizontalskew; 
        
        endwidth = sourcewidth / skewfactor;  
	endheight = sourceheight  / skewfactor; 

        }

    if (o->stretch == STRETCH_FALSE) {
        float sourceheight; 
        float sourcewidth; 
        
        sourcewidth = (flippit(p,t,o) ? t->imageheight : t->imagewidth); 
        sourceheight = (flippit(p,t,o) ? t->imagewidth : t->imageheight); 
      
        endwidth = sourcewidth * resolutionfactor(t) * t->xresolution;  
	endheight = sourceheight * resolutionfactor(t) * t->yresolution; 
        
	#ifdef DEBUG
	printf ("iw %d ih %d sw %f sh %f flip %d ew %f eh %f pw %f ph %f ppw %f pph %f", t->imagewidth, t->imageheight, sourcewidth, sourceheight, flippit(p,t,o), endwidth, endheight, p->width, p->height, o->paperwidth, o->paperheight);
        #endif
       	  
	}

    m.d = endheight;
    m.a = endwidth;
    
    m.b = m.c = 0.0;
    m.e = (p->width - endwidth) / 2.0;
    if (o->bottom < 0) /*if no bottom is given, centric alignment*/
        m.f = (p->height - endheight) / 2.0;/*x*/
    else
        m.f = o->bottom;/*y*/
    pdf_concat(p, m);

    #ifdef DEBUG
    printf(" h, %f, v: %f",  (float)m.f, (float)o->bottom);
    #endif
    /* todo: image name */ 	/* HACK */
    (void) fprintf(p->fp,"/I0 Do\n", t->pagecount);

}


void
C4_PDF_end_page(PDF *p, float crop[], int runs)
  /*this function differs from PDFlib's original PDF_end_page (p_basic.c) only in that a crop box is provided for*/
{
const char *pdf_transitions_names[] = {
    "", "Split", "Blinds", "Box", "Wipe", "Dissolve", "Glitter", "R"
};


    pdf_item	*i;
    int		index = 0;

    pdf_end_contents_section(p);

    pdf_begin_obj(p, p->pages[p->current_page]);	/* Page object */
    pdf_begin_dict(p);
    (void) fputs("/Type /Page\n", p->fp);
    (void) fprintf(p->fp,"/Parent %ld 0 R\n", p->pages_id);

    p->res_id = pdf_alloc_id(p);
    (void) fprintf(p->fp,"/Resources %ld 0 R\n", p->res_id);

    (void) fprintf(p->fp,"/MediaBox [0 0 %g %g]\n", p->width, p->height);
    (void) fprintf(p->fp,"/CropBox [%g %g %g %g]\n", crop[0], crop[1], p->width-crop[2], p->height-crop[3]);
    if (p->duration > 0)
	(void) fprintf(p->fp, "/D %s\n", pdf_float(p->duration));

    if (p->transition != trans_none) {
	(void) fputs("/Trans ", p->fp);
	pdf_begin_dict(p);
	    (void) fprintf(p->fp, "/S /%s",
                                pdf_transitions_names[p->transition]);
	pdf_end_dict(p);
    }

    (void) fputs("/Contents [", p->fp);
    for (index = 0; index < p->next_content; index++) {
	(void) fprintf(p->fp,"%ld 0 R", p->contents_ids[index]);
	(void) fputs(index+1 % 6 ? " " : "\n", p->fp);
    }
    (void) fputs("]\n", p->fp);

    pdf_end_dict(p);
    pdf_end_obj(p);

    pdf_begin_obj(p, p->res_id);			/* Resource object */
    pdf_begin_dict(p);

    (void) fputs("/ProcSet [/PDF", p->fp);		/* ProcSet resources */
    if ( p->res.procset & ImageB)
	(void) fputs(" /ImageB", p->fp);
    if ( p->res.procset & ImageC)
	(void) fputs(" /ImageC", p->fp);
    if ( p->res.procset & ImageI)
	(void) fputs(" /ImageI", p->fp);
    if ( p->res.procset & Text)
	(void) fputs(" /Text", p->fp);
    (void) fputs("]\n", p->fp);

    if (p->res.font != (pdf_item *) NULL)
    {
	(void) fputs("/Font ", p->fp);			/* Font resources */

	pdf_begin_dict(p);
	    for(i = p->res.font, index = 0; i != (pdf_item *) NULL; i = i->next)
	    {
		(void) fprintf(p->fp,"/F%d %ld 0 R\n", index++, i->obj_id);
	    }
	pdf_end_dict(p);
    }

    if (p->res.xobject != (pdf_item *) NULL)
    {
	(void) fputs("/XObject ", p->fp);		/* XObject resources */

	pdf_begin_dict(p);
	    for(i = p->res.xobject, index = 0; i != (pdf_item *) NULL; i = i->next)
	    {
	      /*new feature*/
	      if (i->next == (pdf_item *) NULL)
		(void) fprintf(p->fp,"/I0 %ld 0 R\n", i->obj_id);
	    }
	pdf_end_dict(p);
    }

    pdf_end_dict(p);
    pdf_end_obj(p);
}














