#include "c42pdf.h"

long GetLong (FILE* tiffile,char byteorder)
{
long out=0;
if (byteorder == FILLORDER_LSB2MSB)
  { 
  out+=(long)getc(tiffile);
  out+=(long)getc(tiffile)*256;
  out+=(long)getc(tiffile)*256*256;
  out+=(long)getc(tiffile)*256*256*256;
  }
else
  {
  out+=(long)getc(tiffile)*256*256*256;
  out+=(long)getc(tiffile)*256*256;
  out+=(long)getc(tiffile)*256; 
  out+=(long)getc(tiffile);
  }
return out;
}

int GetInt (FILE* tiffile,char byteorder)
{
int out=0;
if (byteorder == FILLORDER_LSB2MSB)
  {
  out+=(int)getc(tiffile);
  out+=(int)getc(tiffile)*256;
  }
else
  {
  out+=(int)getc(tiffile)*256;
  out+=(int)getc(tiffile);  
  }
return out;
}

float resolutionfactor(TIFF *t) 
{
 switch (t->resolutionunit)
      {
      case RESUNIT_NONE: printf("Error, resolution unit in TIFF image specified as RESUNIT_NONE, can't get page size!\n"); exit(2); break;
      case RESUNIT_INCH: return 72.0; break;
      case RESUNIT_CENTIMETER: return 26.66667; break; 
      default: printf("Error, resolution unit in TIFF image is not defined: (%d)\n", t->resolutionunit); exit(2); break;
      }
}

int flippit (PDF *p, TIFF *t, options *o) {
        if (o->flip && (t->imagewidth*t->xresolution > t->imageheight*t->yresolution && o->paperwidth < o->paperheight || t->imageheight*t->yresolution > t->imagewidth*t->xresolution && o->paperheight < o->paperwidth))return true;  /*landscape orientation*/ 
	else
	  return false; 
}

void handle_fancy_options(PDF *p, TIFF *t, options *o)
{
        float buffer; 
	/*image size is resized to output format automatic paper resizing*/
         if (!(o->fixedpapersize)) 
                {
		#ifdef DEBUG
			printf("handling fancy options"); 
		#endif
                o->paperwidth = t->xresolution * resolutionfactor(t) *t->imagewidth;
                o->paperheight = t->yresolution * resolutionfactor(t) * t->imageheight;
                }

	
                

}

void readtiffpage(PDF *p, TIFF *t, options *o)
{
  int entry_no; /*number of field entries in TIFF file*/
  int field_no; /*number of field analyzed*/
  int i;

	fseek(t->tiffile,t->nextpageifdoffset,SEEK_SET); /*pointer to IFD*/
        entry_no = GetInt(t->tiffile,t->byteorder);
	for (i=0;i<entry_no;i++)
	  {
	  field_no = GetInt(t->tiffile,t->byteorder);
	 
	  fseek (t->tiffile,6,SEEK_CUR);
	  switch(field_no)
	    {
	    case TIFFTAG_IMAGEWIDTH: 
              t->imagewidth = (int)GetLong(t->tiffile,t->byteorder); break;
	    case TIFFTAG_IMAGELENGTH: 
              t->imageheight = (int)GetLong(t->tiffile,t->byteorder);break;
	    case TIFFTAG_STRIPOFFSETS: 
              t->thispagedatastart = GetLong(t->tiffile,t->byteorder);break;
	    case TIFFTAG_COMPRESSION: 
              t->compression = (int)GetLong(t->tiffile,t->byteorder); break;
            case TIFFTAG_FILLORDER: 
	      t->compressionfillorder = (char)GetLong(t->tiffile,t->byteorder); break; 
            case TIFFTAG_RESOLUTIONUNIT: 
	      t->resolutionunit = GetInt(t->tiffile,t->byteorder); fseek(t->tiffile,2,SEEK_CUR) ; break;
            case TIFFTAG_XRESOLUTION: 
              fseek (t->tiffile,-4,SEEK_CUR); t->xresolution = (float)GetLong(t->tiffile,t->byteorder)/(float)GetLong(t->tiffile,t->byteorder);break;
            case TIFFTAG_YRESOLUTION: 
              fseek (t->tiffile,-4,SEEK_CUR); t->yresolution = (float)GetLong(t->tiffile,t->byteorder)/(float)GetLong(t->tiffile,t->byteorder);break;
	    default: 
              fseek(t->tiffile,4,SEEK_CUR);
	    }
	  }
        /*pointer to next fdi*/
        (o->runs)++;
        t->thispagedataend = GetLong(t->tiffile,t->byteorder);
	if (o->runs == o->repetitions) 
	         {
                 t->nextpageifdoffset = t->thispagedataend;
                 o->runs = 0;
                 } 
        if (t->thispagedataend==0)/*last image, special*/
                 { 
                 long curpos=ftell(t->tiffile);
	         fseek(t->tiffile,0L,SEEK_END); 
                 t->thispagedataend=ftell(t->tiffile);
                 fseek(t->tiffile,curpos,SEEK_SET);
                 }
       	  


	handle_fancy_options(p,t,o);
	
	p->width=o->paperwidth; p->height=o->paperheight; /*portrait orientation*/
    
        if (flippit(p,t,o)) 
	  {float buffer; 
		#ifdef DEBUG
		  printf ("flipping "); 
		#endif
		  buffer=p->width;
		  p->width=p->height; 
		  p->height = buffer; 
	  }  
        /*landscape orientation*/      
         

	#ifdef DEBUG
        printf("compression %d datastart %ld dataend %ld nextpageifdoffset %ld height %d width %d entryno %d xresolution %f yresolution %f resolutionunit %d papaerwidth %f paperheight %f pagewidth %f pageheight %f\n",t->compression,t->thispagedatastart,t->thispagedataend,t->nextpageifdoffset,t->imageheight,t->imagewidth,entry_no,t->xresolution,t->yresolution,t->resolutionunit,o->paperwidth,o->paperheight, p->width, p->height);
	#endif
        if (t->compression!=COMPRESSION_CCITTFAX4) {printf("No CCITT4 compression in TIFF source file (tag for compression type=%d). c42pdf cannot handle this file !", t->compression); exit(2);}	
}

void readtifffile(PDF * p, TIFF *t, options * o)
{
  /*defaults*/
  t->compression = 0; 
  t->compressionfillorder = FILLORDER_MSB2LSB; /*(if tag 266 is missing)*/
  t->pagecount = 0;
  t->resolutionunit = RESUNIT_NONE;
  t->xresolution = 1.0; t->yresolution = 1.0; 

  t->byteorder = getc(t->tiffile);
    switch(t->byteorder)
      {
      case 'I': t->byteorder = FILLORDER_LSB2MSB; break; /*Intel little endian*/
      case 'M': t->byteorder = FILLORDER_MSB2LSB; break; /*Motorola big endian*/
      default: printf("Error: This is not a TIFF file (it ought to begin with I or M when viewed in ASCII editor and not with \"%c\").\n", t->byteorder); exit(2);
      }
    fseek(t->tiffile,4,SEEK_SET);
    t->nextpageifdoffset = GetLong(t->tiffile,t->byteorder);
        /*position of first IFD pointer in header*/
    
    do
      { 
	float widthbuffer, heightbuffer; 
	readtiffpage(p,t,o);

	widthbuffer = p->width; heightbuffer = p->height; 
        PDF_begin_page(p, p->width, p->height);
	p->height = heightbuffer; p->width = widthbuffer; 
 
	/* define outline with filename */

        C4_put_image(p, t, o);

        C4_execute_image(p, t, o);

	p->res.procset = ImageB;
        C4_PDF_end_page(p,o->crop,o->runs);

        t->pagecount++;
      } while (t->nextpageifdoffset);
    if (fclose(t->tiffile)!=0) printf ("Error in closing file.");
}













