.ds e \s-2\e\s0
.Lc The\ Reader 7
.pp
The 
.Fr
reader is controlled by a 
.i readtable.
A readtable is an array of fixnums, one fixnum for each of the 128
ascii characters. 
The fixnums tell the reader what the properties of the each character
are.
The initial readtable is described below.
The user may create new readtables using the
.i makereadtable
function.
The current readtable is the value of the lisp
symbol 
.i readtable 
which, like any lisp symbol, may be 
lambda bound to allow the user to change the 
reader syntax very quickly.
The values which may appear in the readtable are:
.TS
center box;
c | c | c | c
ab | n | c |  c .
type	value (decimal)	meaning	default
=
vnum	0	digit	0-9
_
vsign	1	plus or minus	+ -
_
vchar	2	alphabetic character	T{
A-Z a-z ^H ! $ % & * , / : ; < = > ? @ ^ _ ` { | } ~  
T}
_
vsca	66	single char atom	none
_
vlpara	195	left paren	(
_
vrpara	196	right paren	)
_
vperd	197	period	.
_
vlbrkt	198	left bracket	[
_
vrbrkt	199	right bracket	]
_
veof	200	end of file	rubout
_
vsq	201	single quote	\'
_
vdq	138	T{
double quote, all characters between matching double
quotes are escaped (i.e. treated as \fBvchar\fP)
T}	"
_
vsd	137	T{
string delimiter, all characters between matching
delimiters are concated into an object of type string
T}	none
_
verr	203	illegal character	T{
null ^A-^I ^N-^Z ^\*e-^_
T}
_
vsep	204	separator	^I-^M esc space
_
vspl	205	splicing macro character	none
_
vmac	206	macro character	none
_
vesc	143	escape character	\*e
.TE
.pp
The names in the type column are not known to Franz, we are just using them
to tag the various classes.  You must use the value in the second column.
The default column shows the syntax values of characters in the raw lisp,
i.e.,  the lisp which contains only machine language functions.  The lisp
which you get when you give the lisp command to the shell is an augmented
version of the raw lisp, with additional lisp coded functions and changes
in the readtable.
The syntax changes in the lisp may differ from installation to installation
but will probably include making one character be a comment character.
In the lisp at Berkeley, semicolon is the comment character.  This
was done  by declaring it to be a splicing macro character which
invokes the function 
.i zapline 
when seen.
.pp
To read the syntax of a character, you may use 
(\fBstatus\ syntax\fP\ 's_char).
.pp
To change the syntax bits of a character, use the 
.i setsyntax 
function.
There are two forms, one when you just want to change the syntax bits,
and the other when you want to define a character macro.
The first form is:
.sp 1v
.tl ''(\fBsetsyntax\fP \fI\'s_c \'x_value\fP)''
.sp 1v
Here 
.i s_c 
may be the character itself or it may be the fixnum representation
of that character.
.i x_value 
is one of the values given above in the second column.
You should be careful when you change the syntax of a character
as the change lasts until you explicitly change it back or until you
begin with a new lisp.
Also, some syntax changes are silly and will probably cause system
errors (e.g. changing the syntax of an alphabetic character to be
a 
.b vnum
).
The only syntax values you will probably ever use are:
.b vdq 
and 
.b vesc.
You should not change the syntax to 
.b vspl 
or 
.b vmac 
using the above form,
instead it will be done automatically when you use the form below.
.pp
To declare a character macro use:
.sp 1v
.tl ''(\fBsetsyntax\fP \fI\'s_c \'s_type \'s_fcn\fP)''
.sp 1v
Where 
.i s_c
is again either the character itself or its fixnum equivalent,
type is 
.i splicing 
or 
.i macro,
and 
.i s_fcn 
is either the name of
a function expecting no arguments or is a lambda expression.
The result of the setsyntax function is twofold: the readtable value
for that character is changed to 
.b vspl 
or 
.b vmac, 
and the function
is put on the property list of the character under the indicator "macro".
The difference between a splicing macro and a macro is this: the value
returned by a splicing macro is 
.i nconc ed
to what has been read so far
(i.e. (\fBnconc\fP\ sofar\ justreturned)),
while the value returned by a macro is added to what has been read,
(i.e (\fBnconc\fP\ sofar\ (\fBlist\fP justread)).
Thus if a splicing macro returns nil, then it isn't seen since
(\fBnconc\fP any nil)\ ==>\ any.
In particular splicing macros are useful for conditional loading of 
lisp expressions.
.pp
.Fr 
treats left and right square brackets in a special way when
building lists.
A left bracket is just like a left parenthesis, and a right bracket
matches a left bracket or all open left parentheses, whichever comes
first.
.pp
When building atoms, a character with the syntax code 
.b vesc
will cause the next character to be read in and treated as a 
.b vchar.
To escape an entire string of characters, you surround them with matching
characters
having the 
.b vdq
syntax code.
To escape the
.b vdq
character within the string of characters you use any character of class
.b vesc.
The standard
UNIX
escape character, backslash (`\*e'), is in this class by default.
