static int count = 0;
static char line[1024];
static int log_fd = 0;

extern void (*_echo_to_printer_)();	/* global Echo call variable for printer */

/*
	This routine is called by the LSC "printf" to echo chars
	to a printer. We redirect them to a file for logging.
	
	we also check the gatorbox for log info after each line.
*/

echo_to_file(ch)
register char ch;
{
	if (log_fd == 0)
		{
		log_fd = creat("log file", 0666);
		}
	
	if (log_fd < 0)
		return;

	if (count == 0)
		{
		_echo_to_printer_ = (void *)0;
		_echo_to_printer_ = (void *)echo_to_file;
		}

	if (ch != '\n')
		{
		line[ count++ ] = ch;
		return;
		}
	
	line[ count++ ] = '\r';
	write(log_fd, line, count);
	count = 0;
}

echo_line_to_file(line)
char *line;
{
	write(log_fd, line, strlen(line));
}

echo_to_file_done()
{
	if (log_fd)
		close(log_fd);
		
	log_fd = 0;
}
