/*
 * Copyright (c) 1986 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution is only permitted until one year after the first shipment
 * of 4.4BSD by the Regents.  Otherwise, redistribution and use in source and
 * binary forms are permitted provided that: (1) source distributions retain
 * this entire copyright notice and comment, and (2) distributions including
 * binaries display the following acknowledgement:  This product includes
 * software developed by the University of California, Berkeley and its
 * contributors'' in the documentation or other materials provided with the
 * distribution and in all advertising materials mentioning features or use
 * of this software.  Neither the name of the University nor the names of
 * its contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *	@(#)psreg.h	7.4 (Berkeley) 6/28/90
 */

#ifndef _PSREG_
#define _PSREG_
/*
 * PS300 definitions.
 */
#ifndef KERNEL
#include <sys/ioctl.h>
#else
#include "ioctl.h"
#endif

struct  pslookup {
        int     pl_len;                 /* length of name string */
        char    *pl_name;               /* address of name string */
        u_long  pl_addr;                /* symbol's address */
};

/*
 * Maximum string which may be supplied for lookup.
 */
#define PS_MAXNAMELEN   256             /* must be <= PSMAXDMA */

/*
 * When doing physical i/o, one may specify the address
 * and whether or not refresh sync should is required with
 * a null iovec descriptor (iov_len = 0).
 */
#define PSIO_SYNC       1               /* do physical write w/ refresh sync */

/*
 * Ioctl requests.
 */
#define PSIOGETERROR    _IOR('p', 0, int)                 /* get last error */
#define PSIOLOOKUP      _IOWR('p', 1, struct pslookup)    /* do name lookup */
#define PSIORWLOGICAL   _IOWR('p', 2, int)                /* set i/o mode */

/*
 * Error codes returned by PSIOGETERROR are either
 * returned by the PS300 or, from the list below,
 * generated by the device driver.
 */
#define PSERROR_DIOTIMO         1       /* timeout during dioread/diowrite */
#define PSERROR_INVALBC         2       /* invalid byte count for read/write */
#define PSERROR_BADADDR         3       /* invalid address for read/write */
#define PSERROR_BADCMD          4       /* invalid command in ikstart */
#define PSERROR_NAMETIMO        5       /* timeout during nameaddr dioread */
#define PSERROR_CMDTIMO         6       /* operation timed out */
#endif
