.TH PGREP 1P "22 June 1983"
.UC 4
.SH NAME
pgrep \- search files in a project hierarchy for a pattern
.SH SYNOPSIS
.B pgrep
[\fB\-eilmnw\fR] [\fB\-f \fRmakefile] [\fB\-C \fRcommand] [\fB\-F \fRpatfile]
[\fB\-P \fRpdirname] [\fB\-T \fRtypexpr] [pattern [file ...]]
.SH DESCRIPTION
.I Pgrep
searchs through the files in a project hierarchy for lines matching
.I pattern.
Normally, each line found is printed to standard output. Alternatively,
a
.I command
can be executed in each project directory, with arguments that are
the names of files containing
.I pattern.
.PP
The names of files can be specified as arguments, or obtained from the `HDRS'
and `SRCS' macro definitions in a makefile (\fB\-m \fRoption),
or a combination of both. When
.I pgrep
is told to use a makefile and the
.B \-f
option is not present, the files `makefile' and `Makefile' are tried in
order.
.PP
.I Pgrep
uses
.I pexec
to execute either the
.I grep
or
.I egrep
commands over a project hierarchy.
.I Grep
patterns are limited to regular expressions in the style of \fIex\fR(1).
.I Egrep
patterns are full regular expressions.
Care should be taken when using the characters $ * [ | ( ) and \\ in
.I pattern
as they are also meaningful to the command shell. It is safest to enclose
the entire
.I pattern
in single quotes.
.SH OPTIONS
.IP \fB\-e\fR
Use
.I egrep
instead of
.I grep.
.IP "\fB\-f \fImakefile\fR"
Specify an alternative
.I makefile
file name. This option also implies the
.B \-m
option.
.IP \fB\-i\fR
Ignore case of letters when making comparisons (i.e. upper and lower case
are considered identical).
.I Grep
only.
.IP \fB\-l\fR
List the names of files with matching lines. The file names are printed
one per line.
.IP \fB\-m\fR
Obtain the names of files to search from a makefile. If no
.B \-f
option is present, the makefiles `makefile' and `Makefile' are tried in order.
.IP \fB\-n\fR
Precede each matching line by its relative line number in the file.
.IP \fB\-w\fR
Treat
.I pattern
as a word (i.e. as if surrounded by `\\<' and `\\>'; see \fIex\fR(1)\|).
.I Grep
only.
.IP "\fB\-C \fIcommand\fR"
Execute
.I command
in each project directory, with arguments that are
the names of files containing
.I pattern.
.IP "\fB\-F \fIpatfile\fR"
The regular expression is taken from
.I patfile.
.I Egrep
only.
.IP "\fB\-P \fIpdirname\fR"
Specify a project other than the current working project. If
.I pdirname
is a project directory, search files in that directory only.
.IP "\fB\-T \fItypexpr\fR"
Only search files in project directories corresponding to boolean type
label expression,
.I typexpr.
.SH EXAMPLES
If all the directories in a project that contain source code have been
labeled previously as type `src', then, to search all the source code
makefiles for the pattern `VERSION =', type:
.PP
	pgrep  \-Tsrc  \'\^VERSION.*=\'  Makefile
.PP
where quotes surround the pattern to prevent file name expansion in the
current directory.
.PP
To edit all the source code files that contain the pattern `open(' using
the
.I vi
editor, type:
.PP
	pgrep  \-m  \-Cvi  \-Tsrc  \'open(\'
.PP
where
.B \-m
tells
.I pgrep
to get the names of the source code files from a makefile.
.SH FILES
.ta \w'makefile'u+.5i
makefile	Default makefile.
.br
Makefile	Alternative default makefile.
.DT
.SH "SEE ALSO"
egrep(1), ex(1), grep(1), make(1), mkmf(1P), pexec(1P), pgrep(3P), vi(1)
.SH DIAGNOSTICS
Exit status is 0 if any matches are found, 1 if none,
2 for syntax errors or inaccessible files and directories.
.SH AUTHOR
Peter J. Nicklin
