.TH PHELP 1P "22 June 1983"
.UC 4
.SH NAME
phelp \- on-line help for a project
.SH SYNOPSIS
.B phelp
[\fB\-P \fRprojectname] [topic [subtopic ... ]]
.SH DESCRIPTION
.I Phelp
(\fIp\ze\h'0.1m'\v'-0.4m'-\v'0.4m'\h'0.1m'\'help\fR)
provides information about a project. There are two modes of operation:
.PP
.I Interactive
.PP
After the
.I phelp
command is typed, it will respond with `???' indicating that it is ready for
a command. The following commands are recognized:
.nf
.RS
.ta \w'carriage return only'u+.5i

     Command	     Response
.PP
\fIa topic name\fR	Print help information on topic.
index	Display list of topics available at this level.
help	Display help on how to use \fIphelp\fR.
?	Display this command summary.
q	Exit from \fIphelp\fR.
P \fIprojectname\fR	Change to another project.
~	Return to the top level of help topics.
\fIcarriage return only\fR	Go up one level of help topics.
.DT
.RE
.fi
.PP
If a topic name is typed in reply,
.I phelp
will print a page of information and then wait until a space is typed
before it continues.
.PP
.I "Command line topics"
.PP
Information on a specific
.I topic
can be requested by giving the
.I phelp
command with the topic name as an argument on the command line.
If the last argument is
.B index,
the subtopics corresponding to the previous argument are listed.
Provided the information has not been redirected to a file,
.I phelp
will prompt for further commands once it has finished printing.
.PP
.B "Creating topics"
.PP
Project help files reside in the `help' directory located in the project
root directory. Subtopics are contained in subdirectories. A
subtopic directory has the same name as a help file but with a `.d'
suffix. For example, if ``bugfixes'' is a subtopic of ``news'', it will be
found in the directory `news.d', which itself is a subdirectory of the
project `help' directory.
.PP
Subtopics can be nested to any level.
.PP
Any filename beginning with a `.' is ignored by
.I phelp.
.SH OPTIONS
.IP "\fB\-P \fIprojectname\fR"
Specify a project other than the current working project.
.SH EXAMPLES
In the following examples,
.B bold
script indicates what the user types.
.PP
To find out about topic ``news'':
.nf
	% \fBphelp\fR
	(\fIprints introduction to phelp and a list of topics available\fR)
	??? \fBnews\fR
	(\fIprints \fR``\fInews\fR'')
	??? \fBq\fR
	%
.PP
Using command line arguments instead:
.PP
	% \fBphelp news\fR
	(\fIprints \fR``\fInews\fR'')
	??? \fBq\fR
	%
.PP
To print topic ``news'' on the line printer:
.PP
	% \fBphelp news | lpr\fR
	%
.PP
If ``bugfixes'' is a subtopic of ``news'', then to print ``news'', and
then ``bugfixes'':
.PP
	% \fBphelp news\fR
	(\fIprints \fR``\fInews\fR'')
	news subtopics:  bugfixes
	news-->??? \fBbugfixes\fR
	(\fIprints \fR``\fIbugfixes\fR'')
	news-->??? \fBq\fR
	%
.fi
.SH FILES
.ta \w'/usr/new/lib/phelp.help'u+.5i
.nf
/usr/new/lib/phelp.help	Introduction on how to use \fIphelp\fR.
/usr/new/lib/phelp.cmd	\fIPhelp\fR command summary.
\fIproject\fR/help/*	Help text files.
\fIproject\fR/help/*.d	Subtopic directories.
.fi
.DT
.SH DIAGNOSTICS
Exit status 0 is normal. Exit status 1 indicates an error.
.SH AUTHOR
Peter J. Nicklin
