.\" Copyright (c) 1980 The Regents of the University of California.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in the
.\"    documentation and/or other materials provided with the distribution.
.\" 3. All advertising materials mentioning features or use of this software
.\"    must display the following acknowledgement:
.\"	This product includes software developed by the University of
.\"	California, Berkeley and its contributors.
.\" 4. Neither the name of the University nor the names of its contributors
.\"    may be used to endorse or promote products derived from this software
.\"    without specific prior written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
.\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
.\" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\"
.\"	@(#)ch1.n	6.4 (Berkeley) 4/17/91
.\"
.\" $Header: ch1.n,v 1.3 83/07/27 15:11:17 layer Exp $
.Lc \s+2F\s-2RANZ\s0\ L\s-2ISP\s0\s-2 1
.sh 2
.Fr \*[\(dg\*]
was created as a tool to further research in symbolic and
algebraic manipulation,
artificial intelligence,
and programming languages at the University of California
at Berkeley.
.(f
\*[\(dg\*]It is rumored that this name has something to do with Franz
Liszt [F\fIr\fPa\*:nts List] (1811-1886) a Hungarian composer
and keyboard virtuoso. 
These allegations have never been proven.
.)f
Its roots are in a PDP-11 Lisp system which originally came
from Harvard.
As it grew it adopted features of Maclisp and Lisp Machine Lisp.
Substantial compatibility with other Lisp dialects
(Interlisp, UCILisp, CMULisp) is achieved by 
means of support packages and compiler switches.
The heart of
.Fr
is written almost entirely in the programming language C.
Of course, it has been greatly extended by additions written
in Lisp.
A small part is written in the assembly language for the current
host machines, VAXen and a couple of flavors of 68000.
Because 
.Fr
is written in C, it is relatively portable and easy to comprehend.
.pp
.Fr
is capable of running large lisp programs in a timesharing environment,
has facilities for arrays and user defined structures,
has a user controlled reader with character and word macro  capabilities,
and can interact directly with compiled Lisp, C, Fortran, and Pascal code.
.pp 
This document is a reference manual for the 
.Fr
system.
It is not a Lisp primer or introduction to the language.
Some parts will be of interest primarily to those maintaining 
.Fr
at their computer site.
There is an additional document entitled
\fIThe Franz Lisp System,\fP
by John Foderaro, which partially describes the system implementation.
.Fr ,
as delivered by Berkeley, includes all source code
and machine readable version of this manual and system document.
The system document is in a single file named "franz.n" in
the "doc" subdirectory.
.pp
This document is divided into four Movements.
In the first one we will attempt to describe the language of
.Fr
precisely and completely as it now stands (Opus 38.69, June 1983).
In the second Movement we will look at the reader, function types,
arrays and exception handling.
In the third Movement we will look at several large support packages 
written to help the 
.Fr
user, namely the trace package,  compiler, fixit and stepping package.
Finally the fourth movement contains  an index into the other movements.
In the rest of this chapter we shall examine the data types of 
.Fr .
The conventions used in the description of the 
.Fr
functions will be given in \(sc1.3 -- it is very important that 
these conventions are  understood.
.sh 2 Data\ Types
.Fr
has fourteen data types.
In this section we shall look in detail at each type and if a type is
divisible we shall look inside it.
There is a Lisp function
.i type
which will return the type name of a lisp object.
This is the official 
.Fr
name for that type and we will use this name and this name only in 
the manual to avoid confusing the reader.
The types are listed in terms of importance rather than alphabetically.
.sh 3 lispval - - 0
This is the name we use to describe any Lisp object.
The function
.i type
will never return `lispval'.
.sh 3 symbol
This object corresponds to a variable in most other programming languages.
It may have a value or may be `unbound'.
A symbol may be 
.i lambda 
.i bound 
meaning that its current value is stored
away somewhere and the symbol  is given a new value for the duration of a 
certain context.
When the Lisp processor  leaves that context, the 
symbol's current value is thrown
away and its old value is restored.
.sp .5v
A symbol may also have a 
.i function 
.i binding .
This function binding is static; it cannot be lambda bound.
Whenever the symbol is used in the functional position of a Lisp expression
the function binding of the symbol is examined (see Chapter 4 for more
details on  evaluation).
.sp .5v
A symbol may also have a 
.i property 
.i list ,
another static data structure.
The property list consists of a list of an even number of elements,
considered to be grouped as pairs. 
The first element of the pair is the 
.i indicator 
the second the 
.i value 
of that indicator.
.sp .5v
Each symbol has a print name 
.i (pname) 
which is how this symbol is accessed from input and referred to
on  (printed) output.
.sp .5v
A symbol also has a hashlink used to link symbols together in the
oblist -- this field is inaccessible to the lisp user.
.sp .5v
Symbols are created by the reader and by the functions
.i concat ,
.i maknam
and their derivatives.
Most symbols live on 
.Fr 's
sole 
.i oblist ,
and therefore two symbols with the same print name are
usually the  exact same object (they are
.i eq ).
Symbols which are not on the oblist are said to be 
.i uninterned.
The function
.i maknam
creates uninterned symbols while 
.i concat
creates 
.i interned 
ones.
.(b
.TS
box center ; 
c | c | c |  c .
Subpart name	Get value	Set value	Type

=
value	eval	set	lispval
		setq
_
property	plist	setplist	list or nil
list	get	putprop	
		defprop	
_
function	getd	putd	array, binary, list
binding		def	or nil
_
print name	get_pname		string
_
hash link
.TE
.)b
.sh 3 list
A list cell has two parts, called the car and cdr.
List cells are created by the function 
.i cons .
.(b
.TS
box center ;
c | c | c | c .
Subpart name	Get value	Set value	Type

=
car	car	rplaca	lispval
_
cdr	cdr	rplacd	lispval
.TE
.)b
.sh 3 binary
This type acts as a function header for machine coded functions.
It has two parts, a pointer to the start of the function and a
symbol whose print name describes the 
argument
.i discipline .
The discipline (if 
.i lambda ,
.i macro 
or 
.i nlambda )
determines whether the arguments to this function will be evaluated
by the caller
before this function is called.
If the discipline is a string (specifically 
"\fIsubroutine\fP",
"\fIfunction\fP",
"\fIinteger-function\fP",
"\fIreal-function\fP",
"\fIc-function\fP",
"\fIdouble-c-function\fP",
or "\fIvector-c-function\fP"
)
then this function is
a foreign subroutine or function (see \(sc8.5 for more details on this).
Although the type of the 
.i entry 
field of a binary type object is usually \fBstring\fP or \fBother\fP,
the object pointed to
is actually a sequence of machine instructions.
.br
Objects of type binary are created by 
.i mfunction,
.i cfasl,
and
.i getaddress.
.(b
.TS
box center ;
c | c | c | c .
Subpart name	Get value	Set value	Type

=
entry	getentry		string or fixnum
_
discipline	getdisc	putdisc	symbol or fixnum
.TE
.)b
.sh 3 fixnum
A fixnum is an integer constant in the range \(mi2\*[31\*] to
2\*[31\*]\(mi1.
Small fixnums (-1024 to 1023) are stored in a special table so they needn't be
allocated each time one is needed.
In principle, the range for fixnums is machine dependent, although
all current implementations for franz have this range.
.sh 3 flonum
A flonum is a double precision real number. On the VAX,
the range is
\(+-2.9\(mu10\*[-37\*] to \(+-1.7\(mu10\*[38\*].
There are approximately sixteen decimal digits of precision.
Other machines may have other ranges.
.sh 3 bignum
A bignum is an integer of potentially unbounded size.
When integer arithmetic exceeds the limits of fixnums mentioned above,
the calculation is automatically done with bignums.
Should calculation with bignums give a result which can be represented
as a fixnum, then the fixnum representation will be used\*[\(dg\*].
.(f
\*[\(dg\*]The current algorithms for integer arithmetic operations will return
(in certain cases) a result 
between \(+-2\*[30\*] and 2\*[31\*] as a bignum although this
could be represented as a fixnum.
.)f
This contraction is known as
.i integer
.i normalization .
Many Lisp functions assume that integers are normalized.
Bignums are composed of a sequence of
.b list
cells and a cell known as an 
.b sdot.
The user should consider a 
.b bignum
structure indivisible and use functions such as
.i haipart ,
and 
.i bignum-leftshift
to extract parts of it.
.sh 3 string
A string is a null terminated sequence of characters.
Most functions of symbols which operate on the symbol's print name will
also work on strings.
The default reader syntax is set so that 
a sequence of characters surrounded by double quotes is a string.
.sh 3  port
A port is a structure which the system I/O routines can reference to
transfer data between the Lisp system and external media.
Unlike other Lisp objects there are a very limited number of ports (20).
Ports are allocated by 
.i infile 
and 
.i outfile 
and deallocated by 
.i close 
and 
.i resetio .
The 
.i print
function prints a port as a percent sign followed by the name of the file it
is connected to (if the port was opened by \fIfileopen, infile, or outfile\fP).
During initialization,
.Fr
binds the symbol \fBpiport\fP to a port attached to the standard input stream.
This port prints as %$stdin.
There are ports connected to the standard output and error streams,
which print as %$stdout and %$stderr.
This is discussed in more detail at the beginning of Chapter 5.
.sh 3 vector
Vectors are indexed sequences of data.
They can be used to implement a notion of user-defined types
via their associated property list.
They make \fBhunks\fP (see below) logically unnecessary, although hunks are very
efficiently garbage collected.
There is a second kind of vector, called an immediate-vector,
which stores binary data.
The name that the function \fItype\fP returns for immediate-vectors
is \fBvectori\fP.
Immediate-vectors could be used to implement strings and block-flonum arrays,
for example.
Vectors are discussed in chapter 9.
The functions
\fInew-vector\fP, and
\fIvector\fP, can
be used to create vectors.
.(b
.TS
box center ;
c | c | c | c .
Subpart name	Get value	Set value	Type

=
datum[\fIi\fP]	vref	vset	lispval
_
property	vprop	vsetprop	lispval
		vputprop
_
size	vsize	\-	fixnum
.TE
.)b
.sh 3 array
Arrays are rather complicated types and are fully described in
Chapter 9.
An array consists of a block of contiguous data, a function
to access that data, and auxiliary fields for use by the accessing
function.
Since an array's accessing function is created by the user, an array can
have any form the user chooses (e.g. n-dimensional, triangular, or hash
table).
.br
Arrays are created by the function
.i marray .
.(b
.TS
box center ;
c | c | c | c .
Subpart name	Get value	Set value	Type

=
access function	getaccess	putaccess	binary, list
			or symbol
_
auxiliary	getaux	putaux	lispval
_
data	arrayref	replace	block of contiguous
		set	lispval
_
length	getlength	putlength	fixnum
_
delta	getdelta	putdelta	fixnum
.TE
.)b
.sh 3 value
A value cell contains a pointer to a lispval.
This type is used mainly by arrays of general lisp objects.
Value cells are created with the 
.i ptr
function.
A value cell containing a pointer to the symbol `foo' is printed
as `(ptr\ to)foo'
.sh 3 hunk
A hunk is a vector of from 1 to 128 lispvals.
Once a hunk is created (by 
.i hunk 
or 
.i makhunk ) 
it cannot grow or shrink.
The access time for an element of a hunk is slower than a list cell element
but faster than an array.
Hunks are really only allocated in sizes which are powers of two, but 
can appear to the user to be any size in the 1 to 128 range.
Users of hunks must realize that \fI(not\ (atom\ 'lispval))\fP
will return true if 
.i lispval
is a hunk.
Most lisp systems do not have a direct test for a list cell and instead use
the above test and assume that 
a true result means 
.i lispval 
is a list cell.
In
.Fr
you can use
.i dtpr
to check for a list cell.
Although hunks are not list cells, you can still access the first two
hunk elements with 
.i cdr
and
.i car
and you can access any hunk element with
.i cxr \*[\(dg\*].
.(f
\*[\(dg\*]In a hunk, the function 
.i cdr
references the first element 
and 
.i car
the second.
.)f
You can set the value of the first two elements of a hunk with 
.i rplacd
and 
.i rplaca
and you can set the value of any element of the hunk with 
.i rplacx .
A hunk is printed by printing its contents surrounded by { and }.
However a hunk cannot be read in in this way in the standard lisp system.
It is easy to write a reader macro to do this if desired.
.sh 3 other
Occasionally, you can obtain a pointer to storage not allocated
by the lisp system.  One example of this is the entry field of
those
.Fr
functions written in C.  Such objects are classified as of type
\fBother\fP.
Foreign functions which call malloc to allocate their own space,
may also inadvertantly create such objects.
The garbage collector is supposed to ignore such objects.
.sh 2 Documentation Conventions.
The conventions used in the following chapters were designed to
give a great deal of information in a brief
space.
The first line of a function description contains the function
name in \fBbold\ face\fP and then lists the arguments, if any.
The arguments all have names which begin with a letter  or letters and 
an underscore.
The letter(s) gives the allowable type(s) for that argument according to
this table.
.(b
.TS
box center ;
c  | c 
l | l .
Letter	Allowable type(s)

=
g	any type
_
s	symbol (although nil may not be allowed)
_
t	string
_
l	list (although nil may be allowed)
_
n	number (fixnum, flonum, bignum)
_
i	integer (fixnum, bignum)
_
x	fixnum
_
b	bignum
_
f	flonum
_
u	function type (either binary or lambda body)
_
y	binary
_
v	vector
_
V	vectori
_
a	array
_
e	value
_
p	port (or nil)
_
h	hunk
.TE
.)b
In the first line of a function description,
those arguments preceded by a quote mark are evaluated (usually 
before the function is called).
The quoting convention is used so that we can give a name to the result of
evaluating the argument and we can describe the allowable types.
If an argument is not quoted it does not mean that that argument will
not be evaluated, but rather that 
if it is evaluated, the time at which it is evaluated
will be specifically mentioned in the function description.
Optional arguments are surrounded by square brackets.
An ellipsis (...) means zero or more occurrences of an argument of the 
directly preceding
type.
