If you are using g++, you will need to install the header files from
libg++.  The only other parts of libg++ used by groff are contained in
the files xyzzy.c and gnulib3.c; the libg++.a that I use contains only
xyzzy.o and gnulib3.o.  You don't need xyzzy.o unless you're using GNU
ld.

On a Sun 3 and other 68k machines, using libg++ 1.37.0 you will need
to apply the following change to g++-include/math.h:

*** math.h-	Sat Jan  6 14:09:52 1990
--- math.h	Tue Mar 13 02:07:01 1990
***************
*** 32,39 ****
  
  
  #ifdef __HAVE_68881__		/* MC68881/2 Floating-Point Coprocessor */
- #include <math-68881.h>
  extern "C" {			/* fill in what we've left out */
  
  double  acosh(double);
  double  asinh(double);
--- 32,39 ----
  
  
  #ifdef __HAVE_68881__		/* MC68881/2 Floating-Point Coprocessor */
  extern "C" {			/* fill in what we've left out */
+ #include <math-68881.h>
  
  double  acosh(double);
  double  asinh(double);

If you have bison 1.11, you will need to apply the following fix to
bison.simple if you want change any of the grammars:

*** bison.simple.~1~	Fri Aug 10 12:13:41 1990
--- bison.simple	Fri Aug 10 12:24:46 1990
***************
*** 20,26 ****
--- 20,28 ----
  
  
  #ifdef __GNUC__
+ #ifndef alloca
  #define alloca __builtin_alloca
+ #endif /* Not alloca. */
  #else /* Not GNU C.  */
  #if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__)
  #include <alloca.h>
***************
*** 114,123 ****
--- 116,129 ----
  /* This is the most reliable way to avoid incompatibilities
     in available built-in functions on various systems.  */
  static void
+ #ifdef __cplusplus
+ __yy_bcopy (char *from, char *to, int count)
+ #else
  __yy_bcopy (from, to, count)
       char *from;
       char *to;
       int count;
+ #endif
  {
    register char *f = from;
    register char *t = to;
***************
*** 127,133 ****
      *t++ = *f++;
  }
  
! #line 131 "/usr/local/lib/bison.simple"
  int
  yyparse()
  {
--- 133,139 ----
      *t++ = *f++;
  }
  
! #line 137 "/usr/local/lib/bison.simple"
  int
  yyparse()
  {

On a Sequent Symmetry S27 running Dynix 3.0.17, you'll need to use GNU
make or add 'MAKE=make' to Makefiles which use $(MAKE).  You'll also
need to change

  dev=${GROFF_TYPESETTER:-@DEVICE@}

to

  dev=$GROFF_TYPESETTER

in groff.sh.  You should use gcc to compile xditview.

You should only have to edit the top-level Makefile.  The comments
should make it clear what has to be changed.  If you don't have a
separate directory tree for local manual pages you can make
MAN[157]EXT be l (that's an ell) or n, and MANROOT be /usr/man.  The
changes you make to the top-level Makefile will be propagated to
sub-makes, but this won't happen if you invoke make in the
sub-directories.

You might also need to edit groff.sh.  This is a shell-script that
runs gtroff, an appropriate postprocessor and optionally various
preprocessors.  (Actually, the shell-script is created from groff.sh
by substituting for some variables surrounded by @s).  If your kernel
doesn't understand #!, you will need to arrange for the script to be
run by /bin/sh in some other way.

If you want to use existing troff drivers you should change groff.sh
so that it recognises them.  It is also a good idea to copy over the
dev* directory for the device into a directory that's only searched by
groff (eg /usr/local/lib/groff/font), so that you can take advantage
of the groff extensions to the DESC and font formats.  Groff only uses
the ASCII versions of the device files so you only need copy them.  If
you want to use GNU eqn, it is essential that the font files contain
correct height and depth information.  The format for this information
is described in the groff_font(5) page.  The best way to add this
information is to modify the program that generates the font files.
As a last resort you could try using the program addftinfo: it
attempts to guess plausible heights and depths.  To obtain good
results you would probably have to do more work on addftinfo.

To compile everything, just do a `make'.  If that works, then do a
`make install'.

If you have problems compiling pic/pic.tab.c or eqn/eqn.tab.c, you might
want to try using your system's yacc.  Set YACC=yacc in the top-level
Makefile, and also do

  mv pic/pic.tab.c pic/pic.tab.c.dist
  mv eqn/eqn.tab.c eqn/eqn.tab.c.dist

so that the parsers will be regenerated using yacc (the supplied
*.tab.[ch] files were generated by bison.)

If you want to install xditview, you'll need to do that separately.
Follow the instructions in xditview/INSTALL.

The dvi files produced by grodvi can use fonts at non-standard
magnifications.  You may need to compile fonts with Metafont at these
magnifications. The CompileFonts script in the dvi/devdvi directory
may help you to do this. (It will take a *long* time.)

If you have problems printing existing troff documents, read the
section on `Incompatbilities' in gtroff(1).  If you have existing
macro packages that are in the habit of omitting the space between a
macro or request and its arguments, it is good idea to produce a
version with spaces so that you can use it with groff (without having
to use the -C flag).  The file macros/fixmacros.sed is a sed script
which will attempt to edit a file of macros so that it can be used
with groff without the -C flag.

If you have the DWB 2.0 mm macros installed on your machine, you might
want to do a `make install.dwbmm'; this will copy the mm macros to
groff's macro directory and fix a few problems that occur when using
the DWB mm macros with groff; this requires the `patch' program.  If
the patch in macros/mm.diff is rejected, carefully apply it by hand.
If you do this make sure that TMAC_M=gm in the Makefile, so that the
groff mm macros are installed as -mgm.

You can share groff with a friend who has the same type of machine as
you, but does not have a C++ compiler.  First do `make bindist'; this
will create a subdirectory `bindist' containing a set of binaries, a
Makefile and a README.  If you want to strip the binaries, now do a
`make strip' in the bindist directory.  Rename the bindist directory
to something more meaningful, tar it up, and give to your friend along
with the original groff source distribution.  Your friend can then
install groff just by editing the Makefile in the bindist directory
and doing a make there; this will automatically install the non-binary
parts of the groff source distribution as well as the binaries from
the bindist directory.
