;
; Copyright (c) 1991 The Regents of the University of California.
; All rights reserved.
;
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
;
;	@(#)doctor.l	4.5 (Berkeley) 5/13/91
;

(eval-when (eval) (cvttomaclisp))
; these functions are franz only.
; to make doctor:
;   liszt -mr -o doctor doctor.l

(declare (special endtime starttime ticks float-format user topipe
		  user-top-level))

(defun mailbill ()
  (setq endtime (ptime)
	ticks  (difference (car endtime) (car starttime))
	user (getenv '|USER|)
	float-format "%.2f")
  (apply 'process (list (concat "//bin//mail " user)
		       'topipe
		       'frompipe))
  (msg (|P| topipe) "From the doctor" |N|
		  "To: " user |N|
  		  "Subject: bill for services" |N| |N|
  		  "Please remit $" (min 50. (quotient (times ticks 10000.0) 
					     (times 60 60 60)))
  			" for " (quotient ticks 60.0) " cpu seconds "
			|N|
			"       thank you, " |N|
			"           The doctor."
			|N|)
  (close topipe))

(DECLARE (SPECIAL TERMINAL LETTER WORD SENTENCE KEYSTACK TERMINALWIDTH 
		  CARRIAGERETURN RUBOUT LINEFEED FLAG PARSELIST 
		  RULES FLIPFLOP S D LINE)
	 (SPECIAL READTABLE)
	 (EVAL (READ)))

(PROG2  (SETSYNTAX #/' 2 ) 
	(SETSYNTAX #/; 2 )
	(setsyntax #/" 2)
	(setsyntax #/, 2)
	(setsyntax #/` 2)
	(setsyntax #/# 2)
	)






(DEFUN GOBBLE-LINES-OF-CHARS NIL
     (PROG (CH L)
      C    (SETQ CH (readc))
           (COND ((AND (EQ CH linefeed)
		       (SETQ L (CONS CH L))
		       (EQ (SETQ CH (readc)) linefeed))
		  (RETURN (NREVERSE (CONS CH L))))
		(t(SETQ L (CONS CH L))))
	   (GO C) ))


(DEFUN WORKER NIL
 (setq terminalwidth 72)
	(PROG (SENTENCE KEYSTACK)
	      (TERPRI)
	      (PRINC (QUOTE SPEAK/ UP!/ HIT/ 2/ RETURNS/ after/ typing))
	      (TERPRI)
	  A   (SETQ SENTENCE (SETQ KEYSTACK NIL))
	      (READIN)
	      (ANALYZE)
	      (TERPRI)
	      (TERPRI)
	      (GO A)) )
   






(DEFUN READIN NIL 
   (PROG (WORD LETTER FLAG TERMINAL LINE)
         (SETQ LINE (GOBBLE-LINES-OF-CHARS))
      A  (COND ((NULL (READWORD)) (GO B)))
         (MAKESENTENCE)
	 (SETKEYSTACK)
      B  (BREAKANALYZE)
	 (COND ((NOT FLAG) (GO A)))
	 (SETQ SENTENCE (NREVERSE SENTENCE)) ))

(DEFUN READWORD NIL 
 (PROG NIL
       (SETQ WORD NIL)
  A    (COND ((SETQ FLAG (GET (NEXTCH) (QUOTE BREAK)))
	      (RETURN (COND (WORD (SETQ WORD
					(IMPLODE (REVERSE WORD))))))))
       (SETQ WORD (CONS LETTER WORD))
       (GO A)))

(DEFUN MAKESENTENCE NIL 
 (SETQ SENTENCE
       (CONS (COND ((SETQ FLAG (GET WORD (QUOTE TRANSLATION)))
			    FLAG)
		   (WORD))
	     SENTENCE)))

(DEFUN SETKEYSTACK NIL 
 (COND ((AND (SETQ FLAG (GET WORD (QUOTE PRIORITY)))
	     KEYSTACK
	     (GREATERP FLAG
		       (GET (CAR KEYSTACK) (QUOTE PRIORITY))))
	(SETQ KEYSTACK (CONS WORD KEYSTACK)))
       (FLAG (SETQ KEYSTACK (APPEND KEYSTACK (LIST WORD))))))

(DEFUN BREAKANALYZE NIL 
 (COND ((EQ LETTER CARRIAGERETURN) (SETQ FLAG TERMINAL)
					(SETQ TERMINAL T))
       ((AND 	(SETQ FLAG (GET LETTER (QUOTE PUNCTUATION)))
		KEYSTACK)
		(GOBBLE))
       (FLAG (SETQ SENTENCE (SETQ FLAG NIL)))
       ((NOT (EQ LETTER LINEFEED))
	    (SETQ TERMINAL NIL))))

(DEFUN TEST (D S)
 (PROG NIL
  G    (COND ((NULL D)
	      (RETURN (COND ((NOT S)
			     (SETQ PARSELIST
				   (REVERSE PARSELIST))))))
	     ((NOT (COND ((NUMBERP (CAR D))
			  (COND ((ZEROP (CAR D)) (TEST5))
				((TEST3 (CAR D) NIL))))
			 ((TEST4 (CAR D)) (TEST2))))
	      (RETURN NIL)))
       (SETQ D (CDR D))
       (GO G)))

(DEFUN ADVANCE NIL 
     (RPLACA (CDAR RULES)
	     (COND ((NULL (CDADAR RULES)) (CDDAR RULES))
		   ((CDADAR RULES)))))

(DEFUN SENTPRINT (ANS)
       (PROG (N)
	  A0 (SETQ N 0)
	  A  (PRINC (CAR ANS))
	     (SETQ N (PLUS N (FLATSIZE (CAR ANS))))
	     (COND ((SETQ ANS (CDR ANS))
		    (COND ((GREATERP N TERMINALWIDTH)
			   (TERPRI) 
			   (GO A0))
			  ((PRINC (QUOTE / ))))
		    (GO A)))
	     (MEMORY)))

(DEFUN RECONSTRUCT (R)
     (COND ((NULL R) NIL)
	   ((NUMBERP (CAR R)) (APPEND (RECO1 (CAR R) PARSELIST)
				      (RECONSTRUCT (CDR R))))
	   ((CONS (CAR R) (RECONSTRUCT (CDR R))))))

(DEFUN GOBBLE NIL 
 (PROG NIL
      A	   (NEXTCH)
	   (BREAKANALYZE)
	   (COND ((NOT FLAG) (GO A)))))

(DEFUN NEXTCH NIL
	(SETQ LETTER (CAR LINE))
	(SETQ LINE (CDR LINE))
	LETTER)

(DEFUN TEST1 (PROPL X)
   (COND ((NULL PROPL) NIL)
	 ((GET X (CAR PROPL)) T)
		 ((TEST1 (CDR PROPL) X))))

(DEFUN TEST2 NIL 
  (PROG NIL
   (SETQ PARSELIST (CONS (LIST (CAR S)) PARSELIST))
   (SETQ S (CDR S))
   (RETURN T)))

(DEFUN TEST3 (X L)
	 (COND ((ZEROP X) (SETQ PARSELIST (CONS (REVERSE L) PARSELIST)))
	       (S (TEST3 (SUB1 X)
			 (CONS (CAR S) (PROG2 (SETQ S (CDR S)) L))))))

(DEFUN TEST4 (D)
     (COND ((NULL S) NIL)
	   ((ATOM D) (EQ D (CAR S)))
	   ((CAR D) (MEMBER (CAR S) D))
	   ((TEST1 (CDR D) (CAR S)))))

(DEFUN TEST5 NIL 
 (PROG (L)
       (COND ((NULL (CDR D)) (SETQ PARSELIST (CONS S PARSELIST))
			     (RETURN (NOT (SETQ S NIL)))))
  A    (COND ((TEST4 (CADR D))
	      (RETURN (SETQ PARSELIST
			    (CONS (REVERSE L) PARSELIST))))
	     ((AND (SETQ L (CONS (CAR S) L)) (SETQ S (CDR S)))
	      (GO A)))))

(DEFUN RECO1 (X P)
  (COND ((GREATERP X 1) 
	 (RECO1 (SUB1 X) (CDR P))) 
	((CAR P))))

(DEFUN ANALYZE NIL 
    (PROG (RULES PARSELIST DECOMP)
	(SETQ KEYSTACK
	      (APPEND KEYSTACK
		      (LIST (GET (QUOTE NONE)
				 (COND ((ZEROP (SETQ FLIPFLOP
						     (DIFFERENCE 2 FLIPFLOP)))
					(QUOTE MEM))
				       ((QUOTE LASTRESORT)))))))
   A	(SETQ RULES (GET (CAR KEYSTACK) (QUOTE RULES)))
   B	(SETQ DECOMP (CAAR (COND ((ATOM (CAR RULES))
				  (SETQ RULES (GET (CAR RULES) (QUOTE RULES))))
				 (RULES))))
	(SETQ PARSELIST NIL)
	(COND ((NOT (TEST DECOMP SENTENCE)) (SETQ RULES (CDR RULES)))
	      ((AND (NOT (ATOM (CAR (SETQ RULES (CAR (ADVANCE))))))
		    (NOT (EQ (CAAR RULES) (QUOTE PRE))))
	       (RETURN (SENTPRINT (RECONSTRUCT (CAR RULES)))))
	      ((NOT (ATOM (CAR RULES)))
	       (SETQ SENTENCE (RECONSTRUCT (CADAR RULES)))
	       (SETQ RULES (CDDAR RULES)))
	      ((EQ (CAR RULES) (QUOTE NEWKEY)) (SETQ KEYSTACK (CDR KEYSTACK))
					       (GO A)))
	(GO B)))


(DEFUN MEMORY NIL 
    ((LAMBDA (PARSELIST)
	     (AND (SETQ RULES (GET (CAR KEYSTACK) (QUOTE MEMR)))
		  (TEST (CAAR RULES) SENTENCE)
		  ((LAMBDA (X) (RPLACA X
				       (APPEND (CAR X)
					       (LIST (RECONSTRUCT (CAAR (ADVANCE)))))))
			(CDAR (GET (GET (QUOTE NONE) (QUOTE MEM)) (QUOTE RULES))))))
	NIL))


(COMMENT DOCTOR SET UP OF SOME INITIAL VALUES AND PROPERTIES)


(MAPC 	(QUOTE (LAMBDA (X) (PUTPROP (SET (CAR X) (ASCII (CADR X))) T (QUOTE BREAK))))
	(QUOTE ((RUBOUT 127.)
		(BLANK 32.)
		(CARRIAGERETURN 10.)
		(LINEFEED 10.)
		(HORIZONTALTAB 9.))))

(SETQ FLIPFLOP 0)

(MAPC 	(QUOTE (LAMBDA (X) 
		   (PUTPROP X T (QUOTE BREAK))
		   (PUTPROP X T (QUOTE PUNCTUATION))))
	(QUOTE (/. /, /( /) ! ? : /;)))


(COMMENT  DOCTOR SCRIPT - UPDATED TO /25 NOV /69)

(PUTPROP (QUOTE NONE)
	 ((LAMBDA (X)
		  (PUTPROP X 
			   (QUOTE (((0)
					(NIL)
					(I AM NOT SURE I UNDERSTAND YOU FULLY)
					(PLEASE GO ON)
					(WHAT DOES THAT SUGGEST TO YOU)
					(DO YOU FEEL STRONGLY ABOUT DISCUSSING SUCH THINGS))))
			   (QUOTE RULES))
		   X)
	   (GENSYM))
	 (QUOTE LASTRESORT))

(PUTPROP (QUOTE NONE)
	 ((LAMBDA (X)
		  (PUTPROP X 
			   (LIST  (LIST (LIST 0)
					(LIST NIL)
					(GET (QUOTE NONE)
					     (QUOTE LASTRESORT))))
			   (QUOTE RULES))
		  X)
	      (GENSYM))
	 (QUOTE MEM))



(DEFPROP SORRY 0 PRIORITY)

(DEFPROP SORRY
	 (((0) (NIL)
	       (PLEASE DON/'T APOLOGIZE)
	       (APOLOGIES ARE NOT NECESSARY)
	       (WHAT FEELINGS DO YOU HAVE WHEN YOU APOLOGIZE)
	       (I/'VE TOLD YOU THAT APOLOGIES ARE NOT REQUIRED)
	       (APOLOGIES ARE NOT NECESSARY/, PLEASE GO ON)))
	 RULES)

(DEFPROP DONT DON/'T TRANSLATION)

(DEFPROP CANT CAN/'T TRANSLATION)

(DEFPROP WONT WON/'T TRANSLATION)

(DEFPROP REMEMBER 5 PRIORITY)

(DEFPROP REMEMBER
	 (((0 YOU REMEMBER 0) (NIL)
			      (DO YOU OFTEN THINK OF 4)
			      (DOES THINKING OF 4 BRING ANYTHING ELSE TO MIND)
			      (WHAT ELSE DO YOU REMEMBER)
			      (WHY DO YOU REMEMBER 4 JUST NOW)
			      (WHAT IN THE PRESENT SITUATION REMINDS YOU OF 4)
			      (WHAT IS THE CONNECTION BETWEEN ME AND 4))
	  ((0 DO I REMEMBER 0) (NIL)
			       (DID YOU THINK I WOULD FORGET 5)
			       (WHY DO YOU THINK I SHOULD RECALL 5 NOW)
			       (WHAT ABOUT 5)
			       WHAT
			       (YOU MENTIONED 5))
	  ((0) (NIL) NEWKEY))
	 RULES)

(DEFPROP IF 3 PRIORITY)

(DEFPROP IF
	 (((0 IF 0 HAD 0) (NIL) (PRE (1 2 3 MIGHT HAVE 5) IF))
	  ((0 IF 0) (NIL)
		    (DO YOU THINK ITS LIKELY THAT 3)
		    (DO YOU WISH THAT 3)
		    (WHAT DO YOU THINK ABOUT 3)
		    (REALLY IF 3)))
	 RULES)

(DEFPROP DREAMT 4 PRIORITY)

(DEFPROP DREAMT
	 (((0 YOU DREAMT 0) (NIL)
			    (REALLY 4)
			    (HAVE YOU EVER FANTASIED 4 WHILE YOU WERE AWAKE)
			    (HAVE YOU DREAMT 4 BEFORE)
			    DREAM
			    NEWKEY)
	 ((0) (NIL) DREAM NEWKEY))
	 RULES)

(DEFPROP DREAMED DREAMT TRANSLATION)

(DEFPROP DREAMED 4 PRIORITY)

(DEFPROP DREAMED (DREAMT) RULES)

(DEFPROP DREAM 3 PRIORITY)

(DEFPROP DREAM
	 (((0)
	   (NIL)
	   (WHAT DOES THAT DREAM SUGGEST TO YOU)
	   (DO YOU DREAM OFTEN)
	   (WHAT PERSONS APPEAR IN YOUR DREAMS)
	   (DON/'T YOU BELIEVE THAT DREAM HAS SOMETHING TO DO WITH YOUR PROBLEM)
	   (DO YOU EVER WISH YOU COULD FLEE FROM REALITY)
	   NEWKEY))
	 RULES)

(DEFPROP DREAMS DREAM TRANSLATION)

(DEFPROP DREAMS 3 PRIORITY)

(DEFPROP DREAMS (DREAM) RULES)

(DEFPROP WHAT 0 PRIORITY)

(DEFPROP WHAT
	(((WHAT WHERE)
	  (NIL)
	  HOW)
	 ((0 (WHAT WHERE) 0)
	  (NIL)
	  (TELL ME ABOUT 2 3)
	  (2 3)
	  (DO YOU WANT ME TO TELL YOU 2 3)
	  (REALLY)
	  (I SEE)
	  NEWKEY))
	RULES)

(DEFPROP ALIKE 10. PRIORITY)

(DEFPROP ALIKE (DIT) RULES)

(DEFPROP SAME 10. PRIORITY)

(DEFPROP SAME (DIT) RULES)

(DEFPROP CERTAINLY 0 PRIORITY)

(DEFPROP CERTAINLY (YES) RULES)

(DEFPROP FEEL T BELIEF)

(DEFPROP THINK T BELIEF)

(DEFPROP BELIEVE T BELIEF)

(DEFPROP WISH T BELIEF)

(DEFPROP BET T BELIEF)

(DEFPROP MY
	 (((0 YOUR 1 0)
	   (NIL)
	   (EARLIER YOU SAID YOUR 3 4)
	   (BUT YOUR 3 4)
	   (DOES THAT HAVE ANYTHING TO DO WITH YOUR STATEMENT ABOUT 3 4)))
	 MEMR)



(DEFPROP PERHAPS 0 PRIORITY)

(DEFPROP PERHAPS
	 (((0) (NIL)
	       (YOU DON/'T SEEM QUITE CERTAIN)
	       (WHY THE UNCERTAIN TONE)
	       (CAN/'T YOU BE MORE POSITIVE)
	       (YOU AREN/'T SURE)
	       (DON/'T YOU KNOW)))
	 RULES)

(DEFPROP MAYBE 0 PRIORITY)

(DEFPROP MAYBE (PERHAPS) RULES)

(DEFPROP NAME 15. PRIORITY)

(DEFPROP NAME
	 (((0)
	   (NIL)
	   (I AM NOT INTERESTED IN NAMES)
	   (I/'VE TOLD YOU BEFORE I DON/'T CARE ABOUT NAMES /- PLEASE CONTINUE)))
	 RULES)

(DEFPROP DEUTSCH 0 PRIORITY)

(DEFPROP DEUTSCH (((0) (NIL) (I AM SORRY/, I SPEAK ONLY ENGLISH))) RULES)

(DEFPROP FRANCAIS 0 PRIORITY)

(DEFPROP FRANCAIS (DEUTSCH) RULES)

(DEFPROP SVENSKA 0 PRIORITY)

(DEFPROP SVENSKA (DEUTSCH) RULES)

(DEFPROP ITALIANO 0 PRIORITY)

(DEFPROP ITALIANO (DEUTSCH) RULES)

(DEFPROP ESPANOL 0 PRIORITY)

(DEFPROP ESPANOL (DEUTSCH) RULES)

(DEFPROP HELLO 0 PRIORITY)

(DEFPROP HELLO (((0) (NIL) (HOW DO YOU DO/. PLEASE STATE YOUR PROBLEM))) RULES)

(DEFPROP COMPUTER 50. PRIORITY)

(DEFPROP COMPUTER
	 (((0) (NIL)
	       (DO COMPUTERS WORRY YOU)
	       (WHY DO YOU MENTION COMPUTERS)
	       (WHAT DO YOU THINK MACHINES HAVE TO DO WITH YOUR PROBLEM)
	       (DON/'T YOU THINK COMPUTERS CAN HELP PEOPLE)
	       (WHAT ABOUT MACHINES WORRIES YOU)
	       (WHAT DO YOU THINK ABOUT MACHINES)))
	 RULES)

(DEFPROP MACHINE 50. PRIORITY)

(DEFPROP MACHINE (COMPUTER) RULES)

(DEFPROP MACHINES 50. PRIORITY)

(DEFPROP MACHINES (COMPUTER) RULES)

(DEFPROP COMPUTERS 50. PRIORITY)

(DEFPROP COMPUTERS (COMPUTER) RULES)

(DEFPROP AM 0 PRIORITY)

(DEFPROP AM ARE TRANSLATION)

(DEFPROP AM
	 (((0 ARE YOU 0) (NIL)
			 (DO YOU BELIEVE YOU ARE 4)
			 (WOULD YOU WANT TO BE 4)
			 (YOU WISH I WOULD TELL YOU YOU ARE 4)
			 (WHAT WOULD IT MEAN IF YOU WERE 4)
			 HOW)
	  ((0) (NIL) (WHY DO YOU SAY /'AM/') (I DON/'T UNDERSTAND THAT)))
	 RULES)

(DEFPROP ARE 0 PRIORITY)

(DEFPROP ARE
	 (((0 THERE ARE 0 YOU 0) (NIL) (PRE (1 2 3 4) ARE))
	  ((0 THERE ARE 1 0) (NIL)
			     (WHAT MAKES YOU THINK 2 3 4 5)
			     (DO YOU USUALLY CONSIDER 4 5)
			     (DO YOU WISH 2 WERE 4 5))
	  ((0 THERE ARE 0) (NIL) NEWKEY)
	  ((0 ARE I 0) (NIL)
		       (WHY ARE YOU INTERESTED IN WHETHER I AM 4 OR NOT)
		       (WOULD YOU PREFER IF I WEREN/'T 4)
		       (PERHAPS I AM 4 IN YOUR FANTASIES)
		       (DO YOU SOMETIMES THINK I AM 4)
		       HOW)
	  ((ARE 0) (NIL) HOW)
	  ((0 ARE 0) (NIL)
		     (DID YOU THINK THEY MIGHT NOT BE 3)
		     (WOULD YOU LIKE IT IF THEY WERE NOT 3)
		     (WHAT IF THEY WERE NOT 3)
		     (POSSIBLY THEY ARE 3)))
	 RULES)

(DEFPROP YOUR 0 PRIORITY)

(DEFPROP YOUR MY TRANSLATION)

(DEFPROP YOUR
	 (((0 MY 0) (NIL)
		    (WHY ARE YOU CONCERNED OVER MY 3)
		    (WHAT ABOUT YOUR OWN 3)
		    (ARE YOU WORRIED ABOUT SOMEONE ELSES 3)
		    (REALLY/, MY 3)))
	 RULES)

(DEFPROP WAS 2 PRIORITY)

(DEFPROP WAS
	 (((0 WAS YOU 0) (NIL)
			 (WHAT IF YOU WERE 4)
			 (DO YOU THINK YOU WERE 4)
			 (WERE YOU 4)
			 (WHAT WOULD IT MEAN IF YOU WERE 4)
			 (WHAT DOES /' 4 /' SUGGEST TO YOU)
			 HOW)
	  ((0 YOU WAS 0) (NIL)
			 (WERE YOU REALLY)
			 (WHY DO YOU TELL ME YOU WERE 4 NOW)
			 (PERHAPS I ALREADY KNEW YOU WERE 4))
	  ((0 WAS I 0) (NIL)
		       (WOULD YOU LIKE TO BELIEVE I WAS 4)
		       (WHAT SUGGESTS THAT I WAS 4)
		       (WHAT DO YOU THINK)
		       (PERHAPS I WAS 4)
		       (WHAT IF I HAD BEEN 4))
	  ((0) (NIL) NEWKEY))
	 RULES)

(DEFPROP WERE 0 PRIORITY)

(DEFPROP WERE WAS TRANSLATION)

(DEFPROP WERE (WAS) RULES)

(DEFPROP ME YOU TRANSLATION)

(DEFPROP YOU/'RE 0 PRIORITY)

(DEFPROP YOU/'RE I/'M TRANSLATION)

(DEFPROP YOU/'RE (((0 I/'M 0) (NIL) (PRE (I ARE 3) YOU))) RULES)

(DEFPROP I/'M 0 PRIORITY)

(DEFPROP I/'M YOU/'RE TRANSLATION)

(DEFPROP I/'M (((0 YOU/'RE 0) (NIL) (PRE (YOU ARE 3) I))) RULES)

(DEFPROP MYSELF YOURSELF TRANSLATION)

(DEFPROP YOURSELF MYSELF TRANSLATION)

(DEFPROP MOTHER T FAMILY)

(DEFPROP MOM MOTHER TRANSLATION)

(DEFPROP MOM T FAMILY)

(DEFPROP MOMMY MOTHER TRANSLATION)

(DEFPROP MOMMY T FAMILY)

(DEFPROP DAD FATHER TRANSLATION)

(DEFPROP DAD T FAMILY)

(DEFPROP FATHER T FAMILY)

(DEFPROP DADDY FATHER TRANSLATION)

(DEFPROP DADDY T FAMILY)

(DEFPROP SISTER T FAMILY)

(DEFPROP BROTHER T FAMILY)

(DEFPROP WIFE T FAMILY)

(DEFPROP CHILDREN T FAMILY)

(DEFPROP I 0 PRIORITY)

(DEFPROP I YOU TRANSLATION)

(DEFPROP I
	 (((0 YOU (WANT NEED) 0)
	   (NIL)
	   (WHAT WOULD IT MEAN TO YOU IF YOU GOT 4)
	   (WHY DO YOU WANT 4)
	   (SUPPOSE YOU GOT 4 SOON)
	   (WHAT IF YOU NEVER GOT 4)
	   (WHAT WOULD GETTING 4 MEAN TO YOU)
	   (WHAT DOES WANTING 4 HAVE TO DO WITH THIS DISCUSSION)
	   (YOU REALLY WANT 4)
	   (I SUSPECT YOU REALLY DON/'T WANT 4))
	  ((0 YOU ARE 0 (SAD UNHAPPY DEPRESSED SICK) 0)
	   (NIL)
	   (I AM SORRY TO HEAR YOU ARE 5)
	   (DO YOU THINK COMING HERE WILL HELP YOU NOT TO BE 5)
	   (I/'M SURE ITS NOT PLEASANT TO BE 5)
	   (CAN YOU EXPLAIN WHAT MADE YOU 5)
	   (PLEASE GO ON))
	  ((0 YOU ARE 0 (HAPPY ELATED GLAD BETTER) 0)
	   (NIL)
	   (HOW HAVE I HELPED YOU TO BE 5)
	   (HAS YOUR TREATMENT MADE YOU 5)
	   (WHAT MAKES YOU 5 JUST NOW)
	   (CAN YOU EXPLAIN WHY YOU ARE SUDDENLY 5)
	   (ARE YOU SURE)
	   (WHAT DO YOU MEAN BY 5))
	  ((0 YOU WAS 0) (NIL) WAS)
	  ((0 YOU (NIL BELIEF) YOU 0) (NIL)
				      (DO YOU REALLY THINK SO)
				      (BUT YOU ARE NOT SURE YOU 5)
				      (DO YOU REALLY DOUBT YOU 5))
	  ((0 YOU 0 (NIL BELIEF) 0 I 0) (NIL) YOU)
	  ((0 YOU ARE 0) (NIL)
			 (IS IT BECAUSE YOU ARE 4 THAT YOU CAME TO ME)
			 (HOW LONG HAVE YOU BEEN 4)
			 (DO YOU BELIEVE IT NORMAL TO BE 4)
			 (DO YOU ENJOY BEING 4))
	  ((0 YOU (CAN/'T CANNOT) 0) (NIL)
				    (HOW DO YOU KNOW YOU CAN/'T 4)
				    (HAVE YOU TRIED)
				    (PERHAPS YOU COULD 4 NOW)
				    (DO YOU REALLY WANT TO BE ABLE TO 4))
	  ((0 YOU DON/'T 0) (NIL)
			   (DON/'T YOU REALLY 4)
			   (WHY DON/'T YOU 4)
			   (DO YOU WISH TO BE ABLE TO 4)
			   (DOES THAT TROUBLE YOU))
	  ((0 YOU FEEL 0) (NIL)
			  (TELL ME MORE ABOUT SUCH FEELINGS)
			  (DO YOU OFTEN FEEL 4)
			  (DO YOU ENJOY FEELING 4)
			  (OF WHAT DOES FEELING 4 REMIND YOU))
	  ((0 YOU 0 I 0) (NIL)
			 (PERHAPS IN YOUR FANTASY WE 3 EACH OTHER)
			 (DO YOU WISH TO 3 ME)
			 (YOU SEEM TO NEED TO 3 ME)
			 (DO YOU 3 ANYONE ELSE))
	  ((0) (NIL)
	       (YOU SAY 1)
	       (CAN YOU ELABORATE ON THAT)
	       (DO YOU SAY 1 FOR SOME SPECIAL REASON)
	       (THAT/'S QUITE INTERESTING)))
	 RULES)

(DEFPROP YOU 0 PRIORITY)

(DEFPROP YOU I TRANSLATION)

(DEFPROP YOU
	 (((0 I REMIND YOU OF 0) (NIL) DIT)
	  ((0 I ARE 0 YOU 0) (NIL) NEWKEY)
	  ((0 I 0 ARE 0) (NIL)
			 (WHAT MAKES YOU THINK I AM 5)
			 (DOES IT PLEASE YOU TO BELIEVE I AM 5)
			 (PERHAPS YOU WOULD LIKE TO BE 5)
			 (DO YOU SOMETIMES WISH YOU WERE 5))
	  ((0 I 0 YOU) (NIL)
		       (WHY DO YOU THINK I 3 YOU)
		       (YOU LIKE TO THINK I 3 YOU /- DON/'T YOU)
		       (WHAT MAKES YOU THINK I 3 YOU)
		       (REALLY/, I 3 YOU)
		       (DO YOU WISH TO BELIEVE I 3 YOU)
		       (SUPPOSE I DID 3 YOU /- WHAT WOULD THAT MEAN)
		       (DOES SOMEONE ELSE BELIEVE I 3 YOU))
	  ((0 I 1 0) (NIL)
		     (WE WERE DISCUSSING YOU /- NOT ME)
		     (OH/, I 3 4)
		     (IS THIS REALLY RELEVANT TO YOUR PROBLEM)
		     (PERHAPS I DO 3 4)
		     (ARE YOU GLAD TO KNOW I 3 4)
		     (DO YOU 3 4)
		     (WHAT ARE YOUR FEELINGS NOW))
	  ((0) (NIL) NEWKEY))
	 RULES)

(DEFPROP WE YOU TRANSLATION)

(DEFPROP WE 0 PRIORITY)

(DEFPROP WE (I) RULES)

(DEFPROP XXYYZZ 0 PRIORITY)

(DEFPROP XXYYZZ
	 (((0) (NIL)
	       (YOURE BEING SOMEWHAT SHORT WITH ME)
	       (YOU DONT SEEM VERY TALKATIVE TODAY)
	       (PERHAPS YOUD RATHER TALK ABOUT SOMETHING ELSE)
	       (ARE YOU USING MONOSYLLABLES FOR SOME REASON)
	       NEWKEY))
	 RULES)

(DEFPROP YES 0 PRIORITY)

(DEFPROP YES
	 (((YES) (NIL) XXYYZZ (PRE (X YES) YES)) ((0) (NIL)
						      (YOU SEEM QUITE POSITIVE)
						      (YOU ARE SURE)
						      (I SEE)
						      (I UNDERSTAND)
						      NEWKEY))
	 RULES)

(DEFPROP NO 0 PRIORITY)

(DEFPROP NO
	 (((NO) (NIL) XXYYZZ (PRE (X NO) NO))
	  ((0) (NIL)
	       (ARE YOU SAYING /'NO/' JUST TO BE NEGATIVE)
	       (YOU ARE BEING A BIT NEGATIVE)
	       (WHY NOT)
	       (WHY /'NO/')
	       NEWKEY))
	 RULES)

(DEFPROP MY 2 PRIORITY)

(DEFPROP MY YOUR TRANSLATION)

(DEFPROP MY
	 (((0 YOUR 0 (NIL FAMILY) 0)
	   (NIL)
	   (TELL ME MORE ABOUT YOUR FAMILY)
	   (WHO ELSE IN YOUR FAMILY 5)
	   (YOUR 4)
	   (WHAT ELSE COMES TO MIND WHEN YOU THINK OF YOUR 4))
	  ((0 YOUR 1 0) (NIL)
			(YOUR 3 4)
			(WHY DO YOU SAY YOUR 3 4)
			(DOES THAT SUGGEST ANYTHING ELSE WHICH BELONGS TO YOU)
			(IS IT IMPORTANT TO YOU THAT YOUR 3 4))
	  ((0) (NIL) NEWKEY))
	 RULES)

(DEFPROP CAN 0 PRIORITY)

(DEFPROP CAN
	 (((0 CAN I 0) (NIL)
		       (YOU BELIEVE I CAN 4 DON/'T YOU)
			HOW
		       (YOU WANT ME TO BE ABLE TO 4)
		       (PERHAPS YOU WOULD LIKE TO BE ABLE TO 4 YOURSELF))
	  ((0 CAN YOU 0)
	   (NIL)
	   (WHETHER OR NOT YOU CAN 4 DEPENDS ON YOU MORE THAN ON ME)
	   (DO YOU WANT TO BE ABLE TO 4)
	   (PERHAPS YOU DON/'T WANT TO 4)
	   HOW)
	 ((0) (NIL) HOW NEWKEY))
	 RULES)

(DEFPROP IS 0 PRIORITY)

(DEFPROP IS
	 (((1 0 IS 1 0) (NIL)
			(SUPPOSE 1 2 WERE NOT 4 5)
			(PERHAPS 1 2 REALLY IS 4 5)
			(TELL ME MORE ABOUT 1 2))
	  ((0) (NIL) NEWKEY))
	 RULES)

(DEFPROP WHERE 0 PRIORITY)

(DEFPROP WHERE (HOW) RULES)

(DEFPROP HOW 0 PRIORITY)

(DEFPROP HOW
	 (((0) (NIL)
	       (WHY DO YOU ASK)
	       (DOES THAT QUESTION INTEREST YOU)
	       (WHAT IS IT YOU REALLY WANT TO KNOW)
	       (ARE SUCH QUESTIONS MUCH ON YOUR MIND)
	       (WHAT ANSWER WOULD PLEASE YOU MOST)
	       (WHAT DO YOU THINK)
	       (WHAT COMES TO YOUR MIND WHEN YOU ASK THAT)
	       (HAVE YOU ASKED SUCH QUESTIONS BEFORE)
	       (HAVE YOU ASKED ANYONE ELSE)))
	 RULES)

(DEFPROP BECAUSE 0 PRIORITY)

(DEFPROP BECAUSE
	 (((0) (NIL)
	       (IS THAT THE REAL REASON)
	       (DON/'T ANY OTHER REASONS COME TO MIND)
	       (DOES THAT REASON SEEM TO EXPLAIN ANYTHING ELSE)
	       (WHAT OTHER REASONS MIGHT THERE BE)
	       (YOU/'RE NOT CONCEALING ANYTHING FROM ME/, ARE YOU)))
	 RULES)

(DEFPROP WHY 0 PRIORITY)

(DEFPROP WHY
	 (((0 WHY DON/'T I 0) (NIL)
			     (DO YOU BELIEVE I DON/'T 5)
			     (PERHAPS I WILL 5 IN GOOD TIME)
			     (SHOULD YOU 5 YOURSELF)
			     (YOU WANT ME TO 5)
			     HOW)
	  ((0 WHY CAN/'T YOU 0) (NIL)
			       (DO YOU THINK YOU SHOULD BE ABLE TO 5)
			       (DO YOU WANT TO BE ABLE TO 5)
			       (DO YOU BELIEVE THIS WILL HELP YOU TO 5)
			       (HAVE YOU ANY IDEA WHY YOU CAN/'T 5)
			       HOW)
	 ((0) (NIL) (WHY INDEED) (WHY /'WHY/') (WHY NOT) HOW NEWKEY))
	 RULES)

(DEFPROP EVERYONE 2 PRIORITY)

(DEFPROP EVERYONE
	 (((0 (EVERYONE EVERYBODY NOBODY NOONE) 0)
	   (NIL)
	   (REALLY/, 2)
	   (SURELY NOT 2)
	   (CAN YOU THINK OF ANYONE IN PARTICULAR)
	   (WHO/, FOR EXAMPLE)
	   (YOU ARE THINKING OF A VERY SPECIAL PERSON)
	   (WHO/, MAY I ASK)
	   (SOMEONE SPECIAL PERHAPS)
	   (YOU HAVE A PARTICULAR PERSON IN MIND/, DON/'T YOU)
	   (WHO DO YOU THINK YOU/'RE TALKING ABOUT)
	   (I SUSPECT YOU/'RE EXAGGERATING A LITTLE)))
	 RULES)

(DEFPROP EVERYBODY 2 PRIORITY)

(DEFPROP EVERYBODY (EVERYONE) RULES)

(DEFPROP NOBODY 2 PRIORITY)

(DEFPROP NOBODY (EVERYONE) RULES)

(DEFPROP NOONE 2 PRIORITY)

(DEFPROP NOONE (EVERYONE) RULES)

(DEFPROP ALWAYS 1 PRIORITY)

(DEFPROP ALWAYS
	 (((0) (NIL)
	       (CAN YOU THINK OF A SPECIFIC EXAMPLE)
	       (WHEN)
	       (WHAT INCIDENT ARE YOU THINKING OF)
	       (REALLY/, ALWAYS)
	       (WHAT IF THIS NEVER HAPPENED)))
	 RULES)

(DEFPROP LIKE 10. PRIORITY)

(DEFPROP LIKE
	 (((0 (AM IS ARE WAS) 0 LIKE 0) (NIL) DIT) ((0) (NIL) NEWKEY))
	 RULES)

(DEFPROP DIT
	 (((0) (NIL)
	       (IN WHAT WAY)
	       (WHAT RESEMBLANCE DO YOU SEE)
	       (WHAT DOES THAT SIMILARITY SUGGEST TO YOU)
	       (WHAT OTHER CONNECTIONS DO YOU SEE)
	       (WHAT DO YOU SUPPOSE THAT RESEMBLANCE MEANS)
	       (WHAT IS THE CONNECTION/, DO YOU SUPPOSE)
	       (COULD THERE REALLY BE SOME CONNECTION)
	       (HOW)))
	 RULES)

(DEFPROP BAG 5 PRIORITY)

(DEFPROP BAG
	 (((0 (BITE BITES) THE BAG) (NIL)
				    (DO YOU SAY 1 2 3 4 FOR SOME SPECIAL REASON)
				    (WHAT MIGHT 1 HAVE TO DO WITH YOUR PROBLEM)
				    (DO YOU OFTEN SAY /' 2 3 4 /')
				    (PERHAPS YOU FEEL THAT YOU BITE 3 4))
	 ((0) (^IL) (WHY THE INTEREST IN BAGS) (PLEASE BE MORE SPECIFIC)
(YOU AREN/'T PULLING MY LEG ARE YOU) NEWKEY))
	 RULES)

(DEFPROP ZZYYXX (((0) (NIL) NEWKEY)) RULES)

(DEFPROP FUCK 55. PRIORITY)

(DEFPROP FUCK
	 (((0) (NIL)
	       (ARE SUCH OBSCENITIES FREQUENTLY ON YOUR MIND)
	       (YOU ARE BEING A BIT CHILDISH)
	       (REALLY NOW)
	       (DEAR ME)
	       (I REALLY SHOULDN/'T TOLERATE SUCH LANGUAGE)
	       NEWKEY))
	 RULES)

(DEFPROP SHIT 55. PRIORITY)

(DEFPROP SHIT (FUCK) RULES)

(DEFPROP CUNT 55. PRIORITY)

(DEFPROP CUNT (FUCK) RULES)

(DEFPROP PISS 55. PRIORITY)

(DEFPROP PISS (FUCK) RULES)

(DEFPROP BARF 0 PRIORITY)

(DEFPROP BARF (FUCK) RULES)

(DEFPROP DAMN 0 PRIORITY)

(DEFPROP DAMN (FUCK) RULES)

(DEFPROP HELL 0 PRIORITY)

(DEFPROP HELL (FUCK) RULES)

(DEFPROP SUCK 5 PRIORITY)

(DEFPROP SUCK (FUCK) RULES)

(DEFPROP SUCKS SUCK TRANSLATION)

(DEFPROP PROBLEM 5 PRIORITY)

(DEFPROP PROBLEM
	 (((0 (IS ARE) YOUR (PROBLEM PROBLEMS) 0) (NIL)
						  (1 2 YOUR 4)
						  (ARE YOU SURE 1 2 YOUR 4)
						  (PERHAPS 1 2 NOT YOUR REAL 4)
						  (YOU THINK YOU HAVE PROBLEMS)
						  (DO YOU OFTEN THINK ABOUT 1))
	  ((0 YOUR (PROBLEM PROBLEMS) (IS ARE) 0) (NIL)
						  (YOUR 2 3 4)
						  (ARE YOU SURE YOUR2 3 4)
						  (PERHAPS YOUR REAL 2 3 NOT 4)
						  (YOU THINK YOU HAVE PROBLEMS))
	  ((0) (NIL)
	       (PLEASE CONTINUE/, THIS MAY BE INTERESTING)
	       (HAVE YOU ANY OTHER PROBLEMS YOU WISH TO DISCUSS)
	       (PERHAPS YOU/'D RATHER CHANGE THE SUBJECT)
	       (YOU SEEM A BIT UNEASY)
	       NEWKEY))
	 RULES)

(DEFPROP PROBLEMS 5 PRIORITY)

(DEFPROP PROBLEMS (PROBLEM) RULES)

(DEFPROP PROBLEM
	 (((0 IS YOUR PROBLEM 0)
	   (NIL)
	   (EARLIER YOU MENTIONED 1)
	   (LET/'S TALK FURTHER ABOUT 1)
	   (TELL ME MORE ABOUT 1)
	   (YOU HAVEN/'T MENTIONED 1 FOR A WHILE)))
	 MEMR)

(DEFPROP PROBLEMS
	(((0 ARE YOU PROBLEMS)
	(NIL)
	(EARLIER YOU MENTIONED 1)
	(LET/'S TALK ABOUT 1)
	(TELL ME MORE ABOUT 1)
	(YOU HAVEN/'T MENTIONED 1 FOR A WHILE)))
	MEMR)

(DEFPROP CRAP 6 PRIORITY)

(DEFPROP CRAP (FUCK) RULES)

(DEFPROP ASK 0 PRIORITY)

(DEFPROP ASK
	(((0 YOU ASK 0)
	  (NIL)
	  HOW)
	 ((0 YOU 1 ASKING 0)
	  (NIL)
	  HOW)
	 ((0 I 0)
	  (NIL)
	  YOU)
	 ((0)
	  (NIL)
	  NEWKEY))
	RULES)



(defun top-level () (setq user-top-level nil starttime (ptime)) (worker))
(setq user-top-level (quote top-level))

(signal 2 (quote byebye))

(defun byebye (x)
  (terpri)(terpri)
  (princ (quote your/ bill/ will/ be/ in/ the/ mail ))
  (terpri)
  (mailbill)
  (exit))
