/*	@(#)test1.c	1.3 89/01/10 NFS Rev 2 Testsuite	*/
/*
 * Test file and directory creation.
 * Builds a tree on the server.
 *
 * Uses the following important system calls against the server:
 *
 *	chdir()
 *	mkdir()		(if creating directories, level > 1)
 *	creat()
 */

#include "tests.h"

int Tflag = 0;		/* print timing */
int Hflag = 0;		/* print help message */
int Sflag = 0;		/* don't print non-error messages */
int Fflag = 0;		/* test function only;  set count to 1, negate -t */
int Nflag = 0;		/* Suppress directory operations */

#ifdef ANSI
void usage(void);
void main(int argc, char *argv[]);
#endif

void
usage()
{
	fprintf(stdout, "usage: %s [-htfn] [levels files dirs fname dname]\n",
	    Myname);
	/* -s is a hidden option used by test2 */
	fprintf(stdout, "  Flags:  h    Help - print this usage info\n");
	fprintf(stdout, "          t    Print execution time statistics\n");
	fprintf(stdout, "          f    Test function only (negate -t)\n");
	fprintf(stdout, "          n    Suppress test directory create operations\n");
}

void
main(argc, argv)
	int argc;
	char *argv[];
{
	int files = DFILS;	/* number of files in each dir */
	int totfiles = 0;
	int dirs = DDIRS;	/* directories in each dir */
	int totdirs = 0;
	int levels = DLEVS;	/* levels deep */
	char *fname = FNAME;
	char *dname = DNAME;
	struct timeval time;
	char *opts;

	setbuf(stdout, NULL);
	Myname = *argv++;
	argc--;
	while (argc && **argv == '-') {
		for (opts = &argv[0][1]; *opts; opts++) {
			switch (*opts) {
				case 'h':	/* help */
					usage();
					exit(1);

				case 's':	/* silent */
					Sflag++;
					break;

				case 't':	/* time */
					Tflag++;
					break;

				case 'f':	/* funtionality */
					Fflag++;
					break;

				case 'n':	/* No Test Directory create */
					Nflag++;
					break;

				default:
					error("unknown option '%c'", *opts);
					usage();
					exit(1);
			}
		}
		argc--;
		argv++;
	}

	if (argc) {
		levels = (int) getparm(*argv, 1L, "levels");
		argv++;
		argc--;
	}
	if (argc) {
		files = (int) getparm(*argv, 0L, "files");
		argv++;
		argc--;
	}
	if (argc) {
		dirs = (int) getparm(*argv, 0L, "dirs");
		if (dirs == 0 && levels != 1) {
			error("Illegal dirs parameter, must be at least 1");
			exit(1);
		}
		argv++;
		argc--;
	}
	if (argc) {
		fname = *argv;
		argc--;
		argv++;
	}
	if (argc) {
		dname = *argv;
		argc--;
		argv++;
	}
	if (argc != 0) {
		error("too many parameters");
		usage();
		exit(1);
	}

	if (Fflag) {
		Tflag = 0;
		levels = 2;
		files = 2;
		dirs = 2;
	}

	if (!Sflag) {
		fprintf(stdout, "%s: File and directory creation test\n",
		    Myname);
	}

	if (!Nflag)
		testdir(NULL);
	else
		mtestdir(NULL);

	if (Tflag && !Sflag) {
		starttime();
	}
	dirtree(levels, files, dirs, fname, dname, &totfiles, &totdirs);
	if (Tflag && !Sflag) {
		endtime(&time);
	}
	if (!Sflag) {
		fprintf(stdout,
		    "\tcreated %d files %d directories %d levels deep",
		    totfiles, totdirs, levels);
	}
	if (Tflag && !Sflag) {
		printtimes(&time, 0L);
	}
	if (!Sflag) {
		fprintf(stdout, "\n");
	}
	complete();
}
