/*	@(#)stat2.c	1.1 88/10/12 NFS Rev 2 Testsuite	*/
/*
 * create a bunch of files and stat them repeatedly
 */

#include <tests.h>

int stats = 0;
int readdirs = 0;

#ifdef ANSI
void main(int argc, char *argv[]);
#endif

void
main(argc, argv)
	int argc;
	char *argv[];
{
	struct timeval stim, etim;
	float elapsed;
	int files, count;
	register int i, j;
	char name[256];
	struct stat statb;

	if (argc != 4) {
		fprintf(stderr, "usage: %s dir files count\n", argv[0]);
		exit(1);
	}

#ifdef DOS
	if (mkdir(argv[1]) < 0) {
#else
	if (mkdir(argv[1], CHMOD_YES) < 0) {
#endif
		perror(argv[1]);
	}
	unix_chdir(argv[1]);
	files = atoi(argv[2]);
	count = atoi(argv[3]);
	for (i=0; i<files; i++) {
		sprintf(name, "%d", i);
		close(creat(name, CHMOD_YES));
	}

	gettimeofday(&stim, 0);
	for (i=0; i<count; i++) {
		for (j=0; j<files; j++) {
			sprintf(name, "%d", i);
			stat(name, &statb);
			stats++;
		}
	}
	gettimeofday(&etim, 0);
	elapsed = (float) (etim.tv_sec - stim.tv_sec) +
	    (float)(etim.tv_usec - stim.tv_usec) / 1000000.0;
	if (elapsed == (float) 0.0)
		fprintf(stdout, "%d calls in 0 seconds\n", stats);
	else
		fprintf(stdout, "%d calls in %f seconds (%f calls/sec)\n",
			stats, elapsed, (float)stats / elapsed);
	exit(0);
}
