#ifndef lint
static char yysccsid[] = "@(#)yaccpar	1.8 (Berkeley) 01/20/90";
#endif
#define YYBYACC 1
#line 1 "/usr/src/usr.sbin/config/config.y"
typedef union {
	char	*str;
	int	val;
	struct	file_list *file;
	struct	idlst *lst;
} YYSTYPE;
#line 72 "/usr/src/usr.sbin/config/config.y"

/*
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)config.y	5.18 (Berkeley) 7/31/92
 */

#include "config.h"
#include <ctype.h>
#include <stdio.h>

struct	device cur;
struct	device *curp = 0;
char	*temp_id;
char	*val_id;

#line 59 "y.tab.c"
#define AND 257
#define ANY 258
#define ARGS 259
#define AT 260
#define BIO 261
#define COMMA 262
#define CONFIG 263
#define CONTROLLER 264
#define CPU 265
#define CSR 266
#define DEVICE 267
#define DISK 268
#define DRIVE 269
#define DRQ 270
#define DST 271
#define DUMPS 272
#define EQUALS 273
#define FLAGS 274
#define HZ 275
#define IDENT 276
#define IOMEM 277
#define IOSIZ 278
#define IRQ 279
#define MACHINE 280
#define MAJOR 281
#define MASTER 282
#define MAXUSERS 283
#define MINOR 284
#define MINUS 285
#define NET 286
#define NEXUS 287
#define ON 288
#define OPTIONS 289
#define MAKEOPTIONS 290
#define PORT 291
#define PRIORITY 292
#define PSEUDO_DEVICE 293
#define ROOT 294
#define SEMICOLON 295
#define SIZE 296
#define SLAVE 297
#define SWAP 298
#define TIMEZONE 299
#define TTY 300
#define TRACE 301
#define VECTOR 302
#define ID 303
#define NUMBER 304
#define FPNUMBER 305
#define YYERRCODE 256
short yylhs[] = {                                        -1,
    0,   12,   12,   13,   13,   13,   13,   13,   15,   15,
   15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
   15,   15,   15,   15,   15,   15,   15,   15,   18,   19,
   20,   20,   21,   21,   21,   21,   22,   27,   27,   28,
   11,   11,   23,    9,    9,   24,   10,   10,   25,    8,
    8,    7,   26,   26,    5,    5,    6,    6,    6,   16,
   16,   29,   29,    2,    2,    1,   17,   17,   30,    3,
   14,   14,   14,   14,   14,   14,   31,   34,   32,   32,
   35,   35,   36,   36,   37,   37,   37,   37,   37,   37,
   37,   37,   37,   37,   37,   37,   37,   33,   33,   33,
    4,    4,
};
short yylen[] = {                                         2,
    1,    2,    0,    2,    2,    2,    1,    2,    2,    2,
    2,    2,    2,    1,    2,    2,    4,    3,    2,    4,
    3,    3,    5,    4,    3,    5,    4,    2,    2,    2,
    2,    1,    1,    1,    1,    1,    3,    3,    1,    2,
    1,    1,    3,    1,    1,    3,    1,    1,    3,    1,
    1,    4,    1,    0,    2,    0,    1,    2,    3,    3,
    1,    1,    3,    1,    1,    1,    3,    1,    3,    1,
    4,    4,    4,    4,    3,    4,    3,    0,    2,    0,
    3,    3,    2,    0,    2,    2,    2,    2,    2,    2,
    2,    2,    2,    1,    1,    1,    2,    2,    2,    0,
    1,    2,
};
short yydefred[] = {                                      3,
    0,    0,    0,    0,   78,    0,   78,   78,    0,    0,
    0,   78,    0,    0,    0,   78,    7,    0,    0,    2,
    0,    0,   14,    0,    8,   66,   30,    0,    0,   10,
    0,    0,   15,   13,    9,    0,   28,    0,    0,   61,
    0,    0,   68,    0,    0,    0,    0,    6,    4,    5,
    0,    0,    0,    0,    0,   32,   33,   34,   35,   36,
    0,    0,   84,   70,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   53,    0,    0,
    0,    0,   31,    0,    0,    0,    0,   74,    0,   77,
   71,   73,   72,   64,   65,   63,   60,   69,   67,   76,
    0,    0,   17,   20,    0,    0,   50,   51,   49,   47,
   48,   46,   44,   45,   43,   41,   42,    0,    0,   39,
   82,   81,   99,    0,   98,   95,    0,    0,    0,    0,
    0,    0,    0,   96,    0,    0,   94,   83,   23,   26,
    0,    0,    0,   40,    0,  102,   85,   86,   89,   97,
   90,   91,   88,   93,   92,   87,    0,   59,   55,   38,
   52,
};
short yydgoto[] = {                                       1,
  106,   96,   65,  125,  144,  116,  117,  109,  115,  112,
  118,    2,   20,   21,   22,   39,   42,   23,   24,   55,
   56,   57,   58,   59,   60,   79,  119,  120,   40,   43,
   28,   62,   88,   29,   63,   89,  138,
};
short yysindex[] = {                                      0,
    0, -154, -282, -265,    0, -265,    0,    0, -269, -263,
 -265,    0, -241, -265, -265,    0,    0, -268, -226,    0,
 -223, -219,    0, -233,    0,    0,    0, -175, -215,    0,
 -175, -175,    0,    0,    0, -175,    0, -182, -162,    0,
 -161, -146,    0, -215, -285, -153, -152,    0,    0,    0,
 -165, -165, -165, -165, -233,    0,    0,    0,    0,    0,
 -272, -238,    0,    0, -179, -238, -238, -238, -261, -265,
 -261, -265, -167, -133, -131, -156, -155,    0, -275, -275,
 -275, -275,    0, -147, -144, -143, -265,    0, -115,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 -139, -138,    0,    0, -137, -136,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, -127, -107,    0,
    0,    0,    0, -265,    0,    0, -134, -132, -130, -129,
 -126, -125, -124,    0, -196, -123,    0,    0,    0,    0,
 -111, -145, -121,    0, -275,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, -120,    0,    0,    0,
    0,
};
short yyrindex[] = {                                      0,
    0,  177,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, -218,    0,    0,
 -218, -218,    0,    0,    0, -218,    0, -239, -109,    0,
    0, -108,    0,    0,    0, -106, -105,    0,    0,    0,
 -273, -273, -273, -273, -104,    0,    0,    0,    0,    0,
    0, -103,    0,    0,    0, -103, -103, -103,    0,    0,
    0,    0, -102, -101, -282, -100,  -99,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, -168,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  -98,  -97,    0,    0,    0, -245,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, -142, -250,    0,
    0,    0,    0,  -96,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, -199,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,
};
short yygindex[] = {                                      0,
   -4,  117,  -43,   77,    0,  -76,   25,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  145,    0,    0,    0,    0,   79,    0,   57,  133,  132,
   74,   58,   76,  189,    0,    0,    0,
};
#define YYTABLESIZE 205
short yytable[] = {                                      27,
   73,   30,  107,  110,  113,  105,   35,   54,   37,   38,
   41,   57,   25,   57,   84,   57,   45,   85,   74,   75,
   57,   37,   62,   57,   57,   51,   57,   26,   57,   54,
   64,   57,   57,   57,   33,   46,   47,   26,   52,   34,
   57,   94,   95,   37,   37,   57,   57,   37,   57,   57,
   57,   57,   57,   86,   57,   62,   57,   58,  155,   58,
   53,   58,   37,   87,   54,   38,   58,   41,   48,   58,
   58,   49,   58,   80,   58,   50,   80,   58,   58,   58,
   31,   32,  124,   80,   61,   36,   58,   64,   66,   67,
   69,   58,   58,   68,   58,   58,   58,   58,   58,   70,
   58,    3,   58,  108,  111,  114,   26,  154,    4,    5,
    6,   71,    7,    8,   56,   72,   56,   76,   77,  124,
    9,   10,   78,   79,   90,   11,   79,   12,   13,   56,
   80,   81,   82,   79,   14,   15,  100,  101,   16,  102,
   17,   91,   92,   93,   18,  126,   19,  103,  104,  145,
  127,   56,   56,  128,  129,   56,  121,  158,  130,  122,
  123,  131,  132,  133,  139,  140,  141,  142,  143,  147,
  134,  148,  157,  149,  150,  135,    1,  151,  152,  153,
  156,  136,  159,  161,  137,   11,   12,   98,   16,   19,
   29,  100,   75,   22,   18,   21,   24,   27,  101,   83,
  146,  160,   97,   99,   44,
};
short yycheck[] = {                                       4,
   44,    6,   79,   80,   81,  281,   11,  281,  259,   14,
   15,  257,  295,  259,  287,  261,  285,   61,  304,  305,
  266,  272,  262,  269,  270,  259,  272,  303,  274,  303,
  303,  277,  278,  279,  304,  304,  305,  303,  272,  303,
  286,  303,  304,  294,  295,  291,  292,  298,  294,  295,
  296,  297,  298,  292,  300,  295,  302,  257,  135,  259,
  294,  261,  304,  302,  298,   70,  266,   72,  295,  269,
  270,  295,  272,  292,  274,  295,  295,  277,  278,  279,
    7,    8,   87,  302,  260,   12,  286,  303,   31,   32,
  273,  291,  292,   36,  294,  295,  296,  297,  298,  262,
  300,  256,  302,   79,   80,   81,  303,  304,  263,  264,
  265,  273,  267,  268,  257,  262,  259,  271,  271,  124,
  275,  276,  288,  292,  304,  280,  295,  282,  283,  272,
   52,   53,   54,  302,  289,  290,  304,  271,  293,  271,
  295,   66,   67,   68,  299,  261,  301,  304,  304,  257,
  266,  294,  295,  269,  270,  298,  304,  303,  274,  304,
  304,  277,  278,  279,  304,  304,  304,  304,  296,  304,
  286,  304,  284,  304,  304,  291,    0,  304,  304,  304,
  304,  297,  304,  304,  300,  295,  295,   71,  295,  295,
  295,  295,  295,  295,  295,  295,  295,  295,  295,   55,
  124,  145,   70,   72,   16,
};
#define YYFINAL 1
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 305
#if YYDEBUG
char *yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"AND","ANY","ARGS","AT","BIO",
"COMMA","CONFIG","CONTROLLER","CPU","CSR","DEVICE","DISK","DRIVE","DRQ","DST",
"DUMPS","EQUALS","FLAGS","HZ","IDENT","IOMEM","IOSIZ","IRQ","MACHINE","MAJOR",
"MASTER","MAXUSERS","MINOR","MINUS","NET","NEXUS","ON","OPTIONS","MAKEOPTIONS",
"PORT","PRIORITY","PSEUDO_DEVICE","ROOT","SEMICOLON","SIZE","SLAVE","SWAP",
"TIMEZONE","TTY","TRACE","VECTOR","ID","NUMBER","FPNUMBER",
};
char *yyrule[] = {
"$accept : Configuration",
"Configuration : Many_specs",
"Many_specs : Many_specs Spec",
"Many_specs :",
"Spec : Device_spec SEMICOLON",
"Spec : Config_spec SEMICOLON",
"Spec : TRACE SEMICOLON",
"Spec : SEMICOLON",
"Spec : error SEMICOLON",
"Config_spec : MACHINE Save_id",
"Config_spec : CPU Save_id",
"Config_spec : OPTIONS Opt_list",
"Config_spec : MAKEOPTIONS Mkopt_list",
"Config_spec : IDENT ID",
"Config_spec : System_spec",
"Config_spec : HZ NUMBER",
"Config_spec : TIMEZONE NUMBER",
"Config_spec : TIMEZONE NUMBER DST NUMBER",
"Config_spec : TIMEZONE NUMBER DST",
"Config_spec : TIMEZONE FPNUMBER",
"Config_spec : TIMEZONE FPNUMBER DST NUMBER",
"Config_spec : TIMEZONE FPNUMBER DST",
"Config_spec : TIMEZONE MINUS NUMBER",
"Config_spec : TIMEZONE MINUS NUMBER DST NUMBER",
"Config_spec : TIMEZONE MINUS NUMBER DST",
"Config_spec : TIMEZONE MINUS FPNUMBER",
"Config_spec : TIMEZONE MINUS FPNUMBER DST NUMBER",
"Config_spec : TIMEZONE MINUS FPNUMBER DST",
"Config_spec : MAXUSERS NUMBER",
"System_spec : System_id System_parameter_list",
"System_id : CONFIG Save_id",
"System_parameter_list : System_parameter_list System_parameter",
"System_parameter_list : System_parameter",
"System_parameter : swap_spec",
"System_parameter : root_spec",
"System_parameter : dump_spec",
"System_parameter : arg_spec",
"swap_spec : SWAP optional_on swap_device_list",
"swap_device_list : swap_device_list AND swap_device",
"swap_device_list : swap_device",
"swap_device : swap_device_spec optional_size",
"swap_device_spec : device_name",
"swap_device_spec : major_minor",
"root_spec : ROOT optional_on root_device_spec",
"root_device_spec : device_name",
"root_device_spec : major_minor",
"dump_spec : DUMPS optional_on dump_device_spec",
"dump_device_spec : device_name",
"dump_device_spec : major_minor",
"arg_spec : ARGS optional_on arg_device_spec",
"arg_device_spec : device_name",
"arg_device_spec : major_minor",
"major_minor : MAJOR NUMBER MINOR NUMBER",
"optional_on : ON",
"optional_on :",
"optional_size : SIZE NUMBER",
"optional_size :",
"device_name : Save_id",
"device_name : Save_id NUMBER",
"device_name : Save_id NUMBER ID",
"Opt_list : Opt_list COMMA Option",
"Opt_list : Option",
"Option : Save_id",
"Option : Save_id EQUALS Opt_value",
"Opt_value : ID",
"Opt_value : NUMBER",
"Save_id : ID",
"Mkopt_list : Mkopt_list COMMA Mkoption",
"Mkopt_list : Mkoption",
"Mkoption : Save_id EQUALS Opt_value",
"Dev : ID",
"Device_spec : DEVICE Dev_name Dev_info Int_spec",
"Device_spec : MASTER Dev_name Dev_info Int_spec",
"Device_spec : DISK Dev_name Dev_info Int_spec",
"Device_spec : CONTROLLER Dev_name Dev_info Int_spec",
"Device_spec : PSEUDO_DEVICE Init_dev Dev",
"Device_spec : PSEUDO_DEVICE Init_dev Dev NUMBER",
"Dev_name : Init_dev Dev NUMBER",
"Init_dev :",
"Dev_info : Con_info Info_list",
"Dev_info :",
"Con_info : AT Dev NUMBER",
"Con_info : AT NEXUS NUMBER",
"Info_list : Info_list Info",
"Info_list :",
"Info : CSR NUMBER",
"Info : DRIVE NUMBER",
"Info : SLAVE NUMBER",
"Info : IRQ NUMBER",
"Info : DRQ NUMBER",
"Info : IOMEM NUMBER",
"Info : IOSIZ NUMBER",
"Info : PORT device_name",
"Info : PORT NUMBER",
"Info : TTY",
"Info : BIO",
"Info : NET",
"Info : FLAGS NUMBER",
"Int_spec : VECTOR Id_list",
"Int_spec : PRIORITY NUMBER",
"Int_spec :",
"Id_list : Save_id",
"Id_list : Save_id Id_list",
};
#endif
#define yyclearin (yychar=(-1))
#define yyerrok (yyerrflag=0)
#ifdef YYSTACKSIZE
#ifndef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#endif
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 500
#define YYMAXDEPTH 500
#endif
#endif
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short yyss[YYSTACKSIZE];
YYSTYPE yyvs[YYSTACKSIZE];
#define yystacksize YYSTACKSIZE
#line 547 "/usr/src/usr.sbin/config/config.y"

yyerror(s)
	char *s;
{

	fprintf(stderr, "config: line %d: %s\n", yyline + 1, s);
}

/*
 * return the passed string in a new space
 */
char *
ns(str)
	register char *str;
{
	register char *cp;

	cp = malloc((unsigned)(strlen(str)+1));
	(void) strcpy(cp, str);
	return (cp);
}

/*
 * add a device to the list of devices
 */
newdev(dp)
	register struct device *dp;
{
	register struct device *np;

	np = (struct device *) malloc(sizeof *np);
	*np = *dp;
	np->d_next = 0;
	if (curp == 0)
		dtab = np;
	else
		curp->d_next = np;
	curp = np;
}

/*
 * note that a configuration should be made
 */
mkconf(sysname)
	char *sysname;
{
	register struct file_list *fl, **flp;

	fl = (struct file_list *) malloc(sizeof *fl);
	fl->f_type = SYSTEMSPEC;
	fl->f_needs = sysname;
	fl->f_rootdev = NODEV;
	fl->f_dumpdev = NODEV;
	fl->f_fn = 0;
	fl->f_next = 0;
	for (flp = confp; *flp; flp = &(*flp)->f_next)
		;
	*flp = fl;
	confp = flp;
}

struct file_list *
newswap()
{
	struct file_list *fl = (struct file_list *)malloc(sizeof (*fl));

	fl->f_type = SWAPSPEC;
	fl->f_next = 0;
	fl->f_swapdev = NODEV;
	fl->f_swapsize = 0;
	fl->f_needs = 0;
	fl->f_fn = 0;
	return (fl);
}

/*
 * Add a swap device to the system's configuration
 */
mkswap(system, fl, size)
	struct file_list *system, *fl;
	int size;
{
	register struct file_list **flp;
	char name[80];

	if (system == 0 || system->f_type != SYSTEMSPEC) {
		yyerror("\"swap\" spec precedes \"config\" specification");
		return;
	}
	if (size < 0) {
		yyerror("illegal swap partition size");
		return;
	}
	/*
	 * Append swap description to the end of the list.
	 */
	flp = &system->f_next;
	for (; *flp && (*flp)->f_type == SWAPSPEC; flp = &(*flp)->f_next)
		;
	fl->f_next = *flp;
	*flp = fl;
	fl->f_swapsize = size;
	/*
	 * If first swap device for this system,
	 * set up f_fn field to insure swap
	 * files are created with unique names.
	 */
	if (system->f_fn)
		return;
	if (eq(fl->f_fn, "generic"))
		system->f_fn = ns(fl->f_fn);
	else
		system->f_fn = ns(system->f_needs);
}

/*
 * find the pointer to connect to the given device and number.
 * returns 0 if no such device and prints an error message
 */
struct device *
connect(dev, num)
	register char *dev;
	register int num;
{
	register struct device *dp;
	struct device *huhcon();

	if (num == QUES)
		return (huhcon(dev));
	for (dp = dtab; dp != 0; dp = dp->d_next) {
		if ((num != dp->d_unit) || !eq(dev, dp->d_name))
			continue;
		if (dp->d_type != CONTROLLER && dp->d_type != MASTER) {
			(void) sprintf(errbuf,
			    "%s connected to non-controller", dev);
			yyerror(errbuf);
			return (0);
		}
		return (dp);
	}
	(void) sprintf(errbuf, "%s %d not defined", dev, num);
	yyerror(errbuf);
	return (0);
}

/*
 * connect to an unspecific thing
 */
struct device *
huhcon(dev)
	register char *dev;
{
	register struct device *dp, *dcp;
	struct device rdev;
	int oldtype;

	/*
	 * First make certain that there are some of these to wildcard on
	 */
	for (dp = dtab; dp != 0; dp = dp->d_next)
		if (eq(dp->d_name, dev))
			break;
	if (dp == 0) {
		(void) sprintf(errbuf, "no %s's to wildcard", dev);
		yyerror(errbuf);
		return (0);
	}
	oldtype = dp->d_type;
	dcp = dp->d_conn;
	/*
	 * Now see if there is already a wildcard entry for this device
	 * (e.g. Search for a "uba ?")
	 */
	for (; dp != 0; dp = dp->d_next)
		if (eq(dev, dp->d_name) && dp->d_unit == -1)
			break;
	/*
	 * If there isn't, make one because everything needs to be connected
	 * to something.
	 */
	if (dp == 0) {
		dp = &rdev;
		init_dev(dp);
		dp->d_unit = QUES;
		dp->d_name = ns(dev);
		dp->d_type = oldtype;
		newdev(dp);
		dp = curp;
		/*
		 * Connect it to the same thing that other similar things are
		 * connected to, but make sure it is a wildcard unit
		 * (e.g. up connected to sc ?, here we make connect sc? to a
		 * uba?).  If other things like this are on the NEXUS or
		 * if they aren't connected to anything, then make the same
		 * connection, else call ourself to connect to another
		 * unspecific device.
		 */
		if (dcp == TO_NEXUS || dcp == 0)
			dp->d_conn = dcp;
		else
			dp->d_conn = connect(dcp->d_name, QUES);
	}
	return (dp);
}

init_dev(dp)
	register struct device *dp;
{

	dp->d_name = "OHNO!!!";
	dp->d_type = DEVICE;
	dp->d_conn = 0;
	dp->d_vec = 0;
	dp->d_addr = dp->d_flags = dp->d_dk = 0;
	dp->d_pri = -1;
	dp->d_slave = dp->d_drive = dp->d_unit = UNKNOWN;
	dp->d_port = (char *)0;
	dp->d_portn = 0;
	dp->d_irq = -1;
	dp->d_drq = -1;
	dp->d_maddr = 0;
	dp->d_msize = 0;
	dp->d_mask = "null";
}

/*
 * make certain that this is a reasonable type of thing to connect to a nexus
 */
check_nexus(dev, num)
	register struct device *dev;
	int num;
{

	switch (machine) {

	case MACHINE_VAX:
		if (!eq(dev->d_name, "uba") && !eq(dev->d_name, "mba") &&
		    !eq(dev->d_name, "bi"))
			yyerror("only uba's, mba's, and bi's should be connected to the nexus");
		if (num != QUES)
			yyerror("can't give specific nexus numbers");
		break;

	case MACHINE_TAHOE:
		if (!eq(dev->d_name, "vba")) 
			yyerror("only vba's should be connected to the nexus");
		break;

	case MACHINE_HP300:
	case MACHINE_LUNA68K:
		if (num != QUES)
			dev->d_addr = num;
		break;

	case MACHINE_I386:
		if (!eq(dev->d_name, "isa"))
			yyerror("only isa's should be connected to the nexus");
		break;

	case MACHINE_NEWS3400:
		if (!eq(dev->d_name, "iop") && !eq(dev->d_name, "hb") &&
		    !eq(dev->d_name, "vme"))
			yyerror("only iop's, hb's and vme's should be connected to the nexus");
		break;
	}
}

/*
 * Check the timezone to make certain it is sensible
 */

check_tz()
{
	if (abs(zone) > 12 * 60)
		yyerror("timezone is unreasonable");
	else
		hadtz = 1;
}

/*
 * Check system specification and apply defaulting
 * rules on root, argument, dump, and swap devices.
 */
checksystemspec(fl)
	register struct file_list *fl;
{
	char buf[BUFSIZ];
	register struct file_list *swap;
	int generic;

	if (fl == 0 || fl->f_type != SYSTEMSPEC) {
		yyerror("internal error, bad system specification");
		exit(1);
	}
	swap = fl->f_next;
	generic = swap && swap->f_type == SWAPSPEC && eq(swap->f_fn, "generic");
	if (fl->f_rootdev == NODEV && !generic) {
		yyerror("no root device specified");
		exit(1);
	}
	/*
	 * Default swap area to be in 'b' partition of root's
	 * device.  If root specified to be other than on 'a'
	 * partition, give warning, something probably amiss.
	 */
	if (swap == 0 || swap->f_type != SWAPSPEC) {
		dev_t dev;

		swap = newswap();
		dev = fl->f_rootdev;
		if (minor(dev) & 07) {
			(void) sprintf(buf, 
"Warning, swap defaulted to 'b' partition with root on '%c' partition",
				(minor(dev) & 07) + 'a');
			yyerror(buf);
		}
		swap->f_swapdev =
		   makedev(major(dev), (minor(dev) &~ 07) | ('b' - 'a'));
		swap->f_fn = devtoname(swap->f_swapdev);
		mkswap(fl, swap, 0);
	}
	/*
	 * Make sure a generic swap isn't specified, along with
	 * other stuff (user must really be confused).
	 */
	if (generic) {
		if (fl->f_rootdev != NODEV)
			yyerror("root device specified with generic swap");
		if (fl->f_dumpdev != NODEV)
			yyerror("dump device specified with generic swap");
		return;
	}
	/*
	 * Default dump device and warn if place is not a
	 * swap area.
	 */
	if (fl->f_dumpdev == NODEV)
		fl->f_dumpdev = swap->f_swapdev;
	if (fl->f_dumpdev != swap->f_swapdev) {
		struct file_list *p = swap->f_next;

		for (; p && p->f_type == SWAPSPEC; p = p->f_next)
			if (fl->f_dumpdev == p->f_swapdev)
				return;
		(void) sprintf(buf,
		    "Warning: dump device is not a swap partition");
		yyerror(buf);
	}
}

/*
 * Verify all devices specified in the system specification
 * are present in the device specifications.
 */
verifysystemspecs()
{
	register struct file_list *fl;
	dev_t checked[50], *verifyswap();
	register dev_t *pchecked = checked;

	for (fl = conf_list; fl; fl = fl->f_next) {
		if (fl->f_type != SYSTEMSPEC)
			continue;
		if (!finddev(fl->f_rootdev))
			deverror(fl->f_needs, "root");
		*pchecked++ = fl->f_rootdev;
		pchecked = verifyswap(fl->f_next, checked, pchecked);
#define	samedev(dev1, dev2) \
	((minor(dev1) &~ 07) != (minor(dev2) &~ 07))
		if (!alreadychecked(fl->f_dumpdev, checked, pchecked)) {
			if (!finddev(fl->f_dumpdev))
				deverror(fl->f_needs, "dump");
			*pchecked++ = fl->f_dumpdev;
		}
	}
}

/*
 * Do as above, but for swap devices.
 */
dev_t *
verifyswap(fl, checked, pchecked)
	register struct file_list *fl;
	dev_t checked[];
	register dev_t *pchecked;
{

	for (;fl && fl->f_type == SWAPSPEC; fl = fl->f_next) {
		if (eq(fl->f_fn, "generic"))
			continue;
		if (alreadychecked(fl->f_swapdev, checked, pchecked))
			continue;
		if (!finddev(fl->f_swapdev))
			fprintf(stderr,
			   "config: swap device %s not configured", fl->f_fn);
		*pchecked++ = fl->f_swapdev;
	}
	return (pchecked);
}

/*
 * Has a device already been checked
 * for it's existence in the configuration?
 */
alreadychecked(dev, list, last)
	dev_t dev, list[];
	register dev_t *last;
{
	register dev_t *p;

	for (p = list; p < last; p++)
		if (samedev(*p, dev))
			return (1);
	return (0);
}

deverror(systemname, devtype)
	char *systemname, *devtype;
{

	fprintf(stderr, "config: %s: %s device not configured\n",
		systemname, devtype);
}

/*
 * Look for the device in the list of
 * configured hardware devices.  Must
 * take into account stuff wildcarded.
 */
/*ARGSUSED*/
finddev(dev)
	dev_t dev;
{

	/* punt on this right now */
	return (1);
}
#line 841 "y.tab.c"
#define YYABORT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
yyparse()
{
    register int yym, yyn, yystate;
#if YYDEBUG
    register char *yys;
    extern char *getenv();

    if (yys = getenv("YYDEBUG"))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if (yyn = yydefred[yystate]) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, reading %d (%s)\n", yystate,
                    yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: state %d, shifting to state %d\n",
                    yystate, yytable[yyn]);
#endif
        if (yyssp >= yyss + yystacksize - 1)
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#ifdef lint
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#ifdef lint
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: state %d, error recovery shifting\
 to state %d\n", *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yyss + yystacksize - 1)
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: error recovery discarding state %d\n",
                            *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, error recovery discards token %d (%s)\n",
                    yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("yydebug: state %d, reducing by rule %d (%s)\n",
                yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 1:
#line 121 "/usr/src/usr.sbin/config/config.y"
 { verifysystemspecs(); }
break;
case 4:
#line 132 "/usr/src/usr.sbin/config/config.y"
 { newdev(&cur); }
break;
case 6:
#line 136 "/usr/src/usr.sbin/config/config.y"
 { do_trace = !do_trace; }
break;
case 9:
#line 144 "/usr/src/usr.sbin/config/config.y"
 {
		if (!strcmp(yyvsp[0].str, "vax")) {
			machine = MACHINE_VAX;
			machinename = "vax";
		} else if (!strcmp(yyvsp[0].str, "tahoe")) {
			machine = MACHINE_TAHOE;
			machinename = "tahoe";
		} else if (!strcmp(yyvsp[0].str, "hp300")) {
			machine = MACHINE_HP300;
			machinename = "hp300";
		} else if (!strcmp(yyvsp[0].str, "i386")) {
			machine = MACHINE_I386;
			machinename = "i386";
		} else if (!strcmp(yyvsp[0].str, "mips")) {
			machine = MACHINE_MIPS;
			machinename = "mips";
		} else if (!strcmp(yyvsp[0].str, "pmax")) {
			machine = MACHINE_PMAX;
			machinename = "pmax";
		} else if (!strcmp(yyvsp[0].str, "luna68k")) {
			machine = MACHINE_LUNA68K;
			machinename = "luna68k";
		} else if (!strcmp(yyvsp[0].str, "news3400")) {
			machine = MACHINE_NEWS3400;
			machinename = "news3400";
		} else
			yyerror("Unknown machine type");
	      }
break;
case 10:
#line 173 "/usr/src/usr.sbin/config/config.y"
 {
		struct cputype *cp =
		    (struct cputype *)malloc(sizeof (struct cputype));
		cp->cpu_name = ns(yyvsp[0].str);
		cp->cpu_next = cputype;
		cputype = cp;
		free(temp_id);
	      }
break;
case 13:
#line 186 "/usr/src/usr.sbin/config/config.y"
 { ident = ns(yyvsp[0].str); }
break;
case 15:
#line 190 "/usr/src/usr.sbin/config/config.y"
 { hz = yyvsp[0].val; }
break;
case 16:
#line 192 "/usr/src/usr.sbin/config/config.y"
 { zone = 60 * yyvsp[0].val; check_tz(); }
break;
case 17:
#line 194 "/usr/src/usr.sbin/config/config.y"
 { zone = 60 * yyvsp[-2].val; dst = yyvsp[0].val; check_tz(); }
break;
case 18:
#line 196 "/usr/src/usr.sbin/config/config.y"
 { zone = 60 * yyvsp[-1].val; dst = 1; check_tz(); }
break;
case 19:
#line 198 "/usr/src/usr.sbin/config/config.y"
 { zone = yyvsp[0].val; check_tz(); }
break;
case 20:
#line 200 "/usr/src/usr.sbin/config/config.y"
 { zone = yyvsp[-2].val; dst = yyvsp[0].val; check_tz(); }
break;
case 21:
#line 202 "/usr/src/usr.sbin/config/config.y"
 { zone = yyvsp[-1].val; dst = 1; check_tz(); }
break;
case 22:
#line 204 "/usr/src/usr.sbin/config/config.y"
 { zone = -60 * yyvsp[0].val; check_tz(); }
break;
case 23:
#line 206 "/usr/src/usr.sbin/config/config.y"
 { zone = -60 * yyvsp[-2].val; dst = yyvsp[0].val; check_tz(); }
break;
case 24:
#line 208 "/usr/src/usr.sbin/config/config.y"
 { zone = -60 * yyvsp[-1].val; dst = 1; check_tz(); }
break;
case 25:
#line 210 "/usr/src/usr.sbin/config/config.y"
 { zone = -yyvsp[0].val; check_tz(); }
break;
case 26:
#line 212 "/usr/src/usr.sbin/config/config.y"
 { zone = -yyvsp[-2].val; dst = yyvsp[0].val; check_tz(); }
break;
case 27:
#line 214 "/usr/src/usr.sbin/config/config.y"
 { zone = -yyvsp[-1].val; dst = 1; check_tz(); }
break;
case 28:
#line 216 "/usr/src/usr.sbin/config/config.y"
 { maxusers = yyvsp[0].val; }
break;
case 29:
#line 220 "/usr/src/usr.sbin/config/config.y"
 { checksystemspec(*confp); }
break;
case 30:
#line 225 "/usr/src/usr.sbin/config/config.y"
 { mkconf(yyvsp[0].str); }
break;
case 40:
#line 251 "/usr/src/usr.sbin/config/config.y"
 { mkswap(*confp, yyvsp[-1].file, yyvsp[0].val); }
break;
case 41:
#line 256 "/usr/src/usr.sbin/config/config.y"
 {
			struct file_list *fl = newswap();

			if (eq(yyvsp[0].str, "generic"))
				fl->f_fn = yyvsp[0].str;
			else {
				fl->f_swapdev = nametodev(yyvsp[0].str, 0, 'b');
				fl->f_fn = devtoname(fl->f_swapdev);
			}
			yyval.file = fl;
		}
break;
case 42:
#line 268 "/usr/src/usr.sbin/config/config.y"
 {
			struct file_list *fl = newswap();

			fl->f_swapdev = yyvsp[0].val;
			fl->f_fn = devtoname(yyvsp[0].val);
			yyval.file = fl;
		}
break;
case 43:
#line 279 "/usr/src/usr.sbin/config/config.y"
 {
			struct file_list *fl = *confp;

			if (fl && fl->f_rootdev != NODEV)
				yyerror("extraneous root device specification");
			else
				fl->f_rootdev = yyvsp[0].val;
		}
break;
case 44:
#line 291 "/usr/src/usr.sbin/config/config.y"
 { yyval.val = nametodev(yyvsp[0].str, 0, 'a'); }
break;
case 46:
#line 297 "/usr/src/usr.sbin/config/config.y"
 {
			struct file_list *fl = *confp;

			if (fl && fl->f_dumpdev != NODEV)
				yyerror("extraneous dump device specification");
			else
				fl->f_dumpdev = yyvsp[0].val;
		}
break;
case 47:
#line 310 "/usr/src/usr.sbin/config/config.y"
 { yyval.val = nametodev(yyvsp[0].str, 0, 'b'); }
break;
case 49:
#line 316 "/usr/src/usr.sbin/config/config.y"
 { yyerror("arg device specification obsolete, ignored"); }
break;
case 50:
#line 321 "/usr/src/usr.sbin/config/config.y"
 { yyval.val = nametodev(yyvsp[0].str, 0, 'b'); }
break;
case 52:
#line 327 "/usr/src/usr.sbin/config/config.y"
 { yyval.val = makedev(yyvsp[-2].val, yyvsp[0].val); }
break;
case 55:
#line 337 "/usr/src/usr.sbin/config/config.y"
 { yyval.val = yyvsp[0].val; }
break;
case 56:
#line 339 "/usr/src/usr.sbin/config/config.y"
 { yyval.val = 0; }
break;
case 57:
#line 344 "/usr/src/usr.sbin/config/config.y"
 { yyval.str = yyvsp[0].str; }
break;
case 58:
#line 346 "/usr/src/usr.sbin/config/config.y"
 {
			char buf[80];

			(void) sprintf(buf, "%s%d", yyvsp[-1].str, yyvsp[0].val);
			yyval.str = ns(buf); free(yyvsp[-1].str);
		}
break;
case 59:
#line 353 "/usr/src/usr.sbin/config/config.y"
 {
			char buf[80];

			(void) sprintf(buf, "%s%d%s", yyvsp[-2].str, yyvsp[-1].val, yyvsp[0].str);
			yyval.str = ns(buf); free(yyvsp[-2].str);
		}
break;
case 62:
#line 369 "/usr/src/usr.sbin/config/config.y"
 {
		struct opt *op = (struct opt *)malloc(sizeof (struct opt));
		op->op_name = ns(yyvsp[0].str);
		op->op_next = opt;
		op->op_value = 0;
		opt = op;
		free(temp_id);
	      }
break;
case 63:
#line 378 "/usr/src/usr.sbin/config/config.y"
 {
		struct opt *op = (struct opt *)malloc(sizeof (struct opt));
		op->op_name = ns(yyvsp[-2].str);
		op->op_next = opt;
		op->op_value = ns(yyvsp[0].str);
		opt = op;
		free(temp_id);
		free(val_id);
	      }
break;
case 64:
#line 390 "/usr/src/usr.sbin/config/config.y"
 { yyval.str = val_id = ns(yyvsp[0].str); }
break;
case 65:
#line 392 "/usr/src/usr.sbin/config/config.y"
 {
		char nb[16];
	        (void) sprintf(nb, "%d", yyvsp[0].val);
		yyval.str = val_id = ns(nb);
	      }
break;
case 66:
#line 401 "/usr/src/usr.sbin/config/config.y"
 { yyval.str = temp_id = ns(yyvsp[0].str); }
break;
case 69:
#line 412 "/usr/src/usr.sbin/config/config.y"
 {
		struct opt *op = (struct opt *)malloc(sizeof (struct opt));
		op->op_name = ns(yyvsp[-2].str);
		op->op_next = mkopt;
		op->op_value = ns(yyvsp[0].str);
		mkopt = op;
		free(temp_id);
		free(val_id);
	      }
break;
case 70:
#line 424 "/usr/src/usr.sbin/config/config.y"
 { yyval.str = ns(yyvsp[0].str); }
break;
case 71:
#line 429 "/usr/src/usr.sbin/config/config.y"
 { cur.d_type = DEVICE; }
break;
case 72:
#line 431 "/usr/src/usr.sbin/config/config.y"
 { cur.d_type = MASTER; }
break;
case 73:
#line 433 "/usr/src/usr.sbin/config/config.y"
 { cur.d_dk = 1; cur.d_type = DEVICE; }
break;
case 74:
#line 435 "/usr/src/usr.sbin/config/config.y"
 { cur.d_type = CONTROLLER; }
break;
case 75:
#line 437 "/usr/src/usr.sbin/config/config.y"
 {
		cur.d_name = yyvsp[0].str;
		cur.d_type = PSEUDO_DEVICE;
		}
break;
case 76:
#line 442 "/usr/src/usr.sbin/config/config.y"
 {
		cur.d_name = yyvsp[-1].str;
		cur.d_type = PSEUDO_DEVICE;
		cur.d_slave = yyvsp[0].val;
		}
break;
case 77:
#line 450 "/usr/src/usr.sbin/config/config.y"
 {
		cur.d_name = yyvsp[-1].str;
		if (eq(yyvsp[-1].str, "mba"))
			seen_mba = 1;
		else if (eq(yyvsp[-1].str, "uba"))
			seen_uba = 1;
		else if (eq(yyvsp[-1].str, "vba"))
			seen_vba = 1;
		else if (eq(yyvsp[-1].str, "isa"))
			seen_isa = 1;
		cur.d_unit = yyvsp[0].val;
		}
break;
case 78:
#line 465 "/usr/src/usr.sbin/config/config.y"
 { init_dev(&cur); }
break;
case 81:
#line 475 "/usr/src/usr.sbin/config/config.y"
 {
		if (eq(cur.d_name, "mba") || eq(cur.d_name, "uba")) {
			(void) sprintf(errbuf,
				"%s must be connected to a nexus", cur.d_name);
			yyerror(errbuf);
		}
		cur.d_conn = connect(yyvsp[-1].str, yyvsp[0].val);
		}
break;
case 82:
#line 484 "/usr/src/usr.sbin/config/config.y"
 { check_nexus(&cur, yyvsp[0].val); cur.d_conn = TO_NEXUS; }
break;
case 85:
#line 494 "/usr/src/usr.sbin/config/config.y"
 { cur.d_addr = yyvsp[0].val; }
break;
case 86:
#line 496 "/usr/src/usr.sbin/config/config.y"
 { cur.d_drive = yyvsp[0].val; }
break;
case 87:
#line 498 "/usr/src/usr.sbin/config/config.y"
 {
		if (cur.d_conn != 0 && cur.d_conn != TO_NEXUS &&
		    cur.d_conn->d_type == MASTER)
			cur.d_slave = yyvsp[0].val;
		else
			yyerror("can't specify slave--not to master");
		}
break;
case 88:
#line 506 "/usr/src/usr.sbin/config/config.y"
 { cur.d_irq = yyvsp[0].val; }
break;
case 89:
#line 508 "/usr/src/usr.sbin/config/config.y"
 { cur.d_drq = yyvsp[0].val; }
break;
case 90:
#line 510 "/usr/src/usr.sbin/config/config.y"
 { cur.d_maddr = yyvsp[0].val; }
break;
case 91:
#line 512 "/usr/src/usr.sbin/config/config.y"
 { cur.d_msize = yyvsp[0].val; }
break;
case 92:
#line 514 "/usr/src/usr.sbin/config/config.y"
 { cur.d_port = ns(yyvsp[0].str); }
break;
case 93:
#line 516 "/usr/src/usr.sbin/config/config.y"
 { cur.d_portn = yyvsp[0].val; }
break;
case 94:
#line 518 "/usr/src/usr.sbin/config/config.y"
 { cur.d_mask = "tty"; }
break;
case 95:
#line 520 "/usr/src/usr.sbin/config/config.y"
 { cur.d_mask = "bio"; }
break;
case 96:
#line 522 "/usr/src/usr.sbin/config/config.y"
 { cur.d_mask = "net"; }
break;
case 97:
#line 524 "/usr/src/usr.sbin/config/config.y"
 { cur.d_flags = yyvsp[0].val; }
break;
case 98:
#line 528 "/usr/src/usr.sbin/config/config.y"
 { cur.d_vec = yyvsp[0].lst; }
break;
case 99:
#line 530 "/usr/src/usr.sbin/config/config.y"
 { cur.d_pri = yyvsp[0].val; }
break;
case 101:
#line 536 "/usr/src/usr.sbin/config/config.y"
 {
		struct idlst *a = (struct idlst *)malloc(sizeof(struct idlst));
		a->id = yyvsp[0].str; a->id_next = 0; yyval.lst = a;
		}
break;
case 102:
#line 540 "/usr/src/usr.sbin/config/config.y"

		{
		struct idlst *a = (struct idlst *)malloc(sizeof(struct idlst));
	        a->id = yyvsp[-1].str; a->id_next = yyvsp[0].lst; yyval.lst = a;
		}
break;
#line 1404 "y.tab.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: after reduction, shifting from state 0 to\
 state %d\n", YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("yydebug: state %d, reading %d (%s)\n",
                        YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("yydebug: after reduction, shifting from state %d \
to state %d\n", *yyssp, yystate);
#endif
    if (yyssp >= yyss + yystacksize - 1)
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
