/*	@(#)test9.c	1.3 89/01/10 NFS Rev 2 Testsuite	*/
/*
 * Test statfs
 *
 * Uses the following important system calls against the server:
 *
 *	chdir()
 *	mkdir()		(for initial directory creation if not -m)
 *	statfs()
 */

#include "tests.h"

#ifdef ANSI
void usage(void);
void main(int argc, char *argv[]);
#endif

int Tflag = 0;		/* print timing */
int Hflag = 0;		/* print help message */
int Fflag = 0;		/* test function only;  set count to 1, negate -t */
int Nflag = 0;		/* Suppress directory operations */

void
usage()
{
	fprintf(stdout, "usage: %s [-htfn] [count]\n", Myname);
	fprintf(stdout, "  Flags:  h    Help - print this usage info\n");
	fprintf(stdout, "          t    Print execution time statistics\n");
	fprintf(stdout, "          f    Test function only (negate -t)\n");
	fprintf(stdout, "          n    Suppress test directory create operations\n");
}

void
main(argc, argv)
	int argc;
	char *argv[];
{
	int count = 1500;	/* times to do statfs call */
	int ct;
	struct timeval time;
	struct statfs sfsb;
	char *opts;

	umask(0);
	setbuf(stdout, NULL);
	Myname = *argv++;
	argc--;
	while (argc && **argv == '-') {
		for (opts = &argv[0][1]; *opts; opts++) {
			switch (*opts) {
				case 'h':	/* help */
					usage();
					exit(1);

				case 't':	/* time */
					Tflag++;
					break;
				
				case 'f':	/* funtionality */
					Fflag++;
					break;
				
				case 'n':	/* No Test Directory create */
					Nflag++;
					break;

				default:
					error("unknown option '%c'", *opts);
					usage();
					exit(1);
			}
		}
		argc--;
		argv++;
	}

	if (argc) {
		count = (int) getparm(*argv, 1L, "count");
		argv++;
		argc--;
	}
	if (argc) {
		usage();
		exit(1);
	}

	if (Fflag) {
		Tflag = 0;
		count = 1;
	}

	if (!Nflag)
		testdir(NULL);
	else
		mtestdir(NULL);

	fprintf(stdout, "%s: statfs\n", Myname);

	if (Tflag) {
		starttime();
	}

	for (ct = 0; ct < count; ct++) {
		if (statfs(".", &sfsb) < 0) {
			error("can't do statfs on \".\"");
			exit(1);
		}
	}

	if (Tflag) {
		endtime(&time);
	}
#ifdef DEBUG
	fprintf(stdout, "\ttype=%d, bsize=%d, blocks=%d, bfree=%d\n\
\t  bavail=%d, files=%d, ffree=%d, fsid=%d %d\n",
		sfsb.f_type, sfsb.f_bsize, sfsb.f_blocks, sfsb.f_bfree,
		sfsb.f_bavail, sfsb.f_files, sfsb.f_ffree,
#ifdef NFS3_2
		sfsb.f_fsid.val[0], sfsb.f_fsid.val[1]);
#else  /* NFS3_2 */
		sfsb.f_fsid[0], sfsb.f_fsid[1]);
#endif /* NFS3_2 */
#endif /* DEBUG */
	fprintf(stdout, "\t%d statfs calls", count);
	if (Tflag) {
		printtimes(&time, 0L);
	}
	fprintf(stdout, "\n");
	complete();
}
