/*	@(#)holey.c	1.1 88/10/12 NFS Rev 2 Testsuite	*/
/*
 * test read/write of holey files
 */

#include <tests.h>

#define BUFSZ   8192
#define FILESZ	70000L
#define DATASZ	4321
#define HOLESZ	9012
#define FILENM  "holefile"
int Debug = 0;
char *Prog;

#ifdef ANSI
void main(int argc, char *argv[]);
#endif

void
main(argc, argv)
int argc;
char *argv[];
{
	int fd, i, tot, ct, bytes, ret;
	long sz;
	char *filenm = FILENM;
	char buf[BUFSZ];
	extern int errno;
	long filesz = FILESZ;
	int datasz = DATASZ;
	int holesz = HOLESZ;

	Prog = argv[0];
	if (argc > 1 && !strcmp(argv[1], "-d")) {
		Debug = 1;
		argc--;
		argv++;
	}
	if (argc > 5 || (argc > 1 && !strcmp(argv[1], "-h"))) {
		fprintf(stderr, "\
usage: %s [filename filesize datasize holesize]\n", Prog);
		exit(1);
	}
	if (argc > 1 && strcmp(argv[1], "-"))
		filenm =       argv[1];
	if (argc > 2 && strcmp(argv[2], "-"))
		filesz =  atol(argv[2]);
	if (argc > 3 && strcmp(argv[3], "-"))
		datasz =  atoi(argv[3]);
	if (argc > 4 && strcmp(argv[4], "-"))
		holesz =  atoi(argv[4]);

	umask(0);
	if (datasz > BUFSZ) {
		fprintf(stderr, "%s: datasize (%d) greater than maximum (%d)\n",
			Prog, datasz, BUFSZ);
		exit(1);
	}
	if ((fd = creat(filenm, CHMOD_YES)) < 0) {
		sprintf(buf, "%s: creat of %s", Prog, filenm);
		perror(buf);
		exit(1);
	}
	if (close(fd)) {
		sprintf(buf, "%s: close of %s after creat", Prog, filenm);
		perror(buf);
		exit(1);
	}
#ifdef DOS
	if ((fd = open(filenm, O_RDWR)) < 0) {
#else
	if ((fd = open(filenm, 2)) < 0) {
#endif
		sprintf(buf, "%s: open of %s", Prog, filenm);
		perror(buf);
		exit(1);
	}
	for (i=0; i < BUFSZ / sizeof(int); i++)
		((int *)buf)[i] = i;

	for (sz = filesz; sz; ) {
		if (datasz || sz) {
			bytes = (int) MIN(sz, (long) datasz);
			if (bytes == 0)
				bytes = 1;
			if ((ret = write(fd, buf, bytes)) != bytes) {
				fprintf(stderr, "write ret %d (expect %d)\n",
					ret, bytes);
				if (errno) perror("write");
				exit(1);
			}
			sz -= bytes;
		}
		if (sz && holesz) {
			bytes = (int) MIN(sz - 1, (long) holesz);
			if (lseek(fd, (long) bytes, SEEK_CUR) == -1) {
				perror("lseek (write)");
				exit(1);
			}
			sz -= bytes;
		}
	}
	if (lseek(fd, 0L, SEEK_SET) == -1) {
		perror("lseek (rewind)");
		exit(1);
	}

	for (sz = filesz; sz; ) {
		if (datasz || sz == 1) {
			bytes = (int) MIN(sz, (long) datasz);
			if (bytes == 0)
				bytes = 1;
			sz -= bytes;
			for ( ; bytes; bytes -= ret) {
				if (Debug) 
					fprintf(stderr, "\
--data read: offset %ld, sz = %ld, bytes = %d\n", filesz - sz - bytes, sz, bytes);
				if ((ret = read(fd, buf, bytes)) <= 0) {
					fprintf(stderr, "\
read (data) offset %ld, sz = %ld, bytes = %d (ret = %d), datasz = %d\n",
filesz - sz - bytes, sz, bytes, ret, datasz);
					if (ret < 0)
						perror("read");
					exit(1);
				}
				ct = bytes - (bytes % sizeof(int));
				if (Debug)
					fprintf(stderr, "\
  ret = %d, ct = %d\n", ret, ct);
				for (i=0; i < ct / sizeof(int); i++) {
					if (((int *)buf)[i] != i) {
						fprintf(stderr, "\
bad data in %s\n", filenm);
						exit(1);
					}
				}
			}
		}
		if (sz && holesz) {
			tot = (int) MIN((long) holesz, sz - 1);
			sz -= tot;
			for (ct = 0; tot; tot -= ret, ct += ret) {
				bytes = MIN(tot, BUFSZ);
				if (Debug)
					fprintf(stderr, "\
++hole read: offset %ld, sz = %ld, tot = %d, bytes = %d\n",
					filesz - sz - tot, sz, tot, bytes);
				if ((ret = read(fd, buf, bytes)) <= 0) {
					fprintf(stderr, "\
read (hole) offset %ld, sz = %ld, bytes = %d (ret %d), holesz = %d\n",
filesz - sz - tot, sz, bytes, ret, holesz);
					if (ret < 0)
						perror("read");
					exit(1);
				}
				if (Debug)
					fprintf(stderr, "  ret = %d\n", ret);
				for (i = 0; i < ret; i++) {
					if (buf[i] != '\0') {
						fprintf(stderr, "\
non-zero data read back from hole (offset %ld)\n", filesz - sz + ct + i);
						exit(1);
					}
				}
			}
		}
	}
	printf("\nHoley file test ok\n");
	exit(0);
}
