.NH 1
Overview of pepsy system
.XS
Overview of pepsy system
.XE
.PP
This section describes how the various parts fit together to make
the system work.
The principle behind pepsy is fairly simple.
The \fBASN.1\fR is summarised as tables of integers.
These tables are read by driver routines which encode or decode
data to or from the internal format that \fBISODE\fR \fBOSI\fR implementation uses.
In \fBISODE\fR specific functions are generated for each \fBASN.1\fR type
defined in contrast the pepsy merely generates a new table of data which
is far far smaller.
.PP
As there is a great deal of effort invested in the \fBISODE\fR interface to the
encoding/decoding routines pepsy automatically provides macros which map
the original functions into the appropriate function call of a driver.
This allows existing posy using code to switch to the
pepsy system with \fBno changes\fR
to the code \fBprovided\fR no function pointers are used to the original
\fBISODE\fR functions.
Even when there are function pointers used the changes are very simple and
take only a few hours to implement.
.NH 2
Brief description of the use of the pepsy system.
.XS
A Brief description of the use of the pepsy system.
.XE
.NH 3
Outline of the files produced under the pepsy system.
.XS
Outline of the files produced under the pepsy system.
.XE
.PP
The pepsy system consists of a program called \fIposy\fR
which translates \fBASN.1\fR modules into a set of tables, called \fIposy\fR at the moment,
and library of driver routines, called \fIlibpepsy.a\fR.
Running this \fIposy\fR program on the \fBASN.1\fR file will produce several
files.
If the name of the \fBASN.1\fR module is \fBMODULE\fR the following files
are generated:
.I
.IP MODULE-types.h
.R
which contains \fBC\fR structure definitions.
The user of the library provides data as a linked list of
these \fBC\fR data structures and expects to receive data back as a similar
linked list.
These data structures are exactly the same as those produced by the original
\fBISODE\fR \fIposy\fR so that existing software written for the old \fIposy\fR
program needs no change.
For details on the \fBC\fR data structures types generated
see the documentation of the original \fIposy\fR program in
volume 4 Chapter 5 of the \fBISODE\fR manuals.
.I
.IP MODULE_tables.c 
.R
This file contains the tables generated by the new \fIposy\fR program.
These tables consist of three parts, the first which contains the summary of
\fBASN.1\fR types.
Each type is summarised as an array of a primitive type, \fBstruct pte\fR,
for encoding and decoding, and \fBstruct ptpe\fR for printing.
As implied there is one array for each type for each of encoding, decoding and
printing as specified when \fIposy\fR is run.
The next part contains up to three tables of pointers to these arrays.
Each of the three different types of arrays, encoding, decoding and printing,
has its own table of pointers.
Finally there is the module type definition which contains contains pointers
to these tables and some other useful information about the module such as its
name.
This module type structure, which is \fBtypedef\fRed to \fBmodtyp\fR,
is the only piece of data which is global, all the
rest of the data is static and is only addressable via the \fBmodtyp\fR
data structure. 
This provides a kind of object oriented approach to handling the tables.
Once you are passed a pointer to an \fBASN.1\fR's \fBmodtyp\fR structure
you can encode, decode and print any of its types by calling the appropriate
\fBlibpepsy.a\fR routine with its type number.
.I
.IP MODULE_pre_defs.h
.R
This file contains \fB#define\fRs symbol of each of the \fBASN.1\fR types
to its type number, which is used when calling a \fBlibpepsy.a\fR routine.
Each symbol is \fB_Ztype-nameMODULE\fR where \fItype-name\fR is the name of
the type with dashes (\fB-\fR) turned into underscores (\fB_\fR) and
\fIMODULE\fR is the name of the module.
For example of the \fBASN.1\fR universal type \fIGraphicString\fR would
have the \fB#define\fR symbol \fB_ZGraphicStringUNIV\fR.
The \fI_Z\fR is prepended to try to make the symbols unique.
This file also contains and extern declaration for the \fBmodtyp\fR data
for its module.
.I
.IP MODULE_defs.h
.R
This file contains macros for  all the encoding, decoding and printing
functions that the \fIpepy\fR program would have for these \fBASN.1\fR
types.
This allows much of the code that uses the routines generated by running
the old \fIposy\fR program and taking its output and running \fIpepy\fR on
augmented \fBASN.1\fR output can be recompiled unchanged.
If the code used pointers to these functions it is necessary to change it
to pass around the type numbers instead and to call appropriately call
a \fBlibpepsy.a\fR library routine with the type number.
As pointers to the printing routines in ISODE are passed as arguments
a \fB#define\fR is provided to turn the argument into the pair of arguments,
type number and pointer to \fBmodtyp\fR structure, which are needed to allow
the diagnostic printing code to work with no change for
the current \fBISODE\fR stack.
This file also contains a \fB#include\fR of the \fIMODULE_pre_defs.h\fR file.
.PP
As the \fIMODULE-types.h\fR file \fB#include\fR's the \fIMODULE_defs.h\fR
file no further \fB#include\fRs need to be added to the files using the
encoding/decoding/printing functions.
This means that code written to use posy/pepy system may need no change at all
and the only effort required is to change the Makefile to use the pepsy
system.
If there is code changes required it would most likely be because function
pointers are used to reference the functions generated by posy.
If only the \fIpepy\fR system was used,
not posy then pepy,
with code placed inside action statements then quite a large amount of work
may be needed to change over to the new system, depending on how large and
complex the \fIpepy\fR module is.
.NH 3
Outline of the pepsy library.
.XS
Outline of the pepsy library.
.XE
.IP enc.c
This contains the routines that encode data from the \fBC\fR data structures
into \fBISODE\fR's \fBPElement\fR linked list data structure which it
uses for all presentation data.
The most important function to pepsy users is \fBenc_f\fR which called to
encode a particular type.
It is passed the type number and a pointer to \fBmodtyp\fR structure for that
module and then the rest of the arguments which are passed to an encode
function generated by \fIposy\fR/\fIpepy\fR system.
See the documentation in Volume 4, "The Applications Cookbook",
Section 6.4 called "Pepy Environment".
Most of these latter arguments are ignored, only \fBparm\fR and \fBpe\fR,
are used.
.PP
Contrary to what the \fBISODE\fR documentation says these ignored parameters
are hardly ever used by existing code.
We have not found a single case where used for encoding a named type,
which is all that the user can reference anyway,
so we don't see any problems with ignoring these other parameters.
Hopefully one day they can be thrown away entirely, until then they are
actually passed the the encoding function.
.PP
The rest of the functions are mostly recursive routines which encode a
particular type of table entry.
For example \fBSEQUENCE\fR is encoded by \fBen_seq\fR which may call itself
or others to encode the types from which it is built up.
The function \fBen_type\fR builds up a simple type and \fBen_obj\fR encodes
a new type (object) and so on with other functions.
There are a few utility routines in the file such as \fBsame\fR which
determines whether the value is the same as the default value also.
.IP dec.c 
This file contains the decoding routines that translate
presentation data into \fBC\fR data structures defined in
the \fBMODULE-types.h\fR
is like \fIenc.c\fR.
It is very much like the file \fIenc.c\fR except the routines do the
reverse tasks
The routines are structured in a very similar way.
We have \fBdec_f\fR which is called by the user to decode a type
and like \fBenc_f\fR takes the same arguments as the decoding functions
generated by \fIposy\fR with two additions, the type number and a pointer
to the \fBmodtyp\fR structure for that module.
Likewise the other functions are very much like those of enc.c
.IP prnt.c
This file contains the routines that print the presentation data in a format
similar to that generated by \fIpepy\fR's printing functions.
It's main function \fBprnt_f\fR is takes the same arguments as the printing
function generated by \fIpepy\fR as well as the now familiar type number
and \fBmodtyp\fR pointer.
The functions are modeled on the decoding routines as it has similar job to.
The only difference is that instead of storing the decoded data
into a \fBC\fR data structure it is nicely printed out.
.IP fr.c
This file contains code to free the data structures
defined in \fBMODULE-types.h\fR.
Likewise if the \fB-f\fR flag is given when generating the types file it also
includes macros in the types file which replace the freeing functions generated
by ISODE's \fIposy\fR.
The function that the user calls us \fBfre_obj\fR which takes a pointer to
the data structure, its decoding table entry and a pointer
to the \fBmodtyp\fR structure for the module. 
The freeing is based on the decoding routines except instead of decoding all
it does is free each part of the data structure, which might involve recursive
calls, then it frees the data structure at the end.
.IP util.c
This contains the utility routines used by more than one of the above files.
This is mostly diagnostic routines at the moment, more general routines could
be included in here.
If there is an error at the moment which it can't recover from it just prints
out a message on standard error and calls \fBexit\fR.
Not perfect and this is something that will need work.
.IP main.c
This contains code to perform a series of tests on the \fIpepsy\fR library
which is a useful check to see whether any of the routines has been broken
by any changes made.
It basically loops through a whole series of test cases.
Each test case is encoded from some built in test data and then decoded
and checked to see if the data has changed in the transfer.
If it is compiled with \fI-DPRNT=1\fR the encoded data is also printed
out to check the printing routines which generates a vast amount of output.
Finally the free routines are used to free the allocated data, although it
can not directly check the free routines to see if they work, it can be used
with a malloc tracing package to check that the routines work.
.IP test_table.h
This contains the test cases that \fImain.c\fR program runs.
Each entry in the table corresponds to a type.
One of the fields is count of how many times that type is to be tested
to try out the different possibly data values it might have.
.IP "pep.h and pepdefs.h"
These files contain the definition of types used for the tables that drive the
encoding/decoding/printing routines.
All the constants used in that table are defined here via \fB#define\fRs.
The \fBmodtyp\fR structure is defined in \fIpepdefs.h\fR.
.IP "t1.py and t2.py"
These are test \fBASN.1\fR modules that are used by \fImain.c\fR routines
to check the \fIpepsy\fR library.
The file \fIt1.py\fR contains the majority of different types with
a few of a different module provided in \fIt2.py\fR.
This allows the testing of the code for handling \fBASN.1\fR
external references, i.e. references to types defined in other, external,
modules.
.NH 3
New files in the pepy directory
.XS
New files in the pepy directory
.XE
.IP "etabs.c, dtabs.c and ptabs.c"
These files contain the code to generate the encoding/decoding/printing tables.
The main routine in \fIetabs.c\fR is \fBtenc_typ\fR which is called
on each \fBASN.1\fR type
to generate an array of entries which describe how to encode that type.
See the details section for more information about how the
table entries function.
Similarly \fIdtabs.c\fR contains the routine \fBtdec_typ\fR which is
called on each type to generate its decoding table entries.
Likewise \fBtprnt_typ\fR routine generates the arrays of table entries for
the printing tables.
This function is in \fIptabs.c\fR.
.IP "dfns.c"
This file contains miscellaneous string handling routines and hash table
routines that don't really belong anywhere else.
Some of the routines could be cleaned up in that they tend not to free memory
they use.
.IP mine.h
This file contains the definitions for the hash table(s) that are used to keep
track of the \fBASN.1\fR types.
This could probably be done with out a hash table, should anyone want to
clean this up, feel welcome.
The lookup function is in \fIdfns.c\fR.
.IP pass2.h
This file has most of the \fB#define\fRs for the table generating program.
Most of the prefixes and suffixes of function names and files names are defined
here so, hopefully, the names can be changed by merely changing the definition.
This contains most of the important definitions needed by the changes
to the \fIposy\fR program needed to generate tables.
.IP posy.h
This contains the definition of a symbol which is now needed outside of the
the main routine and the yacc file.
By putting it here we can include it any file that needs to know it with out
putting in any that doesn't need it and with out including all the other
definitions that occur in \fIpepy.h\fR.
