/*
 * Copyright (c) 1986 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)psreg.h	7.5 (Berkeley) 12/16/90
 */

#ifndef _PSREG_
#define _PSREG_
/*
 * PS300 definitions.
 */
#include <sys/ioctl.h>

struct  pslookup {
        int     pl_len;                 /* length of name string */
        char    *pl_name;               /* address of name string */
        u_long  pl_addr;                /* symbol's address */
};

/*
 * Maximum string which may be supplied for lookup.
 */
#define PS_MAXNAMELEN   256             /* must be <= PSMAXDMA */

/*
 * When doing physical i/o, one may specify the address
 * and whether or not refresh sync should is required with
 * a null iovec descriptor (iov_len = 0).
 */
#define PSIO_SYNC       1               /* do physical write w/ refresh sync */

/*
 * Ioctl requests.
 */
#define PSIOGETERROR    _IOR('p', 0, int)                 /* get last error */
#define PSIOLOOKUP      _IOWR('p', 1, struct pslookup)    /* do name lookup */
#define PSIORWLOGICAL   _IOWR('p', 2, int)                /* set i/o mode */

/*
 * Error codes returned by PSIOGETERROR are either
 * returned by the PS300 or, from the list below,
 * generated by the device driver.
 */
#define PSERROR_DIOTIMO         1       /* timeout during dioread/diowrite */
#define PSERROR_INVALBC         2       /* invalid byte count for read/write */
#define PSERROR_BADADDR         3       /* invalid address for read/write */
#define PSERROR_BADCMD          4       /* invalid command in ikstart */
#define PSERROR_NAMETIMO        5       /* timeout during nameaddr dioread */
#define PSERROR_CMDTIMO         6       /* operation timed out */
#endif
