/*	@(#)test5.c	1.4 89/01/13 NFS Rev 2 Testsuite	*/
/*
 * Test read and write
 *
 * Uses the following important system calls against the server:
 *
 *	chdir()
 *	mkdir()		(for initial directory creation if not -m)
 *	creat()
 *	open()
 *	read()
 *	write()
 *	stat()
 *	fstat()
 *	unlink()
 */

#include "sys_param.h"
#ifndef major
#include "sys_types.h"
#endif
#include "sys_time.h"
#include "sys_stat.h"
#include <stdio.h>
#include "tests.h"

test5(argc, argv)
	int argc;
	char *argv[];
{
	int count = DCOUNT;	/* times to do each file */
	int ct;
	long size = DSIZE;
	long si;
	int i;
	int fd;
	int bytes;
	char *bigfile = "bigfile";
	struct timeval time;
	char str[MAXPATHLEN];
	struct stat statb;
	char *opts;
	char buf[BUFSZ];

	umask(0);
	setbuf(stdout, NULL);
	Myname = *argv++;
	argc--;
	while (argc && **argv == '-') {
		for (opts = &argv[0][1]; *opts; opts++) {
			switch (*opts) {
				case 'h':	/* help */
					usage();
					exit(1);

				case 't':	/* time */
					Tflag++;
					break;
				
				case 'f':	/* funtionality */
					Fflag++;
					break;
				
				case 'n':	/* No Test Directory create */
					Nflag++;
					break;

				default:
					error("unknown option '%c'", *opts);
					usage();
					exit(1);
			}
		}
		argc--;
		argv++;
	}

	if (argc) {
                size = getparm(*argv, 1, "size");
		argv++;
		argc--;
	}
	if (argc) {
                count = getparm(*argv, 1, "count");
		argv++;
		argc--;
	}
	if (argc) {
                bigfile = *argv;
		argv++;
		argc--;
	}
	if (argc) {
		usage();
		exit(1);
	}
	
	if (Fflag) {
		Tflag = 0;
		count = 1;
	}

	fprintf(stdout, "%s: read and write\n", Myname);

	if (!Nflag)
		testdir(NULL);
	else
		mtestdir(NULL);

	for (i=0; i < BUFSZ / sizeof(int); i++) {
		((int *)buf)[i] = i;
	}

	if (Tflag) {
		starttime();
	}

	for (ct = 0; ct < count; ct++) {
		if ((fd = creat(bigfile, 0666)) < 0) {
			error("can't create '%s'", bigfile);
			exit(1);
		}
		if (fstat(fd, &statb) < 0) {
			error("can't stat '%s'", bigfile);
			exit(1);
		}
		if (statb.st_size != 0) {
			error("'%s' has size %ld, should be 0",
			    bigfile, statb.st_size);
			exit(1);
		}
                for (si = size; si > 0; si -= BUFSZ) {
			bytes = MIN(BUFSZ, si);
			if (write(fd, buf, bytes) != bytes) {
				error("'%s' write failed", bigfile);
				exit(1);
			}
		}
		close(fd);
		if (stat(bigfile, &statb) < 0) {
			error("can't stat '%s'", bigfile);
			exit(1);
		}
		if (statb.st_size != size) {
			error("'%s' has size %d, should be %d",
			    bigfile, statb.st_size, size);
			exit(1);
		}
	}

	if (Tflag) {
		endtime(&time);
	}

	if ((fd = open(bigfile, 0)) < 0) {
		error("can't open '%s'", bigfile);
		exit(1);
	}
	for (si = size; si; si -= BUFSZ) {
		bytes = MIN(BUFSZ, si);
		if (read(fd, buf, bytes) != bytes) {
			error("'%s' read failed", bigfile);
			exit(1);
		}
		for (i = 0; i < bytes / sizeof(int); i++) {
			if (((int *)buf)[i] != i) {
printf("i %d, buf %x, i %x\n", i, ((int *)buf)[i], i);
				error("bad data in '%s'", bigfile);
				exit(1);
			}
		}
	}
	close(fd);

	fprintf(stdout, "\twrote %ld byte file %d times", size, count);
	if (Tflag) {
		fprintf(stdout, " in %ld.%-2ld seconds (%ld bytes/sec)",
		    time.tv_sec, time.tv_usec / 10000, size*count/time.tv_sec);
	}
	fprintf(stdout, "\n");
	if (Tflag) {
		starttime();
	}

	for (ct = 0; ct < count; ct++) {
		if ((fd = open(bigfile, 0)) < 0) {
			error("can't open '%s'", bigfile);
			exit(1);
		}
		for (si = size; si; si -= BUFSZ) {
			bytes = MIN(BUFSZ, si);
			if (read(fd, buf, bytes) != bytes) {
				error("'%s' read failed", bigfile);
				exit(1);
			}
		}
		close(fd);
	}

	if (Tflag) {
		endtime(&time);
	}
	fprintf(stdout, "\tread %ld byte file %d times", size, 2*count);
	if (Tflag) {
		fprintf(stdout, " in %ld.%-2ld seconds (%ld bytes/sec)",
		    time.tv_sec, time.tv_usec / 10000, size*count/time.tv_sec);
	}
	fprintf(stdout, "\n");

	if (unlink(bigfile) < 0) {
		error("can't unlink '%s'", bigfile);
		exit(1);
	}
	complete();
}
