#ifndef main_h
#define main_h

#define isterm(file)	(interactive or isatty(fileno(file)))

#include <sgtty.h>
#include <fcntl.h>

typedef struct {
    struct sgttyb sg;		/* standard sgttyb structure */
    struct tchars tc;		/* terminal characters */
    struct ltchars ltc;		/* local special characters */
    integer ldisc;		/* line discipline */
    integer local;		/* TIOCLGET */
    integer fcflags;		/* fcntl(2) F_GETFL, F_SETFL */
} Ttyinfo;

boolean coredump;		/* true if using a core dump */
boolean runfirst;		/* run program immediately */
boolean interactive;		/* standard input IS a terminal */
boolean lexdebug;		/* trace scanner return values */
boolean tracebpts;		/* trace create/delete breakpoints */
boolean traceexec;		/* trace execution */
boolean tracesyms;		/* print symbols are they are read */
boolean traceblocks;		/* trace blocks while reading symbols */
boolean vaddrs;			/* map addresses through page tables */
File corefile;			/* File id of core dump */
init(/*  */);
reinit(/* argv, infile, outfile */);
erecover(/*  */);
savetty(/* f, t */);
restoretty(/* f, t */);
quit(/* r */);
#endif
