


CO(1)               UNIX Programmer's Manual                CO(1)



NAME
     co - check out RCS revisions

SYNOPSIS
     co [ options ] file ...

DESCRIPTION
     _C_o retrieves revisions from RCS files.  Each file name end-
     ing in `,v' is taken to be an RCS file.  All other files are
     assumed to be working files.  _C_o retrieves a revision from
     each RCS file and stores it into the corresponding working
     file.

     Pairs of RCS files and working files may be specified in 3
     ways (see also the example section).

     1) Both the RCS file and the working file are given. The RCS
     file name is of the form _p_a_t_h_1/_w_o_r_k_f_i_l_e,v and the working
     file name is of the form _p_a_t_h_2/_w_o_r_k_f_i_l_e, where _p_a_t_h_1/ and
     _p_a_t_h_2/ are (possibly different or empty) paths and _w_o_r_k_f_i_l_e
     is a file name.

     2) Only the RCS file is given. Then the working file is
     created in the current directory and its name is derived
     from the name of the RCS file by removing _p_a_t_h_1/ and the
     suffix `,v'.

     3) Only the working file is given.  Then the name of the RCS
     file is derived from the name of the working file by remov-
     ing _p_a_t_h_2/ and appending the suffix `,v'.

     If the RCS file is omitted or specified without a path, then
     _c_o looks for the RCS file first in the directory ./RCS and
     then in the current directory.

     Revisions of an RCS file may be checked out locked or
     unlocked. Locking a revision prevents overlapping updates. A
     revision checked out for reading or processing (e.g., com-
     piling) need not be locked. A revision checked out for edit-
     ing and later checkin must normally be locked. Locking a
     revision currently locked by another user fails. (A lock may
     be broken with the _r_c_s (1) command.) _C_o with locking
     requires the caller to be on the access list of the RCS
     file, unless he is the owner of the file or the superuser,
     or the access list is empty.  _C_o without locking is not sub-
     ject to accesslist restrictions.

     A revision is selected by number, checkin date/time, author,
     or state. If none of these options are specified, the latest
     revision on the trunk is retrieved.  When the options are
     applied in combination, the latest revision that satisfies
     all of them is retrieved.  The options for date/time,



Printed 1/10/87              6/29/83                            1






CO(1)               UNIX Programmer's Manual                CO(1)



     author, and state retrieve a revision on the _s_e_l_e_c_t_e_d
     _b_r_a_n_c_h. The selected branch is either derived from the revi-
     sion number (if given), or is the highest branch on the
     trunk.  A revision number may be attached to one of the
     options -l, -p, -q, or -r.

     A _c_o command applied to an RCS file with no revisions
     creates a zero-length file.  _C_o always performs keyword sub-
     stitution (see below).

     -l[_r_e_v]    locks the checked out revision for the caller.
                If omitted, the checked out revision is not
                locked.  See option -r for handling of the revi-
                sion number _r_e_v.

     -p[_r_e_v]    prints the retrieved revision on the std. output
                rather than storing it in the working file.  This
                option is useful when _c_o is part of a pipe.

     -q[_r_e_v]    quiet mode; diagnostics are not printed.

     -d_d_a_t_e     retrieves the latest revision on the selected
                branch whose checkin date/time is less than or
                equal to _d_a_t_e.  The date and time may be given in
                free format and are converted to local time.
                Examples of formats for _d_a_t_e:

                _2_2-_A_p_r_i_l-_1_9_8_2, _1_7:_2_0-_C_D_T,
                _2:_2_5 _A_M, _D_e_c. _2_9, _1_9_8_3,
                _T_u_e-_P_D_T, _1_9_8_1, _4_p_m _J_u_l _2_1         (free format),
                _F_r_i, _A_p_r_i_l _1_6 _1_5:_5_2:_2_5 _E_S_T _1_9_8_2 (output of ctime).

                Most fields in the date and time may be
                defaulted.  _C_o determines the defaults in the
                order year, month, day, hour, minute, and second
                (most to least significant). At least one of
                these fields must be provided. For omitted fields
                that are of higher significance than the highest
                provided field, the current values are assumed.
                For all other omitted fields, the lowest possible
                values are assumed.  For example, the date "20,
                10:30" defaults to 10:30:00 of the 20th of the
                current month and current year.  The date/time
                must be quoted if it contains spaces.

     -r[_r_e_v]    retrieves the latest revision whose number is
                less than or equal to _r_e_v.  If _r_e_v indicates a
                branch rather than a revision, the latest revi-
                sion on that branch is retrieved.  _R_e_v is com-
                posed of one or more numeric or symbolic fields
                separated by `.'. The numeric equivalent of a
                symbolic field is specified with the -n option of



Printed 1/10/87              6/29/83                            2






CO(1)               UNIX Programmer's Manual                CO(1)



                the commands _c_i and _r_c_s.

     -s_s_t_a_t_e    retrieves the latest revision on the selected
                branch whose state is set to _s_t_a_t_e.

     -w[_l_o_g_i_n]  retrieves the latest revision on the selected
                branch which was checked in by the user with
                login name _l_o_g_i_n. If the argument _l_o_g_i_n is omit-
                ted, the caller's login is assumed.

     -j_j_o_i_n_l_i_s_t generates a new revision which is the join of the
                revisions on _j_o_i_n_l_i_s_t.  _J_o_i_n_l_i_s_t is a comma-
                separated list of pairs of the form _r_e_v_2:_r_e_v_3,
                where _r_e_v_2 and _r_e_v_3 are (symbolic or numeric)
                revision numbers.  For the initial such pair,
                _r_e_v_1 denotes the revision selected by the options
                -l, ..., -w. For all other pairs, _r_e_v_1 denotes
                the revision generated by the previous pair.
                (Thus, the output of one join becomes the input
                to the next.)

                For each pair, _c_o joins revisions _r_e_v_1 and _r_e_v_3
                with respect to _r_e_v_2.  This means that all
                changes that transform _r_e_v_2 into _r_e_v_1 are applied
                to a copy of _r_e_v_3.  This is particularly useful
                if _r_e_v_1 and _r_e_v_3 are the ends of two branches
                that have _r_e_v_2 as a common ancestor. If _r_e_v_1 <
                _r_e_v_2 < _r_e_v_3 on the same branch, joining generates
                a new revision which is like _r_e_v_3, but with all
                changes that lead from _r_e_v_1 to _r_e_v_2 undone.  If
                changes from _r_e_v_2 to _r_e_v_1 overlap with changes
                from _r_e_v_2 to _r_e_v_3, _c_o prints a warning and
                includes the overlapping sections, delimited by
                the lines <<<<<<< _r_e_v_1, =======, and
                >>>>>>> _r_e_v_3.

                For the initial pair, _r_e_v_2 may be omitted. The
                default is the common ancestor.  If any of the
                arguments indicate branches, the latest revisions
                on those branches are assumed. If the option -l
                is present, the initial _r_e_v_1 is locked.

KEYWORD SUBSTITUTION
     Strings of the form $_k_e_y_w_o_r_d$ and $_k_e_y_w_o_r_d:...$ embedded in
     the text are replaced with strings of the form
     $_k_e_y_w_o_r_d: _v_a_l_u_e $, where _k_e_y_w_o_r_d and _v_a_l_u_e are pairs listed
     below.  Keywords may be embedded in literal strings or com-
     ments to identify a revision.

     Initially, the user enters strings of the form $_k_e_y_w_o_r_d$.
     On checkout, _c_o replaces these strings with strings of the
     form $_k_e_y_w_o_r_d: _v_a_l_u_e $. If a revision containing strings of



Printed 1/10/87              6/29/83                            3






CO(1)               UNIX Programmer's Manual                CO(1)



     the latter form is checked back in, the value fields will be
     replaced during the next checkout.  Thus, the keyword values
     are automatically updated on checkout.

     Keywords and their corresponding values:

     $Author$     The login name of the user who checked in the
                  revision.

     $Date$       The date and time the revision was checked in.

     $Header$     A standard header containing the RCS file name,
                  the revision number, the date, the author, and
                  the state.

     $Locker$     The login name of the user who locked the revi-
                  sion (empty if not locked).

     $Log$        The log message supplied during checkin, pre-
                  ceded by a header containing the RCS file name,
                  the revision number, the author, and the date.
                  Existing log messages are NOT replaced.
                  Instead, the new log message is inserted after
                  $_L_o_g:...$.  This is useful for accumulating a
                  complete change log in a source file.

     $Revision$   The revision number assigned to the revision.

     $Source$     The full pathname of the RCS file.

     $State$      The state assigned to the revision with _r_c_s -_s
                  or _c_i -_s.

DIAGNOSTICS
     The RCS file name, the working file name, and the revision
     number retrieved are written to the diagnostic output.  The
     exit status always refers to the last file checked out, and
     is 0 if the operation was successful, 1 otherwise.

EXAMPLES
     Suppose the current directory contains a subdirectory `RCS'
     with an RCS file `io.c,v'. Then all of the following com-
     mands retrieve the latest revision from `RCS/io.c,v' and
     store it into `io.c'.

             co  io.c;    co RCS/io.c,v;    co  io.c,v;
             co  io.c  RCS/io.c,v;    co  io.c  io.c,v;
             co  RCS/io.c,v  io.c;    co  io.c,v  io.c;

FILE MODES
     The working file inherits the read and execute permissions
     from the RCS file. In addition, the owner write permission



Printed 1/10/87              6/29/83                            4






CO(1)               UNIX Programmer's Manual                CO(1)



     is turned on, unless the file is checked out unlocked and
     locking is set to _s_t_r_i_c_t (see _r_c_s (1)).

     If a file with the name of the working file exists already
     and has write permission, _c_o aborts the checkout if -q is
     given, or asks whether to abort if -q is not given. If the
     existing working file is not writable, it is deleted before
     the checkout.

FILES
     The caller of the command must have write permission in the
     working directory, read permission for the RCS file, and
     either read permission (for reading) or read/write permis-
     sion (for locking) in the directory which contains the RCS
     file.

     A number of temporary files are created.  A semaphore file
     is created in the directory of the RCS file to prevent
     simultaneous update.

IDENTIFICATION
     Author: Walter F. Tichy, Purdue University, West Lafayette,
     IN, 47907.
     Revision Number: 3.1 ; Release Date: 83/04/04 .
     Copyright 8c9 1982 by Walter F. Tichy.

SEE ALSO
     ci (1), ident(1), rcs (1), rcsdiff (1), rcsintro (1),
     rcsmerge (1), rlog (1), rcsfile (5), sccstorcs (8).
     Walter F. Tichy, "Design, Implementation, and Evaluation of
     a Revision Control System," in _P_r_o_c_e_e_d_i_n_g_s _o_f _t_h_e _6_t_h _I_n_t_e_r_-
     _n_a_t_i_o_n_a_l _C_o_n_f_e_r_e_n_c_e _o_n _S_o_f_t_w_a_r_e _E_n_g_i_n_e_e_r_i_n_g, IEEE, Tokyo,
     Sept. 1982.

LIMITATIONS
     The option -d gets confused in some circumstances, and
     accepts no date before 1970.  There is no way to suppress
     the expansion of keywords, except by writing them dif-
     ferently. In nroff and troff, this is done by embedding the
     null-character `\&' into the keyword.

BUGS
     The option -j does not work for files that contain lines
     with a single `.'.











Printed 1/10/87              6/29/83                            5



