.TH BITMAP 1 "29 January 1986" "X Version 10"
.SH NAME
bitmap \- bitmap editor for X window system

.SH SYNOPSIS
.B bitmap
filename [\fIdimensions\fP] [\fIhost\fP:\fIdisplay\fP] [=\fIgeometry\fP]

.SH DESCRIPTION

.I bitmap
lets you interactively create small bitmaps, or edit previously created
bitmaps.  A bitmap is a small picture, represented as a rectangular
array of 0 and 1 bits.  The X window system uses bitmaps to represent
cursors and icons, among other things.

When you run
.I bitmap,
you are given a magnified version of the bitmap, with each
pixel blown up into a large square, like a piece of graph paper.  You
can then use the mouse to set, clear, or invert individual pixels, and
can invoke commands to set, clear or invert larger rectangular areas of
the bitmap.  Other commands allow you to move or copy rectangular areas
from one part of the bitmap to another, and to define a `hot spot'--a
special single point on the bitmap, which is useful when the bitmap is
used as an X cursor.

The output of the
.I bitmap
program is a small program fragment.  By #include'ing such a program
fragment in your C program, you can easily declare the size and contents
of cursors, icons, and other bitmaps that your program creates to deal
with the X window system.
    
When 
.I bitmap
starts, it first tries to read the specified file
(see FILE FORMAT). If the file already exists, it
creates a window containing a grid of the
appropriate dimensions.

If the file does not exist, 
.I bitmap
will create a window for a
bitmap of the size specified by
.I dimensions
, which should be two
numbers separated by the letter `x' (e.g. 7x9, 13x21).  The first number
is the bitmap's width; the second is its height.  The bitmap will start
out empty.  If no dimensions are specified on the command line, a
16x16 bitmap will be created.  The absolute limit is 99x99; the practical
limit is somewhat lower, and depends on the size and resolution of your
display.

.I bitmap
accepts two other optional command line arguments.  You may specify a
display name in the form \fIhost\fP:\fIdisplay\fP (see \fIX(1)\fP).
And you may provide
a geometry specification.  If you don't give a geometry specification, 
.I bitmap
will ask you where you want to put the window when it starts up.  See
.I X(1)
for a full explanation.

The window that 
.I bitmap
creates has four parts.  The largest
section is the checkerboard grid, which is a magnified version of the
bitmap you are editing.  At the upper left is a set of commands that you
can invoke with any mouse button.  Below the commands is an "actual size"
picture of the bitmap you are editing;  below that is an inverted
version of the same bitmap.  Each time you change the grid, the same
change will occur in the actual-size bitmap and its inverse.

If you use a window manager to make the
.I bitmap
window larger or smaller, the grid squares will automatically
get larger or smaller as well.

.SH COMMANDS

(Note for users of color displays:  In all of the following, 
``white'' means the background color, and ``black'' means the
foreground color.  You may specify a foreground and background
color in your \fI.Xdefaults\fP file;  see the X DEFAULTS section below.)

When the cursor is in the checkerboard region, each mouse button has
a different effect upon the single square that the cursor is over.

The 
.I left mouse button
turns a grid square black and sets the corresponding
bitmap bit to 1.

The 
.I right mouse button
turns a grid square white and sets the corresponding
bitmap bit to 0.

The
.I middle mouse button
inverts a grid square, turning it white if it was
black, or black if it was white.  It also inverts the corresponding bitmap
bit, setting it to 0 if it was 1, and to 1 if it was 0.
  
You can also invoke more sophisticated commands by moving the mouse over
one of the command boxes at the upper right corner, and pressing any
mouse button.

.PP
.TP 8
.I Clear All
turns all the grid squares white and
sets all bitmap bits to 0.  This is irreversible, so invoke it with care.

.PP
.TP 8
.I Set All
turns all the grid squares black and sets all bitmap bits to 1.
This is also irreversible.

.PP
.TP 8
.I Invert All
inverts all the grid squares and bitmap bits, as if you had pressed
the middle mouse button over each square.

.PP
.TP 8
.I Clear Area
clears a rectangular area of the grid, turning it white and setting the
corresponding bitmap bits to 0. After you click over this command, the
cursor turns into an `upper-left corner'.  Press any mouse button over the
upper-left corner of the area you want to invert, and 
.I hold the button down
while moving the mouse to the lower-right corner of the area you
want to invert, then let the button up.

While you are holding down the button, the selected area will be
covered with X's, and the cursor will change to a `lower-right corner'.
If you now wish to abort the command without clearing an area, either press
another mouse button, move the cursor outside the grid, or move the
cursor to the left of or above the upper-left corner.

.PP
.TP 8
.I Set Area
turns a rectangular area of the grid black and sets the corresponding
bitmap bits to 1.  It works the same way as the 
.I Clear Area
command.
    
.PP
.TP 8
.I Invert Area
inverts a rectangular area of
the grid.  It works the same way as the 
.I Clear Area
command.

.PP
.TP 8
.I Copy Area
copies a rectangular area from
one part of the grid to another.  First, you select the rectangle to be
copied, in the manner described under 
.I Clear Area
above.  Then, the
cursor will change to an "upper-left corner".  When you press a mouse
button, a destination rectangle will overlay the grid;  moving the mouse
while holding down the button will move this destination rectangle.  The
copy will occur when you let up the button.  To cancel the copy, move
the mouse outside the grid and then let up the button.

.PP
.TP 8
.I Move Area
works identically to 
.I Copy Area, except
that it clears the source rectangle after copying to the destination.

.PP
.TP 8
.I Set Hotspot
designates a point on the bitmap as the "hot spot".  If a program
is using your bitmap as a cursor, the hot spot indicates which point on
the bitmap is the "actual" location of the cursor.  For instance, if
your cursor is an arrow, the hot spot should be the tip of the arrow;  if
your cursor is a cross, the hot spot should be where the perpendicular
lines intersect.

.PP
.TP 8
.I Clear Hotspot
removes any hot spot that was defined on this bitmap.

.PP
.TP 8
.I Write Output
writes the current bitmap value to the
file specified in the original command line.  If the file already
exists, the original file is first renamed to 
.B filename~
(in the manner of \fIemacs(1)\fP and other text editors).
    
If either the renaming or the writing cause an error (e.g.
``Permission denied'), a Macintosh-style dialog window will appear, asking
if you want to write the file \fI/tmp/filename\fP instead.  If you say yes,
all future ``Write Output'' commands will write to \fI/tmp/filename\fP as well.
See below for the format of the output file.

.PP
.TP 8
.I Quit
exits the 
.I bitmap
program.  If you have edited
the bitmap and have not invoked 
.I Write Output,
or you have edited it
since the last time you invoked 
.I Write Output,
a Macintosh-style dialog
window will appear, asking if you want to save changes before quitting.
``Yes'' does a ``Write Output'' before exiting;  ``No'' just exits, losing
the edits;  ``Cancel'' means you decided not to quit after all.


.SH FILE FORMAT

\fIBitmap\fP reads and writes files in the following format,
which is suitable for #include'ing in a C program:
.nf
#define foo_width 9
#define foo_height 13
#define foo_x_hot 4
#define foo_y_hot 6
static short foo_bits[] = {
   0x0010, 0x0038, 0x007c, 0x0010,
   0x0010, 0x0010, 0x01ff, 0x0010,
   0x0010, 0x0010, 0x007c, 0x0038,
   0x0010};
.fi

The variables ending with
.I _x_hot
and 
.I _y_hot
are optional; they will be present only if a hot spot has been
defined for this bitmap.  The other variables must be present.

In place of ``foo'', the five variables will be prefixed
with a string derived from the name of the file that you specified
on the original command line by
  (1) deleting the directory path (all characters up to and including
the last `/', if one is present)
  (2) deleting the extension (the first `.', if one is present,
and all characters beyond it)

For example, invoking 
.I bitmap
with filename
.I /usr/include/bitmaps/cross.bitmap
will produce a file with variable
names 
.I cross_width, cross_height,
and 
.I cross_bits
(and 
.I cross_x_hot
and 
.I cross_y_hot
if a hot spot is defined).

It's easy to define a bitmap or cursor in an X program by simply #include'ing
a bitmap file and referring to its variables.  For instance, to use a cursor
defined in the files
.I this.cursor
and
.I this_mask.cursor,
one simply writes
.sp
.nf
#include "this.cursor"
#include "this_mask.cursor"
XCreateCursor (this_width, this_height, this_bits, this_mask_bits,
  this_x_hot, this_y_hot, foreground, background, func);
.sp
.fi
where
.I foreground
and
.I background
are color values, and
.I func
is a display function (normally GXcopy).

An X program can also read a bitmap file at runtime by using the function
.I XReadBitmapFile.

.SH X DEFAULTS
.PP
.PP
.TP 8
.B Background
The window's background color.  Bits which are 0 in the bitmap are
displayed in this color.  This option is useful only on color
displays.  Default: white.
.PP
.TP 8
.B Border
The border color.  This option is useful only on color displays. 
Default: black.
.PP
.TP 8
.B BorderWidth
The border width.  Default: 3.
.PP
.TP 8
.B BodyFont
The text font.  Default: vtsingle.
.PP
.TP 8
.B Foreground
The foreground color.  Bits which are 1 in the bitmap are
displayed in this color.  This option is useful only on color
displays. Default: black.
.PP
.TP 8
.B Highlight
The highlight color.
.I bitmap
uses this color to show the hot spot and to indicate rectangular areas
that will be affected by the
.I Move Area, Copy Area, Set Area, Clear Area,
and
.I Invert Area
commands.   If a highlight color is not given, then
.I bitmap
will highlight by inverting.  This option is useful only on color displays.

.PP
.TP 8
.B Mouse
The mouse cursor's color.  This option is useful only on color displays.
Default: black.

.SH ENVIRONMENT
   DISPLAY - the default host and display number.

.SH SEE ALSO
   X(1), Xlib Documentation.


.SH DIAGNOSTICS

The following messages may be displayed in the C-shell that you invoked
.I bitmap
with.  Any of these conditions aborts 
.I bitmap
before it can create its window.


  ``bitmap: could not connect to X server on \fIhost\fP:\fIdisplay\fP''

Either the display given on the command line or the DISPLAY
environment variable has an invalid host name or display number, or
the host is down, or the host is unreachable, or the host is not
running an X server, or the host is refusing connections.

  ``bitmap: no file name specified''

You invoked 
.I bitmap
with no command line arguments.  You must give a
file name as the first argument.


  ``bitmap: could not open file \fIfilename\fP for reading -- \fImessage\fP''

The specified file exists but cannot be read, for the reason given in
<message> (e.g., permission denied).


  ``bitmap: invalid dimensions \fIstring\fP''
  ``bitmap: dimensions must be positive''

The second command line argument was not a valid dimension
specification.

  
  ``bitmap: file \fIfilename\fP does not have a valid width dimension''
  ``bitmap: file \fIfilename\fP does not have a valid height dimension''
  ``bitmap: file \fIfilename\fP has an invalid \fIn\fPth array element''

The input file is not in the correct format;  the program gave up when
trying to read the specified data.


The following messages may be displayed in the C-shell after \fIbitmap\fP
creates its window:
  
  ``bitmap: Unrecognized variable \fIname\fP in file \fIfilename\fP''

.I bitmap
encountered a variable ending in something other than
.I _x_hot, _y_hot, _width,
or
.I _height
while parsing the input file.  It will ignore this variable and
continue parsing the file.


  ``bitmap: XError: \fImessage\fP''
  ``bitmap: XIOError''

A protocol error occurred.  Something is wrong with either the X server
or the X library which the program was compiled with.  Possibly they are
incompatible.  If the server is not on the local host, maybe the
connection broke.


.SH BUGS
   Doesn't take enough command line options yet.  Most options can be
specified only through .\fIXdefaults\fP.
   
   If you move the mouse too fast while holding a mouse button down,
some squares may be `missed'.  This is caused by limitations in how
frequently the X server can sample the mouse location.

   There is no way to write to a file other than that specified on the
command line.

   There is no way to change the size of the bitmap once the program
is started.
   
   Edits are unrecoverably lost if you terminate the program with a ^C
or ^\ in the shell which invoked it, or if you kill it with the shell's
``kill'' command.

   Dimensions greater than 99 are not read properly from the command
line or input file.  Generally such dimensions would not be useful anyway,
since they would produce a window larger than most displays.

.SH AUTHOR
Copyright (c) 1986 by Massachusetts Institute of Technology.
.br
   Ron Newman, MIT Project Athena
