#-h-  defns                       434  ascii   03/30/82  15:11:44
# TCS data file keys

define(STATS,"%%s ")                    # statistics
define(VERKEY,"%%d ")                   # key field on history-info lines
define(COMMENT,"%%c ")
define(ENDKEY,"%%T")                    # end of header
define(INSERT,"%%I ")                   # begin "inserted in this version"
define(DELETE,"%%D ")                   # begin "deleted in this version"
define(ENDSEG,"%%E ")                   # end of segment
#-t-  defns                       434  ascii   03/30/82  15:11:44
#-h-  admin.r                    6642  ascii   03/30/82  15:11:45
#-h- main            2524  asc  15-sep-81 10:31:07  npg
#-p-
#                                                                              
#                                                                              
#                                                                              
#                                MAIN                                          
#                                                                              
#     author: Neil P. Groundwater (ADI)                date: 11-SEP-81         
#                                                                              
#                                                                              
#                                                                              
#     Purpose:  Validates the calling arguments then calls ADMIT.              
#                                                                              
#                                                                              
#     Calling convention:   admin                                              
#                                                                              
#     Modules called by MAIN                                                   
#        error                                                                 
#        admit                                                                 
#        getarg                                                                
#        clower                                                                
#                                                                              
#                                                                              
#                                                                              
#-p-

DRIVER(admin)
# subroutine main
integer getarg, getlin, open

character arg1(FILENAMESIZE)            # might need to be longer
character txtfile(FILENAMESIZE)         # source (text) file (-i flag)
character tcsfile(FILENAMESIZE)         # history (.tcs) file

character clower
integer i, j

if (getarg(1, arg1, FILENAMESIZE) == EOF  
        |  getarg(2, tcsfile, FILENAMESIZE) == EOF)
        # for now, only one valid form
        call error('Usage: admin -ifile filetcs.')

if (arg1(1) != DASH)
        call error('- flag missing.')
else {
        if (clower(arg1(2)) == LETI) {
                i = 3;  j = 1
                repeat {
                        txtfile(j) = arg1(i)
                        if (arg1(i) == EOS)
                                break
                        i = i+1
                        j = j+1
                }
                if (j == 1)
                        call error("-i: filename missing.")

                call admit(txtfile, tcsfile)
        } else
                call error('Invalid flag.')
}
return
end

#-t- main            2524  asc  15-sep-81 10:31:07  npg
#-h- admit           2925  asc  15-sep-81 10:31:09  npg
#-p-
# 
# 
# 
#                                ADMIT
# 
#     author: Neil P. Groundwater (ADI)                date: 11-SEP-81
# 
# 
# 
#     Purpose:  Enter text file into Text Control System for the first time. 
# 
# 
#     Calling convention:   admit(txtfile, tcsfile)
# 
# 
#     Formal Parameters
#        txtfile:  User's source file 
#        tcsfile:  Name of Text Control System version of source file 
# 
# 
#     Modules called by ADMIT
#        cant
#        mkuniq
#        putlin
#        putch
#        gdate
#        gtime
#        mailid
#        close
#        amove
#        bmatch
#        create
#        getlin
#        open
#        prompt
# 
# 
#     Modules which call ADMIT
#        admin
# 
# 
#     Description of algorithm:  Gather date,time,and username from the 
#        system. Accept initial user comments. Enter the source file and add 
#        appropriate keys for Text Control System recognition. 
# 
# 
# 
#-p-

include "defns"

define(DATESIZE, 10)

subroutine admit(txtfile, tcsfile)

character txtfile(FILENAMESIZE)         # name of history file
character tcsfile(FILENAMESIZE)         # name of new history file
                                        # (may be tcsfile)
character scrfile(FILENAMESIZE)         # name of scratch file

integer bmatch, create, getlin, open, prompt

character date(DATESIZE)
character inbuf(MAXLINE)
integer fdtxt, fdscr                    # i/o file descriptors
integer cnt

string sct 'SCT'
string zeroes "0/0/0"
string dee "D 1.1 "
string one0 " 1 0"
string gthan "> "
string one "1"


fdtxt = open(txtfile, READ)
if (fdtxt == ERR)
        call cant(txtfile)

call mkuniq(sct, scrfile)
fdscr = create(scrfile, WRITE)
if (fdscr == ERR)
        call cant(scrfile)

# STEP 1.  Initialize the history info.

# fake the statistics for now.
call putlin(STATS, fdscr)
call putlin(zeroes, fdscr)
call putch(NEWLINE, fdscr)

call putlin(VERKEY, fdscr)
call putlin(dee, fdscr)

call gdate(date)                        # date
call putlin(date, fdscr)
call putch(BLANK, fdscr)
call gtime(date)                        # time
call putlin(date, fdscr)
call putch(BLANK, fdscr)

call getuid(inbuf)                    # fetch user name
call putlin(inbuf, fdscr)

call putlin(one0, fdscr)              # initialize ancestry
call putch(NEWLINE, fdscr)

# STEP 2.  General comments.

call remark ("Enter general comments (end with a 'dot-line').", ERROUT)
repeat {
        cnt = prompt(gthan, inbuf, STDIN)
        if (cnt == 0)
                break
        if ((cnt == 2) & (inbuf(1) == PERIOD))
                break
        call putlin(COMMENT, fdscr)
        call putlin(inbuf, fdscr)
}

call putlin(ENDKEY, fdscr)              # end the header
call putch(NEWLINE, fdscr)

# STEP 3.  Append the text file.

call putlin(INSERT, fdscr)              # start version 1 info
call putlin(one, fdscr)
call putch(NEWLINE, fdscr)

while (getlin(inbuf, fdtxt) != EOF)
        call putlin(inbuf, fdscr)

call putlin(ENDSEG, fdscr)              # end version 1 info
call putlin(one, fdscr)
call putch(NEWLINE, fdscr)

# STEP 4.  Housekeeping.

call close(fdtxt)
call close(fdscr)

call amove(scrfile, tcsfile)            # done - move the results

return

end
#-t- admit           2925  asc  15-sep-81 10:31:09  npg
#-h- gdate
## gdate - get current date
subroutine gdate (date)
character date(ARB)
character time (9)
integer now(7)

call getnow (now)
call fmtdat (date, time, now, 0)
return
end
#-t- gdate
#-h- gtime
## gtime - get current time
subroutine gtime (time)
character time(ARB)
character date(9)
integer now(7)

call getnow (now)
call fmtdat (date, time, now, 0)
return
end
#-t- gtime
#-t-  admin.r                    6642  ascii   03/30/82  15:11:45
#-h-  admin.rof                  1765  ascii   04/02/82  17:08:16
.bp 
.rm 70 
.in 0 
.he 'ADMIN (1)'9/14/81'ADMIN (1)'
.fo ''-#-' 
.fi 
.in 7 
.ti -7 
NAME 
.br 
admin - administer (create) TCS file.
.sp 1 
.ti -7 
SYNOPSIS 
.br 
admin -ifile tcsfile
.sp 1 
.ti -7 
DESCRIPTION 
.br 
Admin -i enters a text file into the TCS system for the first time.
"File" is the source file to be entered into the system;
"tcsfile" is the TCSed version of the file.
(Local convention is to use the
name "file.tcs" for
files maintained by TCS, if possible.)

The file is tagged as Version #1.1 and the user is prompted for
initial comments concerning the development of the file.

The date, time and user ID are recorded in the statistics portion
of the file.
.sp 1 
.ti -7 
FILES 
.br 
A scratch file is used while creating the output file and moved
upon completion of input.
.sp 1
.ti -7 
SEE ALSO 
.br 
DELTA, GET.
.br
"The Source Code Control System" by Marc J. Rochkind,
.ul
IEEE Transactions on Software Engineering,
Vol. SE-1 No. 4, December 1975.
.sp 1 
.ti -7 
DIAGNOSTICS 
.br 
Usage: admin -ifile file.tcs
.in +10 
Correct calling format is provided when called without arguments.
.in -10 

- flag missing
.in +10
Incorrect calling procedure.
.in -10

-i:  filename missing
.in +10
The input filename is expected to be immediately adjacent to the
-i flag.  (no white-space)
.in -10

Invalid flag
.in +10
-i is the only valid flag at present.
.in -10
.ti -7
EXAMPLES
.br
admin -iprogram program.tcs
.in +5
Create an initial version of "program" stored in TCS format and
put on file "program.tcs".

To retrieve the program for more changes, use "get".
Then, to insert the changes back into the TCS system, use "delta".
.in -5
.sp
.ti -7
AUTHORS 
.br 
Neil Groundwater at Analytic Disciplines Inc.
.sp 1 
.ti -7 
BUGS/DEFICIENCIES 
.br
#-t-  admin.rof                  1765  ascii   04/02/82  17:08:16
