# include "mfile2"
/*
 * Make sure that when longs are used as
 *	return(<long exp>)
 * they return an integer
 */
#if pdp11
# define logical(e)	((e) != 0)
#else
# define logical(e)	(e)
#endif
int     fldsz,
        fldshf;
int     sdebug = 0;
int     tdebug = 0;
int     rtyflg = 0;
int	consflg = 0;
struct optab    *rwtable,
		*opptr[DSIZE];
/*
 *	Masks for matching dope with shapes
 */
static int      mamask[] = {
	SIMPFLG,		 /* OPSIMP */
	SIMPFLG | ASGFLG,	 /* ASG OPSIMP */
	COMMFLG,		 /* OPCOMM */
	COMMFLG | ASGFLG,	 /* ASG OPCOMM */
	MULFLG,			 /* OPMUL */
	MULFLG | ASGFLG,	 /* ASG OPMUL */
	DIVFLG,			 /* OPDIV */
	DIVFLG | ASGFLG,	 /* ASG OPDIV */
	UTYPE,			 /* OPUNARY */
	TYFLG,			 /* ASG OPUNARY is senseless */
	LTYPE,			 /* OPLEAF */
	TYFLG,			 /* ASG OPLEAF is senseless */
	0,			 /* OPANY */
	ASGOPFLG | ASGFLG,	 /* ASG OPANY */
	LOGFLG,			 /* OPLOG */
	TYFLG,			 /* ASG OPLOG is senseless */
	FLOFLG,			 /* OPFLOAT */
	FLOFLG | ASGFLG,	 /* ASG OPFLOAT */
	SHFFLG,			 /* OPSHFT */
	SHFFLG | ASGFLG,	 /* ASG OPSHIFT */
	SPFLG,			 /* OPLTYPE */
	TYFLG,			 /* ASG OPLTYPE is senseless */
};
/*
 * return true if shape is appropriate for the node p
 * side effect for SFLD is to set up fldsz,etc
 */
tshape (p, shape)
NODE	*p;
SHAPESZ	shape;
{
	register        o;
	o = p->op;
	if (sdebug) {
		printf ("tshape( %o, %o), op = %d\n", p, shape, o);
	}
	if (shape & SPECIAL) {
		if (shape == SZERO || shape == SONE || shape == SMONE) {
			if (o != ICON || p->name[0])
				return (0);
			if (p->lval == 0 && shape == SZERO)
				return (1);
			else if (p->lval == 1 && shape == SONE)
				return (1);
			else if (p->lval == -1 && shape == SMONE)
				return (1);
			else
				return(0);
		} else
			return (special (p, shape));
	}
	if (shape & SANY)
		return (1);
	if ((shape & INTEMP) && shtemp (p))
		return (1);
	if ((shape & SWADD) && (o == NAME || o == OREG)) {
		if (BYTEOFF (p->lval))
			return (0);
	}
	switch (o) {
		case NAME:
			return (logical(shape & SNAME));
		case ICON:
			return (logical(shape & SCON));
		case FLD:
			if (shape & SFLD) {
				if (!flshape (p->left))
					return (0);
				/*
				 * it is a FIELD shape; make side-effects
				 */
				o = p->rval;
				fldsz = UPKFSZ (o);
# ifdef RTOLBYTES
				fldshf = UPKFOFF (o);
# else
				fldshf = SZINT - fldsz - UPKFOFF (o);
# endif
				return (1);
			}
			return (0);
		case CCODES:
			return (logical(shape & SCC));
		case REG:
			/*
			 * distinctions:
			 * SAREG	any arithmetic register (a,e,i,j)
			 * SINREG	any index register (i,j)
			 * SACREG	the accumulator register (a)
			 * SDREG	the double register (d)
			 * SIREG	the replace byte register (i)
			 * SJREG	the extract byte register (j)
			 * SXREG	the floating accumulator (x)
			 */
			switch(p->rval) {
				case Ra:
					return(logical(shape & (SAREG|SACREG)));
				case Re:
					return(logical(shape & SAREG));
				case Rd:
					return(logical(shape & SDREG));
				case Ri:
					return(logical(shape & (SAREG|SINREG|SIREG)));
				case Rj:
					return(logical(shape & (SAREG|SINREG|SJREG)));
				case Rk:
					return(logical(shape & SKREG));
				case FRx:
					return(logical(shape & SXREG));
			}
			cerror("unknown register for REG node, %o", p->rval);
			/* NOTREACHED */
		case OREG:
			return (logical(shape & SOREG));
		case UNARY MUL:
			/*
			 * return STARNM or STREG's or 0
			 */
			return (logical(shumul (p->left) & shape));
	}
	return (0);
}
/*
 * does the type t match tword
 */
ttype (t, tword)
TWORD t;
{
	if (tdebug) {
		printf ("ttype( ");
		tprint(t);
		printf(", %o )\n", tword);
	}
	if (tword & TANY)
		return (1);
	if (ISPTR (t) && (tword & TPTRTO)) {
		do {
			t = DECREF (t);
		} while (ISARY (t));
		/*
		 * arrays that are left are usually only
		 * in structure references...
		 */
		return (ttype (t, tword & (~TPTRTO)));
	}
	if (t != BTYPE (t))
		return(tword & TPOINT);
	if (tword & TPTRTO)
		return (0);
	switch (t) {
		case CHAR:
			return (tword & TCHAR);
		case SHORT:
			return (tword & TSHORT);
		case STRTY:
		case UNIONTY:
			return (tword & TSTRUCT);
		case INT:
			return (tword & TINT);
		case UNSIGNED:
			return (tword & TUNSIGNED);
		case USHORT:
			return (tword & TUSHORT);
		case UCHAR:
			return (tword & TUCHAR);
		case ULONG:
			return (tword & TULONG);
		case LONG:
			return (tword & TLONG);
		case FLOAT:
			return (tword & TFLOAT);
		case DOUBLE:
			return (tword & TDOUBLE);
	}
	return (0);
}
/*
 * set rwtable to first value which allows rewrite
 */
setrew ()
{
	register struct optab  *q;
	register int    i;
	for (q = table; q->op != FREE; ++q)
		if (q->needs == REWRITE) {
			rwtable = q;
			goto more;
		}
	cerror ("bad setrew");
more:
	for (i = 0; i < DSIZE; ++i) {
		if (dope[i]) {			 /* there is an op... */
			for (q = table; q->op != FREE; ++q) {
				/*
				 *  beware; things like LTYPE that match
				 *    multiple things in the tree must
				 *    not try to look at the NIL at this
				 *    stage of things!  Put something else
				 *    first in table.c
				 *
				 * at one point, the operator matching was 15% of the
				 *    total compile time; thus, the function
				 *    call that was here was removed...
				 */
				if (q->op < OPSIMP) {
					if (q->op == i)
						break;
				}
				else {
					register        opmtemp;
					if ((opmtemp = mamask[q->op - OPSIMP]) & SPFLG) {
						if (i == NAME || i == ICON || i == OREG)
							break;
						else
							if (shltype (i, NIL))
								break;
					}
					else
						if ((dope[i] & (opmtemp | ASGFLG)) == opmtemp)
							break;
				}
			}
			opptr[i] = q;
		}
	}
	if (odebug > 1) {
		printf("setrew:\n");
		for (i = 0; i < DSIZE; i++)
			printf("opptr[%d] = %o, table[%d]\n", i, opptr[i],
				(opptr[i]-table)/sizeof(struct optab));
	}
}
/*
 * called by: order, gencall
 *  look for match in table and generate code if found unless
 *  entry specified REWRITE.
 *  returns MDONE, MNOPE, or rewrite specification from table
 */
match (p, cookie)
NODE	*p;
COOKSZ	cookie;
{
	register struct optab  *q;
	register NODE	*r;
	rcount ();
	if (odebug > 1) {
		printf("match(%o, ", p);
		prcook(cookie);
		printf(")\n");
	}
	if (cookie == FORREW)
		q = rwtable;
	else
		q = opptr[p->op];
	for (; q->op != FREE; ++q) {
		/*
		 * at one point the call that was here was over 15% of the total time;
		 * thus the function call was expanded inline
		 */
		if (q->op < OPSIMP) {
			if (q->op != p->op)
				continue;
		}
		else {
			register        opmtemp;
			if ((opmtemp = mamask[q->op - OPSIMP]) & SPFLG) {
				if (p->op != NAME && p->op != ICON && p->op != OREG &&
						!shltype (p->op, p))
					continue;
			} else if ((dope[p->op] & (opmtemp | ASGFLG)) != opmtemp)
					continue;
		}
		if (odebug > 1) {
			printf("match: template, ");
			prcook(q->visit);
			printf("(%o); cookie: ", q->visit);
			prcook(cookie);
			putchar('\n');
		}
		if (!(q->visit & cookie))
			continue;
		/*
		 * see if left child matches
		 */
		r = getlr (p, 'L');
		if (!tshape (r, q->lshape))
			continue;
		if (!ttype (r->type, q->ltype))
			continue;
		/*
		 * see if right child matches
		 */
		r = getlr (p, 'R');
		if (!tshape (r, q->rshape))
			continue;
		if (!ttype (r->type, q->rtype))
			continue;
		/*
		 * REWRITE means no code from this match but go ahead
		 * and rewrite node to help future match
		 */
		if (q->needs & REWRITE)
			return (q->rewrite);
		/*
		 * if can't generate code, skip entry
		 */
		if (!allo (p, q))
			continue;
		/*
		 * resources are available
		 *	- generate code
		 */
		expand (p, cookie, q->cstring);
		reclaim (p, q->rewrite, cookie);
		return (MDONE);
	}
	return (MNOPE);
}
/*
 * generate code by interpreting table entry
 */
expand (p, cookie, cp)
NODE		*p;
COOKSZ		cookie;
register char  *cp;
{
	CONSZ val;
	/*
	 * Should value placed in a register be retyped ?
	 *  used in reclaim.
	 */
	rtyflg = 0;
	/*
	 * Should constant be output via adrput or conput,
	 *  set by insput to allow building instructions with operands
	 */
	consflg = 0;
	for (; *cp; ++cp) {
		switch (*cp) {
			default: 		 /* this is the usual case */
				PUTCHAR (*cp);
				continue;
			case 'T': 		 /* rewrite register type is suppressed */
				rtyflg = 1;
				continue;
			case 'Z': 		 /* special machine dependent operations */
				zzzcode (p, *++cp);
				continue;
			case 'F': 		 /* this line deleted if FOREFF is active */
				if (cookie & FOREFF)
					while (*++cp != '\n')
						if (*cp == '\0')
							return;
				continue;
			case 'H': 		 /* field shift */
				printf ("%d", fldshf);
				continue;
			case 'M': 		 /* field mask */
			case 'N': 		 /* complement of field mask */
				val = 1;
				val << = fldsz;
				--val;
				val << = fldshf;
				adrcon (*cp == 'M' ? val : (~val) & 0xffffff);
				continue;
			case 'O': 		 /* opcode string */
				hopcode (*++cp, p->op);
				continue;
			case 'B': 		 /* con/adr-put ?? */
				if (!consflg)
					goto makeaddrs;
				/* FALL THRU FOR CONSTANTS THAT FIT AS OPS */
			case 'C': 		 /* for constant value only */
				conput (getlr (p, *++cp));
				continue;
			case 'I': 		 /* in instruction */
				insput(p, *++cp);
				continue;
			case 'A': 		 /* address of */
			makeaddrs:
				adrput (getlr (p, *++cp));
				continue;
			case 'U': 		 /* for upper half of address, only */
				upput (getlr (p, *++cp));
				continue;
		}
	}
}
/*
 * return the pointer to the left or right side of p, or p itself,
 * depending on the optype of p
 */
NODE *
getlr (p, c)
NODE	*p;
char	c;
{
	switch (c) {
		case '1':
		case '2':
		case '3':
			return (&resc[c - '1']);
		case 'L':
			return (optype (p->op) == LTYPE ? p : p->left);
		case 'R':
			return (optype (p->op) != BITYPE ? p : p->right);
	}
	cerror ("bad getlr: %c", c);
	/* NOTREACHED */
}
