#include "mac.h"
#include "mac.x"

/*
 * Scan opcode selector list
 * for selector match & return pointer if found
 * else return NUL
 */

struct os *
scanop(list, selector)
struct oc *list;
register int selector;
{
	register struct os *p;

	p = list->oc_list;
	while(p != NUL) {
		if(p->os_sel == selector)
			break;
		p = p->os_next;
	}

	return(p);
}

/*
 *	relocate opcode table pointers
 *	to conform with the location
 *	in which they are loaded in mac
 */

relopcodes(op)
struct oc *op;
{
	register char *p;
	register struct os *q, *r;
	register int offset, i;

	offset = (char *)op - (char *)head.h_opstart;

	for(i = 0; i < head.h_ops; i++) {
		if(op->oc_list == NULL)
			break;
		p = ((char *)(op->oc_list)) + offset;
		q = op->oc_list = (struct os *)p;
		while(q != NULL) {
			r = q->os_next;
			if(r == NULL)
				break;

			p = ((char *) r) + offset;
			q->os_next = (struct os *)p;
			q = q->os_next;
		}
		op++;
	}
}
