/*
 *	LPD - print a banner page
 */

#include <stdio.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/dir.h>
#include <sys/stat.h>
#include "local.h"
#include "spool.h"
#include "globals.h"
#ifdef	LPR
#include "la.h"

extern struct la_iocb laiocb;
#endif


bannerpage(job, copyno, copies)
int job, copyno, copies;
{
	char c;
	register char *p, *q;
	register	i;

	/*  
	 *	Output the banner page headings.
	 */

	fflush(op);
#ifdef	LPR
	if (mypr->opts & PR_LA) {
		ioctl(fileno(op), LAIOCGET, &laiocb);
		laiocb.la_flags = lpflags & (F_NLCR | F_XTABS | F_NOFF);
		ioctl(fileno(op), LAIOCSET, &laiocb);
	}
#endif
	if (mypr->opts & BIGBAN) {
		p = rindex(realfname, '/');
		if (p == NULL)
			p = realfname;
		else
			p++;
		/*  'p' points past the last '/'  */
		q = &realfname[strlen(realfname)-1];
		if (q < realfname)
			q++;
		/*  'q' points at the end of the string  */
		if (q > p+9) {
			/*  truncate from right  */
			q = p+9;
			*q = '\0';
		} else
		if (q < p+9) {
			/*  extend to the left  */
			p = q-9;
			if (p < realfname) p = realfname;
		}
	 
		q = banner;
	 
		if (*p != '\0') bprint(p);
		else if (person[0] != '\0') bprint(person);
		else fprintf (op, "\n\n\n\n\n\n\n\n\n\n\n\n\n");
		chars(' ');
		chars('!');
		chars('"');
	} else if (!(mypr->opts & WINDUP))
		for (i = 0; i < 40; i++)
			putc('\n', op);



	fprintf (op, "\n\n");
	fprintf (op, "Computer Science Department, Melbourne University\n\n");
	fprintf (op, "\t\tUser: %s\n", person);
	fprintf (op, "\t\tSpool Job Number:  %u", job);
	if (realfname[0] != '\0')
		fprintf(op, "\t\tFile: %s", realfname);
	if ((mypr->opts&BIGBAN) == 0 && banner[0] != '\0')
		fprintf(op, "\t\t**** %s ****", banner);
	fprintf (op, "\n\t\tSubmitted:  %s\n\t\tReleased:   %s", submitted, dt);
	if (copies > 1)
		fprintf (op, "\t\tCopy  %u  of  %u\n\n\n", copyno, copies);

	if (mypr->opts & BIGBAN) {
		chars('#');
		chars('$');
		chars('%');
		putc('\n', op);
		if (*q != 0)
			bprint(q);
	}
	putc('\f', op);


	return;
}
 
chars(ch)
register char ch;
{
	/*
	 *	Print a line of 132 characters, starting with 'c'
	 */
	register j;
	for (j = 0; j < 132; j++) {
		putc(ch++, op);
		if (ch > '~') ch = ' ';
	}
	putc('\n', op);
}

windup()
{
	/*
	 *	Cause the printer to position the paper at the correct
	 *	place for the banner of the next job
	 *	(assuming it will have a small banner, if not, then
	 *	we will waste a page at the start of the next job)
	 */
	register i;

	if (!(mypr->opts & WINDUP))
		return;

#ifdef	LPR
	fflush(op);
	if (mypr->opts & PR_LA) {
		ioctl(fileno(op), LAIOCGET, &laiocb);
		laiocb.la_flags &= F_XTABS|F_NLCR|F_ODD|F_EVEN|F_NOFF;
		laiocb.la_flags |= F_STILL;
		ioctl(fileno(op), LAIOCSET, &laiocb);
	}
#endif

	for (i = 0; i < 40; i++)
		putc('\n', op);
}
