/*	hperrs.h	Feb 24 80	M01	*/

/*
 *	RP06 / RM03 error logging data
 */

typedef	unsigned short	hword;

struct	hplog	{
	struct	errhead	er_h;
	dev_t	er_dev;
	char	er_why;		/* reason for error log */
	char	er_errcnt;	/* minor error counter */
	long	er_ecnt;	/* error counter (for sync) */
	daddr_t	er_blk;		/* disc block causing error */
	unsigned er_bcount;	/* bytes wanted in disc xfer */
	long	er_mbacsr;
	long	er_mbasr;
	long	er_mbabcr;
	short	er_bflags;	/* details of xfer requested */
	hword	er_hpcs1;
	hword	er_hpds;
	hword	er_hper1;
	hword	er_hper2;
	hword	er_hpec1;
	hword	er_hpec2;
	hword	er_hpdt;
	hword	er_hpsn;
	hword	er_hpda;
	hword	er_hpdc;
	hword	er_hpof;
};

#define	HPER_VV		1		/* volume invalid */
#define	HPER_MOL	2		/* medium off line */
#define	HPER_ERR	3		/* device/mba error */
#define	HPER_OK		4		/* error recovered */
#define	HPER_BAD	5		/* error fatal */
