/*	lock.c		M01	Jun 1 80 */
/*
 *	A primitive form of interprocess co-ordination
 *
 *	Two major devices, A & B.
 *
 *	Opening A simply prevents any other process from performing
 *	the same feat till it is closed (a single use device)
 *	(there is no I/O possible)
 *	Opening B is impossible, but the system waits till A is closed
 *	to determine that - ie: an attempt to open B is a wait till the
 *	lock might be free (no guarantees - someone else might get it first)
 *
 *			Robert Elz
 *			Computer Science
 *			Melbourne University
 *			Feb 1980.
 */

#include "../h/param.h"
#include "../h/dir.h"
#include "../h/user.h"

#define	NLOCK	128
#define	LOCKPRI	37

char	lock[NLOCK];

#define	LOCKED	01
#define	WANTED	02

/*
 *	Eventually it might be nice to use the access mode to specify
 *	more than one access mode of the lock - for more accurate
 *	co-ordination - but that can wait
 */

lockopen(dev, flag)
dev_t dev;
{
	register m = minor(dev);
	register char *l;

	if ( m >= NLOCK )
	{
		u.u_error = ENXIO;
		return;
	}

	l = &lock[m];

	if ( *l & LOCKED )
	{
		u.u_error = EBUSY;
		return;
	}

	*l |= LOCKED;
}

lockclose(dev, flag)
dev_t dev;
{
	register char *l = &lock[minor(dev)];

	if ( *l & WANTED )
	{
		*l &= ~WANTED;
		wakeup((caddr_t) l);
	}

	*l &= ~LOCKED;
}

lockwait(dev, flag)
dev_t dev;
{
	register m = minor(dev);
	register char *l;

	if ( m >= NLOCK )
	{
		u.u_error = ENXIO;
		return;
	}

	l = &lock[m];

	while ( *l & LOCKED )
	{
		*l |= WANTED;
		sleep((caddr_t) l, LOCKPRI);
	}

	u.u_error = EBUSY;
}
