#
/*
 *	lpd.c
 *	New line printer spooler for UKC
 *	Peter Collinson - March 1977
 *	Creates a file called "lock" on /usr/lpd
 *	and goes away if this file present
 *	Looks for a file starting with lp
 *	This file will contain
 *	Line 1	- user name
 *	Line 2	- pathname where request was created
 *	Line 3  - a single byte with the switches
 *			M - send mail after printing
 *			D - delete file after printing
 *			L - use 'list' to list file
 *			P - use 'pr' to list file
 *	Line 4	- file name to be printed

 *	The file is passed to lpdexec which actually does the printing
 *	If no lp files are found - the program goes to sleep
 *	and keeps trying
 */

char lp[]	"/dev/lp";
char lock[]	"/usr/lpd/lock";
char lpd[]	"/usr/lpd";
int lockfd;

struct
{	int	fill[16];
	long	modtime;
} statb;

long earliest;
char iobuf[16];
char nextfile[16];	/* Name of the spooler command file currently being processed */

#define WAITTIME 30		/* Waiting period  in secs */


main()
{	register int procno, lpfd;
	int state;


	close(2);
	if(chdir(lpd) < 0) exit();			/* Not much use if can't get to /usr/lpd */
	if(stat(lock, &statb) >= 0) exit();		/* Also get out if any lock file */
	if((lockfd = creat(lock, 0600)) < 0) exit();	/* Can't creat lock file */

	signal(1, 1);
	signal(2, 1);
	signal(3, 1);
	nice(15);
	close(1);

	while(1)
	{
		while(getnext() == '\0') sleep(WAITTIME);
		goahead();
		while((lpfd = open(lp, 1)) < 0);		/* Sleep if can't open lp */
		while((procno = fork())< 0) sleep(WAITTIME);
		if(procno) { procout(procno); wait(&state); }
		else execl("/etc/lpdexec", "lpdexec", nextfile, 0);
		procout(0);
		close(1);
	}
}


char getnext()
{	int fd;
	register int i, *s, *d;

	time(&earliest);
	fd = open(lpd,0);
	seek(fd, 32, 0);		/* Avoid . and .. entries */

	nextfile[0] = '\0';

	while(read(fd, (s = iobuf), 16)> 0)
	if(*s++ && (*s == 'lp'))
	{	stat(s, &statb);
		if(statb.modtime < earliest)
		{	earliest = statb.modtime;
			d = nextfile;
			for(i = 0; i< 7; i++) *d++ = *s++;
		}
	}

	close(fd);
	return(nextfile[0]);
}

goahead()
{	if(getcsw() & 02) sleep(WAITTIME);	}

procout(val)
int val;
{	seek(lockfd, 0, 0);
	write(lockfd, &val, 2);
	write(lockfd, &nextfile, 16);
}
