#
/*
 *	lpdexec.c
 *	Peter Collinson - March 1977
 *	Does the work for the line printer spooler
 *	Takes as argument a single command file
 *	This file will contain
 *	Line 1	- user name
 *	Line 2	- pathname where request was created
 *	Line 3  - a single byte with the switches
 *			N - suppress printing of header page
 *			F - print extended header page
 *			M - send mail after printing
 *			D - delete file after printing
 *			L - use 'list' to list file
 *			P - use 'pr' to list file
 *	Line 4	- file name to be printed
 */

char lpd[]	"/usr/lpd";
char mailfile[]	"/usr/lpd/mail";

#define DAEUID	1
#define NOHDR	040
#define FWANT	020
#define MAIL	010
#define DELETE	04
#define LIST	02
#define PR	01
#define WAITTIME	150		/* Waiting time in case of failure = 2.5(*60) mins */

int iobuf[259];
int procno;			/* Child process */

char *spoolerfile	0;
struct
{	char	user[24];	/* Name of creator of file */
	char	path[512];	/* Pathname of file */
	char	swit;		/* switches set on file */
	char	file[128];	/* The file name itself */
} fdata;

stopall()
{		/* Routine started by interrupt signal - kills all dependant processes */
	if(procno)
	{	kill(procno, 2);
		while(wait() != -1);
	}
	printf("\nlpd: killed\n");
	printf("\014");
	windup();
}
main(argc, argv)
int argc; char **argv;
{
	register char *p;
	if(argc != 2) exit();
	spoolerfile = *++argv;

	setuid(DAEUID);
	signal(2,stopall);
	signal(3,1);
	if(fopen(spoolerfile, &iobuf) < 0) windup();

	if(readline(fdata.user) ||
	   readline(fdata.path) ||
	   ((fdata.swit = getc(iobuf)) < 0) ||
	   (getc(iobuf) != '\n') ||
	   readline(fdata.file)) windup();
	/* look for .lst file */
	p = fdata.file;
	while(*p++);
	p =- 5;
	if(*p++ == '.' && *p++ == 'l' && *p++ == 's' & *p++ == 't') fdata.swit =| DELETE;
	close(iobuf[0]);

	if(fileok())	printffile();
	flush();
	windup();

}

windup()
{	flush(); chdir(lpd); unlink(spoolerfile); exit(); }

int readline(dest)
char *dest;
{	register char *p, c; register int ret;
	p = dest; ret = 0;

	while((c = getc(iobuf)) != '\n')
	{	if(c < 0) { ret++; *dest == '0'; break;	}
		*p++ = c;
	}
	*p = '\0';
	return(ret);
}




int fileok()
{	register int i;

	if((i = chdir(fdata.path)) < 0 || stat(fdata.file, iobuf) < 0)
	{	mail(1);
		return(0);
	}
	return(1);
}

printffile()	/* Current directory is that of the users */
{
	register char *p, sw;
	int stat;

	sw = fdata.swit;
	if((sw&NOHDR) == 0) prheader();
	if(sw&DELETE && ((sw&NOHDR) == 0))
		printf("\t\tFile will be deleted after printing\n\n");
	if((sw&(PR|LIST)) && ((sw&NOHDR)==0))
		printf("\014");

	while((procno = fork()) < 0) sleep(WAITTIME);
	if(procno) wait(&stat);
	else
	{	if(sw&PR)
			execl("/bin/pr", "pr", "-w130", fdata.file, 0);
		else
		if(sw&LIST)
			execl("/usr/bin/list", "list", "-w130", fdata.file, 0);
		else
		{
			if((sw&FWANT) && ((sw&NOHDR)==0) && noform(fdata.file))
				printf("\014");
			execl("/bin/cat", "cat", fdata.file, 0);
		}
	}
	if((sw&(PR | LIST)) == 0) printf("\014");
	if(sw&DELETE) unlink(fdata.file);
	chdir(lpd);
	unlink(spoolerfile);
	if(sw&MAIL) mail(0);
}

mail(news)
int news;
{
	int stat, fd;
	extern fout;

	if((procno = fork()) < 0) return;
	if(procno) wait(&stat);
	else
	{	fd = fcreat(mailfile, &fout);
		if(news)
			printf("lpd: either file - %s or directory - %s could not be found", fdata.file, fdata.path);
		else
		{
			printf("lpd: file - %s has been printed", fdata.file);
			if(fdata.swit&DELETE) printf(" and deleted");
		}
		printf("\n");
		fflush(&fout);
		close(fout);
		close(0);
		fd = open(mailfile, 0);
		close(2); dup(fd);
		execl("/bin/mail", "mail", fdata.user, 0);
	}
	unlink(mailfile);
}


prheader()
{	register char fw;
	int tvec[2];
	if(fw = (fdata.swit&(PR|LIST|FWANT)))
		printf("\013\013\n");
	printf("\016\tUser: %s\n", fdata.user);
	if(fw) printf("\n");
	printf("\016\tFile: %s\n", fdata.file);
	if(fw) printf("\n");
	time(tvec);
	printf("\016\tTime: %s\n", ctime(tvec));
	if(fw) printf("\n");
}

int noform(f)
char *f;
{	int c, fd;

	fd = open(f, 0);
	read(fd, &c, 1);
	close(fd);
	return((c&0377) != 014);
}
